/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.Mapping;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.schemes.ResidueProperties;
import jalview.util.MapList;
import jalview.util.MappingUtils;
import jalview.util.StringUtils;
import java.util.HashSet;
import java.util.List;

public class MappedFeatures {
    private static final String HGV_SP = "HGVSp";
    private static final String CSQ = "CSQ";
    private final SequenceI featureSequence;
    private final Mapping mapping;
    public final List<SequenceFeature> features;
    private final int toPosition;
    private final char toResidue;
    private final int[] codonPos;
    private final char[] baseCodon;

    public MappedFeatures(Mapping theMapping, SequenceI featureSeq, int pos, char res, List<SequenceFeature> theFeatures) {
        int[] codonPositions;
        this.mapping = theMapping;
        this.featureSequence = featureSeq;
        this.toPosition = pos;
        this.toResidue = res;
        this.features = theFeatures;
        int[] codonIntervals = this.mapping.getMap().locateInFrom(this.toPosition, this.toPosition);
        int[] nArray = codonPositions = codonIntervals == null ? null : MappingUtils.flattenRanges(codonIntervals);
        if (codonPositions != null && codonPositions.length == 3) {
            this.codonPos = codonPositions;
            this.baseCodon = new char[3];
            int cdsStart = this.featureSequence.getStart();
            this.baseCodon[0] = Character.toUpperCase(this.featureSequence.getCharAt(this.codonPos[0] - cdsStart));
            this.baseCodon[1] = Character.toUpperCase(this.featureSequence.getCharAt(this.codonPos[1] - cdsStart));
            this.baseCodon[2] = Character.toUpperCase(this.featureSequence.getCharAt(this.codonPos[2] - cdsStart));
        } else {
            this.codonPos = null;
            this.baseCodon = null;
        }
    }

    public String findProteinVariants(SequenceFeature sf) {
        String var;
        int colonPos;
        if (!this.features.contains(sf) || this.baseCodon == null) {
            return "";
        }
        String hgvsp = sf.getValueAsString(CSQ, HGV_SP);
        if (hgvsp != null && (colonPos = hgvsp.lastIndexOf(58)) >= 0 && (var = hgvsp.substring(colonPos + 1)).contains("p.")) {
            return var;
        }
        int cdsPos = sf.getBegin();
        if (cdsPos != sf.getEnd()) {
            return "";
        }
        if (cdsPos != this.codonPos[0] && cdsPos != this.codonPos[1] && cdsPos != this.codonPos[2]) {
            return "";
        }
        String alls = (String)sf.getValue("alleles");
        if (alls == null) {
            return "";
        }
        String from3 = StringUtils.toSentenceCase(ResidueProperties.aa2Triplet.get(String.valueOf(this.toResidue)));
        HashSet<String> variantPeptides = new HashSet<String>();
        String[] alleles = alls.toUpperCase().split(",");
        StringBuilder vars = new StringBuilder();
        for (String allele : alleles) {
            if ((allele = allele.trim().toUpperCase()).length() > 1 || "-".equals(allele)) continue;
            char[] variantCodon = new char[]{this.baseCodon[0], this.baseCodon[1], this.baseCodon[2]};
            int i = cdsPos == this.codonPos[0] ? 0 : (cdsPos == this.codonPos[1] ? 1 : 2);
            variantCodon[i] = allele.toUpperCase().charAt(0);
            if (variantCodon[i] == this.baseCodon[i]) continue;
            String codon = new String(variantCodon);
            String peptide = ResidueProperties.codonTranslate(codon);
            boolean synonymous = this.toResidue == peptide.charAt(0);
            StringBuilder var2 = new StringBuilder();
            if (synonymous) {
                var2.append("c.").append(String.valueOf(cdsPos)).append(String.valueOf(this.baseCodon[i])).append(">").append(String.valueOf(variantCodon[i])).append("(p.=)");
            } else {
                String to3 = ResidueProperties.STOP.equals(peptide) ? "Ter" : StringUtils.toSentenceCase(ResidueProperties.aa2Triplet.get(peptide));
                var2.append("p.").append(from3).append(String.valueOf(this.toPosition)).append(to3);
            }
            if (variantPeptides.contains(peptide)) continue;
            variantPeptides.add(peptide);
            if (vars.length() > 0) {
                vars.append(",");
            }
            vars.append((CharSequence)var2);
        }
        return vars.toString();
    }

    public String getLinkedSequenceName() {
        return this.featureSequence == null ? null : this.featureSequence.getName();
    }

    public int[] getMappedPositions(int begin, int end) {
        MapList map = this.mapping.getMap();
        return this.mapping.to == this.featureSequence ? map.locateInFrom(begin, end) : map.locateInTo(begin, end);
    }

    public boolean isFromCds() {
        if (this.mapping.getMap().getFromRatio() == 3) {
            return this.mapping.to != this.featureSequence;
        }
        return this.mapping.to == this.featureSequence;
    }
}

