/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.bin.GetMemory;

public class MemorySetting {
    public static final String MAX_HEAPSIZE_PERCENT_PROPERTY_NAME = "jvmmempc";
    public static final String MAX_HEAPSIZE_PROPERTY_NAME = "jvmmemmax";
    private static final int MAX_HEAPSIZE_PERCENT_DEFAULT = 90;
    private static final long GIGABYTE = 0x40000000L;
    public static final long LEAVE_FREE_MIN_MEMORY = 0x20000000L;
    public static final long APPLICATION_MIN_MEMORY = 0x20000000L;
    private static final long MAX_HEAPSIZE_GB_DEFAULT = 32L;
    private static final long NOMEM_MAX_HEAPSIZE_GB_DEFAULT = 8L;
    protected static boolean logToClassChecked = false;

    public static long getMemorySetting() {
        return MemorySetting.getMemorySetting(null, null);
    }

    public static long getMemorySetting(String jvmmemmaxarg, String jvmmempcarg) {
        String jvmmemmax;
        long maxMemLong = -1L;
        long memmax = 0x800000000L;
        if (jvmmemmaxarg == null) {
            jvmmemmaxarg = System.getProperty(MAX_HEAPSIZE_PROPERTY_NAME);
        }
        if ((jvmmemmax = jvmmemmaxarg) != null && jvmmemmax.length() > 0) {
            long multiplier = 1L;
            switch (jvmmemmax.toLowerCase().substring(jvmmemmax.length() - 1)) {
                case "t": {
                    multiplier = 0x10000000000L;
                    jvmmemmax = jvmmemmax.substring(0, jvmmemmax.length() - 1);
                    break;
                }
                case "g": {
                    multiplier = 0x40000000L;
                    jvmmemmax = jvmmemmax.substring(0, jvmmemmax.length() - 1);
                    break;
                }
                case "m": {
                    multiplier = 0x100000L;
                    jvmmemmax = jvmmemmax.substring(0, jvmmemmax.length() - 1);
                    break;
                }
                case "k": {
                    multiplier = 1024L;
                    jvmmemmax = jvmmemmax.substring(0, jvmmemmax.length() - 1);
                    break;
                }
                case "b": {
                    multiplier = 1L;
                    jvmmemmax = jvmmemmax.substring(0, jvmmemmax.length() - 1);
                    break;
                }
            }
            try {
                memmax = Long.parseLong(jvmmemmax);
            }
            catch (NumberFormatException e) {
                memmax = 0x800000000L;
                System.out.println("MemorySetting Property 'jvmmemmax' (" + jvmmemmaxarg + "') badly formatted, using default (32g).");
            }
            if (Long.MAX_VALUE / memmax < multiplier) {
                memmax = 0x800000000L;
                System.out.println("MemorySetting Property 'jvmmemmax' (" + jvmmemmaxarg + ") too big, using default (32g).");
            } else {
                memmax = multiplier * memmax;
            }
            if (memmax < 0x20000000L) {
                memmax = 0x20000000L;
                System.out.println("MemorySetting Property 'jvmmemmax' (" + jvmmemmaxarg + ") too small, using minimum (536870912).");
            }
        }
        float percent = 90.0f;
        if (jvmmempcarg == null) {
            jvmmempcarg = System.getProperty(MAX_HEAPSIZE_PERCENT_PROPERTY_NAME);
        }
        String jvmmempc = jvmmempcarg;
        long mempc = -1L;
        try {
            if (jvmmempc != null) {
                float trypercent = Float.parseFloat(jvmmempc);
                if (0.0f < trypercent && trypercent <= 100.0f) {
                    percent = trypercent;
                } else {
                    System.out.println("MemorySetting Property 'jvmmempc' should be in range 1..100. Using default " + percent + "%");
                }
            }
        }
        catch (NumberFormatException e) {
            System.out.println("MemorySetting property 'jvmmempc' (" + jvmmempcarg + ") badly formatted");
        }
        boolean memoryPercentError = false;
        try {
            long physicalMem = GetMemory.getPhysicalMemory();
            if (physicalMem > 0x20000000L) {
                mempc = (long)((float)physicalMem / 100.0f * percent);
                boolean reducedmempc = false;
                if (physicalMem - mempc < 0x20000000L) {
                    mempc = physicalMem - 0x20000000L;
                    reducedmempc = true;
                    System.out.println("MemorySetting Property 'jvmmempc' (" + jvmmempcarg + ") too large. Leaving free space for OS and reducing to (" + mempc + ").");
                }
                if (mempc < 0x20000000L) {
                    if (reducedmempc) {
                        System.out.println("Reduced MemorySetting (" + mempc + ") too small. Increasing to application minimum (536870912).");
                    } else {
                        System.out.println("MemorySetting Property 'jvmmempc' (" + jvmmempcarg + ") too small. Using minimum (536870912).");
                    }
                    mempc = 0x20000000L;
                }
            } else {
                mempc = physicalMem;
                System.out.println("Not enough physical memory for application. Ignoring MemorySetting Property 'jvmmempc' (" + jvmmempcarg + "). Using maximum memory available (" + physicalMem + ").");
            }
        }
        catch (Throwable t) {
            memoryPercentError = true;
            System.out.println("Problem calling GetMemory.getPhysicalMemory(). Likely to be problem with com.sun.management.OperatingSystemMXBean");
            t.printStackTrace();
        }
        if (memoryPercentError && mempc == -1L && (jvmmempcarg != null || jvmmemmaxarg == null) && memmax > 0x200000000L) {
            System.out.println("Capping maximum memory to 8g due to failure to read physical memory size.");
            memmax = 0x200000000L;
        }
        maxMemLong = mempc == -1L ? memmax : Math.min(mempc, memmax);
        return maxMemLong;
    }
}

