/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.bin.HiDPISetting;
import jalview.bin.MemorySetting;
import jalview.util.ChannelProperties;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;

public class Launcher {
    private static final String startClass = "jalview.bin.Jalview";
    private static final String dockIconPath = ChannelProperties.getProperty("logo.512");

    public static void main(String[] args) {
        String scalePropertyArg;
        long maxMemLong;
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        Object memSetting = null;
        boolean isAMac = System.getProperty("os.name").indexOf("Mac") > -1;
        for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            command.add(jvmArg);
        }
        command.add("-cp");
        command.add(ManagementFactory.getRuntimeMXBean().getClassPath());
        String jvmmempc = null;
        String jvmmemmax = null;
        ArrayList<String> arguments = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-jvmmempc=")) {
                jvmmempc = arg.substring("jvmmempc".length() + 2);
                continue;
            }
            if (arg.startsWith("-jvmmemmax=")) {
                jvmmemmax = arg.substring("jvmmemmax".length() + 2);
                continue;
            }
            arguments.add(arg);
        }
        boolean memSet = false;
        boolean dockIcon = false;
        boolean dockName = false;
        for (int i = 0; i < command.size(); ++i) {
            String arg = (String)command.get(i);
            if (arg.startsWith("-Xmx")) {
                if (jvmmempc != null || jvmmemmax != null) continue;
                memSetting = arg;
                memSet = true;
                continue;
            }
            if (arg.startsWith("-Xdock:icon")) {
                dockIcon = true;
                continue;
            }
            if (!arg.startsWith("-Xdock:name")) continue;
            dockName = true;
        }
        if (!memSet && (maxMemLong = MemorySetting.getMemorySetting(jvmmemmax, jvmmempc)) > 0L) {
            memSetting = "-Xmx" + Long.toString(maxMemLong);
            memSet = true;
            command.add((String)memSetting);
        }
        if (isAMac) {
            if (!dockIcon) {
                command.add("-Xdock:icon=" + dockIconPath);
            }
            if (!dockName) {
                command.add("-Xdock:name=" + ChannelProperties.getProperty("app_name"));
            }
        }
        if ((scalePropertyArg = HiDPISetting.getScalePropertyArg()) != null) {
            System.out.println("Running jalview.bin.Jalview with scale setting " + scalePropertyArg);
            command.add(scalePropertyArg);
        }
        command.add(startClass);
        command.addAll(arguments);
        ProcessBuilder builder = new ProcessBuilder(command);
        if (Boolean.parseBoolean(System.getProperty("launcherprint", "false"))) {
            System.out.println("LAUNCHER COMMAND: " + String.join((CharSequence)" ", builder.command()));
        }
        System.out.println("Running jalview.bin.Jalview with " + (String)(memSetting == null ? "no memory setting" : "memory setting " + (String)memSetting));
        if (Boolean.parseBoolean(System.getProperty("launcherstop", "false"))) {
            System.exit(0);
        }
        try {
            builder.inheritIO();
            Process process = builder.start();
            process.waitFor();
        }
        catch (IOException e) {
            if (e.getMessage().toLowerCase().contains("memory")) {
                System.out.println("Caught a memory exception: " + e.getMessage());
                ArrayList<String> commandNoMem = new ArrayList<String>();
                for (int i = 0; i < command.size(); ++i) {
                    if (((String)command.get(i)).startsWith("-Xmx")) continue;
                    commandNoMem.add((String)command.get(i));
                }
                ProcessBuilder builderNoMem = new ProcessBuilder(commandNoMem);
                System.out.println("Command without memory setting: " + String.join((CharSequence)" ", builderNoMem.command()));
                try {
                    builderNoMem.inheritIO();
                    Process processNoMem = builderNoMem.start();
                    processNoMem.waitFor();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

