/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.bin.BuildDetails;
import jalview.datamodel.PDBEntry;
import jalview.gui.Preferences;
import jalview.io.PIRFile;
import jalview.jbgui.GDesktop;
import jalview.schemes.ColourSchemeLoader;
import jalview.schemes.ColourSchemes;
import jalview.schemes.UserColourScheme;
import jalview.structure.StructureImportSettings;
import jalview.urls.IdOrgSettings;
import jalview.util.ChannelProperties;
import jalview.util.ColorUtils;
import jalview.util.Format;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.sifts.SiftsSettings;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class Cache {
    public static final String CASTORLOGLEVEL = "logs.Castor.level";
    public static final String AXISLOGLEVEL = "logs.Axis.level";
    public static final String JALVIEWLOGLEVEL = "logs.Jalview.level";
    public static final String DEFAULT_SIFTS_DOWNLOAD_DIR = System.getProperty("user.home") + File.separatorChar + ".sifts_downloads" + File.separatorChar;
    private static final String DEFAULT_CACHE_THRESHOLD_IN_DAYS = "2";
    private static final String DEFAULT_FAIL_SAFE_PID_THRESHOLD = "30";
    private static final String ID_ORG_FILE = System.getProperty("user.home") + File.separatorChar + ".identifiers.org.ids.json";
    private static final String PDB_DOWNLOAD_FORMAT = PDBEntry.Type.MMCIF.toString();
    private static final String DEFAULT_PDB_FILE_PARSER = StructureImportSettings.StructureParser.JMOL_PARSER.toString();
    private static final DateFormat date_format = SimpleDateFormat.getDateTimeInstance(2, 2, Locale.UK);
    public static Logger log;
    public static final String[] startupProxyProperties;
    public static final String PROXYTYPE_NONE = "none";
    public static final String PROXYTYPE_SYSTEM = "false";
    public static final String PROXYTYPE_CUSTOM = "true";
    public static char[] proxyAuthPassword;
    public static Properties applicationProperties;
    public static Properties buildProperties;
    static String propertiesFile;
    private static boolean propsAreReadOnly;
    private static final String JS_PROPERTY_PREFIX = "jalview_";
    private static int vamsasJarsArePresent;
    private static int groovyJarsArePresent;
    protected static Object tracker;
    protected static Class trackerfocus;
    protected static Class jgoogleanalyticstracker;
    public static final int TRACE = 10;
    public static final int DEBUG = 20;
    public static final int INFO = 30;
    public static final int WARN = 40;
    public static final int ERROR = 50;
    private static final String releaseAppbase;
    private static String getdownAppbase;
    private static String getdownDistDir;

    public static void initLogger() {
        if (log != null) {
            return;
        }
        try {
            ConsoleAppender ap = new ConsoleAppender((Layout)new SimpleLayout(), "System.err");
            ap.setName("JalviewLogger");
            Logger.getRootLogger().addAppender((Appender)ap);
            Logger laxis = Logger.getLogger((String)"org.apache.axis");
            Logger lcastor = Logger.getLogger((String)"org.exolab.castor");
            log = Logger.getLogger((String)"jalview.bin.Jalview");
            laxis.setLevel(Level.toLevel((String)Cache.getDefault("logs.Axis.Level", Level.INFO.toString())));
            lcastor.setLevel(Level.toLevel((String)Cache.getDefault("logs.Castor.Level", Level.INFO.toString())));
            lcastor = Logger.getLogger((String)"org.exolab.castor.xml");
            lcastor.setLevel(Level.toLevel((String)Cache.getDefault("logs.Castor.Level", Level.INFO.toString())));
            Logger.getRootLogger().setLevel(Level.INFO);
            log.setLevel(Level.toLevel((String)Cache.getDefault(JALVIEWLOGLEVEL, Level.INFO.toString())));
            log.debug((Object)(ChannelProperties.getProperty("app_name") + " Debugging Output Follows."));
        }
        catch (Exception ex) {
            System.err.println("Problems initializing the log4j system\n");
            ex.printStackTrace(System.err);
        }
    }

    public static void loadProperties(String propsFile) {
        propertiesFile = propsFile;
        String releasePropertiesFile = null;
        boolean defaultProperties = false;
        if (propsFile == null && !propsAreReadOnly) {
            String channelPrefsFilename = ChannelProperties.getProperty("preferences.filename");
            String releasePrefsFilename = ".jalview_properties";
            propertiesFile = System.getProperty("user.home") + File.separatorChar + channelPrefsFilename;
            releasePropertiesFile = System.getProperty("user.home") + File.separatorChar + releasePrefsFilename;
            defaultProperties = true;
        } else {
            propsAreReadOnly = true;
        }
        if (propertiesFile == null) {
            Platform.readInfoProperties(JS_PROPERTY_PREFIX, applicationProperties);
        } else {
            try {
                InputStream fis;
                try {
                    fis = new URL(propertiesFile).openStream();
                    System.out.println("Loading jalview properties from : " + propertiesFile);
                    System.out.println("Disabling Jalview writing to user's local properties file.");
                    propsAreReadOnly = true;
                }
                catch (Exception ex) {
                    fis = null;
                }
                if (fis == null) {
                    Object readPropertiesFile = propertiesFile;
                    if (defaultProperties && !new File(propertiesFile).exists() && new File(releasePropertiesFile).exists()) {
                        readPropertiesFile = releasePropertiesFile;
                    }
                    fis = new FileInputStream((String)readPropertiesFile);
                }
                applicationProperties.clear();
                applicationProperties.load(fis);
                Cache.deleteBuildProperties();
                fis.close();
            }
            catch (Exception ex) {
                System.out.println("Error reading properties file: " + ex);
            }
        }
        String proxyType = Cache.getDefault("USE_PROXY", PROXYTYPE_SYSTEM);
        switch (proxyType) {
            case "none": {
                Cache.clearProxyProperties();
                break;
            }
            case "false": {
                Cache.resetProxyProperties();
                break;
            }
            case "true": {
                String httpHost = Cache.getDefault("PROXY_SERVER", "");
                String httpPort = Cache.getDefault("PROXY_PORT", "8080");
                String httpsHost = Cache.getDefault("PROXY_SERVER_HTTPS", httpHost);
                String httpsPort = Cache.getDefault("PROXY_PORT_HTTPS", httpPort);
                String httpUser = Cache.getDefault("PROXY_AUTH_USER", null);
                String httpsUser = Cache.getDefault("PROXY_AUTH_USER_HTTPS", httpUser);
                Cache.setProxyProperties(httpHost, httpPort, httpsHost, httpsPort, httpUser, proxyAuthPassword, httpsUser, proxyAuthPassword, "localhost");
                break;
            }
            default: {
                String message = "Incorrect PROXY_TYPE - should be 'none' (clear proxy properties), 'false' (system settings), 'true' (custom settings): " + proxyType;
                Cache.warn(message);
            }
        }
        String authorDetails = Cache.resolveResourceURLFor("/authors.props");
        try {
            if (authorDetails != null) {
                URL localJarFileURL = new URL(authorDetails);
                InputStream in = localJarFileURL.openStream();
                applicationProperties.load(in);
                in.close();
            }
        }
        catch (Exception ex) {
            System.out.println("Error reading author details: " + ex);
            authorDetails = null;
        }
        if (authorDetails == null) {
            applicationProperties.remove("AUTHORS");
            applicationProperties.remove("AUTHORFNAMES");
            applicationProperties.remove("YEAR");
        }
        Cache.loadBuildProperties(false);
        SiftsSettings.setMapWithSifts(Cache.getDefault("MAP_WITH_SIFTS", false));
        SiftsSettings.setSiftDownloadDirectory(Cache.getDefault("sifts_download_dir", DEFAULT_SIFTS_DOWNLOAD_DIR));
        SiftsSettings.setFailSafePIDThreshold(Cache.getDefault("sifts_fail_safe_pid_threshold", DEFAULT_FAIL_SAFE_PID_THRESHOLD));
        SiftsSettings.setCacheThresholdInDays(Cache.getDefault("sifts_cache_threshold_in_days", DEFAULT_CACHE_THRESHOLD_IN_DAYS));
        IdOrgSettings.setUrl(Cache.getDefault("ID_ORG_HOSTURL", "http://www.jalview.org/services/identifiers"));
        IdOrgSettings.setDownloadLocation(ID_ORG_FILE);
        StructureImportSettings.setDefaultStructureFileFormat(Cache.getDefault("PDB_DOWNLOAD_FORMAT", PDB_DOWNLOAD_FORMAT));
        StructureImportSettings.setDefaultPDBFileParser(DEFAULT_PDB_FILE_PARSER);
        String jnlpVersion = System.getProperty("jalview.version");
        if (jnlpVersion == null && Cache.getDefault("VERSION_CHECK", true) && (System.getProperty("java.awt.headless") == null || System.getProperty("java.awt.headless").equals(PROXYTYPE_SYSTEM))) {
            class VersionChecker
            extends Thread {
                VersionChecker() {
                }

                @Override
                public void run() {
                    String remoteBuildPropertiesUrl = Cache.getAppbaseBuildProperties();
                    String orgtimeout = System.getProperty("sun.net.client.defaultConnectTimeout");
                    if (orgtimeout == null) {
                        orgtimeout = Cache.DEFAULT_FAIL_SAFE_PID_THRESHOLD;
                        System.out.println("# INFO: Setting default net timeout to " + orgtimeout + " seconds.");
                    }
                    String remoteVersion = null;
                    try {
                        System.setProperty("sun.net.client.defaultConnectTimeout", "5000");
                        URL url = new URL(remoteBuildPropertiesUrl);
                        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                        Properties remoteBuildProperties = new Properties();
                        remoteBuildProperties.load(in);
                        remoteVersion = remoteBuildProperties.getProperty("VERSION");
                    }
                    catch (Exception ex) {
                        System.out.println("Non-fatal exception when checking version at " + remoteBuildPropertiesUrl + ":");
                        System.out.println(ex);
                        remoteVersion = Cache.getProperty("VERSION");
                    }
                    System.setProperty("sun.net.client.defaultConnectTimeout", orgtimeout);
                    Cache.setProperty("LATEST_VERSION", remoteVersion);
                }
            }
            VersionChecker vc = new VersionChecker();
            vc.start();
        } else if (jnlpVersion != null) {
            Cache.setProperty("LATEST_VERSION", jnlpVersion);
        } else {
            applicationProperties.remove("LATEST_VERSION");
        }
        Cache.initUserColourSchemes(Cache.getProperty("USER_DEFINED_COLOURS"));
        PIRFile.useModellerOutput = Cache.getDefault("PIR_MODELLER", false);
    }

    private static String resolveResourceURLFor(String resourcePath) {
        String url = null;
        if (Platform.isJS() || !Cache.class.getProtectionDomain().getCodeSource().getLocation().toString().endsWith(".jar")) {
            try {
                url = Cache.class.getResource(resourcePath).toString();
            }
            catch (Exception ex) {
                System.err.println("Failed to resolve resource " + resourcePath + ": " + ex.getMessage());
            }
        } else {
            url = "jar:".concat(Cache.class.getProtectionDomain().getCodeSource().getLocation().toString().concat("!" + resourcePath));
        }
        return url;
    }

    public static void loadBuildProperties(boolean reportVersion) {
        Object codeInstallation = Cache.getProperty("INSTALLATION");
        boolean printVersion = codeInstallation == null;
        try {
            String buildDetails = Cache.resolveResourceURLFor("/.build_properties");
            URL localJarFileURL = new URL(buildDetails);
            InputStream in = localJarFileURL.openStream();
            buildProperties.load(in);
            in.close();
            if (buildProperties.getProperty("BUILD_DATE", null) != null) {
                applicationProperties.put("BUILD_DATE", buildProperties.getProperty("BUILD_DATE"));
            }
            if (buildProperties.getProperty("INSTALLATION", null) != null) {
                applicationProperties.put("INSTALLATION", buildProperties.getProperty("INSTALLATION"));
            }
            if (buildProperties.getProperty("VERSION", null) != null) {
                applicationProperties.put("VERSION", buildProperties.getProperty("VERSION"));
            }
        }
        catch (Exception ex) {
            System.out.println("Error reading build details: " + ex);
            applicationProperties.remove("VERSION");
        }
        String codeVersion = Cache.getProperty("VERSION");
        codeInstallation = Cache.getProperty("INSTALLATION");
        if (codeVersion == null) {
            codeVersion = "Test";
            codeInstallation = "";
        } else {
            codeInstallation = " (" + (String)codeInstallation + ")";
        }
        Cache.setProperty("VERSION", codeVersion);
        new BuildDetails(codeVersion, null, (String)codeInstallation);
        if (printVersion && reportVersion) {
            System.out.println(ChannelProperties.getProperty("app_name") + " Version: " + codeVersion + (String)codeInstallation);
        }
    }

    private static void deleteBuildProperties() {
        applicationProperties.remove("LATEST_VERSION");
        applicationProperties.remove("VERSION");
        applicationProperties.remove("AUTHORS");
        applicationProperties.remove("AUTHORFNAMES");
        applicationProperties.remove("YEAR");
        applicationProperties.remove("BUILD_DATE");
        applicationProperties.remove("INSTALLATION");
    }

    public static String getProperty(String key) {
        String prop = applicationProperties.getProperty(key);
        if (prop == null && Platform.isJS()) {
            prop = applicationProperties.getProperty(Platform.getUniqueAppletID() + "_jalview_" + key);
        }
        return prop;
    }

    public static boolean getDefault(String property, boolean def) {
        String string = Cache.getProperty(property);
        if (string != null) {
            def = Boolean.valueOf(string);
        }
        return def;
    }

    public static int getDefault(String property, int def) {
        String string = Cache.getProperty(property);
        if (string != null) {
            try {
                def = Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                System.out.println("Error parsing int property '" + property + "' with value '" + string + "'");
            }
        }
        return def;
    }

    public static String getDefault(String property, String def) {
        String value = Cache.getProperty(property);
        return value == null ? def : value;
    }

    public static Object setProperty(String key, String obj) {
        Object oldValue = null;
        try {
            oldValue = applicationProperties.setProperty(key, obj);
            if (propertiesFile != null && !propsAreReadOnly) {
                FileOutputStream out = new FileOutputStream(propertiesFile);
                applicationProperties.store(out, "---JalviewX Properties File---");
                out.close();
            }
        }
        catch (Exception ex) {
            System.out.println("Error setting property: " + key + " " + obj + "\n" + ex);
        }
        return oldValue;
    }

    public static void removeProperty(String string) {
        applicationProperties.remove(string);
        Cache.saveProperties();
    }

    public static void saveProperties() {
        if (!propsAreReadOnly) {
            try {
                FileOutputStream out = new FileOutputStream(propertiesFile);
                applicationProperties.store(out, "---JalviewX Properties File---");
                out.close();
            }
            catch (Exception ex) {
                System.out.println("Error saving properties: " + ex);
            }
        }
    }

    public static boolean vamsasJarsPresent() {
        if (vamsasJarsArePresent == -1) {
            try {
                if (GDesktop.class.getClassLoader().loadClass("uk.ac.vamsas.client.VorbaId") != null) {
                    log.debug((Object)"Found Vamsas Classes (uk.ac..vamsas.client.VorbaId can be loaded)");
                    vamsasJarsArePresent = 1;
                    Logger lvclient = Logger.getLogger((String)"uk.ac.vamsas");
                    lvclient.setLevel(Level.toLevel((String)Cache.getDefault("logs.Vamsas.Level", Level.INFO.toString())));
                    lvclient.addAppender(log.getAppender("JalviewLogger"));
                    lvclient.debug((Object)(ChannelProperties.getProperty("app_name") + " Vamsas Client Debugging Output Follows."));
                }
            }
            catch (Exception e) {
                vamsasJarsArePresent = 0;
                log.debug((Object)"Vamsas Classes are not present");
            }
        }
        return vamsasJarsArePresent > 0;
    }

    public static boolean groovyJarsPresent() {
        if (groovyJarsArePresent == -1) {
            try {
                if (Cache.class.getClassLoader().loadClass("groovy.lang.GroovyObject") != null) {
                    log.debug((Object)"Found Groovy (groovy.lang.GroovyObject can be loaded)");
                    groovyJarsArePresent = 1;
                    Logger lgclient = Logger.getLogger((String)"groovy");
                    lgclient.setLevel(Level.toLevel((String)Cache.getDefault("logs.Groovy.Level", Level.INFO.toString())));
                    lgclient.addAppender(log.getAppender("JalviewLogger"));
                    lgclient.debug((Object)(ChannelProperties.getProperty("app_name") + " Groovy Client Debugging Output Follows."));
                }
            }
            catch (Error e) {
                groovyJarsArePresent = 0;
                log.debug((Object)"Groovy Classes are not present", (Throwable)e);
            }
            catch (Exception e) {
                groovyJarsArePresent = 0;
                log.debug((Object)"Groovy Classes are not present");
            }
        }
        return groovyJarsArePresent > 0;
    }

    public static void initGoogleTracker() {
        if (tracker == null) {
            if (jgoogleanalyticstracker == null) {
                try {
                    jgoogleanalyticstracker = Cache.class.getClassLoader().loadClass("com.boxysystems.jgoogleanalytics.JGoogleAnalyticsTracker");
                    trackerfocus = Cache.class.getClassLoader().loadClass("com.boxysystems.jgoogleanalytics.FocusPoint");
                }
                catch (Exception e) {
                    log.debug((Object)"com.boxysystems.jgoogleanalytics package is not present - tracking not enabled.");
                    tracker = null;
                    jgoogleanalyticstracker = null;
                    trackerfocus = null;
                    return;
                }
            }
            RuntimeException re = null;
            Exception ex = null;
            Error err = null;
            Object vrs = "No Version Accessible";
            try {
                tracker = jgoogleanalyticstracker.getConstructor(String.class, String.class, String.class).newInstance(ChannelProperties.getProperty("app_name") + " Desktop", vrs = Cache.getProperty("VERSION") + "_" + Cache.getDefault("BUILD_DATE", "unknown"), "UA-9060947-1");
                jgoogleanalyticstracker.getMethod("trackAsynchronously", trackerfocus).invoke(tracker, trackerfocus.getConstructor(String.class).newInstance("Application Started."));
            }
            catch (RuntimeException e) {
                re = e;
            }
            catch (Exception e) {
                ex = e;
            }
            catch (Error e) {
                err = e;
            }
            if (re != null || ex != null || err != null) {
                if (log != null) {
                    if (re != null) {
                        log.debug((Object)"Caught runtime exception in googletracker init:", (Throwable)re);
                    }
                    if (ex != null) {
                        log.warn((Object)("Failed to initialise GoogleTracker for Jalview Desktop with version " + (String)vrs), (Throwable)ex);
                    }
                    if (err != null) {
                        log.error((Object)("Whilst initing GoogleTracker for Jalview Desktop version " + (String)vrs), (Throwable)err);
                    }
                } else {
                    if (re != null) {
                        System.err.println("Debug: Caught runtime exception in googletracker init:" + (String)vrs);
                        re.printStackTrace();
                    }
                    if (ex != null) {
                        System.err.println("Warning:  Failed to initialise GoogleTracker for Jalview Desktop with version " + (String)vrs);
                        ex.printStackTrace();
                    }
                    if (err != null) {
                        System.err.println("ERROR: Whilst initing GoogleTracker for Jalview Desktop version " + (String)vrs);
                        err.printStackTrace();
                    }
                }
            } else {
                log.debug((Object)"Successfully initialised tracker.");
            }
        }
    }

    public static Color getDefaultColour(String property, Color defcolour) {
        String colprop = Cache.getProperty(property);
        if (colprop == null) {
            return defcolour;
        }
        Color col = ColorUtils.parseColourString(colprop);
        if (col == null) {
            log.warn((Object)("Couldn't parse '" + colprop + "' as a colour for " + property));
        }
        return col == null ? defcolour : col;
    }

    public static void setColourProperty(String property, Color colour) {
        Cache.setProperty(property, Format.getHexString(colour));
    }

    public static String setDateProperty(String propertyName, Date date) {
        String formatted = date_format.format(date);
        Cache.setProperty(propertyName, formatted);
        return formatted;
    }

    public static Date getDateProperty(String propertyName) {
        String val = Cache.getProperty(propertyName);
        if (val != null) {
            try {
                return date_format.parse(val);
            }
            catch (Exception ex) {
                System.err.println("Invalid or corrupt date in property '" + propertyName + "' : value was '" + val + "'");
            }
        }
        return null;
    }

    public static Integer getIntegerProperty(String property) {
        String val = Cache.getProperty(property);
        if (val != null && (val = val.trim()).length() > 0) {
            try {
                return Integer.valueOf(val);
            }
            catch (NumberFormatException x) {
                System.err.println("Invalid integer in property '" + property + "' (value was '" + val + "')");
            }
        }
        return null;
    }

    public static void setOrRemove(String propName, String value) {
        if (propName == null) {
            return;
        }
        if (value == null || value.trim().length() < 1) {
            applicationProperties.remove(propName);
        } else {
            applicationProperties.setProperty(propName, value);
        }
    }

    public static void initUserColourSchemes(String files) {
        if (files == null || files.length() == 0) {
            return;
        }
        StringBuffer coloursFound = new StringBuffer();
        StringTokenizer st = new StringTokenizer(files, "|");
        while (st.hasMoreElements()) {
            String file = st.nextToken();
            try {
                UserColourScheme ucs = ColourSchemeLoader.loadColourScheme(file);
                if (ucs == null) continue;
                if (coloursFound.length() > 0) {
                    coloursFound.append("|");
                }
                coloursFound.append(file);
                ColourSchemes.getInstance().registerColourScheme(ucs);
            }
            catch (Exception ex) {
                System.out.println("Error loading User ColourFile\n" + ex);
            }
        }
        if (!files.equals(coloursFound.toString())) {
            if (coloursFound.toString().length() > 1) {
                Cache.setProperty("USER_DEFINED_COLOURS", coloursFound.toString());
            } else {
                applicationProperties.remove("USER_DEFINED_COLOURS");
            }
        }
    }

    private static void appendIfNotNull(StringBuilder sb, String prefix, String value, String suffix, String defaultValue) {
        if (value == null && defaultValue == null) {
            return;
        }
        String line = prefix + (value != null ? value : defaultValue) + suffix;
        sb.append(line);
    }

    public static String getVersionDetailsForConsole() {
        StringBuilder sb = new StringBuilder();
        sb.append(ChannelProperties.getProperty("app_name")).append(" Version: ");
        sb.append(Cache.getDefault("VERSION", "TEST"));
        sb.append("\n");
        sb.append(ChannelProperties.getProperty("app_name")).append(" Installation: ");
        sb.append(Cache.getDefault("INSTALLATION", "unknown"));
        sb.append("\n");
        sb.append("Build Date: ");
        sb.append(Cache.getDefault("BUILD_DATE", "unknown"));
        sb.append("\n");
        sb.append("Java version: ");
        sb.append(System.getProperty("java.version"));
        sb.append("\n");
        sb.append(System.getProperty("os.arch"));
        sb.append(" ");
        sb.append(System.getProperty("os.name"));
        sb.append(" ");
        sb.append(System.getProperty("os.version"));
        sb.append("\n");
        Cache.appendIfNotNull(sb, "Install4j version: ", System.getProperty("sys.install4jVersion"), "\n", null);
        Cache.appendIfNotNull(sb, "Install4j template version: ", System.getProperty("installer_template_version"), "\n", null);
        Cache.appendIfNotNull(sb, "Launcher version: ", System.getProperty("launcher_version"), "\n", null);
        LookAndFeel laf = UIManager.getLookAndFeel();
        String lafName = laf == null ? "Not obtained" : laf.getName();
        String lafClass = laf == null ? "unknown" : laf.getClass().getName();
        sb.append("LookAndFeel: ");
        sb.append(lafName);
        sb.append(" (");
        sb.append(lafClass);
        sb.append(")\n");
        if (Pattern.matches("^\\d[\\d\\.]*\\d[\\.\\-\\w]*$", Cache.getDefault("VERSION", "TEST"))) {
            Cache.appendIfNotNull(sb, "Getdown appdir: ", System.getProperty("getdownappdir"), "\n", null);
            Cache.appendIfNotNull(sb, "Getdown appbase: ", System.getProperty("getdownappbase"), "\n", null);
            Cache.appendIfNotNull(sb, "Java home: ", System.getProperty("java.home"), "\n", "unknown");
        }
        return sb.toString();
    }

    public static String getBuildDetailsForSplash() {
        return Cache.getDefault("INSTALLATION", "unknown");
    }

    public static String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static void clearProxyProperties() {
        Cache.setProxyProperties(null, null, null, null, null, null, null, null, null);
    }

    public static void resetProxyProperties() {
        Cache.setProxyProperties(startupProxyProperties[0], startupProxyProperties[1], startupProxyProperties[2], startupProxyProperties[3], startupProxyProperties[4], startupProxyProperties[5] == null ? null : startupProxyProperties[5].toCharArray(), startupProxyProperties[6], startupProxyProperties[7] == null ? null : startupProxyProperties[7].toCharArray(), startupProxyProperties[8]);
        StringBuilder sb = new StringBuilder();
        sb.append("Setting proxy properties to: http.proxyHost=").append(startupProxyProperties[0]).append(", http.proxyPort=").append(startupProxyProperties[1]).append((String)(startupProxyProperties[4] != null && !startupProxyProperties[4].isEmpty() ? " [" + startupProxyProperties[4] + "]" : "")).append(", https.proxyHost=").append(startupProxyProperties[2]).append(", https.proxyPort=").append(startupProxyProperties[3]).append((String)(startupProxyProperties[6] != null && !startupProxyProperties[6].isEmpty() ? " [" + startupProxyProperties[6] + "]" : ""));
        Cache.debug(sb.toString());
    }

    public static void setProxyPropertiesFromPreferences() {
        Cache.setProxyPropertiesFromPreferences(PROXYTYPE_SYSTEM);
    }

    public static void setProxyPropertiesFromPreferences(String previousProxyType) {
        String proxyType = Cache.getDefault("USE_PROXY", PROXYTYPE_SYSTEM);
        if (previousProxyType != null && !proxyType.equals(PROXYTYPE_CUSTOM) && proxyType.equals(previousProxyType)) {
            return;
        }
        switch (proxyType) {
            case "none": {
                if (previousProxyType.equals(proxyType)) break;
                log.info((Object)"Setting no proxy settings");
                Cache.setProxyProperties(null, null, null, null, null, null, null, null, null);
                break;
            }
            case "true": {
                log.info((Object)"Setting custom proxy settings");
                boolean proxyAuthSet = Cache.getDefault("PROXY_AUTH", false);
                Cache.setProxyProperties(Cache.getDefault("PROXY_SERVER", null), Cache.getDefault("PROXY_PORT", null), Cache.getDefault("PROXY_SERVER_HTTPS", null), Cache.getDefault("PROXY_PORT_HTTPS", null), proxyAuthSet ? Cache.getDefault("PROXY_AUTH_USERNAME", "") : null, (char[])(proxyAuthSet ? proxyAuthPassword : null), proxyAuthSet ? Cache.getDefault("PROXY_AUTH_USERNAME", "") : null, (char[])(proxyAuthSet ? proxyAuthPassword : null), "localhost");
                break;
            }
            default: {
                log.info((Object)"Setting system proxy settings");
                Cache.resetProxyProperties();
            }
        }
    }

    public static void setProxyProperties(final String httpHost, final String httpPort, final String httpsHost, final String httpsPort, final String httpUser, final char[] httpPassword, final String httpsUser, final char[] httpsPassword, String nonProxyHosts) {
        Cache.setOrClearSystemProperty("http.proxyHost", httpHost);
        Cache.setOrClearSystemProperty("http.proxyPort", httpPort);
        Cache.setOrClearSystemProperty("https.proxyHost", httpsHost);
        Cache.setOrClearSystemProperty("https.proxyPort", httpsPort);
        Cache.setOrClearSystemProperty("http.proxyUser", httpUser);
        Cache.setOrClearSystemProperty("https.proxyUser", httpsUser);
        final boolean customProxySet = Cache.getDefault("USE_PROXY", PROXYTYPE_SYSTEM).equals(PROXYTYPE_CUSTOM);
        if (httpUser != null || httpsUser != null) {
            try {
                final char[] displayHttpPw = new char[httpPassword == null ? 0 : httpPassword.length];
                Arrays.fill(displayHttpPw, '*');
                Cache.debug("CACHE Proxy: setting new Authenticator with httpUser='" + httpUser + "' httpPassword='" + displayHttpPw + "'");
                if (!Platform.isJS()) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                                String protocol = this.getRequestingProtocol();
                                boolean needProxyPasswordSet = false;
                                if (customProxySet && protocol.equalsIgnoreCase("http") && httpUser != null && httpUser.length() > 0 && (httpPassword == null || httpPassword.length == 0) || protocol.equalsIgnoreCase("https") && httpsUser != null && httpsUser.length() > 0 && (httpsPassword == null || httpsPassword.length == 0)) {
                                    String message = MessageManager.getString("label.proxy_password_required");
                                    Preferences.openPreferences(5, message);
                                    Preferences.getInstance().proxyAuthPasswordCheckHighlight(true, true);
                                } else {
                                    try {
                                        if (protocol.equalsIgnoreCase("http") && this.getRequestingHost().equalsIgnoreCase(httpHost) && this.getRequestingPort() == Integer.valueOf(httpPort).intValue()) {
                                            Cache.debug("AUTHENTICATOR returning PasswordAuthentication(\"" + httpUser + "\", '" + new String(displayHttpPw) + "')");
                                            return new PasswordAuthentication(httpUser, httpPassword);
                                        }
                                        if (protocol.equalsIgnoreCase("https") && this.getRequestingHost().equalsIgnoreCase(httpsHost) && this.getRequestingPort() == Integer.valueOf(httpsPort).intValue()) {
                                            char[] displayHttpsPw = new char[httpPassword.length];
                                            Arrays.fill(displayHttpsPw, '*');
                                            Cache.debug("AUTHENTICATOR returning PasswordAuthentication(\"" + httpsUser + "\", '" + displayHttpsPw + "'");
                                            return new PasswordAuthentication(httpsUser, httpsPassword);
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        Cache.error("Problem with proxy port values [http:" + httpPort + ", https:" + httpsPort + "]");
                                    }
                                    Cache.debug("AUTHENTICATOR after trying to get PasswordAuthentication");
                                }
                            }
                            Cache.debug("AUTHENTICATOR returning null");
                            return null;
                        }
                    });
                }
                Cache.debug("AUTHENTICATOR setting property 'jdk.http.auth.tunneling.disabledSchemes' to \"\"");
                System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            }
            catch (SecurityException e) {
                Cache.error("Could not set default Authenticator");
                Cache.debug(Cache.getStackTraceString(e));
            }
        } else if (!Platform.isJS()) {
            Cache.debug("AUTHENTICATOR setting default Authenticator to null");
            Authenticator.setDefault(null);
        }
        Cache.debug("AUTHENTICATOR setting property 'http.nonProxyHosts' to \"" + nonProxyHosts + "\"");
        Cache.setOrClearSystemProperty("http.nonProxyHosts", nonProxyHosts);
    }

    public static void setOrClearSystemProperty(String key, char[] value) {
        Cache.setOrClearSystemProperty(key, value == null ? null : new String(value));
    }

    public static void setOrClearSystemProperty(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    public static boolean println(int level, String message) {
        if (log == null) {
            if (level >= 40) {
                System.err.println(message);
            } else if (level >= 30) {
                System.out.println(message);
            }
            return false;
        }
        if (level >= 50) {
            log.error((Object)message);
        } else if (level >= 40) {
            log.warn((Object)message);
        } else if (level >= 30) {
            log.info((Object)message);
        } else if (level >= 20) {
            log.debug((Object)message);
        } else {
            log.trace((Object)message);
        }
        return true;
    }

    public static void trace(String message) {
        Cache.println(10, message);
    }

    public static void debug(String message) {
        Cache.println(20, message);
    }

    public static void info(String message) {
        Cache.println(30, message);
    }

    public static void warn(String message) {
        Cache.println(40, message);
    }

    public static void error(String message) {
        Cache.println(50, message);
    }

    public static void trace(Throwable e) {
        Cache.println(10, Cache.getStackTraceString(e));
    }

    public static void debug(Throwable e) {
        Cache.println(20, Cache.getStackTraceString(e));
    }

    public static void info(Throwable e) {
        Cache.println(30, Cache.getStackTraceString(e));
    }

    public static void warn(Throwable e) {
        Cache.println(40, Cache.getStackTraceString(e));
    }

    public static void error(Throwable e) {
        Cache.println(50, Cache.getStackTraceString(e));
    }

    private static void setGetdownAppbase() {
        if (getdownAppbase != null) {
            return;
        }
        String appbase = System.getProperty("getdownappbase");
        String distDir = System.getProperty("getdowndistdir");
        if (appbase == null) {
            appbase = buildProperties.getProperty("GETDOWNAPPBASE");
            distDir = buildProperties.getProperty("GETDOWNAPPDISTDIR");
        }
        if (appbase == null) {
            appbase = releaseAppbase;
            distDir = "release";
        }
        if (appbase.endsWith("/")) {
            appbase = appbase.substring(0, appbase.length() - 1);
        }
        if (distDir == null) {
            distDir = appbase.equals(releaseAppbase) ? "release" : "alt";
        }
        getdownAppbase = appbase;
        getdownDistDir = distDir;
    }

    public static String getGetdownAppbase() {
        Cache.setGetdownAppbase();
        return getdownAppbase;
    }

    public static String getAppbaseBuildProperties() {
        String appbase = Cache.getGetdownAppbase();
        return appbase + "/" + getdownDistDir + "/build_properties";
    }

    static {
        startupProxyProperties = new String[]{System.getProperty("http.proxyHost"), System.getProperty("http.proxyPort"), System.getProperty("https.proxyHost"), System.getProperty("https.proxyPort"), System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword"), System.getProperty("https.proxyUser"), System.getProperty("https.proxyPassword"), System.getProperty("http.nonProxyHosts")};
        proxyAuthPassword = null;
        applicationProperties = new Properties(){

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        buildProperties = new Properties();
        propsAreReadOnly = Platform.isJS();
        vamsasJarsArePresent = -1;
        groovyJarsArePresent = -1;
        tracker = null;
        trackerfocus = null;
        jgoogleanalyticstracker = null;
        if (!Platform.isJS()) {
            Float specversion = Float.valueOf(Float.parseFloat(System.getProperty("java.specification.version")));
            releaseAppbase = specversion.floatValue() < 9.0f ? "https://www.jalview.org/getdown/release/1.8" : "https://www.jalview.org/getdown/release/11";
        } else {
            getdownAppbase = releaseAppbase = "https://www.jalview.org/jalview-js";
            getdownDistDir = "/swingjs/j2s";
        }
    }
}

