/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.Conservation;
import jalview.analysis.TreeModel;
import jalview.api.AlignViewportI;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.PaintRefresher;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.UserColourScheme;
import jalview.util.Format;
import jalview.util.MappingUtils;
import jalview.viewmodel.AlignmentViewport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class TreeCanvas
extends Panel
implements MouseListener,
MouseMotionListener {
    TreeModel tree;
    ScrollPane scrollPane;
    AlignViewport av;
    public static final String PLACEHOLDER = " * ";
    Font font;
    boolean fitToWindow = true;
    boolean showDistances = false;
    boolean showBootstrap = false;
    boolean markPlaceholders = false;
    int offx = 20;
    int offy;
    float threshold;
    String longestName;
    int labelLength = -1;
    Hashtable nameHash = new Hashtable();
    Hashtable nodeHash = new Hashtable();
    SequenceNode highlightNode;
    AlignmentPanel ap;

    public TreeCanvas(AlignmentPanel ap, ScrollPane scroller) {
        this.ap = ap;
        this.av = ap.av;
        this.font = this.av.getFont();
        this.scrollPane = scroller;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setLayout(null);
        PaintRefresher.Register(this, this.av.getSequenceSetId());
    }

    public void treeSelectionChanged(SequenceI sequence) {
        SequenceGroup selected = this.av.getSelectionGroup();
        if (selected == null) {
            selected = new SequenceGroup();
            this.av.setSelectionGroup(selected);
        }
        selected.setEndRes(this.av.getAlignment().getWidth() - 1);
        selected.addOrRemove(sequence, true);
    }

    public void setTree(TreeModel tree2) {
        this.tree = tree2;
        tree2.findHeight(tree2.getTopNode());
        Vector<SequenceNode> leaves = tree2.findLeaves(tree2.getTopNode());
        boolean has_placeholders = false;
        this.longestName = "";
        for (int i = 0; i < leaves.size(); ++i) {
            SequenceNode lf = leaves.elementAt(i);
            if (lf.isPlaceholder()) {
                has_placeholders = true;
            }
            if (this.longestName.length() >= ((Sequence)lf.element()).getName().length()) continue;
            this.longestName = PLACEHOLDER + ((Sequence)lf.element()).getName();
        }
        this.setMarkPlaceholders(has_placeholders);
    }

    public void drawNode(Graphics g, SequenceNode node, float chunk, double scale, int width, int offx, int offy) {
        if (node == null) {
            return;
        }
        if (node.left() == null && node.right() == null) {
            int btstrap;
            double height = node.height;
            double dist = node.dist;
            int xstart = (int)((height - dist) * scale) + offx;
            int xend = (int)(height * scale) + offx;
            int ypos = (int)(node.ycount * chunk) + offy;
            if (node.element() instanceof SequenceI) {
                SequenceI seq = (SequenceI)node.element();
                if (this.av.getSequenceColour(seq) == Color.white) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(this.av.getSequenceColour(seq).darker());
                }
            } else {
                g.setColor(Color.black);
            }
            g.drawLine(xstart, ypos, xend, ypos);
            Object nodeLabel = "";
            if (this.showDistances && node.dist > 0.0) {
                nodeLabel = new Format("%-.2f").form(node.dist);
            }
            if (this.showBootstrap && (btstrap = node.getBootstrap()) > -1) {
                if (this.showDistances) {
                    nodeLabel = (String)nodeLabel + " : ";
                }
                nodeLabel = (String)nodeLabel + String.valueOf(node.getBootstrap());
            }
            if (!((String)nodeLabel).equals("")) {
                g.drawString((String)nodeLabel, xstart + 2, ypos - 2);
            }
            String name = this.markPlaceholders && node.isPlaceholder() ? PLACEHOLDER + node.getName() : node.getName();
            FontMetrics fm = g.getFontMetrics(this.font);
            int charWidth = fm.stringWidth(name) + 3;
            int charHeight = fm.getHeight();
            Rectangle rect = new Rectangle(xend + 10, ypos - charHeight, charWidth, charHeight);
            this.nameHash.put(node.element(), rect);
            SequenceGroup selected = this.av.getSelectionGroup();
            if (selected != null && selected.getSequences(null).contains(node.element())) {
                g.setColor(Color.gray);
                g.fillRect(xend + 10, ypos - charHeight + 3, charWidth, charHeight);
                g.setColor(Color.white);
            }
            g.drawString(name, xend + 10, ypos);
            g.setColor(Color.black);
        } else {
            int btstrap;
            this.drawNode(g, (SequenceNode)node.left(), chunk, scale, width, offx, offy);
            this.drawNode(g, (SequenceNode)node.right(), chunk, scale, width, offx, offy);
            double height = node.height;
            double dist = node.dist;
            int xstart = (int)((height - dist) * scale) + offx;
            int xend = (int)(height * scale) + offx;
            int ypos = (int)(node.ycount * chunk) + offy;
            g.setColor(node.color.darker());
            g.drawLine(xstart, ypos, xend, ypos);
            if (node == this.highlightNode) {
                g.fillRect(xend - 3, ypos - 3, 6, 6);
            } else {
                g.fillRect(xend - 2, ypos - 2, 4, 4);
            }
            int ystart = (int)(node.left() == null ? 0.0f : ((SequenceNode)node.left()).ycount * chunk) + offy;
            int yend = (int)(node.right() == null ? 0.0f : ((SequenceNode)node.right()).ycount * chunk) + offy;
            Rectangle pos = new Rectangle(xend - 2, ypos - 2, 5, 5);
            this.nodeHash.put(node, pos);
            g.drawLine((int)(height * scale) + offx, ystart, (int)(height * scale) + offx, yend);
            Object nodeLabel = "";
            if (this.showDistances && node.dist > 0.0) {
                nodeLabel = new Format("%-.2f").form(node.dist);
            }
            if (this.showBootstrap && (btstrap = node.getBootstrap()) > -1) {
                if (this.showDistances) {
                    nodeLabel = (String)nodeLabel + " : ";
                }
                nodeLabel = (String)nodeLabel + String.valueOf(node.getBootstrap());
            }
            if (!((String)nodeLabel).equals("")) {
                g.drawString((String)nodeLabel, xstart + 2, ypos - 2);
            }
        }
    }

    public Object findElement(int x, int y) {
        Rectangle rect;
        Object ob;
        Enumeration keys = this.nameHash.keys();
        while (keys.hasMoreElements()) {
            ob = keys.nextElement();
            rect = (Rectangle)this.nameHash.get(ob);
            if (x < rect.x || x > rect.x + rect.width || y < rect.y || y > rect.y + rect.height) continue;
            return ob;
        }
        keys = this.nodeHash.keys();
        while (keys.hasMoreElements()) {
            ob = keys.nextElement();
            rect = (Rectangle)this.nodeHash.get(ob);
            if (x < rect.x || x > rect.x + rect.width || y < rect.y || y > rect.y + rect.height) continue;
            return ob;
        }
        return null;
    }

    public void pickNodes(Rectangle pickBox) {
        int width = this.getSize().width;
        int height = this.getSize().height;
        SequenceNode top = this.tree.getTopNode();
        double wscale = (double)((float)((double)width * 0.8 - (double)(this.offx * 2))) / this.tree.getMaxHeight();
        if (top.count == 0) {
            top.count = ((SequenceNode)top.left()).count + ((SequenceNode)top.right()).count;
        }
        float chunk = (float)(height - this.offy) / (float)top.count;
        this.pickNode(pickBox, top, chunk, wscale, width, this.offx, this.offy);
    }

    public void pickNode(Rectangle pickBox, SequenceNode node, float chunk, double scale, int width, int offx, int offy) {
        if (node == null) {
            return;
        }
        if (node.left() == null && node.right() == null) {
            double height = node.height;
            int xend = (int)(height * scale) + offx;
            int ypos = (int)(node.ycount * chunk) + offy;
            if (pickBox.contains(new Point(xend, ypos)) && node.element() instanceof SequenceI) {
                SequenceI seq = (SequenceI)node.element();
                SequenceGroup sg = this.av.getSelectionGroup();
                if (sg != null) {
                    sg.addOrRemove(seq, true);
                }
            }
        } else {
            this.pickNode(pickBox, (SequenceNode)node.left(), chunk, scale, width, offx, offy);
            this.pickNode(pickBox, (SequenceNode)node.right(), chunk, scale, width, offx, offy);
        }
    }

    public void setColor(SequenceNode node, Color c) {
        if (node == null) {
            return;
        }
        if (node.left() == null && node.right() == null) {
            node.color = c;
            if (node.element() instanceof SequenceI) {
                this.av.setSequenceColour((SequenceI)node.element(), c);
            }
        } else {
            node.color = c;
            this.setColor((SequenceNode)node.left(), c);
            this.setColor((SequenceNode)node.right(), c);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.tree == null) {
            return;
        }
        if (this.nameHash.size() == 0) {
            this.repaint();
        }
        int width = this.scrollPane.getSize().width;
        int height = this.scrollPane.getSize().height;
        if (!this.fitToWindow) {
            height = g.getFontMetrics(this.font).getHeight() * this.nameHash.size();
        }
        if (this.getSize().width > width) {
            this.setSize(new Dimension(width, height));
            this.scrollPane.validate();
            return;
        }
        this.setSize(new Dimension(width, height));
        g.setFont(this.font);
        this.draw(g, width, height);
        this.validate();
    }

    public void draw(Graphics g, int width, int height) {
        this.offy = this.font.getSize() + 10;
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        this.labelLength = g.getFontMetrics(this.font).stringWidth(this.longestName) + 20;
        double wscale = (double)(width - this.labelLength - this.offx * 2) / this.tree.getMaxHeight();
        SequenceNode top = this.tree.getTopNode();
        if (top.count == 0) {
            top.count = ((SequenceNode)top.left()).count + ((SequenceNode)top.right()).count;
        }
        float chunk = (float)(height - this.offy) / (float)top.count;
        this.drawNode(g, this.tree.getTopNode(), chunk, wscale, width, this.offx, this.offy);
        if (this.threshold != 0.0f) {
            if (this.av.getCurrentTree() == this.tree) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.gray);
            }
            int x = (int)(this.threshold * (float)(this.getSize().width - this.labelLength - 2 * this.offx) + (float)this.offx);
            g.drawLine(x, 0, x, this.getSize().height);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (this.highlightNode != null) {
            if (evt.getClickCount() > 1) {
                this.tree.swapNodes(this.highlightNode);
                this.tree.reCount(this.tree.getTopNode());
                this.tree.findHeight(this.tree.getTopNode());
            } else {
                Vector<SequenceNode> leaves = this.tree.findLeaves(this.highlightNode);
                for (int i = 0; i < leaves.size(); ++i) {
                    SequenceI seq = (SequenceI)leaves.elementAt(i).element();
                    this.treeSelectionChanged(seq);
                }
            }
            PaintRefresher.Refresh(this, this.av.getSequenceSetId());
            this.repaint();
            this.av.sendSelection();
        }
    }

    @Override
    public void mouseDragged(MouseEvent ect) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.av.setCurrentTree(this.tree);
        Object ob = this.findElement(evt.getX(), evt.getY());
        if (ob instanceof SequenceNode) {
            this.highlightNode = (SequenceNode)ob;
            this.repaint();
        } else if (this.highlightNode != null) {
            this.highlightNode = null;
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.av.setCurrentTree(this.tree);
        int x = e.getX();
        int y = e.getY();
        Object ob = this.findElement(x, y);
        if (ob instanceof SequenceI) {
            this.treeSelectionChanged((Sequence)ob);
            PaintRefresher.Refresh(this, this.av.getSequenceSetId());
            this.repaint();
            this.av.sendSelection();
            return;
        }
        if (!(ob instanceof SequenceNode) && this.tree.getMaxHeight() != 0.0) {
            this.threshold = (float)(x - this.offx) / (float)(this.getSize().width - this.labelLength - 2 * this.offx);
            List<SequenceNode> groups = this.tree.groupNodes(this.threshold);
            this.setColor(this.tree.getTopNode(), Color.black);
            this.av.setSelectionGroup(null);
            this.av.getAlignment().deleteAllGroups();
            this.av.clearSequenceColours();
            AlignViewportI codingComplement = this.av.getCodingComplement();
            if (codingComplement != null) {
                codingComplement.setSelectionGroup(null);
                codingComplement.getAlignment().deleteAllGroups();
                codingComplement.clearSequenceColours();
            }
            this.colourGroups(groups);
        }
        PaintRefresher.Refresh(this, this.av.getSequenceSetId());
        this.repaint();
    }

    void colourGroups(List<SequenceNode> groups) {
        for (int i = 0; i < groups.size(); ++i) {
            SequenceGroup mappedGroup;
            Color col = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
            this.setColor(groups.get(i), col.brighter());
            Vector<SequenceNode> l = this.tree.findLeaves(groups.get(i));
            Vector<SequenceI> sequences = new Vector<SequenceI>();
            for (int j = 0; j < l.size(); ++j) {
                SequenceI s1 = (SequenceI)l.elementAt(j).element();
                if (sequences.contains(s1)) continue;
                sequences.addElement(s1);
            }
            ColourSchemeI cs = null;
            SequenceGroup sg = new SequenceGroup(sequences, "", cs, true, true, false, 0, this.av.getAlignment().getWidth() - 1);
            if (this.av.getGlobalColourScheme() != null) {
                cs = this.av.getGlobalColourScheme() instanceof UserColourScheme ? new UserColourScheme(((UserColourScheme)this.av.getGlobalColourScheme()).getColours()) : ColourSchemeProperty.getColourScheme(this.av, sg, ColourSchemeProperty.getColourName(this.av.getGlobalColourScheme()));
            }
            sg.setColourScheme(cs);
            sg.getGroupColourScheme().setThreshold(this.av.getResidueShading().getThreshold(), this.av.isIgnoreGapsConsensus());
            sg.setName("JTreeGroup:" + sg.hashCode());
            sg.setIdColour(col);
            if (this.av.getGlobalColourScheme() != null && this.av.getResidueShading().conservationApplied()) {
                Conservation c = new Conservation("Group", sg.getSequences(null), sg.getStartRes(), sg.getEndRes());
                c.calculate();
                c.verdict(false, this.av.getConsPercGaps());
                sg.setColourScheme(cs);
                sg.getGroupColourScheme().setConservation(c);
            }
            this.av.getAlignment().addGroup(sg);
            this.av.getAlignment().addGroup(sg);
            AlignViewportI codingComplement = this.av.getCodingComplement();
            if (codingComplement == null || (mappedGroup = MappingUtils.mapSequenceGroup(sg, this.av, codingComplement)).getSequences().size() <= 0) continue;
            codingComplement.getAlignment().addGroup(mappedGroup);
            for (SequenceI seq : mappedGroup.getSequences()) {
                codingComplement.setSequenceColour(seq, col);
            }
        }
        this.ap.updateAnnotation();
        if (this.av.getCodingComplement() != null) {
            ((AlignmentViewport)this.av.getCodingComplement()).firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
        }
    }

    public void setShowDistances(boolean state) {
        this.showDistances = state;
        this.repaint();
    }

    public void setShowBootstrap(boolean state) {
        this.showBootstrap = state;
        this.repaint();
    }

    public void setMarkPlaceholders(boolean state) {
        this.markPlaceholders = state;
        this.repaint();
    }
}

