/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.api.AlignViewportI;
import jalview.appletgui.APopupMenu;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.PaintRefresher;
import jalview.appletgui.SeqCanvas;
import jalview.appletgui.SliderPanel;
import jalview.appletgui.Tooltip;
import jalview.commands.EditCommand;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SearchResultMatchI;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.schemes.ResidueProperties;
import jalview.structure.SelectionListener;
import jalview.structure.SelectionSource;
import jalview.structure.SequenceListener;
import jalview.structure.StructureSelectionManager;
import jalview.structure.VamsasSource;
import jalview.util.Comparison;
import jalview.util.MappingUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.viewmodel.AlignmentViewport;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class SeqPanel
extends Panel
implements MouseMotionListener,
MouseListener,
SequenceListener,
SelectionListener {
    public SeqCanvas seqCanvas;
    public AlignmentPanel ap;
    protected int lastres;
    protected int startseq;
    protected AlignViewport av;
    boolean seqEditOccurred = false;
    ScrollThread scrollThread = null;
    boolean mouseDragging = false;
    boolean editingSeqs = false;
    boolean groupEditing = false;
    int oldSeq = -1;
    boolean changeEndSeq = false;
    boolean changeStartSeq = false;
    boolean changeEndRes = false;
    boolean changeStartRes = false;
    SequenceGroup stretchGroup = null;
    StringBuffer keyboardNo1;
    StringBuffer keyboardNo2;
    boolean mouseWheelPressed = false;
    Point lastMousePress;
    EditCommand editCommand;
    StructureSelectionManager ssm;
    int startWrapBlock = -1;
    int wrappedBlock = -1;
    String lastMessage;
    Tooltip tooltip;
    private boolean needOverviewUpdate;

    public SeqPanel(AlignViewport avp, AlignmentPanel p) {
        this.av = avp;
        this.seqCanvas = new SeqCanvas(avp);
        this.setLayout(new BorderLayout());
        this.add(this.seqCanvas);
        this.ap = p;
        this.seqCanvas.addMouseMotionListener(this);
        this.seqCanvas.addMouseListener(this);
        this.ssm = StructureSelectionManager.getStructureSelectionManager(this.av.applet);
        this.ssm.addStructureViewerListener(this);
        this.ssm.addSelectionListener(this);
        this.seqCanvas.repaint();
    }

    void endEditing() {
        if (this.editCommand != null && this.editCommand.getSize() > 0) {
            this.ap.alignFrame.addHistoryItem(this.editCommand);
            this.av.firePropertyChange("alignment", null, this.av.getAlignment().getSequences());
        }
        this.startseq = -1;
        this.lastres = -1;
        this.editingSeqs = false;
        this.groupEditing = false;
        this.keyboardNo1 = null;
        this.keyboardNo2 = null;
        this.editCommand = null;
    }

    void setCursorRow() {
        this.seqCanvas.cursorY = this.getKeyboardNo1() - 1;
        this.scrollToVisible(true);
    }

    void setCursorColumn() {
        this.seqCanvas.cursorX = this.getKeyboardNo1() - 1;
        this.scrollToVisible(true);
    }

    void setCursorRowAndColumn() {
        if (this.keyboardNo2 == null) {
            this.keyboardNo2 = new StringBuffer();
        } else {
            this.seqCanvas.cursorX = this.getKeyboardNo1() - 1;
            this.seqCanvas.cursorY = this.getKeyboardNo2() - 1;
            this.scrollToVisible(true);
        }
    }

    void setCursorPosition() {
        SequenceI sequence = this.av.getAlignment().getSequenceAt(this.seqCanvas.cursorY);
        this.seqCanvas.cursorX = sequence.findIndex(this.getKeyboardNo1()) - 1;
        this.scrollToVisible(true);
    }

    void moveCursor(int dx, int dy) {
        this.seqCanvas.cursorX += dx;
        this.seqCanvas.cursorY += dy;
        if (this.av.hasHiddenColumns() && !this.av.getAlignment().getHiddenColumns().isVisible(this.seqCanvas.cursorX)) {
            int original = this.seqCanvas.cursorX - dx;
            int maxWidth = this.av.getAlignment().getWidth();
            while (!this.av.getAlignment().getHiddenColumns().isVisible(this.seqCanvas.cursorX) && this.seqCanvas.cursorX < maxWidth && this.seqCanvas.cursorX > 0) {
                this.seqCanvas.cursorX += dx;
            }
            if (this.seqCanvas.cursorX >= maxWidth || !this.av.getAlignment().getHiddenColumns().isVisible(this.seqCanvas.cursorX)) {
                this.seqCanvas.cursorX = original;
            }
        }
        this.scrollToVisible(false);
    }

    void scrollToVisible(boolean jump) {
        if (this.seqCanvas.cursorX < 0) {
            this.seqCanvas.cursorX = 0;
        } else if (this.seqCanvas.cursorX > this.av.getAlignment().getWidth() - 1) {
            this.seqCanvas.cursorX = this.av.getAlignment().getWidth() - 1;
        }
        if (this.seqCanvas.cursorY < 0) {
            this.seqCanvas.cursorY = 0;
        } else if (this.seqCanvas.cursorY > this.av.getAlignment().getHeight() - 1) {
            this.seqCanvas.cursorY = this.av.getAlignment().getHeight() - 1;
        }
        this.endEditing();
        boolean repaintNeeded = true;
        if (jump) {
            repaintNeeded = !this.av.getRanges().setViewportLocation(this.seqCanvas.cursorX, this.seqCanvas.cursorY);
        } else if (this.av.getWrapAlignment()) {
            this.av.getRanges().scrollToWrappedVisible(this.seqCanvas.cursorX);
        } else {
            this.av.getRanges().scrollToVisible(this.seqCanvas.cursorX, this.seqCanvas.cursorY);
        }
        this.setStatusMessage(this.av.getAlignment().getSequenceAt(this.seqCanvas.cursorY), this.seqCanvas.cursorX, this.seqCanvas.cursorY);
        if (repaintNeeded) {
            this.seqCanvas.repaint();
        }
    }

    void setSelectionAreaAtCursor(boolean topLeft) {
        SequenceGroup sg;
        SequenceI sequence = this.av.getAlignment().getSequenceAt(this.seqCanvas.cursorY);
        if (this.av.getSelectionGroup() != null) {
            int i;
            sg = this.av.getSelectionGroup();
            int min = this.av.getAlignment().getHeight();
            int max = 0;
            for (i = 0; i < sg.getSize(); ++i) {
                int index = this.av.getAlignment().findIndex(sg.getSequenceAt(i));
                if (index > max) {
                    max = index;
                }
                if (index >= min) continue;
                min = index;
            }
            ++max;
            if (topLeft) {
                sg.setStartRes(this.seqCanvas.cursorX);
                if (sg.getEndRes() < this.seqCanvas.cursorX) {
                    sg.setEndRes(this.seqCanvas.cursorX);
                }
                min = this.seqCanvas.cursorY;
            } else {
                sg.setEndRes(this.seqCanvas.cursorX);
                if (sg.getStartRes() > this.seqCanvas.cursorX) {
                    sg.setStartRes(this.seqCanvas.cursorX);
                }
                max = this.seqCanvas.cursorY + 1;
            }
            if (min > max) {
                this.av.setSelectionGroup(null);
            } else {
                sg.clear();
                for (i = min; i < max; ++i) {
                    sg.addSequence(this.av.getAlignment().getSequenceAt(i), false);
                }
            }
        }
        if (this.av.getSelectionGroup() == null) {
            sg = new SequenceGroup();
            sg.setStartRes(this.seqCanvas.cursorX);
            sg.setEndRes(this.seqCanvas.cursorX);
            sg.addSequence(sequence, false);
            this.av.setSelectionGroup(sg);
        }
        this.ap.paintAlignment(false, false);
        this.av.sendSelection();
    }

    void insertGapAtCursor(boolean group) {
        this.groupEditing = group;
        this.startseq = this.seqCanvas.cursorY;
        this.lastres = this.seqCanvas.cursorX;
        this.editSequence(true, this.seqCanvas.cursorX + this.getKeyboardNo1());
        this.endEditing();
    }

    void deleteGapAtCursor(boolean group) {
        this.groupEditing = group;
        this.startseq = this.seqCanvas.cursorY;
        this.lastres = this.seqCanvas.cursorX + this.getKeyboardNo1();
        this.editSequence(false, this.seqCanvas.cursorX);
        this.endEditing();
    }

    void numberPressed(char value) {
        if (this.keyboardNo1 == null) {
            this.keyboardNo1 = new StringBuffer();
        }
        if (this.keyboardNo2 != null) {
            this.keyboardNo2.append(value);
        } else {
            this.keyboardNo1.append(value);
        }
    }

    int getKeyboardNo1() {
        try {
            if (this.keyboardNo1 != null) {
                int value = Integer.parseInt(this.keyboardNo1.toString());
                this.keyboardNo1 = null;
                return value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.keyboardNo1 = null;
        return 1;
    }

    int getKeyboardNo2() {
        try {
            if (this.keyboardNo2 != null) {
                int value = Integer.parseInt(this.keyboardNo2.toString());
                this.keyboardNo2 = null;
                return value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.keyboardNo2 = null;
        return 1;
    }

    void setStatusMessage(SequenceI sequence, int column, int seq) {
        StringBuilder text = new StringBuilder(32);
        String seqno = seq == -1 ? "" : " " + (seq + 1);
        text.append("Sequence" + seqno + " ID: " + sequence.getName());
        String residue = null;
        String displayChar = String.valueOf(sequence.getCharAt(column));
        if (this.av.getAlignment().isNucleotide()) {
            residue = ResidueProperties.nucleotideName.get(displayChar);
            if (residue != null) {
                text.append(" Nucleotide: ").append(residue);
            }
        } else {
            String string = "X".equalsIgnoreCase(displayChar) ? "X" : (residue = "*".equals(displayChar) ? "STOP" : ResidueProperties.aa2Triplet.get(displayChar));
            if (residue != null) {
                text.append(" Residue: ").append(residue);
            }
        }
        int pos = -1;
        if (residue != null) {
            pos = sequence.findPosition(column);
            text.append(" (").append(Integer.toString(pos)).append(")");
        }
        this.ap.alignFrame.statusBar.setText(text.toString());
    }

    private boolean setStatusMessage(SearchResultsI results) {
        AlignmentI al = this.av.getAlignment();
        int sequenceIndex = al.findIndex(results);
        if (sequenceIndex == -1) {
            return false;
        }
        SequenceI ds = al.getSequenceAt(sequenceIndex).getDatasetSequence();
        for (SearchResultMatchI m : results.getResults()) {
            SequenceI seq = m.getSequence();
            if (seq.getDatasetSequence() != null) {
                seq = seq.getDatasetSequence();
            }
            if (seq != ds) continue;
            int start = m.getStart() - m.getSequence().getStart();
            this.setStatusMessage(seq, start, sequenceIndex);
            return true;
        }
        return false;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.lastMousePress = evt.getPoint();
        if (Platform.isWinMiddleButton(evt)) {
            this.mouseWheelPressed = true;
            return;
        }
        if (evt.isShiftDown() || evt.isControlDown() || evt.isAltDown()) {
            if (evt.isControlDown() || evt.isAltDown()) {
                this.groupEditing = true;
            }
        } else {
            this.doMousePressedDefineMode(evt);
            return;
        }
        this.editingSeqs = true;
        int seq = this.findSeq(evt);
        int res = this.findColumn(evt);
        if (seq < 0 || res < 0) {
            return;
        }
        if (seq < this.av.getAlignment().getHeight() && res < this.av.getAlignment().getSequenceAt(seq).getLength()) {
            this.startseq = seq;
            this.lastres = res;
        } else {
            this.startseq = -1;
            this.lastres = -1;
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        SequenceI sequence = this.av.getAlignment().getSequenceAt(this.findSeq(evt));
        if (evt.getClickCount() > 1) {
            int column;
            List<SequenceFeature> features;
            if (this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSize() == 1 && this.av.getSelectionGroup().getEndRes() - this.av.getSelectionGroup().getStartRes() < 2) {
                this.av.setSelectionGroup(null);
            }
            if (!(features = this.findFeaturesAtColumn(sequence, (column = this.findColumn(evt)) + 1)).isEmpty()) {
                SearchResults highlight = new SearchResults();
                highlight.addResult(sequence, features.get(0).getBegin(), features.get(0).getEnd());
                this.seqCanvas.highlightSearchResults(highlight);
                this.seqCanvas.getFeatureRenderer().amendFeatures(Collections.singletonList(sequence), features, false, this.ap);
                this.av.setSearchResults(null);
                this.seqCanvas.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        boolean didDrag = this.mouseDragging;
        this.mouseDragging = false;
        this.mouseWheelPressed = false;
        if (!this.editingSeqs) {
            this.doMouseReleasedDefineMode(evt, didDrag);
            return;
        }
        this.endEditing();
    }

    int findColumn(MouseEvent evt) {
        int res = 0;
        int x = evt.getX();
        int startRes = this.av.getRanges().getStartRes();
        if (this.av.getWrapAlignment()) {
            int hgap = this.av.getCharHeight();
            if (this.av.getScaleAboveWrapped()) {
                hgap += this.av.getCharHeight();
            }
            int cHeight = this.av.getAlignment().getHeight() * this.av.getCharHeight() + hgap + this.seqCanvas.getAnnotationHeight();
            int y = evt.getY();
            y -= hgap;
            x = Math.max(0, x - this.seqCanvas.LABEL_WEST);
            int cwidth = this.seqCanvas.getWrappedCanvasWidth(this.getSize().width);
            if (cwidth < 1) {
                return 0;
            }
            this.wrappedBlock = y / cHeight;
            this.wrappedBlock += startRes / cwidth;
            int startOffset = startRes % cwidth;
            res = this.wrappedBlock * cwidth + startOffset + Math.min(cwidth - 1, x / this.av.getCharWidth());
        } else {
            res = x / this.av.getCharWidth() + startRes;
        }
        if (this.av.hasHiddenColumns()) {
            res = this.av.getAlignment().getHiddenColumns().visibleToAbsoluteColumn(res);
        }
        return res;
    }

    int findSeq(MouseEvent evt) {
        int sqnum = this.findAlRow(evt);
        return sqnum < 0 ? 0 : sqnum;
    }

    private int findAlRow(MouseEvent evt) {
        int seq = 0;
        int y = evt.getY();
        if (this.av.getWrapAlignment()) {
            int cHeight;
            int hgap = this.av.getCharHeight();
            if (this.av.getScaleAboveWrapped()) {
                hgap += this.av.getCharHeight();
            }
            if ((seq = Math.min((y -= hgap) % (cHeight = this.av.getAlignment().getHeight() * this.av.getCharHeight() + hgap + this.seqCanvas.getAnnotationHeight()) / this.av.getCharHeight(), this.av.getAlignment().getHeight() - 1)) < 0) {
                seq = -1;
            }
        } else {
            seq = Math.min(y / this.av.getCharHeight() + this.av.getRanges().getStartSeq(), this.av.getAlignment().getHeight() - 1);
            if (seq < 0) {
                seq = -1;
            }
        }
        return seq;
    }

    public void doMousePressed(MouseEvent evt) {
        int seq = this.findSeq(evt);
        int res = this.findColumn(evt);
        if (seq < this.av.getAlignment().getHeight() && res < this.av.getAlignment().getSequenceAt(seq).getLength()) {
            this.startseq = seq;
            this.lastres = res;
        } else {
            this.startseq = -1;
            this.lastres = -1;
        }
    }

    @Override
    public void mouseOverSequence(SequenceI sequence, int index, int pos) {
        String tmp = "" + (sequence.hashCode() + index);
        if (this.lastMessage == null || !this.lastMessage.equals(tmp)) {
            this.ssm.mouseOverSequence(sequence, index, pos, this.av);
        }
        this.lastMessage = tmp;
    }

    @Override
    public String highlightSequence(SearchResultsI results) {
        if (this.av.isFollowHighlight()) {
            this.ap.setToScrollComplementPanel(false);
            if (this.ap.scrollToPosition(results, true)) {
                this.ap.alignFrame.repaint();
            }
            this.ap.setToScrollComplementPanel(true);
        }
        this.setStatusMessage(results);
        this.seqCanvas.highlightSearchResults(results);
        return null;
    }

    @Override
    public VamsasSource getVamsasSource() {
        return this.ap == null ? null : this.ap.av;
    }

    @Override
    public void updateColours(SequenceI seq, int index) {
        System.out.println("update the seqPanel colours");
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        int column = this.findColumn(evt);
        int seq = this.findSeq(evt);
        if (seq >= this.av.getAlignment().getHeight() || seq < 0 || column < 0) {
            if (this.tooltip != null) {
                this.tooltip.setTip("");
            }
            return;
        }
        SequenceI sequence = this.av.getAlignment().getSequenceAt(seq);
        if (column > sequence.getLength()) {
            if (this.tooltip != null) {
                this.tooltip.setTip("");
            }
            return;
        }
        char ch = sequence.getCharAt(column);
        boolean isGapped = Comparison.isGap(ch);
        int respos = sequence.findPosition(column);
        if (this.ssm != null && !isGapped) {
            this.mouseOverSequence(sequence, column, respos);
        }
        StringBuilder text = new StringBuilder();
        text.append("Sequence ").append(Integer.toString(seq + 1)).append(" ID: ").append(sequence.getName());
        if (!isGapped) {
            if (this.av.getAlignment().isNucleotide()) {
                String base = ResidueProperties.nucleotideName.get(Character.valueOf(ch));
                text.append(" Nucleotide: ").append(base == null ? Character.valueOf(ch) : base);
            } else {
                String residue = ch == 'x' || ch == 'X' ? "X" : ResidueProperties.aa2Triplet.get(String.valueOf(ch));
                text.append(" Residue: ").append(residue == null ? Character.valueOf(ch) : residue);
            }
            text.append(" (").append(Integer.toString(respos)).append(")");
        }
        this.ap.alignFrame.statusBar.setText(text.toString());
        StringBuilder tooltipText = new StringBuilder();
        SequenceGroup[] groups = this.av.getAlignment().findAllGroups(sequence);
        if (groups != null) {
            for (int g = 0; g < groups.length; ++g) {
                if (groups[g].getStartRes() > column || groups[g].getEndRes() < column) continue;
                if (!groups[g].getName().startsWith("JTreeGroup") && !groups[g].getName().startsWith("JGroup")) {
                    tooltipText.append(groups[g].getName()).append(" ");
                }
                if (groups[g].getDescription() != null) {
                    tooltipText.append(groups[g].getDescription());
                }
                tooltipText.append("\n");
            }
        }
        if (this.av.isShowSequenceFeatures()) {
            List<SequenceFeature> allFeatures = this.findFeaturesAtColumn(sequence, column + 1);
            for (SequenceFeature sf : allFeatures) {
                String status;
                tooltipText.append(sf.getType() + " " + sf.begin + ":" + sf.end);
                if (sf.getDescription() != null) {
                    tooltipText.append(" " + sf.getDescription());
                }
                if (sf.getValue("status") != null && (status = sf.getValue("status").toString()).length() > 0) {
                    tooltipText.append(" (" + sf.getValue("status") + ")");
                }
                tooltipText.append("\n");
            }
        }
        if (this.tooltip == null) {
            this.tooltip = new Tooltip(tooltipText.toString(), this.seqCanvas);
        } else {
            this.tooltip.setTip(tooltipText.toString());
        }
    }

    List<SequenceFeature> findFeaturesAtColumn(SequenceI sequence, int column) {
        return this.seqCanvas.getFeatureRenderer().findFeaturesAtColumn(sequence, column);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (this.mouseWheelPressed) {
            int oldWidth = this.av.getCharWidth();
            if (Math.abs(evt.getY() - this.lastMousePress.y) > Math.abs(evt.getX() - this.lastMousePress.x)) {
                int fontSize = this.av.font.getSize();
                if (evt.getY() < this.lastMousePress.y && this.av.getCharHeight() > 1) {
                    --fontSize;
                } else if (evt.getY() > this.lastMousePress.y) {
                    ++fontSize;
                }
                if (fontSize < 1) {
                    fontSize = 1;
                }
                this.av.setFont(new Font(this.av.font.getName(), this.av.font.getStyle(), fontSize), true);
                this.av.setCharWidth(oldWidth);
            } else {
                if (evt.getX() < this.lastMousePress.x && this.av.getCharWidth() > 1) {
                    this.av.setCharWidth(this.av.getCharWidth() - 1);
                } else if (evt.getX() > this.lastMousePress.x) {
                    this.av.setCharWidth(this.av.getCharWidth() + 1);
                }
                if (this.av.getCharWidth() < 1) {
                    this.av.setCharWidth(1);
                }
            }
            this.ap.fontChanged();
            FontMetrics fm = this.getFontMetrics(this.av.getFont());
            this.av.validCharWidth = fm.charWidth('M') <= this.av.getCharWidth();
            this.lastMousePress = evt.getPoint();
            this.ap.paintAlignment(false, false);
            this.ap.annotationPanel.image = null;
            return;
        }
        if (!this.editingSeqs) {
            this.doMouseDraggedDefineMode(evt);
            return;
        }
        int res = this.findColumn(evt);
        if (res < 0) {
            res = 0;
        }
        if (this.lastres == -1 || this.lastres == res) {
            return;
        }
        if (res < this.av.getAlignment().getWidth() && res < this.lastres) {
            this.editSequence(false, res);
        } else {
            this.editSequence(true, res);
        }
        this.mouseDragging = true;
        if (this.scrollThread != null) {
            this.scrollThread.setEvent(evt);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    synchronized void editSequence(boolean insertGap, int startres) {
        block47: {
            int max;
            SequenceI seq;
            block56: {
                int fixedRight;
                block55: {
                    SequenceI[] groupSeqs;
                    boolean fixedColumns;
                    block48: {
                        int n;
                        int n2;
                        SequenceI[] blank2;
                        block52: {
                            boolean blank2;
                            SequenceGroup sg;
                            block51: {
                                block54: {
                                    block53: {
                                        block49: {
                                            block50: {
                                                int fixedLeft = -1;
                                                fixedRight = -1;
                                                fixedColumns = false;
                                                sg = this.av.getSelectionGroup();
                                                seq = this.av.getAlignment().getSequenceAt(this.startseq);
                                                if (!this.groupEditing && this.av.hasHiddenRows() && this.av.isHiddenRepSequence(seq)) {
                                                    sg = this.av.getRepresentedSequences(seq);
                                                    this.groupEditing = true;
                                                }
                                                StringBuffer message = new StringBuffer();
                                                if (this.groupEditing) {
                                                    message.append(MessageManager.getString("action.edit_group")).append(":");
                                                    if (this.editCommand == null) {
                                                        this.editCommand = new EditCommand(MessageManager.getString("action.edit_group"));
                                                    }
                                                } else {
                                                    message.append(MessageManager.getString("label.edit_sequence")).append(" " + seq.getName());
                                                    String label = seq.getName();
                                                    if (label.length() > 10) {
                                                        label = label.substring(0, 10);
                                                    }
                                                    if (this.editCommand == null) {
                                                        this.editCommand = new EditCommand(MessageManager.formatMessage("label.edit_params", new String[]{label}));
                                                    }
                                                }
                                                if (insertGap) {
                                                    message.append(" insert ");
                                                } else {
                                                    message.append(" delete ");
                                                }
                                                message.append(Math.abs(startres - this.lastres) + " gaps.");
                                                this.ap.alignFrame.statusBar.setText(message.toString());
                                                if (this.groupEditing || sg != null && sg.getSequences(this.av.getHiddenRepSequences()).contains(seq)) {
                                                    fixedColumns = true;
                                                    if (sg == null) {
                                                        if (!this.av.isHiddenRepSequence(seq)) {
                                                            this.endEditing();
                                                            return;
                                                        }
                                                        sg = this.av.getRepresentedSequences(seq);
                                                    }
                                                    fixedLeft = sg.getStartRes();
                                                    fixedRight = sg.getEndRes();
                                                    if (startres < fixedLeft && this.lastres >= fixedLeft || startres >= fixedLeft && this.lastres < fixedLeft || startres > fixedRight && this.lastres <= fixedRight || startres <= fixedRight && this.lastres > fixedRight) {
                                                        this.endEditing();
                                                        return;
                                                    }
                                                    if (fixedLeft > startres) {
                                                        fixedRight = fixedLeft - 1;
                                                        fixedLeft = 0;
                                                    } else if (fixedRight < startres) {
                                                        fixedLeft = fixedRight;
                                                        fixedRight = -1;
                                                    }
                                                }
                                                if (this.av.hasHiddenColumns()) {
                                                    fixedColumns = true;
                                                    int y1 = this.av.getAlignment().getHiddenColumns().getNextHiddenBoundary(true, startres);
                                                    int y2 = this.av.getAlignment().getHiddenColumns().getNextHiddenBoundary(false, startres);
                                                    if (insertGap && startres > y1 && this.lastres < y1 || !insertGap && startres < y2 && this.lastres > y2) {
                                                        this.endEditing();
                                                        return;
                                                    }
                                                    if (fixedLeft < y1 && (fixedRight > y2 || fixedRight == -1)) {
                                                        if (startres >= y2) {
                                                            fixedLeft = y2;
                                                        } else {
                                                            fixedRight = y2 - 1;
                                                        }
                                                    }
                                                }
                                                if (!this.groupEditing) break block49;
                                                groupSeqs = sg.getSequences(this.av.getHiddenRepSequences()).toArray(new SequenceI[0]);
                                                if (!insertGap) break block50;
                                                if (sg.getStartRes() == 0 && sg.getEndRes() == fixedRight && sg.getEndRes() == this.av.getAlignment().getWidth() - 1) {
                                                    sg.setEndRes(this.av.getAlignment().getWidth() + startres - this.lastres);
                                                    fixedRight = sg.getEndRes();
                                                }
                                                blank2 = false;
                                                break block51;
                                            }
                                            if (insertGap) break block48;
                                            blank2 = groupSeqs;
                                            n2 = blank2.length;
                                            break block52;
                                        }
                                        if (!insertGap) break block53;
                                        if (fixedColumns && fixedRight != -1) {
                                            for (int j = this.lastres; j < startres; ++j) {
                                                this.insertChar(j, new SequenceI[]{seq}, fixedRight);
                                            }
                                            break block47;
                                        } else {
                                            this.editCommand.appendEdit(EditCommand.Action.INSERT_GAP, new SequenceI[]{seq}, this.lastres, startres - this.lastres, this.av.getAlignment(), true);
                                        }
                                        break block47;
                                    }
                                    if (!fixedColumns || fixedRight == -1) break block54;
                                    break block55;
                                }
                                max = 0;
                                break block56;
                            }
                            block1: while (fixedRight > this.lastres) {
                                blank2 = true;
                                SequenceI[] sequenceIArray = groupSeqs;
                                n = sequenceIArray.length;
                                int n3 = 0;
                                while (true) {
                                    SequenceI gs;
                                    if (n3 < n) {
                                        gs = sequenceIArray[n3];
                                    } else {
                                        int hwidth;
                                        if (!blank2) {
                                            --fixedRight;
                                            continue block1;
                                        }
                                        if (blank2) break block48;
                                        if (sg.getSize() != this.av.getAlignment().getHeight()) {
                                            this.endEditing();
                                            return;
                                        }
                                        if (this.av.hasHiddenColumns() && startres < this.av.getAlignment().getHiddenColumns().getNextHiddenBoundary(false, startres)) {
                                            this.endEditing();
                                            return;
                                        }
                                        int alWidth = this.av.getAlignment().getWidth();
                                        if (this.av.hasHiddenRows() && (hwidth = this.av.getAlignment().getHiddenSequences().getWidth()) > alWidth) {
                                            alWidth = hwidth;
                                        }
                                        sg.setEndRes(sg.getEndRes() + startres - this.lastres);
                                        fixedRight = alWidth + startres - this.lastres;
                                        break block48;
                                    }
                                    for (int j = 0; j < startres - this.lastres; ++j) {
                                        if (Comparison.isGap(gs.getCharAt(fixedRight - j))) continue;
                                        blank2 = false;
                                        break;
                                    }
                                    ++n3;
                                }
                            }
                        }
                        for (n = 0; n < n2; ++n) {
                            SequenceI gs = blank2[n];
                            for (int j = startres; j < this.lastres; ++j) {
                                if (gs.getLength() <= j || Comparison.isGap(gs.getCharAt(j))) continue;
                                this.endEditing();
                                return;
                            }
                        }
                    }
                    if (insertGap) {
                        if (fixedColumns && fixedRight != -1) {
                            for (int j = this.lastres; j < startres; ++j) {
                                this.insertChar(j, groupSeqs, fixedRight);
                            }
                            break block47;
                        } else {
                            this.editCommand.appendEdit(EditCommand.Action.INSERT_GAP, groupSeqs, startres, startres - this.lastres, this.av.getAlignment(), true);
                        }
                        break block47;
                    } else if (fixedColumns && fixedRight != -1) {
                        for (int j = this.lastres; j > startres; --j) {
                            this.deleteChar(startres, groupSeqs, fixedRight);
                        }
                        break block47;
                    } else {
                        this.editCommand.appendEdit(EditCommand.Action.DELETE_GAP, groupSeqs, startres, this.lastres - startres, this.av.getAlignment(), true);
                    }
                    break block47;
                }
                for (int j = this.lastres; j > startres; --j) {
                    if (!Comparison.isGap(seq.getCharAt(startres))) {
                        this.endEditing();
                        break block47;
                    }
                    this.deleteChar(startres, new SequenceI[]{seq}, fixedRight);
                }
                break block47;
            }
            for (int m = startres; m < this.lastres && Comparison.isGap(seq.getCharAt(m)); ++max, ++m) {
            }
            if (max > 0) {
                this.editCommand.appendEdit(EditCommand.Action.DELETE_GAP, new SequenceI[]{seq}, startres, max, this.av.getAlignment(), true);
            }
        }
        this.lastres = startres;
        this.seqCanvas.repaint();
    }

    void insertChar(int j, SequenceI[] seq, int fixedColumn) {
        int blankColumn = fixedColumn;
        for (int s = 0; s < seq.length; ++s) {
            for (blankColumn = fixedColumn; blankColumn > j && !Comparison.isGap(seq[s].getCharAt(blankColumn)); --blankColumn) {
            }
            if (blankColumn > j) continue;
            blankColumn = fixedColumn;
            this.endEditing();
            return;
        }
        this.editCommand.appendEdit(EditCommand.Action.DELETE_GAP, seq, blankColumn, 1, this.av.getAlignment(), true);
        this.editCommand.appendEdit(EditCommand.Action.INSERT_GAP, seq, j, 1, this.av.getAlignment(), true);
    }

    void deleteChar(int j, SequenceI[] seq, int fixedColumn) {
        this.editCommand.appendEdit(EditCommand.Action.DELETE_GAP, seq, j, 1, this.av.getAlignment(), true);
        this.editCommand.appendEdit(EditCommand.Action.INSERT_GAP, seq, fixedColumn, 1, this.av.getAlignment(), true);
    }

    public void doMousePressedDefineMode(MouseEvent evt) {
        int seq;
        if (this.scrollThread != null) {
            this.scrollThread.threadRunning = false;
            this.scrollThread = null;
        }
        int column = this.findColumn(evt);
        this.oldSeq = seq = this.findSeq(evt);
        this.startWrapBlock = this.wrappedBlock;
        if (seq == -1) {
            return;
        }
        SequenceI sequence = this.av.getAlignment().getSequenceAt(seq);
        if (sequence == null || column > sequence.getLength()) {
            return;
        }
        this.stretchGroup = this.av.getSelectionGroup();
        if (this.stretchGroup == null || !this.stretchGroup.contains(sequence, column)) {
            this.stretchGroup = this.av.getAlignment().findGroup(sequence, column);
            if (this.stretchGroup != null) {
                this.av.setSelectionGroup(this.stretchGroup);
            }
        }
        if ((evt.getModifiersEx() & 0x1000) == 4096) {
            List<SequenceFeature> allFeatures = this.findFeaturesAtColumn(sequence, sequence.findPosition(column + 1));
            Vector<String> links = null;
            for (SequenceFeature sf : allFeatures) {
                if (sf.links == null) continue;
                if (links == null) {
                    links = new Vector<String>();
                }
                links.addAll(sf.links);
            }
            APopupMenu popup = new APopupMenu(this.ap, null, links);
            this.add(popup);
            popup.show(this, evt.getX(), evt.getY());
            return;
        }
        if (this.av.cursorMode) {
            this.seqCanvas.cursorX = this.findColumn(evt);
            this.seqCanvas.cursorY = this.findSeq(evt);
            this.seqCanvas.repaint();
            return;
        }
        if (this.stretchGroup == null) {
            SequenceGroup sg = new SequenceGroup();
            sg.setStartRes(column);
            sg.setEndRes(column);
            sg.addSequence(sequence, false);
            this.av.setSelectionGroup(sg);
            this.stretchGroup = sg;
            if (this.av.getConservationSelected()) {
                SliderPanel.setConservationSlider(this.ap, this.av.getResidueShading(), this.ap.getViewName());
            }
            if (this.av.getAbovePIDThreshold()) {
                SliderPanel.setPIDSliderSource(this.ap, this.av.getResidueShading(), this.ap.getViewName());
            }
        }
    }

    public void doMouseReleasedDefineMode(MouseEvent evt, boolean afterDrag) {
        if (this.stretchGroup == null) {
            return;
        }
        boolean vischange = this.stretchGroup.recalcConservation(true);
        this.needOverviewUpdate |= vischange && this.av.isSelectionDefinedGroup() && afterDrag;
        if (this.stretchGroup.cs != null) {
            this.stretchGroup.cs.alignmentChanged(this.stretchGroup, this.av.getHiddenRepSequences());
            if (this.stretchGroup.cs.conservationApplied()) {
                SliderPanel.setConservationSlider(this.ap, this.stretchGroup.cs, this.stretchGroup.getName());
            }
            if (this.stretchGroup.cs.getThreshold() > 0) {
                SliderPanel.setPIDSliderSource(this.ap, this.stretchGroup.cs, this.stretchGroup.getName());
            }
        }
        PaintRefresher.Refresh(this.ap, this.av.getSequenceSetId());
        this.ap.paintAlignment(this.needOverviewUpdate, this.needOverviewUpdate);
        this.needOverviewUpdate = false;
        this.changeEndRes = false;
        this.changeStartRes = false;
        this.stretchGroup = null;
        this.av.sendSelection();
    }

    public void doMouseDraggedDefineMode(MouseEvent evt) {
        int res = this.findColumn(evt);
        int y = this.findSeq(evt);
        if (this.wrappedBlock != this.startWrapBlock) {
            return;
        }
        if (this.stretchGroup == null) {
            return;
        }
        this.mouseDragging = true;
        if (y > this.av.getAlignment().getHeight()) {
            y = this.av.getAlignment().getHeight() - 1;
        }
        if (res >= this.av.getAlignment().getWidth()) {
            res = this.av.getAlignment().getWidth() - 1;
        }
        if (this.stretchGroup.getEndRes() == res) {
            this.changeEndRes = true;
        } else if (this.stretchGroup.getStartRes() == res) {
            this.changeStartRes = true;
        }
        if (res < 0) {
            res = 0;
        }
        if (this.changeEndRes) {
            if (res > this.stretchGroup.getStartRes() - 1) {
                this.stretchGroup.setEndRes(res);
                this.needOverviewUpdate |= this.av.isSelectionDefinedGroup();
            }
        } else if (this.changeStartRes && res < this.stretchGroup.getEndRes() + 1) {
            this.stretchGroup.setStartRes(res);
            this.needOverviewUpdate |= this.av.isSelectionDefinedGroup();
        }
        int dragDirection = 0;
        if (y > this.oldSeq) {
            dragDirection = 1;
        } else if (y < this.oldSeq) {
            dragDirection = -1;
        }
        while (y != this.oldSeq && this.oldSeq > -1 && y < this.av.getAlignment().getHeight()) {
            Sequence seq = (Sequence)this.av.getAlignment().getSequenceAt(this.oldSeq);
            this.oldSeq += dragDirection;
            if (this.oldSeq < 0) break;
            Sequence nextSeq = (Sequence)this.av.getAlignment().getSequenceAt(this.oldSeq);
            if (this.stretchGroup.getSequences(null).contains(nextSeq)) {
                this.stretchGroup.deleteSequence(seq, false);
                this.needOverviewUpdate |= this.av.isSelectionDefinedGroup();
                continue;
            }
            if (seq != null) {
                this.stretchGroup.addSequence(seq, false);
            }
            this.stretchGroup.addSequence(nextSeq, false);
            this.needOverviewUpdate |= this.av.isSelectionDefinedGroup();
        }
        if (this.oldSeq < 0) {
            this.oldSeq = -1;
        }
        if (res > this.av.getRanges().getEndRes() || res < this.av.getRanges().getStartRes() || y < this.av.getRanges().getStartSeq() || y > this.av.getRanges().getEndSeq()) {
            this.mouseExited(evt);
        }
        if (this.scrollThread != null && this.scrollThread.isRunning()) {
            this.scrollThread.setEvent(evt);
        }
        this.seqCanvas.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.oldSeq < 0) {
            this.oldSeq = 0;
        }
        if (this.scrollThread != null && this.scrollThread.isRunning()) {
            this.scrollThread.stopScrolling();
            this.scrollThread = null;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.av.getWrapAlignment()) {
            return;
        }
        if (this.mouseDragging && this.scrollThread == null) {
            this.scrollThread = new ScrollThread();
        }
    }

    void scrollCanvas(MouseEvent evt) {
        if (evt == null) {
            if (this.scrollThread != null && this.scrollThread.isRunning()) {
                this.scrollThread.stopScrolling();
                this.scrollThread = null;
            }
            this.mouseDragging = false;
        } else {
            if (this.scrollThread == null) {
                this.scrollThread = new ScrollThread();
            }
            this.mouseDragging = true;
            this.scrollThread.setEvent(evt);
        }
    }

    @Override
    public void selection(SequenceGroup seqsel, ColumnSelection colsel, HiddenColumns hidden, SelectionSource source) {
        if (this.av != null && (this.av == source || !this.av.followSelection || source instanceof AlignViewport && ((AlignmentViewport)((Object)source)).getSequenceSetId().equals(this.av.getSequenceSetId()))) {
            return;
        }
        if (this.selectionFromTranslation(seqsel, colsel, hidden, source)) {
            return;
        }
        boolean repaint = false;
        boolean copycolsel = false;
        if (this.av.getSelectionGroup() == null || !this.av.isSelectionGroupChanged(true)) {
            SequenceGroup sgroup = null;
            if (seqsel != null && seqsel.getSize() > 0) {
                if (this.av.getAlignment() == null) {
                    System.out.println("Selection message: alignviewport av SeqSetId=" + this.av.getSequenceSetId() + " ViewId=" + this.av.getViewId() + " 's alignment is NULL! returning immediatly.");
                    return;
                }
                sgroup = seqsel.intersect(this.av.getAlignment(), this.av.hasHiddenRows() ? this.av.getHiddenRepSequences() : null);
                if (sgroup != null && sgroup.getSize() > 0) {
                    copycolsel = true;
                }
            }
            if (sgroup != null && sgroup.getSize() > 0) {
                this.av.setSelectionGroup(sgroup);
            } else {
                this.av.setSelectionGroup(null);
            }
            repaint = this.av.isSelectionGroupChanged(true);
        }
        if (copycolsel && (this.av.getColumnSelection() == null || !this.av.isColSelChanged(true))) {
            if (colsel == null || colsel.isEmpty()) {
                if (this.av.getColumnSelection() != null) {
                    this.av.getColumnSelection().clear();
                }
            } else if (this.av.getColumnSelection() == null) {
                this.av.setColumnSelection(new ColumnSelection(colsel));
            } else {
                this.av.getColumnSelection().setElementsFrom(colsel, this.av.getAlignment().getHiddenColumns());
            }
            repaint |= this.av.isColSelChanged(true);
        }
        if (copycolsel && this.av.hasHiddenColumns() && this.av.getColumnSelection() == null) {
            System.err.println("Bad things");
        }
        if (repaint) {
            this.ap.scalePanelHolder.repaint();
            this.ap.repaint();
        }
    }

    public void scrollTo(int row, int column) {
        row = row < 0 ? this.ap.av.getRanges().getStartSeq() : row;
        column = column < 0 ? this.ap.av.getRanges().getStartRes() : column;
        this.ap.scrollTo(column, column, row, true, true);
    }

    public void scrollToRow(int row) {
        row = row < 0 ? this.ap.av.getRanges().getStartSeq() : row;
        this.ap.scrollTo(this.ap.av.getRanges().getStartRes(), this.ap.av.getRanges().getStartRes(), row, true, true);
    }

    public void scrollToColumn(int column) {
        column = column < 0 ? this.ap.av.getRanges().getStartRes() : column;
        this.ap.scrollTo(column, column, this.ap.av.getRanges().getStartSeq(), true, true);
    }

    protected boolean selectionFromTranslation(SequenceGroup seqsel, ColumnSelection colsel, HiddenColumns hidden, SelectionSource source) {
        if (!(source instanceof AlignViewportI)) {
            return false;
        }
        AlignViewportI sourceAv = (AlignViewportI)((Object)source);
        if (sourceAv.getCodingComplement() != this.av && this.av.getCodingComplement() != sourceAv) {
            return false;
        }
        SequenceGroup sg = MappingUtils.mapSequenceGroup(seqsel, sourceAv, this.av);
        this.av.setSelectionGroup(sg);
        this.av.isSelectionGroupChanged(true);
        ColumnSelection cs = new ColumnSelection();
        HiddenColumns hs = new HiddenColumns();
        MappingUtils.mapColumnSelection(colsel, hidden, sourceAv, this.av, cs, hs);
        this.av.setColumnSelection(cs);
        this.av.getAlignment().setHiddenColumns(hs);
        this.ap.scalePanelHolder.repaint();
        this.ap.repaint();
        return true;
    }

    class ScrollThread
    extends Thread {
        MouseEvent evt;
        private volatile boolean threadRunning = true;

        public ScrollThread() {
            this.start();
        }

        public void setEvent(MouseEvent e) {
            this.evt = e;
        }

        public void stopScrolling() {
            this.threadRunning = false;
        }

        public boolean isRunning() {
            return this.threadRunning;
        }

        @Override
        public void run() {
            while (this.threadRunning) {
                if (this.evt != null) {
                    if (SeqPanel.this.mouseDragging && this.evt.getY() < 0 && SeqPanel.this.av.getRanges().getStartSeq() > 0) {
                        SeqPanel.this.av.getRanges().scrollUp(true);
                    }
                    if (SeqPanel.this.mouseDragging && this.evt.getY() >= SeqPanel.this.getSize().height && SeqPanel.this.av.getAlignment().getHeight() > SeqPanel.this.av.getRanges().getEndSeq()) {
                        SeqPanel.this.av.getRanges().scrollUp(false);
                    }
                    if (SeqPanel.this.mouseDragging && this.evt.getX() < 0) {
                        SeqPanel.this.av.getRanges().scrollRight(false);
                    } else if (SeqPanel.this.mouseDragging && this.evt.getX() >= SeqPanel.this.getSize().width) {
                        SeqPanel.this.av.getRanges().scrollRight(true);
                    }
                }
                try {
                    Thread.sleep(75L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

