/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.api.AlignViewportI;
import jalview.api.FinderI;
import jalview.appletgui.AlignmentPanel;
import jalview.bin.JalviewLite;
import jalview.datamodel.SearchResultMatchI;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.util.MessageManager;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Finder
extends Panel
implements ActionListener {
    private AlignViewportI av;
    private AlignmentPanel ap;
    private TextField textfield = new TextField();
    private Button findAll = new Button();
    private Button findNext = new Button();
    private Button createFeatures = new Button();
    private Checkbox caseSensitive = new Checkbox();
    private Checkbox searchDescription = new Checkbox();
    private SearchResultsI searchResults;
    Map<AlignViewportI, FinderI> finders = new HashMap<AlignViewportI, FinderI>();

    public Finder(final AlignmentPanel ap) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.av = ap.av;
        this.ap = ap;
        Frame frame = new Frame();
        frame.add(this);
        JalviewLite.addFrame(frame, MessageManager.getString("action.find"), 340, 120);
        frame.repaint();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ap.highlightSearchResults(null);
            }
        });
        this.textfield.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.textfield) {
            this.doSearch(false);
        } else if (evt.getSource() == this.findNext) {
            this.doSearch(false);
        } else if (evt.getSource() == this.findAll) {
            this.doSearch(true);
        } else if (evt.getSource() == this.createFeatures) {
            this.createFeatures_actionPerformed();
        }
    }

    public void createFeatures_actionPerformed() {
        ArrayList<SequenceI> seqs = new ArrayList<SequenceI>();
        ArrayList<SequenceFeature> features = new ArrayList<SequenceFeature>();
        String searchString = this.textfield.getText().trim();
        for (SearchResultMatchI match : this.searchResults.getResults()) {
            seqs.add(match.getSequence().getDatasetSequence());
            features.add(new SequenceFeature(searchString, "Search Results", match.getStart(), match.getEnd(), "Search Results"));
        }
        if (this.ap.seqPanel.seqCanvas.getFeatureRenderer().amendFeatures(seqs, features, true, this.ap)) {
            this.ap.alignFrame.sequenceFeatures.setState(true);
            this.av.setShowSequenceFeatures(true);
            this.ap.highlightSearchResults(null);
        }
    }

    void doSearch(boolean doFindAll) {
        if (this.ap.av.applet.currentAlignFrame != null) {
            this.ap = this.ap.av.applet.currentAlignFrame.alignPanel;
            this.av = this.ap.av;
        }
        this.createFeatures.setEnabled(false);
        FinderI finder = this.finders.get(this.av);
        if (finder == null) {
            finder = new jalview.analysis.Finder(this.av);
            this.finders.put(this.av, finder);
        }
        String searchString = this.textfield.getText();
        boolean isCaseSensitive = this.caseSensitive.getState();
        boolean doSearchDescription = this.searchDescription.getState();
        if (doFindAll) {
            finder.findAll(searchString, isCaseSensitive, doSearchDescription, false);
        } else {
            finder.findNext(searchString, isCaseSensitive, doSearchDescription, false);
        }
        this.searchResults = finder.getSearchResults();
        List<SequenceI> idMatches = finder.getIdMatches();
        this.ap.idPanel.highlightSearchResults(idMatches);
        if (this.searchResults.isEmpty()) {
            this.searchResults = null;
        } else {
            this.createFeatures.setEnabled(true);
        }
        this.ap.highlightSearchResults(this.searchResults);
        if (idMatches.isEmpty() && this.searchResults == null) {
            this.ap.alignFrame.statusBar.setText(MessageManager.getString("label.finished_searching"));
        } else if (doFindAll) {
            Object message;
            Object object = message = idMatches.size() > 0 ? idMatches.size() + " IDs" : "";
            if (idMatches.size() > 0 && this.searchResults != null && this.searchResults.getCount() > 0) {
                message = (String)message + " and ";
            }
            if (this.searchResults != null) {
                message = (String)message + this.searchResults.getCount() + " subsequence matches.";
            }
            this.ap.alignFrame.statusBar.setText(MessageManager.formatMessage("label.search_results", new String[]{searchString, message}));
        } else {
            this.ap.alignFrame.statusBar.setText(MessageManager.formatMessage("label.found_match_for", new String[]{searchString}));
        }
    }

    private void jbInit() throws Exception {
        Label jLabel1 = new Label(MessageManager.getString("action.find"));
        jLabel1.setFont(new Font("Verdana", 0, 12));
        jLabel1.setBounds(new Rectangle(3, 30, 34, 15));
        this.setLayout(null);
        this.textfield.setFont(new Font("Verdana", 0, 10));
        this.textfield.setText("");
        this.textfield.setBounds(new Rectangle(40, 17, 133, 21));
        this.textfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                Finder.this.textfield_keyTyped();
            }
        });
        this.textfield.addActionListener(this);
        this.findAll.setFont(new Font("Verdana", 0, 10));
        this.findAll.setLabel(MessageManager.getString("action.find_all"));
        this.findAll.addActionListener(this);
        this.findNext.setEnabled(false);
        this.findNext.setFont(new Font("Verdana", 0, 10));
        this.findNext.setLabel(MessageManager.getString("action.find_next"));
        this.findNext.addActionListener(this);
        Panel actionsPanel = new Panel();
        actionsPanel.setBounds(new Rectangle(195, 5, 141, 64));
        GridLayout gridLayout1 = new GridLayout();
        actionsPanel.setLayout(gridLayout1);
        gridLayout1.setHgap(0);
        gridLayout1.setRows(3);
        gridLayout1.setVgap(2);
        this.createFeatures.setEnabled(false);
        this.createFeatures.setFont(new Font("Verdana", 0, 10));
        this.createFeatures.setLabel(MessageManager.getString("label.new_feature"));
        this.createFeatures.addActionListener(this);
        this.caseSensitive.setLabel(MessageManager.getString("label.match_case"));
        this.caseSensitive.setBounds(new Rectangle(30, 39, 126, 23));
        this.searchDescription.setLabel(MessageManager.getString("label.include_description"));
        this.searchDescription.setBounds(new Rectangle(30, 59, 170, 23));
        actionsPanel.add((Component)this.findNext, null);
        actionsPanel.add((Component)this.findAll, null);
        actionsPanel.add((Component)this.createFeatures, null);
        this.add(this.caseSensitive);
        this.add((Component)this.textfield, null);
        this.add((Component)jLabel1, null);
        this.add((Component)actionsPanel, null);
        this.add(this.searchDescription);
    }

    void textfield_keyTyped() {
        this.findNext.setEnabled(true);
    }
}

