/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.UserDefinedColours;
import jalview.bin.JalviewLite;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.GraphLine;
import jalview.datamodel.SequenceGroup;
import jalview.schemes.AnnotationColourGradient;
import jalview.schemes.ColourSchemeI;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class AnnotationColourChooser
extends Panel
implements ActionListener,
AdjustmentListener,
ItemListener,
MouseListener {
    Frame frame;
    AlignViewport av;
    AlignmentPanel ap;
    ColourSchemeI oldcs;
    Map<SequenceGroup, ColourSchemeI> oldgroupColours;
    private Map<AlignmentAnnotation, String> annotationLabels;
    AlignmentAnnotation currentAnnotation;
    boolean adjusting = false;
    Choice annotations = new Choice();
    Button minColour = new Button();
    Button maxColour = new Button();
    Button ok = new Button();
    Button cancel = new Button();
    Button defColours = new Button();
    Panel jPanel1 = new Panel();
    Panel jPanel2 = new Panel();
    Choice threshold = new Choice();
    FlowLayout flowLayout1 = new FlowLayout();
    Panel jPanel3 = new Panel();
    Scrollbar slider = new Scrollbar(0);
    TextField thresholdValue = new TextField(20);
    Checkbox currentColours = new Checkbox();
    BorderLayout borderLayout1 = new BorderLayout();
    Checkbox thresholdIsMin = new Checkbox();

    public AnnotationColourChooser(AlignViewport av, AlignmentPanel ap) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.oldcs = av.getGlobalColourScheme();
        if (av.getAlignment().getGroups() != null) {
            this.oldgroupColours = new HashMap<SequenceGroup, ColourSchemeI>();
            for (SequenceGroup sg : ap.av.getAlignment().getGroups()) {
                this.oldgroupColours.put(sg, sg.getColourScheme());
            }
        }
        this.av = av;
        this.ap = ap;
        this.slider.addAdjustmentListener(this);
        this.slider.addMouseListener(this);
        AlignmentAnnotation[] anns = av.getAlignment().getAlignmentAnnotation();
        if (anns == null) {
            return;
        }
        this.setDefaultMinMax();
        this.adjusting = true;
        if (this.oldcs instanceof AnnotationColourGradient) {
            AnnotationColourGradient acg = (AnnotationColourGradient)this.oldcs;
            this.currentColours.setState(acg.isPredefinedColours() || acg.getBaseColour() != null);
            if (!acg.isPredefinedColours() && acg.getBaseColour() == null) {
                this.minColour.setBackground(acg.getMinColour());
                this.maxColour.setBackground(acg.getMaxColour());
            }
        }
        Vector<String> list = this.getAnnotationItems();
        for (int i = 0; i < list.size(); ++i) {
            this.annotations.addItem(list.elementAt(i).toString());
        }
        this.threshold.addItem(MessageManager.getString("label.threshold_feature_no_threshold"));
        this.threshold.addItem(MessageManager.getString("label.threshold_feature_above_threshold"));
        this.threshold.addItem(MessageManager.getString("label.threshold_feature_below_threshold"));
        if (this.oldcs instanceof AnnotationColourGradient) {
            AnnotationColourGradient acg = (AnnotationColourGradient)this.oldcs;
            String label = this.annotationLabels.get(acg.getAnnotation());
            this.annotations.select(label);
            switch (acg.getAboveThreshold()) {
                case -1: {
                    this.threshold.select(0);
                    break;
                }
                case 1: {
                    this.threshold.select(1);
                    break;
                }
                case 0: {
                    this.threshold.select(1);
                    break;
                }
                default: {
                    throw new Error(MessageManager.getString("error.implementation_error_dont_know_threshold_annotationcolourgradient"));
                }
            }
            this.thresholdIsMin.setState(acg.isThresholdIsMinMax());
            this.thresholdValue.setText("" + acg.getAnnotationThreshold());
        }
        this.adjusting = false;
        this.changeColour();
        this.frame = new Frame();
        this.frame.add(this);
        JalviewLite.addFrame(this.frame, MessageManager.getString("label.colour_by_annotation"), 560, 175);
        this.validate();
    }

    protected Vector<String> getAnnotationItems() {
        this.annotationLabels = new HashMap<AlignmentAnnotation, String>();
        Vector<String> list = new Vector<String>();
        AlignmentAnnotation[] anns = this.av.getAlignment().getAlignmentAnnotation();
        if (anns == null) {
            return list;
        }
        int index = 1;
        for (int i = 0; i < anns.length; ++i) {
            Object label = anns[i].label;
            if (anns[i].sequenceRef != null) {
                label = (String)label + "_" + anns[i].sequenceRef.getName();
            }
            if (!list.contains(label)) {
                list.addElement((String)label);
                this.annotationLabels.put(anns[i], (String)label);
                continue;
            }
            label = (String)label + "_" + index++;
            list.addElement((String)label);
            this.annotationLabels.put(anns[i], (String)label);
        }
        return list;
    }

    private void setDefaultMinMax() {
        this.minColour.setBackground(this.av.applet.getDefaultColourParameter("ANNOTATIONCOLOUR_MIN", Color.orange));
        this.maxColour.setBackground(this.av.applet.getDefaultColourParameter("ANNOTATIONCOLOUR_MAX", Color.red));
    }

    public AnnotationColourChooser() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.minColour.setFont(new Font("Verdana", 0, 11));
        this.minColour.setLabel(MessageManager.getString("label.min_colour"));
        this.minColour.addActionListener(this);
        this.maxColour.setFont(new Font("Verdana", 0, 11));
        this.maxColour.setLabel(MessageManager.getString("label.max_colour"));
        this.maxColour.addActionListener(this);
        this.thresholdIsMin.addItemListener(this);
        this.ok.setLabel(MessageManager.getString("action.ok"));
        this.ok.addActionListener(this);
        this.cancel.setLabel(MessageManager.getString("action.cancel"));
        this.cancel.addActionListener(this);
        this.defColours.setLabel(MessageManager.getString("action.set_defaults"));
        this.defColours.addActionListener(this);
        this.annotations.addItemListener(this);
        this.thresholdValue.addActionListener(this);
        this.slider.setBackground(Color.white);
        this.slider.setPreferredSize(new Dimension(193, 21));
        this.slider.setEnabled(false);
        this.thresholdValue.setPreferredSize(new Dimension(79, 22));
        this.thresholdValue.setEnabled(false);
        this.thresholdValue.setColumns(5);
        this.currentColours.setFont(new Font("Verdana", 0, 11));
        this.currentColours.setLabel(MessageManager.getString("label.use_original_colours"));
        this.currentColours.addItemListener(this);
        this.thresholdIsMin.setBackground(Color.white);
        this.thresholdIsMin.setLabel(MessageManager.getString("label.threshold_minmax"));
        this.setLayout(this.borderLayout1);
        this.jPanel1.setBackground(Color.white);
        this.jPanel2.setLayout(new FlowLayout());
        this.jPanel2.setBackground(Color.white);
        this.threshold.addItemListener(this);
        this.jPanel3.setLayout(new FlowLayout());
        this.jPanel3.setBackground(Color.white);
        Panel jPanel4 = new Panel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBackground(Color.white);
        this.jPanel1.add(this.ok);
        this.jPanel1.add(this.cancel);
        this.jPanel2.add(this.annotations);
        this.jPanel2.add(this.currentColours);
        this.jPanel2.add(this.minColour);
        this.jPanel2.add(this.maxColour);
        jPanel4.add((Component)this.thresholdIsMin, "West");
        jPanel4.add((Component)this.slider, "Center");
        jPanel4.add((Component)this.thresholdValue, "East");
        Panel jPanel34 = new Panel();
        jPanel34.setLayout(new BorderLayout());
        jPanel34.setBackground(Color.white);
        jPanel34.add((Component)this.jPanel2, "North");
        jPanel34.add((Component)this.threshold, "West");
        this.jPanel3.add(this.defColours);
        jPanel34.add((Component)this.jPanel3, "East");
        jPanel34.add((Component)jPanel4, "South");
        this.add((Component)jPanel34, "Center");
        this.add((Component)this.jPanel1, "South");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.thresholdValue) {
            try {
                float f = Float.valueOf(this.thresholdValue.getText()).floatValue();
                this.slider.setValue((int)(f * 1000.0f));
                this.adjustmentValueChanged(null);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (evt.getSource() == this.minColour) {
            this.minColour_actionPerformed(null);
        } else if (evt.getSource() == this.maxColour) {
            this.maxColour_actionPerformed(null);
        } else if (evt.getSource() == this.defColours) {
            this.defColour_actionPerformed();
        } else if (evt.getSource() == this.ok) {
            this.frame.setVisible(false);
        } else if (evt.getSource() == this.cancel) {
            this.reset();
            this.ap.paintAlignment(true, true);
            this.frame.setVisible(false);
        } else {
            this.changeColour();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.currentColours) {
            if (this.currentColours.getState()) {
                this.reset();
            }
            this.maxColour.setEnabled(!this.currentColours.getState());
            this.minColour.setEnabled(!this.currentColours.getState());
        }
        this.changeColour();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (!this.adjusting) {
            this.thresholdValue.setText("" + (float)this.slider.getValue() / 1000.0f);
            if (this.currentColours.getState() && !(this.av.getGlobalColourScheme() instanceof AnnotationColourGradient)) {
                this.changeColour();
            }
            this.currentAnnotation.threshold.value = (float)this.slider.getValue() / 1000.0f;
            this.ap.paintAlignment(false, false);
        }
    }

    public void minColour_actionPerformed(Color newCol) {
        if (newCol != null) {
            this.minColour.setBackground(newCol);
            this.minColour.repaint();
            this.changeColour();
        } else {
            new UserDefinedColours((Object)this, "Min Colour", this.minColour.getBackground());
        }
    }

    public void maxColour_actionPerformed(Color newCol) {
        if (newCol != null) {
            this.maxColour.setBackground(newCol);
            this.maxColour.repaint();
            this.changeColour();
        } else {
            new UserDefinedColours((Object)this, "Max Colour", this.maxColour.getBackground());
        }
    }

    public void defColour_actionPerformed() {
        this.setDefaultMinMax();
        this.minColour.repaint();
        this.maxColour.repaint();
        this.changeColour();
    }

    void changeColour() {
        if (this.adjusting) {
            return;
        }
        this.currentAnnotation = this.av.getAlignment().getAlignmentAnnotation()[this.annotations.getSelectedIndex()];
        int aboveThreshold = -1;
        if (this.threshold.getSelectedIndex() == 1) {
            aboveThreshold = 1;
        } else if (this.threshold.getSelectedIndex() == 2) {
            aboveThreshold = 0;
        }
        this.slider.setEnabled(true);
        this.thresholdValue.setEnabled(true);
        this.thresholdIsMin.setEnabled(true);
        if (aboveThreshold == -1) {
            this.slider.setEnabled(false);
            this.thresholdValue.setEnabled(false);
            this.thresholdIsMin.setEnabled(false);
            this.thresholdValue.setText("");
        } else if (aboveThreshold != -1 && this.currentAnnotation.threshold == null) {
            this.currentAnnotation.setThreshold(new GraphLine((this.currentAnnotation.graphMax - this.currentAnnotation.graphMin) / 2.0f, "Threshold", Color.black));
        }
        if (aboveThreshold != -1) {
            this.adjusting = true;
            this.slider.setMinimum((int)(this.currentAnnotation.graphMin * 1000.0f));
            this.slider.setMaximum((int)(this.currentAnnotation.graphMax * 1000.0f));
            this.slider.setValue((int)(this.currentAnnotation.threshold.value * 1000.0f));
            this.thresholdValue.setText("" + this.currentAnnotation.threshold.value);
            this.slider.setEnabled(true);
            this.thresholdValue.setEnabled(true);
            this.adjusting = false;
        }
        AnnotationColourGradient acg = null;
        if (!this.currentColours.getState()) {
            acg = new AnnotationColourGradient(this.currentAnnotation, this.minColour.getBackground(), this.maxColour.getBackground(), aboveThreshold);
        }
        if (this.currentAnnotation.graphMin == 0.0f && this.currentAnnotation.graphMax == 0.0f) {
            acg.setPredefinedColours(true);
        }
        acg.setThresholdIsMinMax(this.thresholdIsMin.getState());
        this.av.setGlobalColourScheme(acg);
        if (this.av.getAlignment().getGroups() != null) {
            for (SequenceGroup sg : this.ap.av.getAlignment().getGroups()) {
                if (sg.getColourScheme() == null) continue;
                if (this.currentColours.getState()) {
                    sg.setColourScheme(new AnnotationColourGradient(this.currentAnnotation, sg.getColourScheme(), aboveThreshold));
                    continue;
                }
                sg.setColourScheme(new AnnotationColourGradient(this.currentAnnotation, this.minColour.getBackground(), this.maxColour.getBackground(), aboveThreshold));
            }
        }
        this.ap.alignmentChanged();
        this.ap.paintAlignment(true, true);
    }

    void reset() {
        this.av.setGlobalColourScheme(this.oldcs);
        if (this.av.getAlignment().getGroups() != null) {
            for (SequenceGroup sg : this.ap.av.getAlignment().getGroups()) {
                sg.setColourScheme(this.oldgroupColours.get(sg));
            }
        }
        this.ap.paintAlignment(true, true);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.ap.paintAlignment(true, true);
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }
}

