/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.AnnotationSorter;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.appletgui.AlignFrame;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AnnotationLabels;
import jalview.appletgui.AnnotationPanel;
import jalview.appletgui.FeatureRenderer;
import jalview.appletgui.IdPanel;
import jalview.appletgui.IdwidthAdjuster;
import jalview.appletgui.OverviewPanel;
import jalview.appletgui.PaintRefresher;
import jalview.appletgui.ScalePanel;
import jalview.appletgui.SeqPanel;
import jalview.appletgui.SequenceRenderer;
import jalview.appletgui.SplitFrame;
import jalview.bin.JalviewLite;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceI;
import jalview.structure.StructureSelectionManager;
import jalview.viewmodel.ViewportListenerI;
import jalview.viewmodel.ViewportRanges;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

public class AlignmentPanel
extends Panel
implements AdjustmentListener,
AlignmentViewPanel,
ViewportListenerI {
    public AlignViewport av;
    OverviewPanel overviewPanel;
    SeqPanel seqPanel;
    IdPanel idPanel;
    IdwidthAdjuster idwidthAdjuster;
    public AlignFrame alignFrame;
    ScalePanel scalePanel;
    AnnotationPanel annotationPanel;
    AnnotationLabels alabels;
    ViewportRanges vpRanges;
    boolean fastPaint = true;
    int hextent = 0;
    int vextent = 0;
    protected Panel sequenceHolderPanel = new Panel();
    protected Scrollbar vscroll = new Scrollbar();
    protected Scrollbar hscroll = new Scrollbar();
    protected Panel seqPanelHolder = new Panel();
    protected Panel scalePanelHolder = new Panel();
    protected Panel idPanelHolder = new Panel();
    protected Panel idSpaceFillerPanel1 = new Panel();
    public Panel annotationSpaceFillerHolder = new Panel();
    protected Panel hscrollFillerPanel = new Panel();
    Panel annotationPanelHolder = new Panel();
    protected Scrollbar apvscroll = new Scrollbar();
    private boolean scrollComplementaryPanel = true;

    public AlignmentPanel(AlignFrame af, final AlignViewport av) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.alignFrame = af;
        this.av = av;
        this.vpRanges = av.getRanges();
        this.seqPanel = new SeqPanel(av, this);
        this.idPanel = new IdPanel(av, this);
        this.scalePanel = new ScalePanel(av, this);
        this.idwidthAdjuster = new IdwidthAdjuster(this);
        this.annotationPanel = new AnnotationPanel(this);
        this.annotationPanelHolder.add((Component)this.annotationPanel, "Center");
        this.sequenceHolderPanel.add((Component)this.annotationPanelHolder, "South");
        this.alabels = new AnnotationLabels(this);
        this.setAnnotationVisible(av.isShowAnnotation());
        this.idPanelHolder.add((Component)this.idPanel, "Center");
        this.idSpaceFillerPanel1.add((Component)this.idwidthAdjuster, "Center");
        this.annotationSpaceFillerHolder.add((Component)this.alabels, "Center");
        this.scalePanelHolder.add((Component)this.scalePanel, "Center");
        this.seqPanelHolder.add((Component)this.seqPanel, "Center");
        this.fontChanged();
        this.setScrollValues(0, 0);
        this.apvscroll.addAdjustmentListener(this);
        this.hscroll.addAdjustmentListener(this);
        this.vscroll.addAdjustmentListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                if (av.getWrapAlignment()) {
                    int widthInRes = AlignmentPanel.this.seqPanel.seqCanvas.getWrappedCanvasWidth(AlignmentPanel.this.seqPanel.seqCanvas.getWidth());
                    AlignmentPanel.this.vpRanges.setViewportWidth(widthInRes);
                } else {
                    int widthInRes = AlignmentPanel.this.seqPanel.seqCanvas.getWidth() / av.getCharWidth();
                    int heightInSeq = AlignmentPanel.this.seqPanel.seqCanvas.getHeight() / av.getCharHeight();
                    AlignmentPanel.this.vpRanges.setViewportWidth(widthInRes);
                    AlignmentPanel.this.vpRanges.setViewportHeight(heightInSeq);
                }
                if (AlignmentPanel.this.getSize().height > 0 && AlignmentPanel.this.annotationPanelHolder.getSize().height > 0) {
                    AlignmentPanel.this.validateAnnotationDimensions(false);
                }
                AlignmentPanel.this.repaint();
            }
        });
        Dimension d = this.calculateIdWidth();
        this.idPanel.idCanvas.setSize(d);
        this.hscrollFillerPanel.setSize(d.width, this.annotationPanel.getSize().height);
        this.idPanel.idCanvas.setSize(d.width, this.seqPanel.seqCanvas.getSize().height);
        this.annotationSpaceFillerHolder.setSize(d.width, this.annotationPanel.getSize().height);
        this.alabels.setSize(d.width, this.annotationPanel.getSize().height);
        final AlignmentPanel ap = this;
        av.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("alignment")) {
                    PaintRefresher.Refresh(ap, av.getSequenceSetId(), true, true);
                    AlignmentPanel.this.alignmentChanged();
                }
            }
        });
        av.getRanges().addPropertyChangeListener(this);
    }

    @Override
    public AlignViewportI getAlignViewport() {
        return this.av;
    }

    public SequenceRenderer getSequenceRenderer() {
        return this.seqPanel.seqCanvas.sr;
    }

    @Override
    public jalview.api.FeatureRenderer getFeatureRenderer() {
        return this.seqPanel.seqCanvas.fr;
    }

    @Override
    public jalview.api.FeatureRenderer cloneFeatureRenderer() {
        FeatureRenderer nfr = new FeatureRenderer(this.av);
        nfr.transferSettings(this.seqPanel.seqCanvas.fr);
        return nfr;
    }

    public void alignmentChanged() {
        this.av.alignmentChanged(this);
        if (this.overviewPanel != null) {
            this.overviewPanel.updateOverviewImage();
        }
        this.alignFrame.updateEditMenuBar();
        this.repaint();
    }

    public void fontChanged() {
        this.idPanel.idCanvas.image = null;
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        this.scalePanel.setSize(new Dimension(10, this.av.getCharHeight() + fm.getDescent()));
        this.idwidthAdjuster.setSize(new Dimension(10, this.av.getCharHeight() + fm.getDescent()));
        this.av.updateSequenceIdColours();
        this.annotationPanel.image = null;
        int ap = this.annotationPanel.adjustPanelHeight(false);
        Dimension d = this.calculateIdWidth();
        d.setSize(d.width + 4, this.seqPanel.seqCanvas.getSize().height);
        this.alabels.setSize(d.width + 4, ap);
        this.idPanel.idCanvas.setSize(d);
        this.hscrollFillerPanel.setSize(d);
        this.validateAnnotationDimensions(false);
        this.annotationPanel.repaint();
        this.validate();
        this.repaint();
    }

    public void setIdWidth(int w, int h) {
        this.idPanel.idCanvas.setSize(w, h);
        this.idPanelHolder.setSize(w, this.idPanelHolder.getSize().height);
        this.annotationSpaceFillerHolder.setSize(w, this.annotationSpaceFillerHolder.getSize().height);
        this.alabels.setSize(w, this.alabels.getSize().height);
        this.validate();
    }

    Dimension calculateIdWidth() {
        int i;
        if (this.av.nullFrame == null) {
            this.av.nullFrame = new Frame();
            this.av.nullFrame.addNotify();
        }
        Graphics g = this.av.nullFrame.getGraphics();
        FontMetrics fm = g.getFontMetrics(this.av.font);
        AlignmentI al = this.av.getAlignment();
        int idWidth = 0;
        for (i = 0; i < al.getHeight() && al.getSequenceAt(i) != null; ++i) {
            SequenceI s = al.getSequenceAt(i);
            String id = s.getDisplayId(this.av.getShowJVSuffix());
            if (fm.stringWidth(id) <= idWidth) continue;
            idWidth = fm.stringWidth(id);
        }
        if (al.getAlignmentAnnotation() != null) {
            fm = g.getFontMetrics(this.av.nullFrame.getFont());
            for (i = 0; i < al.getAlignmentAnnotation().length; ++i) {
                String label = al.getAlignmentAnnotation()[i].label;
                if (fm.stringWidth(label) <= idWidth) continue;
                idWidth = fm.stringWidth(label);
            }
        }
        return new Dimension(idWidth, this.idPanel.idCanvas.getSize().height);
    }

    public void highlightSearchResults(SearchResultsI results) {
        this.scrollToPosition(results);
        this.seqPanel.seqCanvas.highlightSearchResults(results);
    }

    public boolean scrollToPosition(SearchResultsI results) {
        return this.scrollToPosition(results, true);
    }

    public boolean scrollToPosition(SearchResultsI results, boolean redrawOverview) {
        return this.scrollToPosition(results, 0, redrawOverview, false);
    }

    public boolean scrollToPosition(SearchResultsI results, int verticalOffset, boolean redrawOverview, boolean centre) {
        if (results != null && results.getCount() > 0) {
            AlignmentI alignment = this.av.getAlignment();
            int seqIndex = alignment.findIndex(results);
            if (seqIndex == -1) {
                return false;
            }
            SequenceI seq = alignment.getSequenceAt(seqIndex);
            int[] r = results.getResults(seq, 0, alignment.getWidth());
            if (r == null) {
                if (JalviewLite.debug) {
                    System.out.println("DEBUG: scroll didn't happen - results not within alignment : " + seq.getStart() + "," + seq.getEnd());
                }
                return false;
            }
            if (JalviewLite.debug) {
                // empty if block
            }
            int start = r[0];
            int end = r[1];
            if (centre) {
                int offset = (this.vpRanges.getEndRes() - this.vpRanges.getStartRes() + 1) / 2 - 1;
                start = Math.max(start - offset, 0);
                end = end + offset - 1;
            }
            if (start < 0) {
                return false;
            }
            if (end == seq.getEnd()) {
                return false;
            }
            seqIndex = Math.max(0, seqIndex - verticalOffset);
            return this.scrollTo(start, end, seqIndex, false, redrawOverview);
        }
        return true;
    }

    public boolean scrollTo(int ostart, int end, int seqIndex, boolean scrollToNearest, boolean redrawOverview) {
        int start = -1;
        if (this.av.hasHiddenColumns()) {
            AlignmentI al = this.av.getAlignment();
            start = al.getHiddenColumns().absoluteToVisibleColumn(ostart);
            if (start == (end = al.getHiddenColumns().absoluteToVisibleColumn(end)) && !scrollToNearest && !al.getHiddenColumns().isVisible(ostart)) {
                return false;
            }
        } else {
            start = ostart;
        }
        if (!this.av.getWrapAlignment()) {
            int startv = this.vpRanges.getStartRes();
            if (startv >= start) {
                this.setScrollValues(start - 1, seqIndex);
            } else {
                int endv = this.vpRanges.getEndRes();
                if (endv <= end) {
                    this.setScrollValues(startv + 1 + end - endv, seqIndex);
                } else {
                    int starts = this.vpRanges.getStartSeq();
                    if (starts > seqIndex) {
                        this.setScrollValues(this.vpRanges.getStartRes(), seqIndex);
                    } else {
                        int ends = this.vpRanges.getEndSeq();
                        if (ends <= seqIndex) {
                            this.setScrollValues(this.vpRanges.getStartRes(), starts + seqIndex - ends + 1);
                        }
                    }
                }
            }
        } else {
            this.vpRanges.scrollToWrappedVisible(start);
        }
        this.paintAlignment(redrawOverview, false);
        return true;
    }

    public OverviewPanel getOverviewPanel() {
        return this.overviewPanel;
    }

    public void setOverviewPanel(OverviewPanel op) {
        this.overviewPanel = op;
    }

    public void setAnnotationVisible(boolean b) {
        if (!this.av.getWrapAlignment()) {
            this.annotationSpaceFillerHolder.setVisible(b);
            this.annotationPanelHolder.setVisible(b);
        } else {
            this.annotationSpaceFillerHolder.setVisible(false);
            this.annotationPanelHolder.setVisible(false);
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void adjustAnnotationHeight() {
        if (this.alignFrame.getSize().height == 0) {
            System.out.println("adjustAnnotationHeight frame size zero NEEDS FIXING");
        }
        this.fontChanged();
        this.validateAnnotationDimensions(true);
        this.apvscroll.addNotify();
        this.hscroll.addNotify();
        this.validate();
        this.paintAlignment(true, false);
    }

    protected void validateAnnotationDimensions(boolean adjustPanelHeight) {
        int annotationHeight;
        int rowHeight = this.av.getCharHeight();
        int alignmentHeight = rowHeight * this.av.getAlignment().getHeight();
        int mheight = annotationHeight = this.av.calcPanelHeight();
        Dimension d = this.sequenceHolderPanel.getSize();
        int availableHeight = d.height - this.scalePanelHolder.getHeight();
        if (adjustPanelHeight) {
            if (annotationHeight + alignmentHeight > availableHeight) {
                annotationHeight = Math.min(annotationHeight, availableHeight - 2 * rowHeight);
            }
        } else {
            annotationHeight = this.annotationPanelHolder.getSize().height;
        }
        if (availableHeight - annotationHeight < 5) {
            annotationHeight = availableHeight;
        }
        this.annotationPanel.setSize(new Dimension(d.width, annotationHeight));
        this.annotationPanelHolder.setSize(new Dimension(d.width, annotationHeight));
        this.seqPanel.seqCanvas.setSize(d.width, this.seqPanel.seqCanvas.getSize().height);
        Dimension e = this.idPanel.getSize();
        this.alabels.setSize(new Dimension(e.width, annotationHeight));
        this.annotationSpaceFillerHolder.setSize(new Dimension(e.width, annotationHeight));
        int s = this.apvscroll.getValue();
        if (s > mheight - annotationHeight) {
            s = 0;
        }
        this.apvscroll.setValues(s, annotationHeight, 0, mheight);
        this.annotationPanel.setScrollOffset(this.apvscroll.getValue(), false);
        this.alabels.setScrollOffset(this.apvscroll.getValue(), false);
    }

    public void setWrapAlignment(boolean wrap) {
        this.vpRanges.setStartEndSeq(0, this.vpRanges.getVisibleAlignmentHeight());
        this.vpRanges.setStartRes(0);
        this.scalePanelHolder.setVisible(!wrap);
        this.hscroll.setVisible(!wrap);
        this.idwidthAdjuster.setVisible(!wrap);
        if (wrap) {
            this.annotationPanelHolder.setVisible(false);
            this.annotationSpaceFillerHolder.setVisible(false);
        } else if (this.av.isShowAnnotation()) {
            this.annotationPanelHolder.setVisible(true);
            this.annotationSpaceFillerHolder.setVisible(true);
        }
        this.idSpaceFillerPanel1.setVisible(!wrap);
        this.fontChanged();
        this.validate();
        this.sequenceHolderPanel.validate();
        this.repaint();
    }

    public void setScrollValues(int xpos, int ypos) {
        int x = xpos;
        int y = ypos;
        if (this.av.getWrapAlignment()) {
            this.setScrollingForWrappedPanel(x);
        } else {
            int width = this.av.getAlignment().getVisibleWidth();
            int height = this.av.getAlignment().getHeight();
            if (x < 0) {
                x = 0;
            }
            this.hextent = this.seqPanel.seqCanvas.getSize().width / this.av.getCharWidth();
            this.vextent = this.seqPanel.seqCanvas.getSize().height / this.av.getCharHeight();
            if (this.hextent > width) {
                this.hextent = width;
            }
            if (this.vextent > height) {
                this.vextent = height;
            }
            if (this.hextent + x > width) {
                System.err.println("hextent was " + this.hextent + " and x was " + x);
                x = width - this.hextent;
            }
            if (this.vextent + y > height) {
                y = height - this.vextent;
            }
            if (y < 0) {
                y = 0;
            }
            if (x < 0) {
                System.err.println("x was " + x);
                x = 0;
            }
            this.hscroll.setValues(x, this.hextent, 0, width);
            this.vscroll.setValues(y, this.vextent, 0, height);
            this.adjustHorizontal(x);
            this.adjustVertical(y);
            this.sendViewPosition();
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (evt == null || evt.getSource() == this.apvscroll) {
            this.annotationPanel.setScrollOffset(this.apvscroll.getValue(), false);
            this.alabels.setScrollOffset(this.apvscroll.getValue(), false);
        }
        if (evt == null || evt.getSource() == this.hscroll) {
            int x = this.hscroll.getValue();
            this.adjustHorizontal(x);
        }
        if (evt == null || evt.getSource() == this.vscroll) {
            int offy = this.vscroll.getValue();
            this.adjustVertical(offy);
        }
    }

    private void adjustHorizontal(int x) {
        int oldX = this.vpRanges.getStartRes();
        int oldwidth = this.vpRanges.getViewportWidth();
        int width = this.seqPanel.seqCanvas.getWidth() / this.av.getCharWidth();
        if (x == oldX && width == oldwidth) {
            return;
        }
        this.vpRanges.setViewportStartAndWidth(x, width);
        if (this.av.getWrapAlignment() || !this.fastPaint) {
            this.repaint();
        }
        this.sendViewPosition();
    }

    private void adjustVertical(int newY) {
        if (this.av.getWrapAlignment()) {
            int oldX = this.vpRanges.getStartRes();
            int oldY = this.vpRanges.getWrappedScrollPosition(oldX);
            if (oldY == newY) {
                return;
            }
            if (newY > -1) {
                int rowSize = this.vpRanges.getViewportWidth();
                int newX = newY > oldY ? oldX + rowSize : oldX - rowSize;
                this.vpRanges.setViewportStartAndWidth(Math.max(0, newX), rowSize);
            }
        } else {
            int height = this.seqPanel.seqCanvas.getHeight() / this.av.getCharHeight();
            int oldY = this.vpRanges.getStartSeq();
            int oldheight = this.vpRanges.getViewportHeight();
            if (newY == oldY && height == oldheight) {
                return;
            }
            this.vpRanges.setViewportStartAndHeight(newY, height);
        }
        if (this.av.getWrapAlignment() || !this.fastPaint) {
            this.repaint();
        }
        this.sendViewPosition();
    }

    private AlignmentPanel getComplementPanel() {
        AlignFrame other;
        SplitFrame sf;
        AlignmentPanel ap = null;
        if (this.alignFrame != null && (sf = this.alignFrame.getSplitFrame()) != null && (other = sf.getComplement(this.alignFrame)) != null) {
            ap = other.alignPanel;
        }
        return ap;
    }

    protected void scrollToCentre(SearchResultsI sr, int seqOffset) {
        SequenceI mappedTo = sr.getResults().get(0).getSequence();
        List<SequenceI> seqs = this.av.getAlignment().getSequences();
        boolean matched = false;
        for (SequenceI seq : seqs) {
            if (mappedTo != seq.getDatasetSequence()) continue;
            matched = true;
            break;
        }
        if (!matched) {
            return;
        }
        this.scrollToPosition(sr, seqOffset, true, true);
    }

    private void sendViewPosition() {
        StructureSelectionManager.getStructureSelectionManager(this.av.applet).sendViewPosition(this, this.vpRanges.getStartRes(), this.vpRanges.getEndRes(), this.vpRanges.getStartSeq(), this.vpRanges.getEndSeq());
    }

    @Override
    public void paintAlignment(boolean updateOverview, boolean updateStructures) {
        AnnotationSorter sorter = new AnnotationSorter(this.getAlignment(), this.av.isShowAutocalculatedAbove());
        sorter.sort(this.getAlignment().getAlignmentAnnotation(), this.av.getSortAnnotationsBy());
        this.repaint();
        if (updateStructures) {
            StructureSelectionManager.getStructureSelectionManager(this.av.applet).sequenceColoursChanged(this);
        }
        if (updateOverview && this.overviewPanel != null) {
            this.overviewPanel.updateOverviewImage();
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        this.invalidate();
        Dimension d = this.idPanel.idCanvas.getSize();
        int canvasHeight = this.seqPanel.seqCanvas.getSize().height;
        if (canvasHeight != d.height) {
            this.idPanel.idCanvas.setSize(d.width, canvasHeight);
        }
        this.setScrollValues(this.vpRanges.getStartRes(), this.vpRanges.getStartSeq());
        this.seqPanel.seqCanvas.repaint();
        this.idPanel.idCanvas.repaint();
        if (!this.av.getWrapAlignment()) {
            if (this.av.isShowAnnotation()) {
                this.alabels.repaint();
                this.annotationPanel.repaint();
            }
            this.scalePanel.repaint();
        }
    }

    private void setScrollingForWrappedPanel(int topLeftColumn) {
        int scrollPosition = this.vpRanges.getWrappedScrollPosition(topLeftColumn);
        int maxScroll = this.vpRanges.getWrappedMaxScroll(topLeftColumn);
        this.vscroll.setUnitIncrement(1);
        this.vscroll.setValues(scrollPosition, 1, 0, maxScroll + 1);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.sequenceHolderPanel.setLayout(new BorderLayout());
        this.seqPanelHolder.setLayout(new BorderLayout());
        this.scalePanelHolder.setBackground(Color.white);
        this.scalePanelHolder.setLayout(new BorderLayout());
        this.idPanelHolder.setLayout(new BorderLayout());
        this.idSpaceFillerPanel1.setBackground(Color.white);
        this.idSpaceFillerPanel1.setLayout(new BorderLayout());
        this.annotationSpaceFillerHolder.setBackground(Color.white);
        this.annotationSpaceFillerHolder.setLayout(new BorderLayout());
        this.hscroll.setOrientation(0);
        Panel hscrollHolder = new Panel();
        hscrollHolder.setLayout(new BorderLayout());
        this.hscrollFillerPanel.setBackground(Color.white);
        this.apvscroll.setOrientation(1);
        this.apvscroll.setVisible(true);
        this.apvscroll.addAdjustmentListener(this);
        this.annotationPanelHolder.setBackground(Color.white);
        this.annotationPanelHolder.setLayout(new BorderLayout());
        this.annotationPanelHolder.add((Component)this.apvscroll, "East");
        hscrollHolder.setBackground(Color.white);
        this.seqPanelHolder.setBackground(Color.white);
        this.idPanelHolder.setBackground(Color.white);
        this.sequenceHolderPanel.add((Component)this.scalePanelHolder, "North");
        this.sequenceHolderPanel.add((Component)this.seqPanelHolder, "Center");
        this.seqPanelHolder.add((Component)this.vscroll, "East");
        this.add((Component)this.idPanelHolder, "West");
        this.idPanelHolder.add((Component)this.idSpaceFillerPanel1, "North");
        this.idPanelHolder.add((Component)this.annotationSpaceFillerHolder, "South");
        this.add((Component)hscrollHolder, "South");
        hscrollHolder.add((Component)this.hscroll, "Center");
        hscrollHolder.add((Component)this.hscrollFillerPanel, "West");
        this.add((Component)this.sequenceHolderPanel, "Center");
    }

    public void updateAnnotation() {
        this.updateAnnotation(false);
    }

    public void updateAnnotation(boolean applyGlobalSettings) {
        this.updateAnnotation(applyGlobalSettings, false);
    }

    public void updateAnnotation(boolean applyGlobalSettings, boolean preserveNewGroupSettings) {
        this.av.updateGroupAnnotationSettings(applyGlobalSettings, preserveNewGroupSettings);
        this.adjustAnnotationHeight();
    }

    @Override
    public AlignmentI getAlignment() {
        return this.av.getAlignment();
    }

    @Override
    public String getViewName() {
        return this.getName();
    }

    @Override
    public StructureSelectionManager getStructureSelectionManager() {
        return StructureSelectionManager.getStructureSelectionManager(this.av.applet);
    }

    @Override
    public void raiseOOMWarning(String string, OutOfMemoryError error) {
        System.err.println("Out of memory whilst '" + string + "'");
        error.printStackTrace();
    }

    protected void setToScrollComplementPanel(boolean b) {
        this.scrollComplementaryPanel = b;
    }

    protected boolean isSetToScrollComplementPanel() {
        return this.scrollComplementaryPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int x = this.vpRanges.getStartRes();
        int y = this.vpRanges.getStartSeq();
        this.setScrollValues(x, y);
        if (this.isSetToScrollComplementPanel()) {
            this.setToScrollComplementPanel(false);
            this.av.scrollComplementaryAlignment(this.getComplementPanel());
            this.setToScrollComplementPanel(true);
        }
    }
}

