/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis.scoremodels;

import jalview.analysis.AlignSeq;
import jalview.analysis.scoremodels.SimilarityScoreModel;
import jalview.api.AlignmentViewPanel;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.SequenceI;
import jalview.math.Matrix;
import jalview.math.MatrixI;

public class SmithWatermanModel
extends SimilarityScoreModel {
    private static final String NAME = "Smith Waterman Score";
    private String description;

    @Override
    public MatrixI findSimilarities(AlignmentView seqData, SimilarityParamsI options) {
        SequenceI[] sequenceString = seqData.getVisibleAlignment(' ').getSequencesArray();
        int noseqs = sequenceString.length;
        double[][] distances = new double[noseqs][noseqs];
        double max = -1.0;
        for (int i = 0; i < noseqs - 1; ++i) {
            for (int j = i; j < noseqs; ++j) {
                AlignSeq as = new AlignSeq(sequenceString[i], sequenceString[j], seqData.isNa() ? "dna" : "pep");
                as.calcScoreMatrix();
                as.traceAlignment();
                as.printAlignment(System.out);
                distances[i][j] = as.maxscore;
                if (!(max < distances[i][j])) continue;
                max = distances[i][j];
            }
        }
        return new Matrix(distances);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isDNA() {
        return true;
    }

    @Override
    public boolean isProtein() {
        return true;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ScoreModelI getInstance(AlignmentViewPanel avp) {
        return this;
    }
}

