/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis.scoremodels;

import jalview.analysis.scoremodels.SimilarityScoreModel;
import jalview.api.AlignmentViewPanel;
import jalview.api.analysis.PairwiseScoreModelI;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.datamodel.AlignmentView;
import jalview.math.Matrix;
import jalview.math.MatrixI;
import jalview.util.Comparison;
import java.util.Arrays;

public class ScoreMatrix
extends SimilarityScoreModel
implements PairwiseScoreModelI {
    private static final char GAP_CHARACTER = '-';
    private static final int UNKNOWN_IDENTITY_SCORE = 1;
    private static boolean scoreGapAsAny = false;
    public static final short UNMAPPED = -1;
    private static final String BAD_ASCII_ERROR = "Unexpected character %s in getPairwiseScore";
    private static final int MAX_ASCII = 127;
    private String name;
    private String description;
    private char[] symbols;
    private float[][] matrix;
    private short[] symbolIndex;
    private boolean peptide;
    private float minValue;
    private float maxValue;
    private boolean symmetric;

    public ScoreMatrix(String theName, char[] alphabet, float[][] values) {
        this(theName, null, alphabet, values);
    }

    public ScoreMatrix(String theName, String theDescription, char[] alphabet, float[][] values) {
        if (alphabet.length != values.length) {
            throw new IllegalArgumentException("score matrix size must match alphabet size");
        }
        for (float[] row : values) {
            if (row.length == alphabet.length) continue;
            throw new IllegalArgumentException("score matrix size must be square");
        }
        this.matrix = values;
        this.name = theName;
        this.description = theDescription;
        this.symbols = alphabet;
        this.symbolIndex = this.buildSymbolIndex(alphabet);
        this.findMinMax();
        this.symmetric = this.checkSymmetry();
        this.peptide = alphabet.length >= 20;
    }

    private boolean checkSymmetry() {
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = i; j < this.matrix.length; ++j) {
                if (this.matrix[i][j] == this.matrix[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    protected void findMinMax() {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        if (this.matrix != null) {
            for (float[] row : this.matrix) {
                if (row == null) continue;
                for (float f : row) {
                    min = Math.min(min, f);
                    max = Math.max(max, f);
                }
            }
        }
        this.minValue = min;
        this.maxValue = max;
    }

    short[] buildSymbolIndex(char[] alphabet) {
        short[] index = new short[128];
        Arrays.fill(index, (short)-1);
        short pos = 0;
        for (char c : alphabet) {
            short lowerCase;
            if (c <= '\u007f') {
                index[c] = pos;
            }
            if (c >= 'A' && c <= 'Z' && index[lowerCase = (short)(c + 32)] == -1) {
                index[lowerCase] = pos;
            }
            pos = (short)(pos + 1);
        }
        return index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isDNA() {
        return !this.peptide;
    }

    @Override
    public boolean isProtein() {
        return this.peptide;
    }

    public float[][] getMatrix() {
        float[][] v = new float[this.matrix.length][this.matrix.length];
        for (int i = 0; i < this.matrix.length; ++i) {
            v[i] = Arrays.copyOf(this.matrix[i], this.matrix[i].length);
        }
        return v;
    }

    public int getMatrixIndex(char c) {
        if (c < this.symbolIndex.length) {
            return this.symbolIndex[c];
        }
        return -1;
    }

    @Override
    public float getPairwiseScore(char c, char d) {
        if (c >= this.symbolIndex.length) {
            System.err.println(String.format(BAD_ASCII_ERROR, Character.valueOf(c)));
            return 0.0f;
        }
        if (d >= this.symbolIndex.length) {
            System.err.println(String.format(BAD_ASCII_ERROR, Character.valueOf(d)));
            return 0.0f;
        }
        short cIndex = this.symbolIndex[c];
        short dIndex = this.symbolIndex[d];
        if (cIndex != -1 && dIndex != -1) {
            return this.matrix[cIndex][dIndex];
        }
        return c == d ? 1.0f : this.getMinimumScore();
    }

    public String toString() {
        return this.outputMatrix(false);
    }

    public String outputMatrix(boolean html) {
        StringBuilder sb = new StringBuilder(512);
        if (html) {
            sb.append("<table border=\"1\">");
            sb.append(html ? "<tr><th></th>" : "");
        } else {
            sb.append("ScoreMatrix ").append(this.getName()).append("\n");
        }
        for (char sym : this.symbols) {
            if (html) {
                sb.append("<th>&nbsp;").append(sym).append("&nbsp;</th>");
                continue;
            }
            sb.append("\t").append(sym);
        }
        sb.append(html ? "</tr>\n" : "\n");
        for (char c1 : this.symbols) {
            if (html) {
                sb.append("<tr><td>");
            }
            sb.append(c1).append(html ? "</td>" : "");
            for (char c2 : this.symbols) {
                sb.append(html ? "<td>" : "\t").append(this.matrix[this.symbolIndex[c1]][this.symbolIndex[c2]]).append(html ? "</td>" : "");
            }
            sb.append(html ? "</tr>\n" : "\n");
        }
        if (html) {
            sb.append("</table>");
        }
        return sb.toString();
    }

    public int getSize() {
        return this.symbols.length;
    }

    @Override
    public MatrixI findSimilarities(AlignmentView seqstrings, SimilarityParamsI options) {
        char gapChar = scoreGapAsAny ? (seqstrings.isNa() ? (char)'N' : 'X') : (char)'-';
        String[] seqs = seqstrings.getSequenceStrings(gapChar);
        return this.findSimilarities(seqs, options);
    }

    protected MatrixI findSimilarities(String[] seqs, SimilarityParamsI params) {
        double[][] values = new double[seqs.length][seqs.length];
        for (int row = 0; row < seqs.length; ++row) {
            int col;
            int n = col = this.symmetric ? row : 0;
            while (col < seqs.length) {
                double total;
                values[row][col] = total = this.computeSimilarity(seqs[row], seqs[col], params);
                if (this.symmetric) {
                    values[col][row] = total;
                }
                ++col;
            }
        }
        return new Matrix(values);
    }

    protected double computeSimilarity(String seq1, String seq2, SimilarityParamsI params) {
        int len1 = seq1.length();
        int len2 = seq2.length();
        double total = 0.0;
        int width = Math.max(len1, len2);
        for (int i = 0; i < width && (i < len1 && i < len2 || !params.denominateByShortestLength()); ++i) {
            char c1 = i >= len1 ? (char)'-' : (char)seq1.charAt(i);
            char c2 = i >= len2 ? (char)'-' : (char)seq2.charAt(i);
            boolean gap1 = Comparison.isGap(c1);
            boolean gap2 = Comparison.isGap(c2);
            if (gap1 && gap2 ? !params.includeGappedColumns() : (gap1 || gap2) && !params.includeGaps()) continue;
            float score = this.getPairwiseScore(c1, c2);
            total += (double)score;
        }
        return total;
    }

    public int hashCode() {
        int hs = Arrays.hashCode(this.symbols);
        for (float[] row : this.matrix) {
            hs = hs * 31 + Arrays.hashCode(row);
        }
        return hs;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ScoreMatrix)) {
            return false;
        }
        ScoreMatrix sm = (ScoreMatrix)obj;
        return Arrays.equals(this.symbols, sm.symbols) && Arrays.deepEquals((Object[])this.matrix, (Object[])sm.matrix);
    }

    String getSymbols() {
        return new String(this.symbols);
    }

    public float getMinimumScore() {
        return this.minValue;
    }

    public float getMaximumScore() {
        return this.maxValue;
    }

    @Override
    public ScoreModelI getInstance(AlignmentViewPanel avp) {
        return this;
    }

    public boolean isSymmetric() {
        return this.symmetric;
    }
}

