/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis.scoremodels;

import jalview.analysis.scoremodels.SimilarityScoreModel;
import jalview.api.AlignmentViewPanel;
import jalview.api.analysis.PairwiseScoreModelI;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.datamodel.AlignmentView;
import jalview.math.Matrix;
import jalview.math.MatrixI;
import jalview.util.Comparison;

public class PIDModel
extends SimilarityScoreModel
implements PairwiseScoreModelI {
    private static final String NAME = "PID";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public boolean isDNA() {
        return true;
    }

    @Override
    public boolean isProtein() {
        return true;
    }

    @Override
    public float getPairwiseScore(char c, char d) {
        if ((c = PIDModel.toUpper(c)) == (d = PIDModel.toUpper(d)) && !Comparison.isGap(c)) {
            return 1.0f;
        }
        return 0.0f;
    }

    protected static char toUpper(char c) {
        if ('a' <= c && c <= 'z') {
            c = (char)(c - 32);
        }
        return c;
    }

    @Override
    public MatrixI findSimilarities(AlignmentView seqData, SimilarityParamsI options) {
        String[] seqs = seqData.getSequenceStrings('-');
        MatrixI result = this.findSimilarities(seqs, options);
        result.multiply((double)seqData.getWidth() / 100.0);
        return result;
    }

    @Override
    public MatrixI findDistances(AlignmentView seqData, SimilarityParamsI options) {
        MatrixI result = super.findDistances(seqData, options);
        if (seqData.getWidth() != 0) {
            result.multiply(100.0 / (double)seqData.getWidth());
        }
        return result;
    }

    protected MatrixI findSimilarities(String[] seqs, SimilarityParamsI options) {
        double[][] values = new double[seqs.length][seqs.length];
        for (int row = 0; row < seqs.length; ++row) {
            for (int col = row; col < seqs.length; ++col) {
                double total;
                values[row][col] = total = PIDModel.computePID(seqs[row], seqs[col], options);
                values[col][row] = total;
            }
        }
        return new Matrix(values);
    }

    public static double computePID(String seq1, String seq2, SimilarityParamsI options) {
        int len1 = seq1.length();
        int len2 = seq2.length();
        int width = Math.max(len1, len2);
        int total = 0;
        int divideBy = 0;
        for (int i = 0; i < width; ++i) {
            if (i >= len1 || i >= len2) {
                if (options.denominateByShortestLength()) break;
                if (options.includeGaps()) {
                    ++divideBy;
                }
                if (!options.matchGaps()) continue;
                ++total;
                continue;
            }
            char c1 = seq1.charAt(i);
            char c2 = seq2.charAt(i);
            boolean gap1 = Comparison.isGap(c1);
            boolean gap2 = Comparison.isGap(c2);
            if (gap1 && gap2) {
                if (!options.includeGappedColumns()) continue;
                ++divideBy;
                ++total;
                continue;
            }
            if (gap1 || gap2) {
                if (options.includeGaps()) {
                    ++divideBy;
                }
                if (!options.matchGaps()) continue;
                ++total;
                continue;
            }
            if (PIDModel.toUpper(c1) == PIDModel.toUpper(c2)) {
                ++total;
            }
            ++divideBy;
        }
        return divideBy == 0 ? 0.0 : 100.0 * (double)total / (double)divideBy;
    }

    @Override
    public ScoreModelI getInstance(AlignmentViewPanel avp) {
        return this;
    }
}

