/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis.scoremodels;

import jalview.analysis.scoremodels.DistanceScoreModel;
import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureRenderer;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.SequenceFeature;
import jalview.math.Matrix;
import jalview.math.MatrixI;
import jalview.util.SetUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureDistanceModel
extends DistanceScoreModel {
    private static final String NAME = "Sequence Feature Similarity";
    private String description;
    FeatureRenderer fr;

    @Override
    public ScoreModelI getInstance(AlignmentViewPanel view) {
        try {
            FeatureDistanceModel instance = (FeatureDistanceModel)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            instance.configureFromAlignmentView(view);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            System.err.println("Error in " + this.getClass().getName() + ".getInstance(): " + e.getMessage());
            return null;
        }
        catch (ReflectiveOperationException roe) {
            return null;
        }
    }

    boolean configureFromAlignmentView(AlignmentViewPanel view) {
        this.fr = view.cloneFeatureRenderer();
        return true;
    }

    @Override
    public MatrixI findDistances(AlignmentView seqData, SimilarityParamsI params) {
        SeqCigar[] seqs = seqData.getSequences();
        int noseqs = seqs.length;
        int cpwidth = 0;
        double[][] distances = new double[noseqs][noseqs];
        List<String> dft = null;
        if (this.fr != null) {
            dft = this.fr.getDisplayedFeatureTypes();
        }
        if (dft == null || dft.isEmpty()) {
            return new Matrix(distances);
        }
        int[] viscont = seqData.getVisibleContigs();
        for (int vc = 0; vc < viscont.length; vc += 2) {
            for (int cpos = viscont[vc]; cpos <= viscont[vc + 1]; ++cpos) {
                ++cpwidth;
                Map<SeqCigar, Set<String>> sfap = this.findFeatureTypesAtColumn(seqs, cpos);
                for (int i = 0; i < noseqs - 1; ++i) {
                    for (int j = i + 1; j < noseqs; ++j) {
                        boolean gap2;
                        SeqCigar sc1 = seqs[i];
                        SeqCigar sc2 = seqs[j];
                        Set<String> set1 = sfap.get(sc1);
                        Set<String> set2 = sfap.get(sc2);
                        boolean gap1 = set1 == null;
                        boolean bl = gap2 = set2 == null;
                        if ((gap1 || gap2) && !params.includeGaps()) continue;
                        int seqDistance = SetUtils.countDisjunction(set1, set2);
                        double[] dArray = distances[i];
                        int n = j;
                        dArray[n] = dArray[n] + (double)seqDistance;
                    }
                }
            }
        }
        for (int i = 0; i < noseqs; ++i) {
            for (int j = i + 1; j < noseqs; ++j) {
                double[] dArray = distances[i];
                int n = j;
                dArray[n] = dArray[n] / (double)cpwidth;
                distances[j][i] = distances[i][j];
            }
        }
        return new Matrix(distances);
    }

    protected Map<SeqCigar, Set<String>> findFeatureTypesAtColumn(SeqCigar[] seqs, int columnPosition) {
        HashMap<SeqCigar, Set<String>> sfap = new HashMap<SeqCigar, Set<String>>();
        for (SeqCigar seq : seqs) {
            int spos = seq.findPosition(columnPosition);
            if (spos == -1) continue;
            HashSet<String> types = new HashSet<String>();
            List<SequenceFeature> sfs = this.fr.findFeaturesAtResidue(seq.getRefSeq(), spos, spos);
            for (SequenceFeature sf : sfs) {
                types.add(sf.getType());
            }
            sfap.put(seq, types);
        }
        return sfap;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isDNA() {
        return true;
    }

    @Override
    public boolean isProtein() {
        return true;
    }

    public String toString() {
        return "Score between sequences based on hamming distance between binary vectors marking features displayed at each column";
    }
}

