/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.CigarArray;
import jalview.datamodel.CigarSimple;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.math.MatrixI;
import jalview.viewmodel.AlignmentViewport;
import java.util.BitSet;
import java.util.Vector;

public abstract class TreeBuilder {
    public static final String AVERAGE_DISTANCE = "AV";
    public static final String NEIGHBOUR_JOINING = "NJ";
    protected Vector<BitSet> clusters;
    protected SequenceI[] sequences;
    public AlignmentView seqData;
    protected BitSet done;
    protected int noseqs;
    int noClus;
    protected MatrixI distances;
    protected int mini;
    protected int minj;
    protected double ri;
    protected double rj;
    SequenceNode maxdist;
    SequenceNode top;
    double maxDistValue;
    double maxheight;
    int ycount;
    Vector<SequenceNode> node;
    private AlignmentView seqStrings;

    public TreeBuilder(AlignmentViewport av, ScoreModelI sm, SimilarityParamsI scoreParameters) {
        int end;
        int start;
        boolean selview = av.getSelectionGroup() != null && av.getSelectionGroup().getSize() > 1;
        this.seqStrings = av.getAlignmentView(selview);
        if (!selview) {
            start = 0;
            end = av.getAlignment().getWidth();
            this.sequences = av.getAlignment().getSequencesArray();
        } else {
            start = av.getSelectionGroup().getStartRes();
            end = av.getSelectionGroup().getEndRes() + 1;
            this.sequences = av.getSelectionGroup().getSequencesInOrder(av.getAlignment());
        }
        this.init(this.seqStrings, start, end);
        this.computeTree(sm, scoreParameters);
    }

    public SequenceI[] getSequences() {
        return this.sequences;
    }

    double findHeight(SequenceNode nd) {
        if (nd == null) {
            return this.maxheight;
        }
        if (nd.left() == null && nd.right() == null) {
            nd.height = ((SequenceNode)nd.parent()).height + nd.dist;
            if (nd.height > this.maxheight) {
                return nd.height;
            }
            return this.maxheight;
        }
        if (nd.parent() != null) {
            nd.height = ((SequenceNode)nd.parent()).height + nd.dist;
        } else {
            this.maxheight = 0.0;
            nd.height = 0.0;
        }
        this.maxheight = this.findHeight((SequenceNode)nd.left());
        this.maxheight = this.findHeight((SequenceNode)nd.right());
        return this.maxheight;
    }

    void reCount(SequenceNode nd) {
        this.ycount = 0;
        this._reCount(nd);
    }

    void _reCount(SequenceNode nd) {
        if (nd == null) {
            return;
        }
        if (nd.left() != null && nd.right() != null) {
            this._reCount((SequenceNode)nd.left());
            this._reCount((SequenceNode)nd.right());
            SequenceNode l = (SequenceNode)nd.left();
            SequenceNode r = (SequenceNode)nd.right();
            nd.count = l.count + r.count;
            nd.ycount = (l.ycount + r.ycount) / 2.0f;
        } else {
            nd.count = 1;
            nd.ycount = this.ycount++;
        }
    }

    public SequenceNode getTopNode() {
        return this.top;
    }

    public boolean hasDistances() {
        return true;
    }

    public boolean hasBootstrap() {
        return false;
    }

    public boolean hasRootDistance() {
        return true;
    }

    void cluster() {
        while (this.noClus > 2) {
            this.findMinDistance();
            this.joinClusters(this.mini, this.minj);
            --this.noClus;
        }
        int rightChild = this.done.nextClearBit(0);
        int leftChild = this.done.nextClearBit(rightChild + 1);
        this.joinClusters(leftChild, rightChild);
        this.top = this.node.elementAt(leftChild);
        this.reCount(this.top);
        this.findHeight(this.top);
        this.findMaxDist(this.top);
    }

    protected abstract double findMinDistance();

    protected void computeTree(ScoreModelI sm, SimilarityParamsI scoreOptions) {
        this.distances = sm.findDistances(this.seqData, scoreOptions);
        this.makeLeaves();
        this.noClus = this.clusters.size();
        this.cluster();
    }

    void findMaxDist(SequenceNode nd) {
        if (nd == null) {
            return;
        }
        if (nd.left() == null && nd.right() == null) {
            double dist = nd.dist;
            if (dist > this.maxDistValue) {
                this.maxdist = nd;
                this.maxDistValue = dist;
            }
        } else {
            this.findMaxDist((SequenceNode)nd.left());
            this.findMaxDist((SequenceNode)nd.right());
        }
    }

    protected double findr(int i, int j) {
        double tmp = 1.0;
        for (int k = 0; k < this.noseqs; ++k) {
            if (k == i || k == j || this.done.get(k)) continue;
            tmp += this.distances.getValue(i, k);
        }
        if (this.noClus > 2) {
            tmp /= (double)(this.noClus - 2);
        }
        return tmp;
    }

    protected void init(AlignmentView seqView, int start, int end) {
        this.node = new Vector();
        if (seqView != null) {
            this.seqData = seqView;
        } else {
            CigarSimple[] seqs = new SeqCigar[this.sequences.length];
            for (int i = 0; i < this.sequences.length; ++i) {
                seqs[i] = new SeqCigar(this.sequences[i], start, end);
            }
            CigarArray sdata = new CigarArray(seqs);
            sdata.addOperation('M', end - start + 1);
            this.seqData = new AlignmentView(sdata, start);
        }
        this.noseqs = 0;
        this.done = new BitSet();
        for (SequenceI seq : this.sequences) {
            if (seq == null) continue;
            ++this.noseqs;
        }
    }

    void joinClusters(int i, int j) {
        double dist = this.distances.getValue(i, j);
        this.ri = this.findr(i, j);
        this.rj = this.findr(j, i);
        this.findClusterDistance(i, j);
        SequenceNode sn = new SequenceNode();
        sn.setLeft(this.node.elementAt(i));
        sn.setRight(this.node.elementAt(j));
        SequenceNode tmpi = this.node.elementAt(i);
        SequenceNode tmpj = this.node.elementAt(j);
        this.findNewDistances(tmpi, tmpj, dist);
        tmpi.setParent(sn);
        tmpj.setParent(sn);
        this.node.setElementAt(sn, i);
        this.clusters.get(i).or(this.clusters.get(j));
        this.clusters.get(j).clear();
        this.done.set(j);
    }

    protected abstract void findNewDistances(SequenceNode var1, SequenceNode var2, double var3);

    protected abstract void findClusterDistance(int var1, int var2);

    void makeLeaves() {
        this.clusters = new Vector();
        for (int i = 0; i < this.noseqs; ++i) {
            SequenceNode sn = new SequenceNode();
            sn.setElement(this.sequences[i]);
            sn.setName(this.sequences[i].getName());
            this.node.addElement(sn);
            BitSet bs = new BitSet();
            bs.set(i);
            this.clusters.addElement(bs);
        }
    }

    public AlignmentView getOriginalData() {
        return this.seqStrings;
    }
}

