/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.Rna;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import jalview.util.Format;
import jalview.util.QuickSort;
import java.util.Hashtable;

public class StructureFrequency {
    public static final int STRUCTURE_PROFILE_LENGTH = 74;
    public static final String MAXCOUNT = "C";
    public static final String MAXRESIDUE = "R";
    public static final String PID_GAPS = "G";
    public static final String PID_NOGAPS = "N";
    public static final String PROFILE = "P";
    public static final String PAIRPROFILE = "B";

    public static int findPair(SequenceFeature[] pairs, int indice) {
        for (int i = 0; i < pairs.length; ++i) {
            if (pairs[i].getBegin() != indice) continue;
            return pairs[i].getEnd();
        }
        return -1;
    }

    public static final void calculate(SequenceI[] sequences, int start, int end, Hashtable<String, Object>[] result, boolean profile, AlignmentAnnotation rnaStruc) {
        char[] struc = rnaStruc.getRNAStruc().toCharArray();
        SequenceFeature[] rna = rnaStruc._rnasecstr;
        int bpEnd = -1;
        int jSize = sequences.length;
        for (int i = start; i < end; ++i) {
            int canonicalOrWobblePairCount = 0;
            int canonical = 0;
            int otherPairCount = 0;
            int nongap = 0;
            String maxResidue = "-";
            int[] values = new int[255];
            int[][] pairs = new int[255][255];
            bpEnd = -1;
            char s = i < struc.length ? struc[i] : (char)'-';
            if (s == '.' || s == ' ') {
                s = '-';
            }
            if (!Rna.isOpeningParenthesis(s)) {
                if (s == '-') {
                    values[45] = values[45] + 1;
                }
            } else {
                bpEnd = StructureFrequency.findPair(rna, i);
                if (bpEnd > -1) {
                    for (int j = 0; j < jSize; ++j) {
                        if (sequences[j] == null) {
                            System.err.println("WARNING: Consensus skipping null sequence - possible race condition.");
                            continue;
                        }
                        char c = sequences[j].getCharAt(i);
                        char cEnd = sequences[j].getCharAt(bpEnd);
                        if (Comparison.isGap(c) || Comparison.isGap(cEnd)) {
                            values[45] = values[45] + 1;
                            continue;
                        }
                        ++nongap;
                        if ('a' <= c && 'z' >= c) {
                            c = (char)(c - 32);
                        }
                        if ('a' <= cEnd && 'z' >= cEnd) {
                            cEnd = (char)(cEnd - 32);
                        }
                        if (Rna.isCanonicalOrWobblePair(c, cEnd)) {
                            ++canonicalOrWobblePairCount;
                            if (Rna.isCanonicalPair(c, cEnd)) {
                                ++canonical;
                            }
                        } else {
                            ++otherPairCount;
                        }
                        int[] nArray = pairs[c];
                        char c2 = cEnd;
                        nArray[c2] = nArray[c2] + 1;
                    }
                }
            }
            Hashtable<String, Object> residueHash = new Hashtable<String, Object>();
            if (profile) {
                residueHash.put(PROFILE, new int[][]{values, {jSize, jSize - values[45]}});
                residueHash.put(PAIRPROFILE, pairs);
            }
            values[40] = canonicalOrWobblePairCount;
            values[91] = canonical;
            values[123] = otherPairCount;
            int count = canonicalOrWobblePairCount;
            if (canonicalOrWobblePairCount > 0 || otherPairCount > 0) {
                maxResidue = canonicalOrWobblePairCount >= otherPairCount ? (canonicalOrWobblePairCount - canonical < canonical ? "(" : "[") : "{";
            }
            residueHash.put(MAXCOUNT, count);
            residueHash.put(MAXRESIDUE, maxResidue);
            float percentage = (float)count * 100.0f / (float)jSize;
            residueHash.put(PID_GAPS, Float.valueOf(percentage));
            percentage = (float)count * 100.0f / (float)nongap;
            residueHash.put(PID_NOGAPS, Float.valueOf(percentage));
            if (result[i] == null) {
                result[i] = residueHash;
            }
            if (bpEnd <= 0) continue;
            values[41] = values[40];
            values[93] = values[91];
            values[125] = values[123];
            values[40] = 0;
            values[91] = 0;
            values[123] = 0;
            maxResidue = maxResidue.equals("(") ? ")" : (maxResidue.equals("[") ? "]" : "}");
            residueHash = new Hashtable();
            if (profile) {
                residueHash.put(PROFILE, new int[][]{values, {jSize, jSize - values[45]}});
                residueHash.put(PAIRPROFILE, pairs);
            }
            residueHash.put(MAXCOUNT, count);
            residueHash.put(MAXRESIDUE, maxResidue);
            percentage = (float)count * 100.0f / (float)jSize;
            residueHash.put(PID_GAPS, Float.valueOf(percentage));
            percentage = (float)count * 100.0f / (float)nongap;
            residueHash.put(PID_NOGAPS, Float.valueOf(percentage));
            result[bpEnd] = residueHash;
        }
    }

    public static void completeConsensus(AlignmentAnnotation consensus, Hashtable<String, Object>[] hconsensus, int iStart, int width, boolean ignoreGapsInConsensusCalculation, boolean includeAllConsSymbols, long nseq) {
        if (consensus == null || consensus.annotations == null || consensus.annotations.length < width) {
            return;
        }
        Object fmtstr = "%3.1f";
        int precision = 2;
        while (nseq > 100L) {
            ++precision;
            nseq /= 10L;
        }
        if (precision > 2) {
            fmtstr = "%" + (2 + precision) + "." + precision + "f";
        }
        Format fmt = new Format((String)fmtstr);
        for (int i = iStart; i < width; ++i) {
            Hashtable<String, Object> hci;
            if (i >= hconsensus.length || (hci = hconsensus[i]) == null) {
                consensus.annotations[i] = null;
                continue;
            }
            float value = 0.0f;
            Float fv = ignoreGapsInConsensusCalculation ? (Float)hci.get(PID_NOGAPS) : (Float)hci.get(PID_GAPS);
            if (fv == null) {
                consensus.annotations[i] = null;
                continue;
            }
            value = fv.floatValue();
            String maxRes = hci.get(MAXRESIDUE).toString();
            Object mouseOver = hci.get(MAXRESIDUE) + " ";
            if (maxRes.length() > 1) {
                mouseOver = "[" + maxRes + "] ";
                maxRes = "+";
            }
            int[][] profile = (int[][])hci.get(PROFILE);
            int[][] pairs = (int[][])hci.get(PAIRPROFILE);
            if (pairs != null && includeAllConsSymbols) {
                mouseOver = "";
                int[][] ca = new int[625][];
                float[] vl = new float[625];
                int x = 0;
                for (int c = 65; c < 90; ++c) {
                    for (int d = 65; d < 90; ++d) {
                        ca[x] = new int[]{c, d};
                        vl[x] = pairs[c][d];
                        ++x;
                    }
                }
                QuickSort.sort(vl, (Object[])ca);
                int p = 0;
                int divisor = profile[1][ignoreGapsInConsensusCalculation ? 1 : 0];
                for (int c = 624; c > 0; --c) {
                    if (!(vl[c] > 0.0f)) continue;
                    float tval = vl[c] * 100.0f / (float)divisor;
                    mouseOver = (String)mouseOver + (p == 0 ? "" : "; ") + (char)ca[c][0] + (char)ca[c][1] + " " + fmt.form(tval) + "%";
                    ++p;
                }
            } else {
                mouseOver = (String)mouseOver + fmt.form(value) + "%";
            }
            consensus.annotations[i] = new Annotation(maxRes, (String)mouseOver, ' ', value);
        }
    }

    public static int[] extractProfile(Hashtable<String, Object> hconsensus, boolean ignoreGapsInConsensusCalculation) {
        int[] rtnval = new int[74];
        int[][] profile = (int[][])hconsensus.get(PROFILE);
        int[][] pairs = (int[][])hconsensus.get(PAIRPROFILE);
        if (profile == null) {
            return null;
        }
        int[][] ca = new int[625][];
        float[] vl = new float[625];
        int x = 0;
        for (int c = 65; c < 90; ++c) {
            for (int d = 65; d < 90; ++d) {
                ca[x] = new int[]{c, d};
                vl[x] = pairs[c][d];
                ++x;
            }
        }
        QuickSort.sort(vl, (Object[])ca);
        int valuesCount = 0;
        rtnval[1] = 0;
        int offset = 2;
        int divisor = profile[1][ignoreGapsInConsensusCalculation ? 1 : 0];
        for (int c = 624; c > 0; --c) {
            if (!(vl[c] > 0.0f)) continue;
            rtnval[offset++] = ca[c][0];
            rtnval[offset++] = ca[c][1];
            rtnval[offset] = (int)(vl[c] * 100.0f / (float)divisor);
            rtnval[1] = rtnval[1] + rtnval[offset++];
            ++valuesCount;
        }
        rtnval[0] = valuesCount;
        int[] result = new int[rtnval.length + 1];
        result[0] = 1;
        System.arraycopy(rtnval, 0, result, 1, rtnval.length);
        return result;
    }
}

