/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.TreeBuilder;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.datamodel.SequenceNode;
import jalview.viewmodel.AlignmentViewport;

public class NJTree
extends TreeBuilder {
    public NJTree(AlignmentViewport av, ScoreModelI sm, SimilarityParamsI scoreParameters) {
        super(av, sm, scoreParameters);
    }

    @Override
    protected double findMinDistance() {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.noseqs - 1; ++i) {
            for (int j = i + 1; j < this.noseqs; ++j) {
                double tmp;
                if (this.done.get(i) || this.done.get(j) || !((tmp = this.distances.getValue(i, j) - (this.findr(i, j) + this.findr(j, i))) < min)) continue;
                this.mini = i;
                this.minj = j;
                min = tmp;
            }
        }
        return min;
    }

    @Override
    protected void findNewDistances(SequenceNode nodei, SequenceNode nodej, double dist) {
        nodei.dist = (dist + this.ri - this.rj) / 2.0;
        nodej.dist = dist - nodei.dist;
        if (nodei.dist < 0.0) {
            nodei.dist = 0.0;
        }
        if (nodej.dist < 0.0) {
            nodej.dist = 0.0;
        }
    }

    @Override
    protected void findClusterDistance(int i, int j) {
        double[] newdist = new double[this.noseqs];
        double ijDistance = this.distances.getValue(i, j);
        for (int l = 0; l < this.noseqs; ++l) {
            newdist[l] = l != i && l != j ? (this.distances.getValue(i, l) + this.distances.getValue(j, l) - ijDistance) / 2.0 : 0.0;
        }
        for (int ii = 0; ii < this.noseqs; ++ii) {
            this.distances.setValue(i, ii, newdist[ii]);
            this.distances.setValue(ii, i, newdist[ii]);
        }
    }
}

