/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.GeneticCodeI;
import jalview.bin.Cache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class GeneticCodes {
    private static final int CODON_LENGTH = 3;
    private static final String QUOTE = "\"";
    private static final String NUCS = "TCAG";
    private static final int NUCS_COUNT = "TCAG".length();
    private static final int NUCS_COUNT_SQUARED = NUCS_COUNT * NUCS_COUNT;
    private static final int NUCS_COUNT_CUBED = NUCS_COUNT * NUCS_COUNT * NUCS_COUNT;
    private static final String AMBIGUITY_CODES_FILE = "/AmbiguityCodes.dat";
    private static final String RESOURCE_FILE = "/GeneticCodes.dat";
    private static GeneticCodes instance = new GeneticCodes();
    private Map<String, String> ambiguityCodes;
    private Map<String, GeneticCodeI> codeTables;

    private GeneticCodes() {
        if (instance == null) {
            this.ambiguityCodes = new HashMap<String, String>();
            this.codeTables = new LinkedHashMap<String, GeneticCodeI>();
            this.loadAmbiguityCodes(AMBIGUITY_CODES_FILE);
            this.loadCodes(RESOURCE_FILE);
        }
    }

    public static GeneticCodes getInstance() {
        return instance;
    }

    public Iterable<GeneticCodeI> getCodeTables() {
        return this.codeTables.values();
    }

    public GeneticCodeI getCodeTable(String id) {
        return this.codeTables.get(id);
    }

    public GeneticCodeI getStandardCodeTable() {
        return this.codeTables.values().iterator().next();
    }

    protected void loadCodes(String fileName) {
        try {
            InputStream is = this.getClass().getResourceAsStream(fileName);
            if (is == null) {
                System.err.println("Resource file not found: " + fileName);
                return;
            }
            BufferedReader dataIn = new BufferedReader(new InputStreamReader(is));
            String line = "";
            while (line != null && !line.startsWith("Genetic-code-table")) {
                line = this.readLine(dataIn);
            }
            line = this.readLine(dataIn);
            while (line.startsWith("{")) {
                line = this.loadOneTable(dataIn);
            }
        }
        catch (IOException | NullPointerException e) {
            Cache.log.error((Object)("Error reading genetic codes data file " + fileName + ": " + e.getMessage()));
        }
        if (this.codeTables.isEmpty()) {
            System.err.println("No genetic code tables loaded, check format of file " + fileName);
        }
    }

    protected void loadAmbiguityCodes(String fileName) {
        try {
            InputStream is = this.getClass().getResourceAsStream(fileName);
            if (is == null) {
                System.err.println("Resource file not found: " + fileName);
                return;
            }
            BufferedReader dataIn = new BufferedReader(new InputStreamReader(is));
            String line = "";
            while (line != null) {
                line = this.readLine(dataIn);
                if (line == null || "DNA".equals(line.toUpperCase())) continue;
                String[] tokens = line.split("\\t");
                if (tokens.length == 2) {
                    this.ambiguityCodes.put(tokens[0].toUpperCase(), tokens[1].toUpperCase());
                    continue;
                }
                System.err.println("Unexpected data in " + fileName + ": " + line);
            }
        }
        catch (IOException e) {
            Cache.log.error((Object)("Error reading nucleotide ambiguity codes data file: " + e.getMessage()));
        }
    }

    protected String readLine(BufferedReader dataIn) throws IOException {
        String line = dataIn.readLine();
        while (line != null && line.startsWith("#")) {
            line = this.readLine(dataIn);
        }
        return line == null ? null : line.trim();
    }

    protected String loadOneTable(BufferedReader dataIn) throws IOException {
        String name = null;
        String id = null;
        HashMap<String, String> codons = new HashMap<String, String>();
        String line = this.readLine(dataIn);
        while (line != null && !line.startsWith("}")) {
            if (line.startsWith("name") && name == null) {
                name = line.substring(line.indexOf(QUOTE) + 1, line.lastIndexOf(QUOTE));
            } else if (line.startsWith("id")) {
                id = new StringTokenizer(line.substring(2)).nextToken();
            } else if (line.startsWith("ncbieaa")) {
                String aminos = line.substring(line.indexOf(QUOTE) + 1, line.lastIndexOf(QUOTE));
                if (aminos.length() != NUCS_COUNT_CUBED) {
                    Cache.log.error((Object)("wrong data length in code table: " + line));
                } else {
                    for (int i = 0; i < aminos.length(); ++i) {
                        String peptide = String.valueOf(aminos.charAt(i));
                        char codon1 = NUCS.charAt(i / NUCS_COUNT_SQUARED);
                        char codon2 = NUCS.charAt(i % NUCS_COUNT_SQUARED / NUCS_COUNT);
                        char codon3 = NUCS.charAt(i % NUCS_COUNT);
                        String codon = new String(new char[]{codon1, codon2, codon3});
                        codons.put(codon, peptide);
                    }
                }
            }
            line = this.readLine(dataIn);
        }
        this.registerCodeTable(id, name, codons);
        return this.readLine(dataIn);
    }

    protected void registerCodeTable(final String id, final String name, final Map<String, String> codons) {
        this.codeTables.put(id, new GeneticCodeI(){
            Map<String, String> ambiguous = new HashMap<String, String>();

            @Override
            public String translateCanonical(String codon) {
                return (String)codons.get(codon.toUpperCase());
            }

            @Override
            public String translate(String codon) {
                String upper = codon.toUpperCase();
                String peptide = this.translateCanonical(upper);
                if (peptide == null) {
                    peptide = GeneticCodes.this.getAmbiguousTranslation(upper, this.ambiguous, this);
                }
                return peptide;
            }

            @Override
            public String getId() {
                return id;
            }

            @Override
            public String getName() {
                return name;
            }
        });
    }

    protected String getAmbiguousTranslation(String codon, Map<String, String> ambiguous, GeneticCodeI codeTable) {
        if (codon.length() != 3) {
            return null;
        }
        boolean isAmbiguous = false;
        char[][] expanded = new char[3][];
        for (int i = 0; i < 3; ++i) {
            String base = String.valueOf(codon.charAt(i));
            if (this.ambiguityCodes.containsKey(base)) {
                isAmbiguous = true;
                base = this.ambiguityCodes.get(base);
            }
            expanded[i] = base.toCharArray();
        }
        if (!isAmbiguous) {
            return null;
        }
        String peptide = null;
        for (char c1 : expanded[0]) {
            for (char c2 : expanded[1]) {
                for (char c3 : expanded[2]) {
                    char[] cdn = new char[]{c1, c2, c3};
                    String possibleCodon = String.valueOf(cdn);
                    String pep = codeTable.translate(possibleCodon);
                    if (pep == null || peptide != null && !pep.equals(peptide)) {
                        ambiguous.put(codon, null);
                        return null;
                    }
                    peptide = pep;
                }
            }
        }
        ambiguous.put(codon, peptide);
        return peptide;
    }
}

