/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.CodonComparator;
import jalview.analysis.GeneticCodeI;
import jalview.api.AlignViewportI;
import jalview.datamodel.AlignedCodon;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.FeatureProperties;
import jalview.datamodel.GraphLine;
import jalview.datamodel.Mapping;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import jalview.util.DBRefUtils;
import jalview.util.MapList;
import jalview.util.ShiftList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Dna {
    private static final String STOP_ASTERIX = "*";
    private static final Comparator<AlignedCodon> comparator = new CodonComparator();
    private final List<SequenceI> selection;
    private final String[] seqstring;
    private final Iterator<int[]> contigs;
    private final char gapChar;
    private final AlignmentAnnotation[] annotations;
    private final int dnaWidth;
    private final AlignmentI dataset;
    private ShiftList vismapping;
    private int[] startcontigs;
    private int aaWidth = 0;
    private AlignedCodon[] alignedCodons;

    public Dna(AlignViewportI viewport, Iterator<int[]> visibleContigs) {
        this.selection = Arrays.asList(viewport.getSequenceSelection());
        this.seqstring = viewport.getViewAsString(true);
        this.contigs = visibleContigs;
        this.gapChar = viewport.getGapCharacter();
        this.annotations = viewport.getAlignment().getAlignmentAnnotation();
        this.dnaWidth = viewport.getAlignment().getWidth();
        this.dataset = viewport.getAlignment().getDataset();
        this.initContigs();
    }

    private void initContigs() {
        this.vismapping = new ShiftList();
        int npos = 0;
        int[] lastregion = null;
        ArrayList<Integer> tempcontigs = new ArrayList<Integer>();
        while (this.contigs.hasNext()) {
            int[] region = this.contigs.next();
            if (lastregion == null) {
                this.vismapping.addShift(npos, region[0]);
            } else {
                this.vismapping.addShift(npos, region[0] - lastregion[1] + 1);
            }
            lastregion = region;
            tempcontigs.add(region[0]);
            tempcontigs.add(region[1]);
        }
        this.startcontigs = new int[tempcontigs.size()];
        int i = 0;
        for (Integer val : tempcontigs) {
            this.startcontigs[i] = val;
            ++i;
        }
        tempcontigs = null;
    }

    public static final int compareCodonPos(AlignedCodon ac1, AlignedCodon ac2) {
        return comparator.compare(ac1, ac2);
    }

    private static int jalview_2_8_2compare(AlignedCodon ac1, AlignedCodon ac2) {
        if (ac1 == null || ac2 == null || ac1.equals(ac2)) {
            return 0;
        }
        if (ac1.pos1 < ac2.pos1 || ac1.pos2 < ac2.pos2 || ac1.pos3 < ac2.pos3) {
            return -1;
        }
        return 1;
    }

    public AlignmentI translateCdna(GeneticCodeI codeTable) {
        AlignedCodonFrame acf = new AlignedCodonFrame();
        this.alignedCodons = new AlignedCodon[this.dnaWidth];
        int sSize = this.selection.size();
        ArrayList<SequenceI> pepseqs = new ArrayList<SequenceI>();
        for (int s = 0; s < sSize; ++s) {
            SequenceI newseq = this.translateCodingRegion(this.selection.get(s), this.seqstring[s], acf, pepseqs, codeTable);
            if (newseq == null) continue;
            pepseqs.add(newseq);
            SequenceI ds = newseq;
            if (this.dataset == null) continue;
            while (ds.getDatasetSequence() != null) {
                ds = ds.getDatasetSequence();
            }
            this.dataset.addSequence(ds);
        }
        SequenceI[] newseqs = pepseqs.toArray(new SequenceI[pepseqs.size()]);
        Alignment al = new Alignment(newseqs);
        al.padGaps();
        al.setDataset(this.dataset);
        this.translateAlignedAnnotations(al, acf);
        al.addCodonFrame(acf);
        return al;
    }

    public static boolean canTranslate(SequenceI[] selection, int[] viscontigs) {
        for (int gd = 0; gd < selection.length; ++gd) {
            int d;
            SequenceI dna = selection[gd];
            List<DBRefEntry> dnarefs = DBRefUtils.selectRefs(dna.getDBRefs(), DBRefSource.DNACODINGDBS);
            if (dnarefs == null) continue;
            ArrayList<DBRefEntry> mappedrefs = new ArrayList<DBRefEntry>();
            Sequence.DBModList<DBRefEntry> refs = dna.getDBRefs();
            int nd = refs.size();
            for (d = 0; d < nd; ++d) {
                DBRefEntry ref = (DBRefEntry)refs.get(d);
                if (ref.getMap() == null || ref.getMap().getMap() == null || ref.getMap().getMap().getFromRatio() != 3 || ref.getMap().getMap().getToRatio() != 1) continue;
                mappedrefs.add(ref);
            }
            dnarefs = mappedrefs;
            nd = dnarefs.size();
            for (d = 0; d < nd; ++d) {
                Mapping mp = dnarefs.get(d).getMap();
                if (mp == null) continue;
                int nv = viscontigs.length;
                for (int vc = 0; vc < nv; vc += 2) {
                    int[] mpr = mp.locateMappedRange(viscontigs[vc], viscontigs[vc + 1]);
                    if (mpr == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void translateAlignedAnnotations(AlignmentI al, AlignedCodonFrame acf) {
        if (this.annotations != null) {
            for (AlignmentAnnotation annotation : this.annotations) {
                SequenceI aaSeq;
                SequenceI seqRef;
                Annotation[] anots;
                if (annotation.autoCalculated || !annotation.visible || annotation.isRNA()) continue;
                int aSize = this.aaWidth;
                Annotation[] annotationArray = anots = annotation.annotations == null ? null : new Annotation[aSize];
                if (anots != null) {
                    for (int a = 0; a < aSize; ++a) {
                        if (a >= this.alignedCodons.length || this.alignedCodons[a] == null || this.alignedCodons[a].pos1 != this.alignedCodons[a].pos3 - 2) continue;
                        anots[a] = Dna.getCodonAnnotation(this.alignedCodons[a], annotation.annotations);
                    }
                }
                AlignmentAnnotation aa = new AlignmentAnnotation(annotation.label, annotation.description, anots);
                aa.graph = annotation.graph;
                aa.graphGroup = annotation.graphGroup;
                aa.graphHeight = annotation.graphHeight;
                if (annotation.getThreshold() != null) {
                    aa.setThreshold(new GraphLine(annotation.getThreshold()));
                }
                if (annotation.hasScore) {
                    aa.setScore(annotation.getScore());
                }
                if ((seqRef = annotation.sequenceRef) != null && (aaSeq = acf.getAaForDnaSeq(seqRef)) != null) {
                    aa.setSequenceRef(aaSeq);
                    aa.createSequenceMapping(aaSeq, aaSeq.getStart(), true);
                    aa.adjustForAlignment();
                    aaSeq.addAlignmentAnnotation(aa);
                }
                al.addAnnotation(aa);
            }
        }
    }

    private static Annotation getCodonAnnotation(AlignedCodon is, Annotation[] annotations) {
        int contrib = 0;
        Annotation annot = null;
        for (int p = 1; p <= 3; ++p) {
            int dnaCol = is.getBaseColumn(p);
            if (annotations[dnaCol] == null) continue;
            if (annot == null) {
                annot = new Annotation(annotations[dnaCol]);
                contrib = 1;
                continue;
            }
            Annotation cpy = new Annotation(annotations[dnaCol]);
            if (annot.colour == null) {
                annot.colour = cpy.colour;
            }
            if (annot.description == null || annot.description.length() == 0) {
                annot.description = cpy.description;
            }
            if (annot.displayCharacter == null) {
                annot.displayCharacter = cpy.displayCharacter;
            }
            if (annot.secondaryStructure == '\u0000') {
                annot.secondaryStructure = cpy.secondaryStructure;
            }
            annot.value += cpy.value;
            ++contrib;
        }
        if (contrib > 1) {
            annot.value /= (float)contrib;
        }
        return annot;
    }

    protected SequenceI translateCodingRegion(SequenceI selection, String seqstring, AlignedCodonFrame acf, List<SequenceI> proteinSeqs, GeneticCodeI codeTable) {
        ArrayList<int[]> skip = new ArrayList<int[]>();
        int[] skipint = null;
        int npos = 0;
        int vc = 0;
        int[] scontigs = new int[this.startcontigs.length];
        System.arraycopy(this.startcontigs, 0, scontigs, 0, this.startcontigs.length);
        StringBuilder protein = new StringBuilder(seqstring.length() / 2);
        String seq = seqstring.replace('U', 'T').replace('u', 'T');
        char[] codon = new char[3];
        int[] cdp = new int[3];
        int rf = 0;
        int lastnpos = 0;
        int aspos = 0;
        int resSize = 0;
        int nend = seq.length();
        for (npos = 0; npos < nend; ++npos) {
            if (!Comparison.isGap(seq.charAt(npos))) {
                cdp[rf] = npos;
                codon[rf++] = seq.charAt(npos);
            }
            if (rf != 3) continue;
            AlignedCodon alignedCodon = new AlignedCodon(cdp[0], cdp[1], cdp[2]);
            Object aa = codeTable.translate(new String(codon));
            rf = 0;
            String gapString = String.valueOf(this.gapChar);
            if (aa == null) {
                aa = gapString;
                if (skipint == null) {
                    skipint = new int[]{alignedCodon.pos1, alignedCodon.pos3};
                }
                skipint[1] = alignedCodon.pos3;
            } else {
                if (skipint != null) {
                    skipint[0] = this.vismapping.shift((int)skipint[0]);
                    skipint[1] = this.vismapping.shift(skipint[1]);
                    vc = 0;
                    while (vc < scontigs.length) {
                        int[] t;
                        if (scontigs[vc + 1] < skipint[0]) {
                            vc += 2;
                            continue;
                        }
                        if (scontigs[vc] > skipint[1]) break;
                        if (scontigs[vc] > skipint[0]) continue;
                        if (skipint[0] == scontigs[vc]) {
                            if (scontigs[vc + 1] > skipint[1]) {
                                scontigs[vc] = skipint[1];
                                vc += 2;
                                continue;
                            }
                            if (scontigs[vc + 1] == skipint[1]) {
                                t = new int[scontigs.length - 2];
                                if (vc > 0) {
                                    System.arraycopy(scontigs, 0, t, 0, vc - 1);
                                }
                                if (vc + 2 < t.length) {
                                    System.arraycopy(scontigs, vc + 2, t, vc, t.length - vc + 2);
                                }
                                scontigs = t;
                                continue;
                            }
                            scontigs[vc + 1] = skipint[0] - 1;
                            vc += 2;
                            continue;
                        }
                        if (scontigs[vc + 1] < skipint[1]) {
                            scontigs[vc + 1] = skipint[0] - 1;
                            vc += 2;
                            continue;
                        }
                        t = new int[scontigs.length + 2];
                        System.arraycopy(scontigs, 0, t, 0, vc + 1);
                        t[vc + 1] = skipint[0];
                        t[vc + 2] = skipint[1];
                        System.arraycopy(scontigs, vc + 1, t, vc + 3, scontigs.length - (vc + 1));
                        scontigs = t;
                        vc += 4;
                    }
                    skip.add(skipint);
                    skipint = null;
                }
                if (((String)aa).equals(ResidueProperties.STOP)) {
                    aa = STOP_ASTERIX;
                }
                ++resSize;
            }
            boolean findpos = true;
            while (findpos) {
                int compareCodonPos = Dna.compareCodonPos(alignedCodon, this.alignedCodons[aspos]);
                switch (compareCodonPos) {
                    case -1: {
                        this.insertAAGap(aspos, proteinSeqs);
                        findpos = false;
                        break;
                    }
                    case 1: {
                        aa = gapString + (String)aa;
                        ++aspos;
                        break;
                    }
                    case 0: {
                        findpos = false;
                    }
                }
            }
            protein.append((String)aa);
            lastnpos = npos;
            if (this.alignedCodons[aspos] == null) {
                this.alignedCodons[aspos] = alignedCodon;
            } else if (!this.alignedCodons[aspos].equals(alignedCodon)) {
                throw new IllegalStateException("Tried to coalign " + this.alignedCodons[aspos].toString() + " with " + alignedCodon.toString());
            }
            if (aspos >= this.aaWidth) {
                this.aaWidth = aspos;
            }
            ++aspos;
        }
        if (resSize > 0) {
            Sequence newseq = new Sequence(selection.getName(), protein.toString());
            if (rf != 0) {
                String errMsg = "trimming contigs for incomplete terminal codon.";
                System.err.println("trimming contigs for incomplete terminal codon.");
                vc = scontigs.length - 1;
                lastnpos = this.vismapping.shift(lastnpos);
                while (vc >= 0 && scontigs[vc] > lastnpos) {
                    if (vc > 0 && scontigs[vc - 1] > lastnpos) {
                        vc -= 2;
                        continue;
                    }
                    scontigs[vc] = lastnpos;
                }
                if (vc > 0 && vc + 1 < scontigs.length) {
                    int[] t = new int[vc + 1];
                    System.arraycopy(scontigs, 0, t, 0, vc + 1);
                    scontigs = t;
                }
                if (vc <= 0) {
                    scontigs = null;
                }
            }
            if (scontigs != null) {
                npos = 0;
                for (vc = 0; vc < scontigs.length; vc += 2) {
                    scontigs[vc] = selection.findPosition(scontigs[vc]);
                    scontigs[vc + 1] = selection.findPosition(scontigs[vc + 1]);
                    if (scontigs[vc + 1] == selection.getEnd()) break;
                }
                if (vc + 2 < scontigs.length) {
                    int[] t = new int[vc + 2];
                    System.arraycopy(scontigs, 0, t, 0, vc + 2);
                    scontigs = t;
                }
                MapList map = new MapList(scontigs, new int[]{1, resSize}, 3, 1);
                Dna.transferCodedFeatures(selection, newseq, map);
                SequenceI rseq = newseq.deriveSequence();
                acf.addMap(selection, rseq, map);
                return rseq;
            }
        }
        return null;
    }

    protected void insertAAGap(int pos, List<SequenceI> proteinSeqs) {
        ++this.aaWidth;
        for (SequenceI seq : proteinSeqs) {
            seq.insertCharAt(pos, this.gapChar);
        }
        this.checkCodonFrameWidth();
        if (pos < this.aaWidth) {
            ++this.aaWidth;
            System.arraycopy(this.alignedCodons, pos, this.alignedCodons, pos + 1, this.alignedCodons.length - pos - 1);
            this.alignedCodons[pos] = null;
        }
    }

    protected void checkCodonFrameWidth() {
        if (this.alignedCodons[this.alignedCodons.length - 1] != null) {
            AlignedCodon[] c = new AlignedCodon[this.alignedCodons.length + 10];
            System.arraycopy(this.alignedCodons, 0, c, 0, this.alignedCodons.length);
            this.alignedCodons = c;
        }
    }

    private static void transferCodedFeatures(SequenceI dna, SequenceI pep, MapList map) {
        for (SequenceFeature sf : dna.getFeatures().getAllFeatures(new String[0])) {
            if (!FeatureProperties.isCodingFeature(null, sf.getType())) continue;
        }
    }

    public AlignmentI reverseCdna(boolean complement) {
        int sSize = this.selection.size();
        ArrayList<SequenceI> reversed = new ArrayList<SequenceI>();
        for (int s = 0; s < sSize; ++s) {
            SequenceI newseq = Dna.reverseSequence(this.selection.get(s).getName(), this.seqstring[s], complement);
            if (newseq == null) continue;
            reversed.add(newseq);
        }
        SequenceI[] newseqs = reversed.toArray(new SequenceI[reversed.size()]);
        Alignment al = new Alignment(newseqs);
        al.createDatasetAlignment();
        return al;
    }

    public static SequenceI reverseSequence(String seqName, String sequence, boolean complement) {
        String newName = seqName + "|rev" + (complement ? "comp" : "");
        char[] originalSequence = sequence.toCharArray();
        int length = originalSequence.length;
        char[] reversedSequence = new char[length];
        int bases = 0;
        for (int i = 0; i < length; ++i) {
            char c;
            reversedSequence[length - i - 1] = c = complement ? Dna.getComplement(originalSequence[i]) : originalSequence[i];
            if (Comparison.isGap(c)) continue;
            ++bases;
        }
        Sequence reversed = new Sequence(newName, reversedSequence, 1, bases);
        return reversed;
    }

    public static String reverseComplement(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = s.length() - 1; i >= 0; --i) {
            sb.append(Dna.getComplement(s.charAt(i)));
        }
        return sb.toString();
    }

    public static char getComplement(char c) {
        int result = c;
        switch (c) {
            case 32: 
            case 45: 
            case 46: {
                break;
            }
            case 97: {
                result = 116;
                break;
            }
            case 65: {
                result = 84;
                break;
            }
            case 99: {
                result = 103;
                break;
            }
            case 67: {
                result = 71;
                break;
            }
            case 103: {
                result = 99;
                break;
            }
            case 71: {
                result = 67;
                break;
            }
            case 116: {
                result = 97;
                break;
            }
            case 84: {
                result = 65;
                break;
            }
            case 117: {
                result = 97;
                break;
            }
            case 85: {
                result = 65;
                break;
            }
            case 114: {
                result = 121;
                break;
            }
            case 82: {
                result = 89;
                break;
            }
            case 121: {
                result = 114;
                break;
            }
            case 89: {
                result = 82;
                break;
            }
            case 107: {
                result = 109;
                break;
            }
            case 75: {
                result = 77;
                break;
            }
            case 109: {
                result = 107;
                break;
            }
            case 77: {
                result = 75;
                break;
            }
            case 98: {
                result = 118;
                break;
            }
            case 66: {
                result = 86;
                break;
            }
            case 118: {
                result = 98;
                break;
            }
            case 86: {
                result = 66;
                break;
            }
            case 100: {
                result = 104;
                break;
            }
            case 68: {
                result = 72;
                break;
            }
            case 104: {
                result = 100;
                break;
            }
            case 72: {
                result = 68;
            }
        }
        return (char)result;
    }
}

