/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.scoremodels.ScoreMatrix;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.ResidueCount;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import jalview.util.Format;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class Conservation {
    private static final int THRESHOLD_PERCENT = 3;
    private static final int TOUPPERCASE = 32;
    private static final int GAP_INDEX = -1;
    private static final Format FORMAT_3DP = new Format("%2.5f");
    SequenceI[] sequences;
    int start;
    int end;
    Vector<int[]> seqNums;
    int maxLength = 0;
    boolean seqNumsChanged = false;
    Map<String, Integer>[] total;
    boolean canonicaliseAa = true;
    private Vector<Double> quality;
    private double qualityMinimum;
    private double qualityMaximum;
    private Sequence consSequence;
    private int threshold;
    private String name = "";
    private int[][] cons2;
    private int[] cons2GapCounts;
    private String[] consSymbs;

    public Conservation(String name, List<SequenceI> sequences, int start, int end) {
        this(name, 3, sequences, start, end);
    }

    public Conservation(String name, int threshold, List<SequenceI> sequences, int start, int end) {
        this.name = name;
        this.threshold = threshold;
        this.start = start;
        this.end = end;
        this.maxLength = end - start + 1;
        int sSize = sequences.size();
        SequenceI[] sarray = new SequenceI[sSize];
        this.sequences = sarray;
        try {
            for (int s = 0; s < sSize; ++s) {
                sarray[s] = sequences.get(s);
                if (sarray[s].getLength() <= this.maxLength) continue;
                this.maxLength = sarray[s].getLength();
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.sequences = new SequenceI[0];
            this.maxLength = 0;
        }
    }

    private void calcSeqNum(int i, ScoreMatrix sm) {
        int sSize = this.sequences.length;
        if (i > -1 && i < sSize) {
            String sq = this.sequences[i].getSequenceAsString();
            if (this.seqNums.size() <= i) {
                this.seqNums.addElement(new int[sq.length() + 1]);
            }
            if (sq.hashCode() != this.seqNums.elementAt(i)[0]) {
                this.seqNumsChanged = true;
                int len = sq.length();
                if (this.maxLength < len) {
                    this.maxLength = len;
                }
                int[] sqnum = new int[len + 1];
                sqnum[0] = sq.hashCode();
                for (int j = 1; j <= len; ++j) {
                    char residue = sq.charAt(j - 1);
                    if (Comparison.isGap(residue)) {
                        sqnum[j] = -1;
                        continue;
                    }
                    sqnum[j] = sm.getMatrixIndex(residue);
                    if (sqnum[j] != -1) continue;
                    sqnum[j] = -1;
                }
                this.seqNums.setElementAt(sqnum, i);
            } else {
                System.out.println("SEQUENCE HAS BEEN DELETED!!!");
            }
        } else {
            System.err.println("ERROR: calcSeqNum called with out of range sequence index for Alignment\n");
        }
    }

    public void calculate() {
        int height = this.sequences.length;
        this.total = new Map[this.maxLength];
        for (int column = this.start; column <= this.end; ++column) {
            ResidueCount values = this.countResidues(column);
            int thresh = this.threshold * height / 100;
            TreeMap<String, Integer> resultHash = new TreeMap<String, Integer>();
            ResidueCount.SymbolCounts symbolCounts = values.getSymbolCounts();
            char[] symbols = symbolCounts.symbols;
            int[] counts = symbolCounts.values;
            for (int j = 0; j < symbols.length; ++j) {
                char c = symbols[j];
                if (counts[j] <= thresh) continue;
                Conservation.recordConservation(resultHash, String.valueOf(c));
            }
            if (values.getGapCount() > thresh) {
                Conservation.recordConservation(resultHash, "-");
            }
            if (this.total.length <= 0) continue;
            this.total[column - this.start] = resultHash;
        }
    }

    protected static void recordConservation(Map<String, Integer> resultMap, String res) {
        res = res.toUpperCase();
        for (Map.Entry<String, Map<String, Integer>> property : ResidueProperties.propHash.entrySet()) {
            String propertyName = property.getKey();
            Integer residuePropertyValue = property.getValue().get(res);
            if (!resultMap.containsKey(propertyName)) {
                if (residuePropertyValue != null) {
                    resultMap.put(propertyName, residuePropertyValue);
                    continue;
                }
                resultMap.put(propertyName, property.getValue().get("-"));
                continue;
            }
            Integer currentResult = resultMap.get(propertyName);
            if (currentResult == -1 || currentResult.equals(residuePropertyValue)) continue;
            resultMap.put(propertyName, -1);
        }
    }

    protected ResidueCount countResidues(int column) {
        ResidueCount values = new ResidueCount(false);
        for (int row = 0; row < this.sequences.length; ++row) {
            if (this.sequences[row].getLength() > column) {
                int index;
                int c = this.sequences[row].getCharAt(column);
                c = this.canonicaliseAa ? ((index = ResidueProperties.aaIndex[c]) > 20 ? 45 : (int)ResidueProperties.aa[index].charAt(0)) : this.toUpperCase((char)c);
                if (Comparison.isGap((char)c)) {
                    values.addGap();
                    continue;
                }
                values.add((char)c);
                continue;
            }
            values.addGap();
        }
        return values;
    }

    public int[] countConservationAndGaps(int column) {
        int gapCount = 0;
        boolean fullyConserved = true;
        int iSize = this.sequences.length;
        if (iSize == 0) {
            return new int[]{0, 0};
        }
        char lastRes = '0';
        for (int i = 0; i < iSize; ++i) {
            if (column >= this.sequences[i].getLength()) {
                ++gapCount;
                continue;
            }
            char c = this.sequences[i].getCharAt(column);
            if (Comparison.isGap(c)) {
                ++gapCount;
                continue;
            }
            c = this.toUpperCase(c);
            if (lastRes == '0') {
                lastRes = c;
            }
            if (c == lastRes) continue;
            fullyConserved = false;
        }
        int[] r = new int[]{fullyConserved ? 1 : 0, gapCount};
        return r;
    }

    char toUpperCase(char c) {
        if ('a' <= c && c <= 'z') {
            c = (char)(c - 32);
        }
        return c;
    }

    public void verdict(boolean positiveOnly, float maxPercentageGaps) {
        int i;
        StringBuilder consString = new StringBuilder(this.end);
        for (i = 0; i < this.start; ++i) {
            consString.append('-');
        }
        this.consSymbs = new String[this.end - this.start + 1];
        for (i = this.start; i <= this.end; ++i) {
            int[] gapcons = this.countConservationAndGaps(i);
            boolean fullyConserved = gapcons[0] == 1;
            int totGaps = gapcons[1];
            float pgaps = (float)totGaps * 100.0f / (float)this.sequences.length;
            if (maxPercentageGaps > pgaps) {
                Map<String, Integer> resultHash = this.total[i - this.start];
                int count = 0;
                StringBuilder positives = new StringBuilder(64);
                StringBuilder negatives = new StringBuilder(32);
                for (String type : resultHash.keySet()) {
                    int result = resultHash.get(type);
                    if (result == -1) continue;
                    ++count;
                    if (result == 1) {
                        positives.append(positives.length() == 0 ? "" : " ");
                        positives.append(type);
                    }
                    if (result != 0 || positiveOnly) continue;
                    negatives.append(negatives.length() == 0 ? "" : " ");
                    negatives.append("!").append(type);
                }
                if (negatives.length() > 0) {
                    positives.append(" ").append((CharSequence)negatives);
                }
                this.consSymbs[i - this.start] = positives.toString();
                if (count < 10) {
                    consString.append(count);
                    continue;
                }
                consString.append(fullyConserved ? "*" : "+");
                continue;
            }
            consString.append('-');
        }
        this.consSequence = new Sequence(this.name, consString.toString(), this.start, this.end);
    }

    public SequenceI getConsSequence() {
        return this.consSequence;
    }

    public void findQuality() {
        this.findQuality(0, this.maxLength - 1, ScoreModels.getInstance().getBlosum62());
    }

    private void percentIdentity(ScoreMatrix sm) {
        this.seqNums = new Vector();
        int i = 0;
        int iSize = this.sequences.length;
        for (i = 0; i < iSize; ++i) {
            this.calcSeqNum(i, sm);
        }
        if (this.cons2 == null || this.seqNumsChanged) {
            this.cons2 = new int[this.maxLength][24];
            this.cons2GapCounts = new int[this.maxLength];
            for (int j = 0; j < this.sequences.length; ++j) {
                int[] sqnum = this.seqNums.elementAt(j);
                for (i = 1; i < sqnum.length; ++i) {
                    int index = sqnum[i];
                    if (index == -1) {
                        int n = i - 1;
                        this.cons2GapCounts[n] = this.cons2GapCounts[n] + 1;
                        continue;
                    }
                    int[] nArray = this.cons2[i - 1];
                    int n = index;
                    nArray[n] = nArray[n] + 1;
                }
                i = sqnum.length - 1;
                while (i < this.maxLength) {
                    int n = i++;
                    this.cons2GapCounts[n] = this.cons2GapCounts[n] + 1;
                }
            }
        }
    }

    protected void findQuality(int startCol, int endCol, ScoreMatrix scoreMatrix) {
        this.quality = new Vector();
        double max = -1.7976931348623157E308;
        float[][] scores = scoreMatrix.getMatrix();
        this.percentIdentity(scoreMatrix);
        int size = this.seqNums.size();
        int[] lengths = new int[size];
        for (int l = 0; l < size; ++l) {
            lengths[l] = this.seqNums.elementAt(l).length - 1;
        }
        int symbolCount = scoreMatrix.getSize();
        for (int j = startCol; j <= endCol; ++j) {
            double bigtot = 0.0;
            double[] x = new double[symbolCount];
            int ii = 0;
            while (ii < symbolCount) {
                x[ii] = 0.0;
                for (int i2 = 0; i2 < symbolCount - 1; ++i2) {
                    int n = ii;
                    x[n] = x[n] + ((double)this.cons2[j][i2] * (double)scores[ii][i2] + 4.0);
                }
                int n = ii;
                x[n] = x[n] + (4.0 + (double)((float)this.cons2GapCounts[j] * scoreMatrix.getMinimumScore()));
                int n2 = ii++;
                x[n2] = x[n2] / (double)size;
            }
            for (int k = 0; k < size; ++k) {
                double tot = 0.0;
                double[] xx = new double[symbolCount];
                int seqNum = j < lengths[k] ? this.seqNums.elementAt(k)[j + 1] : -1;
                for (int i = 0; i < symbolCount - 1; ++i) {
                    double sr = 4.0;
                    sr = seqNum == -1 ? (sr += (double)scoreMatrix.getMinimumScore()) : (sr += (double)scores[i][seqNum]);
                    xx[i] = x[i] - sr;
                    tot += xx[i] * xx[i];
                }
                bigtot += Math.sqrt(tot);
            }
            max = Math.max(max, bigtot);
            this.quality.addElement(bigtot);
        }
        double newmax = -1.7976931348623157E308;
        for (int j = startCol; j <= endCol; ++j) {
            double tmp = this.quality.elementAt(j);
            tmp = (max - tmp) * (double)(size - this.cons2GapCounts[j]) / (double)size;
            this.quality.setElementAt(tmp, j);
            if (!(tmp > newmax)) continue;
            newmax = tmp;
        }
        this.qualityMinimum = 0.0;
        this.qualityMaximum = newmax;
    }

    public void completeAnnotations(AlignmentAnnotation conservation, AlignmentAnnotation quality2, int istart, int alWidth) {
        SequenceI cons = this.getConsSequence();
        float minR = 0.3f;
        float minG = 0.0f;
        float minB = 0.0f;
        float maxR = 1.0f - minR;
        float maxG = 0.9f - minG;
        float maxB = 0.0f - minB;
        float min = 0.0f;
        float max = 11.0f;
        float qmin = 0.0f;
        float qmax = 0.0f;
        if (conservation != null && conservation.annotations != null && conservation.annotations.length != alWidth) {
            conservation.annotations = new Annotation[alWidth];
        }
        if (quality2 != null) {
            quality2.graphMax = (float)this.qualityMaximum;
            if (quality2.annotations != null && quality2.annotations.length != alWidth) {
                quality2.annotations = new Annotation[alWidth];
            }
            qmin = (float)this.qualityMinimum;
            qmax = (float)this.qualityMaximum;
        }
        for (int i = istart; i < alWidth; ++i) {
            float vprop;
            float value = 0.0f;
            char c = cons.getCharAt(i);
            if (Character.isDigit(c)) {
                value = c - 48;
            } else if (c == '*') {
                value = 11.0f;
            } else if (c == '+') {
                value = 10.0f;
            }
            if (conservation != null) {
                vprop = value - min;
                int consp = i - this.start;
                String conssym = value > 0.0f && consp > -1 && consp < this.consSymbs.length ? this.consSymbs[consp] : "";
                conservation.annotations[i] = new Annotation(String.valueOf(c), conssym, ' ', value, new Color(minR + maxR * (vprop /= max), minG + maxG * vprop, minB + maxB * vprop));
            }
            if (quality2 == null) continue;
            value = this.quality.elementAt(i).floatValue();
            vprop = value - qmin;
            String description = FORMAT_3DP.form(value);
            quality2.annotations[i] = new Annotation(" ", description, ' ', value, new Color(minR + maxR * (vprop /= qmax), minG + maxG * vprop, minB + maxB * vprop));
        }
    }

    public static Conservation calculateConservation(String name, List<SequenceI> seqs, int start, int end, boolean positiveOnly, int maxPercentGaps, boolean calcQuality) {
        Conservation cons = new Conservation(name, seqs, start, end);
        cons.calculate();
        cons.verdict(positiveOnly, maxPercentGaps);
        if (calcQuality) {
            cons.findQuality();
        }
        return cons;
    }

    String getTooltip(int column) {
        SequenceI cons = this.getConsSequence();
        int val = column < cons.getLength() ? (int)cons.getCharAt(column) : 45;
        boolean hasConservation = val != 45 && val != 48;
        int consp = column - this.start;
        String tip = hasConservation && consp > -1 && consp < this.consSymbs.length ? this.consSymbs[consp] : "";
        return tip;
    }
}

