/*
 * Decompiled with CFR 0.152.
 */
package ext.edu.ucsf.rbvi.strucviz2;

import ext.edu.ucsf.rbvi.strucviz2.ChimUtils;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraModel;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraResidue;
import ext.edu.ucsf.rbvi.strucviz2.StructureManager;
import ext.edu.ucsf.rbvi.strucviz2.port.ListenerThreads;
import jalview.ws.HttpClientUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChimeraManager {
    private static final int REST_REPLY_TIMEOUT_MS = 15000;
    private static final int CONNECTION_TIMEOUT_MS = 100;
    private static final boolean debug = false;
    private int chimeraRestPort;
    private Process chimera;
    private ListenerThreads chimeraListenerThread;
    private Map<Integer, ChimeraModel> currentModelsMap;
    private Logger logger = LoggerFactory.getLogger(ChimeraManager.class);
    private StructureManager structureManager;
    private volatile boolean busy = false;

    public ChimeraManager(StructureManager structureManager) {
        this.structureManager = structureManager;
        this.chimera = null;
        this.chimeraListenerThread = null;
        this.currentModelsMap = new HashMap<Integer, ChimeraModel>();
    }

    public List<ChimeraModel> getChimeraModels(String modelName) {
        List<ChimeraModel> models = this.getChimeraModels(modelName, StructureManager.ModelType.PDB_MODEL);
        models.addAll(this.getChimeraModels(modelName, StructureManager.ModelType.SMILES));
        return models;
    }

    public List<ChimeraModel> getChimeraModels(String modelName, StructureManager.ModelType modelType) {
        ArrayList<ChimeraModel> models = new ArrayList<ChimeraModel>();
        for (ChimeraModel model : this.currentModelsMap.values()) {
            if (!modelName.equals(model.getModelName()) || !modelType.equals((Object)model.getModelType())) continue;
            models.add(model);
        }
        return models;
    }

    public Map<String, List<ChimeraModel>> getChimeraModelsMap() {
        HashMap<String, List<ChimeraModel>> models = new HashMap<String, List<ChimeraModel>>();
        for (ChimeraModel model : this.currentModelsMap.values()) {
            String modelName = model.getModelName();
            if (!models.containsKey(modelName)) {
                models.put(modelName, new ArrayList());
            }
            if (((List)models.get(modelName)).contains(model)) continue;
            ((List)models.get(modelName)).add(model);
        }
        return models;
    }

    public ChimeraModel getChimeraModel(Integer modelNumber, Integer subModelNumber) {
        Integer key = ChimUtils.makeModelKey(modelNumber, subModelNumber);
        if (this.currentModelsMap.containsKey(key)) {
            return this.currentModelsMap.get(key);
        }
        return null;
    }

    public ChimeraModel getChimeraModel() {
        return this.currentModelsMap.values().iterator().next();
    }

    public Collection<ChimeraModel> getChimeraModels() {
        return this.currentModelsMap.values();
    }

    public int getChimeraModelsCount(boolean smiles) {
        int counter = this.currentModelsMap.size();
        if (smiles) {
            return counter;
        }
        for (ChimeraModel model : this.currentModelsMap.values()) {
            if (model.getModelType() != StructureManager.ModelType.SMILES) continue;
            --counter;
        }
        return counter;
    }

    public boolean hasChimeraModel(Integer modelNubmer) {
        return this.hasChimeraModel(modelNubmer, 0);
    }

    public boolean hasChimeraModel(Integer modelNubmer, Integer subModelNumber) {
        return this.currentModelsMap.containsKey(ChimUtils.makeModelKey(modelNubmer, subModelNumber));
    }

    public void addChimeraModel(Integer modelNumber, Integer subModelNumber, ChimeraModel model) {
        this.currentModelsMap.put(ChimUtils.makeModelKey(modelNumber, subModelNumber), model);
    }

    public void removeChimeraModel(Integer modelNumber, Integer subModelNumber) {
        int modelKey = ChimUtils.makeModelKey(modelNumber, subModelNumber);
        if (this.currentModelsMap.containsKey(modelKey)) {
            this.currentModelsMap.remove(modelKey);
        }
    }

    public List<ChimeraModel> openModel(String modelPath, StructureManager.ModelType type) {
        return this.openModel(modelPath, this.getFileNameFromPath(modelPath), type);
    }

    public List<ChimeraModel> openModel(String modelPath, String modelName, StructureManager.ModelType type) {
        this.logger.info("chimera open " + modelPath);
        List<ChimeraModel> modelList = this.getModelList();
        List<String> response = null;
        response = type == StructureManager.ModelType.MODBASE_MODEL ? this.sendChimeraCommand("open modbase:" + modelPath, true) : this.sendChimeraCommand("open " + modelPath, true);
        if (response == null) {
            this.logger.warn("Could not open " + modelPath);
            return null;
        }
        for (ChimeraModel newModel : this.getModelList()) {
            if (modelList.contains(newModel)) continue;
            newModel.setModelName(modelName);
            this.sendChimeraCommand("setattr M name " + modelName + " #" + newModel.getModelNumber(), false);
            modelList.add(newModel);
        }
        for (ChimeraModel chimeraModel : modelList) {
            Color modelColor;
            Color color = modelColor = this.isChimeraX() ? null : this.getModelColor(chimeraModel);
            if (modelColor != null) {
                chimeraModel.setModelColor(modelColor);
            }
            if (type == StructureManager.ModelType.SMILES || this.isChimeraX()) continue;
            this.addResidues(chimeraModel);
        }
        this.sendChimeraCommand("focus", false);
        return modelList;
    }

    private String getFileNameFromPath(String modelPath) {
        String modelName = modelPath;
        if (modelPath == null) {
            return null;
        }
        if (modelPath.lastIndexOf(File.separator) > 0) {
            modelName = modelPath.substring(modelPath.lastIndexOf(File.separator) + 1);
        } else if (modelPath.lastIndexOf("/") > 0) {
            modelName = modelPath.substring(modelPath.lastIndexOf("/") + 1);
        }
        return modelName;
    }

    public void closeModel(ChimeraModel model) {
        this.stopListening();
        this.logger.info("chimera close model " + model.getModelName());
        if (this.currentModelsMap.containsKey(ChimUtils.makeModelKey(model.getModelNumber(), model.getSubModelNumber()))) {
            this.sendChimeraCommand("close " + model.toSpec(), false);
            this.currentModelsMap.remove(ChimUtils.makeModelKey(model.getModelNumber(), model.getSubModelNumber()));
        } else {
            this.logger.warn("Could not find model " + model.getModelName() + " to close.");
        }
        this.startListening();
    }

    public void startListening() {
        this.sendChimeraCommand("listen start models; listen start selection", false);
    }

    public void stopListening() {
        String command = "listen stop models ; listen stop selection ";
        this.sendChimeraCommand(command, false);
    }

    public void startListening(String uri) {
        String command = "listen start models url " + uri;
        this.sendChimeraCommand(command, false);
        command = "listen start select prefix SelectionChanged url " + uri;
        this.sendChimeraCommand(command, false);
    }

    public void select(String command) {
        this.sendChimeraCommand("listen stop selection; " + command + "; listen start selection", false);
    }

    public void focus() {
        this.sendChimeraCommand("focus", false);
    }

    public void clearOnChimeraExit() {
        this.chimera = null;
        this.currentModelsMap.clear();
        this.chimeraRestPort = 0;
        this.structureManager.clearOnChimeraExit();
    }

    public void exitChimera() {
        if (this.isChimeraLaunched() && this.chimera != null) {
            this.sendChimeraCommand("stop really", false);
            try {
                this.chimera.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.clearOnChimeraExit();
    }

    public Map<Integer, ChimeraModel> getSelectedModels() {
        HashMap<Integer, ChimeraModel> selectedModelsMap = new HashMap<Integer, ChimeraModel>();
        List<String> chimeraReply = this.sendChimeraCommand("list selection level molecule", true);
        if (chimeraReply != null) {
            for (String modelLine : chimeraReply) {
                ChimeraModel chimeraModel = new ChimeraModel(modelLine);
                Integer modelKey = ChimUtils.makeModelKey(chimeraModel.getModelNumber(), chimeraModel.getSubModelNumber());
                selectedModelsMap.put(modelKey, chimeraModel);
            }
        }
        return selectedModelsMap;
    }

    public List<String> getSelectedResidueSpecs() {
        ArrayList<String> selectedResidues = new ArrayList<String>();
        String command = "list selection level residue";
        List<String> chimeraReply = this.sendChimeraCommand(command, true);
        if (chimeraReply != null) {
            for (String inputLine : chimeraReply) {
                String[] inputLineParts = inputLine.split("\\s+");
                if (inputLineParts.length < 5) continue;
                selectedResidues.add(inputLineParts[2]);
            }
        }
        return selectedResidues;
    }

    public void getSelectedResidues(Map<Integer, ChimeraModel> selectedModelsMap) {
        List<String> chimeraReply = this.sendChimeraCommand("list selection level residue", true);
        if (chimeraReply != null) {
            for (String inputLine : chimeraReply) {
                ChimeraResidue r = new ChimeraResidue(inputLine);
                Integer modelKey = ChimUtils.makeModelKey(r.getModelNumber(), r.getSubModelNumber());
                if (!selectedModelsMap.containsKey(modelKey)) continue;
                ChimeraModel model = selectedModelsMap.get(modelKey);
                model.addResidue(r);
            }
        }
    }

    public List<ChimeraModel> getModelList() {
        ArrayList<ChimeraModel> modelList = new ArrayList<ChimeraModel>();
        String command = "list models type " + (this.isChimeraX() ? "AtomicStructure" : "molecule");
        List<String> list = this.sendChimeraCommand(command, true);
        if (list != null) {
            for (String modelLine : list) {
                try {
                    ChimeraModel chimeraModel = new ChimeraModel(modelLine);
                    modelList.add(chimeraModel);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        return modelList;
    }

    public List<String> getPresets() {
        ArrayList<String> presetList = new ArrayList<String>();
        List<String> output = this.sendChimeraCommand("preset list", true);
        if (output != null) {
            for (String preset : output) {
                preset = preset.substring(7);
                preset = preset.replaceFirst("\"", "(");
                preset = preset.replaceFirst("\"", ")");
                presetList.add(preset);
            }
        }
        return presetList;
    }

    public boolean isChimeraLaunched() {
        boolean launched = false;
        if (this.chimera != null) {
            try {
                this.chimera.exitValue();
            }
            catch (IllegalThreadStateException e) {
                launched = true;
            }
        }
        return launched;
    }

    public boolean launchChimera(List<String> chimeraPaths) {
        if (this.isChimeraLaunched()) {
            return true;
        }
        Object error = "Error message: ";
        String workingPath = "";
        for (String chimeraPath : chimeraPaths) {
            try {
                chimeraPath = Paths.get(chimeraPath, new String[0]).toRealPath(new LinkOption[0]).toString();
                File path = new File(chimeraPath);
                if (!path.canExecute()) {
                    error = (String)error + "File '" + path + "' does not exist.\n";
                    continue;
                }
                ArrayList<String> args = new ArrayList<String>();
                args.add(chimeraPath);
                this.addLaunchArguments(args);
                ProcessBuilder pb = new ProcessBuilder(args);
                this.chimera = pb.start();
                error = "";
                workingPath = chimeraPath;
                break;
            }
            catch (Exception e) {
                error = (String)error + e.getMessage();
            }
        }
        if (((String)error).length() == 0) {
            this.chimeraRestPort = this.getPortNumber();
            System.out.println("Chimera REST API started on port " + this.chimeraRestPort);
            this.structureManager.setChimeraPathProperty(workingPath);
            return this.chimeraRestPort > 0;
        }
        this.logger.warn((String)error);
        return false;
    }

    protected void addLaunchArguments(List<String> args) {
        args.add("--start");
        args.add("RESTServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPortNumber() {
        int port = 0;
        InputStream readChan = this.chimera.getInputStream();
        BufferedReader lineReader = new BufferedReader(new InputStreamReader(readChan));
        StringBuilder responses = new StringBuilder();
        try {
            String response = lineReader.readLine();
            while (response != null) {
                responses.append("\n" + response);
                if (response.startsWith("REST server")) {
                    String[] tokens = response.split(" ");
                    for (int i = 0; i < tokens.length - 1; ++i) {
                        if (!"port".equals(tokens[i])) continue;
                        port = Integer.parseInt(tokens[i + 1]);
                        break;
                    }
                }
                if (port > 0) {
                    break;
                }
                response = lineReader.readLine();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get REST port number from " + responses + ": " + e.getMessage());
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException iOException) {}
        }
        if (port == 0) {
            System.err.println("Failed to start Chimera with REST service, response was: " + responses);
        }
        this.logger.info("Chimera REST service listening on port " + this.chimeraRestPort);
        return port;
    }

    public Color getModelColor(ChimeraModel model) {
        List<String> colorLines = this.sendChimeraCommand("list model spec " + model.toSpec() + " attribute color", true);
        if (colorLines == null || colorLines.size() == 0) {
            return null;
        }
        return ChimUtils.parseModelColor(colorLines.get(0));
    }

    public void addResidues(ChimeraModel model) {
        int modelNumber = model.getModelNumber();
        int subModelNumber = model.getSubModelNumber();
        List<String> reply = this.sendChimeraCommand("list residues spec " + model.toSpec(), true);
        if (reply == null) {
            return;
        }
        for (String inputLine : reply) {
            ChimeraResidue r = new ChimeraResidue(inputLine);
            if (r.getModelNumber() != modelNumber && r.getSubModelNumber() != subModelNumber) continue;
            model.addResidue(r);
        }
    }

    public List<String> getAttrList() {
        ArrayList<String> attributes = new ArrayList<String>();
        String command = (this.isChimeraX() ? "info " : "list ") + "resattr";
        List<String> reply = this.sendChimeraCommand(command, true);
        if (reply != null) {
            for (String inputLine : reply) {
                String[] lineParts = inputLine.split("\\s");
                if (lineParts.length != 2 || !lineParts[0].equals("resattr")) continue;
                attributes.add(lineParts[1]);
            }
        }
        return attributes;
    }

    public Map<ChimeraResidue, Object> getAttrValues(String aCommand, ChimeraModel model) {
        HashMap<ChimeraResidue, Object> values = new HashMap<ChimeraResidue, Object>();
        List<String> reply = this.sendChimeraCommand("list residue spec " + model.toSpec() + " attribute " + aCommand, true);
        if (reply != null) {
            for (String inputLine : reply) {
                String[] lineParts = inputLine.split("\\s");
                if (lineParts.length != 5) continue;
                ChimeraResidue residue = ChimUtils.getResidue(lineParts[2], model);
                String value = lineParts[4];
                if (residue == null || value.equals("None")) continue;
                if (value.equals("True") || value.equals("False")) {
                    values.put(residue, Boolean.valueOf(value));
                    continue;
                }
                try {
                    Double doubleValue = Double.valueOf(value);
                    values.put(residue, doubleValue);
                }
                catch (NumberFormatException ex) {
                    values.put(residue, value);
                }
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> sendChimeraCommand(String command, boolean reply) {
        if (!this.isChimeraLaunched() || command == null || "".equals(command.trim())) {
            return null;
        }
        int waited = 0;
        int pause = 25;
        while (this.busy && waited < 1001) {
            try {
                Thread.sleep(pause);
                waited += pause;
            }
            catch (InterruptedException interruptedException) {}
        }
        this.busy = true;
        long startTime = System.currentTimeMillis();
        try {
            List<String> list = this.sendRestCommand(command);
            return list;
        }
        finally {
            this.busy = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> sendRestCommand(String command) {
        String restUrl = "http://127.0.0.1:" + this.chimeraRestPort + "/run";
        ArrayList<NameValuePair> commands = new ArrayList<NameValuePair>(1);
        String method = this.getHttpRequestMethod();
        if ("GET".equals(method)) {
            command = command.replace(" ", "+").replace("#", "%23").replace("|", "%7C").replace(";", "%3B");
        }
        commands.add((NameValuePair)new BasicNameValuePair("command", command));
        ArrayList<String> reply = new ArrayList<String>();
        BufferedReader response = null;
        try {
            response = "GET".equals(method) ? HttpClientUtils.doHttpGet(restUrl, commands, 100, 15000) : HttpClientUtils.doHttpUrlPost(restUrl, commands, 100, 15000);
            String line = "";
            while ((line = response.readLine()) != null) {
                reply.add(line);
            }
        }
        catch (Exception e) {
            this.logger.error("REST call '" + command + "' failed: " + e.getMessage());
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
        return reply;
    }

    protected String getHttpRequestMethod() {
        return "POST";
    }

    protected List<String> sendStdinCommand(String command, boolean readReply) {
        this.chimeraListenerThread.clearResponse(command);
        String text = command.concat("\n");
        try {
            this.chimera.getOutputStream().write(text.getBytes());
            this.chimera.getOutputStream().flush();
        }
        catch (IOException e) {
            this.logger.warn("Unable to execute command: " + text);
            this.logger.warn("Exiting...");
            this.clearOnChimeraExit();
            return null;
        }
        if (!readReply) {
            return null;
        }
        List<String> rsp = this.chimeraListenerThread.getResponse(command);
        return rsp;
    }

    public StructureManager getStructureManager() {
        return this.structureManager;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public Process getChimeraProcess() {
        return this.chimera;
    }

    public boolean isChimeraX() {
        return false;
    }
}

