/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.Log;
import com.threerings.getdown.util.StreamUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;

public class FileUtil {
    public static boolean renameTo(File source, File dest) {
        if (source.renameTo(dest)) {
            return true;
        }
        if (dest.exists()) {
            File temp = new File(dest.getPath() + "_old");
            if (temp.exists() && !FileUtil.deleteHarder(temp)) {
                Log.log.warning("Failed to delete old intermediate file " + temp + ".", new Object[0]);
            }
            if (dest.renameTo(temp) && source.renameTo(dest)) {
                if (!FileUtil.deleteHarder(temp)) {
                    Log.log.warning("Failed to delete intermediate file " + temp + ".", new Object[0]);
                }
                return true;
            }
        }
        try {
            FileUtil.copy(source, dest);
        }
        catch (IOException ioe) {
            Log.log.warning("Failed to copy " + source + " to " + dest + ": " + ioe, new Object[0]);
            return false;
        }
        if (!FileUtil.deleteHarder(source)) {
            Log.log.warning("Failed to delete " + source + " after brute force copy to " + dest + ".", new Object[0]);
        }
        return true;
    }

    public static boolean deleteHarder(File file) {
        boolean deleted;
        boolean bl = deleted = file.delete() || file.delete();
        if (!deleted) {
            file.deleteOnExit();
        }
        return deleted;
    }

    public static boolean deleteDirHarder(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                FileUtil.deleteDirHarder(child);
            }
        }
        return FileUtil.deleteHarder(file);
    }

    public static List<String> readLines(Reader in) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader bin = new BufferedReader(in);){
            String line = null;
            while ((line = bin.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    public static void unpackJar(JarFile jar, File target, boolean cleanExistingDirs) throws IOException {
        File efile;
        JarEntry entry;
        Enumeration<JarEntry> entries;
        if (cleanExistingDirs) {
            entries = jar.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (!entry.isDirectory() || !(efile = new File(target, entry.getName())).exists()) continue;
                for (File f : efile.listFiles()) {
                    if (f.isDirectory()) continue;
                    f.delete();
                }
            }
        }
        entries = jar.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            efile = new File(target, entry.getName());
            if (entry.isDirectory()) {
                if (efile.exists() || efile.mkdir()) continue;
                Log.log.warning("Failed to create jar entry path", "jar", jar, "entry", entry);
                continue;
            }
            File parent = new File(efile.getParent());
            if (!parent.exists() && !parent.mkdirs()) {
                Log.log.warning("Failed to create jar entry parent", "jar", jar, "parent", parent);
                continue;
            }
            try {
                BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(efile));
                Throwable throwable = null;
                try {
                    InputStream jin = jar.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        StreamUtil.copy(jin, fout);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (jin == null) continue;
                        if (throwable2 != null) {
                            try {
                                jin.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        jin.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (fout == null) continue;
                    if (throwable != null) {
                        try {
                            fout.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    fout.close();
                }
            }
            catch (Exception e) {
                throw new IOException(Log.format("Failure unpacking", "jar", jar, "entry", efile), e);
            }
        }
    }

    public static void unpackPacked200Jar(File packedJar, File target) throws IOException {
        try (FileInputStream packJarIn = new FileInputStream(packedJar);
             JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(target));){
            boolean gz = packedJar.getName().endsWith(".gz") || packedJar.getName().endsWith(".gz_new");
            try (InputStream packJarIn2 = gz ? new GZIPInputStream(packJarIn) : packJarIn;){
                Pack200.Unpacker unpacker = Pack200.newUnpacker();
                unpacker.unpack(packJarIn2, jarOut);
            }
        }
    }

    public static void copy(File source, File target) throws IOException {
        try (FileInputStream in = new FileInputStream(source);
             FileOutputStream out = new FileOutputStream(target);){
            StreamUtil.copy(in, out);
        }
    }

    public static void makeExecutable(File file) {
        try {
            if (file.exists() && !file.setExecutable(true, false)) {
                Log.log.warning("Failed to mark as executable", "file", file);
            }
        }
        catch (Exception e) {
            Log.log.warning("Failed to mark as executable", "file", file, "error", e);
        }
    }

    public static void walkTree(File root, Visitor visitor) {
        File[] children = root.listFiles();
        if (children == null) {
            return;
        }
        ArrayDeque<File> stack = new ArrayDeque<File>(Arrays.asList(children));
        while (!stack.isEmpty()) {
            File currentFile = (File)stack.pop();
            if (!currentFile.exists()) continue;
            visitor.visit(currentFile);
            File[] currentChildren = currentFile.listFiles();
            if (currentChildren == null) continue;
            for (File file : currentChildren) {
                stack.push(file);
            }
        }
    }

    public static interface Visitor {
        public void visit(File var1);
    }
}

