/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.fc.AquaFileChooserBrowser;
import org.violetlib.aqua.fc.BrowserPreviewRenderer;
import org.violetlib.aqua.fc.ColumnView;
import org.violetlib.aqua.fc.FilePreview;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.GenericCellRenderer;
import org.violetlib.aqua.fc.JBrowser;
import org.violetlib.aqua.fc.SubtreeTreeModel;

public class ColumnViewImpl
extends ColumnView {
    public static final String PREVIEW_COMPONENT_CLIENT_PROPERTY_KEY = "JFileChooser.previewComponent";
    protected final JFileChooser fc;
    protected final AquaFileChooserBrowser browser;
    protected final JScrollPane browserScrollPane;
    private final MouseListener mouseListener;
    private final TreeSelectionListener treeSelectionListener;
    private boolean isActive;

    public ColumnViewImpl(JFileChooser jFileChooser) {
        this.fc = jFileChooser;
        this.mouseListener = this.createDoubleClickListener();
        this.treeSelectionListener = new MyTreeSelectionListener();
        this.setFocusable(false);
        this.browser = new ColumnViewBrowser(jFileChooser);
        this.browser.setFixedCellWidth(170);
        this.browser.setShowCellTipOrigin((Point)UIManager.get("FileChooser.cellTipOrigin"));
        this.browser.setShowCellTips(true);
        this.browser.setPreviewColumnFilled(true);
        this.browserScrollPane = new JScrollPane();
        this.browserScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.browserScrollPane.setViewportView(this.browser);
        this.browserScrollPane.putClientProperty("Quaqua.Component.visualMargin", new Insets(3, 2, 3, 2));
        this.browserScrollPane.setFocusable(false);
        this.browserScrollPane.getVerticalScrollBar().setFocusable(false);
        this.browserScrollPane.getHorizontalScrollBar().setFocusable(false);
        this.setLayout(new BorderLayout());
        this.add(this.browserScrollPane);
    }

    @Override
    public void setActive(boolean bl) {
        this.isActive = bl;
        if (bl) {
            this.browser.addMouseListener(this.mouseListener);
            this.browser.addTreeSelectionListener(this.treeSelectionListener);
        } else {
            this.browser.removeMouseListener(this.mouseListener);
            this.browser.removeTreeSelectionListener(this.treeSelectionListener);
        }
    }

    @Override
    public void setModel(SubtreeTreeModel subtreeTreeModel) {
        this.browser.setModel(subtreeTreeModel);
        FileSystemTreeModel fileSystemTreeModel = (FileSystemTreeModel)subtreeTreeModel.getTargetModel();
        this.browser.setPrototypeCellValue(fileSystemTreeModel.getPrototypeValue());
    }

    @Override
    public void setFileRenderer(GenericCellRenderer genericCellRenderer) {
        this.browser.setColumnCellRenderer((ListCellRenderer)((Object)genericCellRenderer));
    }

    @Override
    public void setMultipleSelection(boolean bl) {
        if (bl) {
            this.browser.setSelectionMode(4);
        } else {
            this.browser.setSelectionMode(1);
        }
    }

    @Override
    public List<TreePath> getSelection() {
        TreePath[] treePathArray = this.browser.getSelectionPaths();
        return treePathArray != null ? new ArrayList<TreePath>(Arrays.asList(treePathArray)) : new ArrayList();
    }

    @Override
    public void setSelection(TreePath treePath) {
        this.browser.setSelectionPath(treePath);
    }

    @Override
    public void setSelection(List<TreePath> list) {
        TreePath[] treePathArray = list.toArray(new TreePath[list.size()]);
        this.browser.setSelectionPaths(treePathArray);
    }

    @Override
    public void ensurePathIsVisible(TreePath treePath) {
        this.browser.ensurePathIsVisible(treePath);
    }

    private void installPreviewComponent() {
        final Component component = (Component)this.fc.getClientProperty(PREVIEW_COMPONENT_CLIENT_PROPERTY_KEY);
        if (component != null) {
            this.browser.setPreviewRenderer(new BrowserPreviewRenderer(){

                @Override
                public Component getPreviewRendererComponent(JBrowser jBrowser, TreePath[] treePathArray) {
                    return component;
                }
            });
            this.browser.setPreviewColumnWidth(Math.max(this.browser.getFixedCellWidth(), component.getPreferredSize().width));
        } else {
            boolean bl = this.isFileNameFieldVisible();
            this.browser.setPreviewRenderer(bl ? null : this.createFilePreview(this.fc));
            this.browser.setPreviewColumnWidth(this.browser.getFixedCellWidth());
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.browser.requestFocusInWindow();
    }

    @Override
    public synchronized void addKeyListener(KeyListener keyListener) {
        this.browser.addKeyListener(keyListener);
    }

    @Override
    public void reconfigure() {
        this.setMultipleSelection(this.fc.isMultiSelectionEnabled());
        this.browser.repaint();
        this.installPreviewComponent();
        this.browser.updatePreviewColumn();
    }

    @Override
    public synchronized void setDropTarget(DropTarget dropTarget) {
        super.setDropTarget(dropTarget);
        this.browser.setDropTarget(dropTarget);
    }

    protected MouseListener createDoubleClickListener() {
        return new DoubleClickListener();
    }

    protected boolean isFileNameFieldVisible() {
        return this.fc.getDialogType() == 1 || this.fc.getDialogType() == 2;
    }

    protected BrowserPreviewRenderer createFilePreview(JFileChooser jFileChooser) {
        return new FilePreview(jFileChooser);
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        protected DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TreePath treePath;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && ColumnViewImpl.this.fc.getDialogType() != 1 && (treePath = ColumnViewImpl.this.browser.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                for (TreePath treePath2 : ColumnViewImpl.this.browser.getSelectionPaths()) {
                    FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)treePath2.getLastPathComponent();
                    if (ColumnViewImpl.this.fc.accept(node.getFile())) continue;
                    return;
                }
                ColumnViewImpl.this.select(treePath);
            }
        }
    }

    protected class MyTreeSelectionListener
    implements TreeSelectionListener {
        protected MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            ColumnViewImpl.this.selectionChanged();
        }
    }

    protected class ColumnViewBrowser
    extends AquaFileChooserBrowser {
        public ColumnViewBrowser(JFileChooser jFileChooser) {
            super(jFileChooser);
        }

        @Override
        protected void fileSelectedInSavePanel(File file) {
            if (ColumnViewImpl.this.isActive) {
                SubtreeTreeModel subtreeTreeModel = (SubtreeTreeModel)this.getModel();
                FileSystemTreeModel fileSystemTreeModel = (FileSystemTreeModel)subtreeTreeModel.getTargetModel();
                TreePath treePath = fileSystemTreeModel.toPath(file, null);
                ColumnViewImpl.this.select(treePath);
            }
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            if (ColumnViewImpl.this.browser.isPreviewColumnFilled()) {
                JViewport jViewport = (JViewport)this.getParent();
                int n = jViewport.getPreferredSize().width;
                Dimension dimension = jViewport.getExtentSize();
                if (dimension.width > n) {
                    return true;
                }
            }
            return false;
        }
    }
}

