/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import javax.swing.JComponent;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaFonts;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaUtilControlSize {
    protected static final String CLIENT_PROPERTY_KEY = "JComponent.sizeVariant";
    protected static final String SYSTEM_PROPERTY_KEY = "swing.component.sizevariant";
    protected static final AquaUtils.RecyclableSingleton<PropertySizeListener> sizeListener = new AquaUtils.RecyclableSingletonFromDefaultConstructor<PropertySizeListener>(PropertySizeListener.class);
    protected static final AquaUIPainter.Size defaultSize = AquaUtilControlSize.getDefaultSize();

    protected static PropertySizeListener getSizeListener() {
        return sizeListener.get();
    }

    protected static void addSizePropertyListener(JComponent jComponent) {
        jComponent.addPropertyChangeListener(CLIENT_PROPERTY_KEY, AquaUtilControlSize.getSizeListener());
        AquaUtilControlSize.applyComponentSize(jComponent, jComponent.getClientProperty(CLIENT_PROPERTY_KEY));
    }

    protected static void removeSizePropertyListener(JComponent jComponent) {
        jComponent.removePropertyChangeListener(CLIENT_PROPERTY_KEY, AquaUtilControlSize.getSizeListener());
    }

    private static AquaUIPainter.Size getSizeFromString(String string) {
        if ("regular".equalsIgnoreCase(string)) {
            return AquaUIPainter.Size.REGULAR;
        }
        if ("small".equalsIgnoreCase(string)) {
            return AquaUIPainter.Size.SMALL;
        }
        if ("mini".equalsIgnoreCase(string)) {
            return AquaUIPainter.Size.MINI;
        }
        if ("large".equalsIgnoreCase(string)) {
            return AquaUIPainter.Size.LARGE;
        }
        return null;
    }

    public static String getStringFromSize(AquaUIPainter.Size size) {
        if (size == AquaUIPainter.Size.REGULAR) {
            return "regular";
        }
        if (size == AquaUIPainter.Size.SMALL) {
            return "small";
        }
        if (size == AquaUIPainter.Size.MINI) {
            return "mini";
        }
        if (size == AquaUIPainter.Size.LARGE) {
            return "large";
        }
        return null;
    }

    private static AquaUIPainter.Size getDefaultSize() {
        String string = AccessController.doPrivileged(() -> System.getProperty(SYSTEM_PROPERTY_KEY));
        AquaUIPainter.Size size = AquaUtilControlSize.getSizeFromString(string);
        if (size != null) {
            return size;
        }
        return AquaUIPainter.Size.REGULAR;
    }

    public static AquaUIPainter.Size getUserSizeFrom(JComponent jComponent) {
        Object object = jComponent.getClientProperty(CLIENT_PROPERTY_KEY);
        if (object == null) {
            return defaultSize;
        }
        AquaUIPainter.Size size = AquaUtilControlSize.getSizeFromString(object.toString());
        return size != null ? size : AquaUIPainter.Size.REGULAR;
    }

    private static boolean applyUISizing(JComponent jComponent, AquaUIPainter.Size size, boolean bl) {
        Sizeable sizeable = AquaUtils.getUI(jComponent, Sizeable.class);
        if (sizeable != null) {
            sizeable.applySizeFor(jComponent, size, bl);
            return true;
        }
        return false;
    }

    private static void applyComponentSize(JComponent jComponent, Object object) {
        AquaUIPainter.Size size = null;
        boolean bl = false;
        if (object != null) {
            size = AquaUtilControlSize.getSizeFromString(object.toString());
        }
        if (size == null) {
            size = defaultSize;
            bl = true;
        }
        if (!AquaUtilControlSize.applyUISizing(jComponent, size, bl)) {
            AquaUtilControlSize.configureFontFromSize(jComponent, size);
        }
    }

    public static void configureFontFromSize(JComponent jComponent, AquaUIPainter.Size size) {
        Font font;
        if (AquaUtilControlSize.isOKToInstallDefaultFont(jComponent) && (font = jComponent.getFont()) != null) {
            AquaUtilControlSize.installDefaultFont(jComponent, AquaUtilControlSize.getFontForSize(font, size));
        }
    }

    public static void installDefaultFont(JComponent jComponent, Font font) {
        if (AquaUtilControlSize.isOKToInstallDefaultFont(jComponent)) {
            jComponent.setFont(font);
        }
    }

    public static boolean isOKToInstallDefaultFont(JComponent jComponent) {
        Font font = jComponent.getFont();
        return font == null || font instanceof UIResource;
    }

    public static void uninstallDefaultFont(JComponent jComponent) {
        Font font = jComponent.getFont();
        if (font instanceof UIResource) {
            jComponent.setFont(null);
        }
    }

    public static Font getFontForSize(Font font, AquaUIPainter.Size size) {
        if (!(font instanceof AquaFonts.DerivedUIResourceFont)) {
            font = new AquaFonts.DerivedUIResourceFont(font);
        }
        if (size == AquaUIPainter.Size.MINI) {
            return font.deriveFont(AquaFonts.getMiniControlTextFont().getSize2D());
        }
        if (size == AquaUIPainter.Size.SMALL) {
            return font.deriveFont(AquaFonts.getSmallControlTextFont().getSize2D());
        }
        return font.deriveFont(AquaFonts.getControlTextFont().getSize2D());
    }

    protected static class PropertySizeListener
    implements PropertyChangeListener {
        protected PropertySizeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!AquaUtilControlSize.CLIENT_PROPERTY_KEY.equalsIgnoreCase(string)) {
                return;
            }
            Object object = propertyChangeEvent.getSource();
            if (!(object instanceof JComponent)) {
                return;
            }
            JComponent jComponent = (JComponent)object;
            AquaUtilControlSize.applyComponentSize(jComponent, propertyChangeEvent.getNewValue());
        }
    }

    static interface Sizeable {
        public void applySizeFor(JComponent var1, AquaUIPainter.Size var2, boolean var3);
    }
}

