/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopIconUI;
import org.violetlib.aqua.AquaFonts;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.JavaSupport;

public class AquaInternalFrameDockIconUI
extends DesktopIconUI
implements MouseListener,
MouseMotionListener,
ComponentListener {
    private static final String CACHED_FRAME_ICON_KEY = "apple.laf.internal.frameIcon";
    protected JInternalFrame.JDesktopIcon fDesktopIcon;
    protected JInternalFrame fFrame;
    protected ScaledImageLabel fIconPane;
    protected DockLabel fDockLabel;
    protected boolean fTrackingIcon = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaInternalFrameDockIconUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.fDesktopIcon = (JInternalFrame.JDesktopIcon)jComponent;
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallComponents();
        this.uninstallListeners();
        this.fDesktopIcon = null;
        this.fFrame = null;
    }

    protected void installComponents() {
        this.fFrame = this.fDesktopIcon.getInternalFrame();
        this.fIconPane = new ScaledImageLabel();
        this.fDesktopIcon.setLayout(new BorderLayout());
        this.fDesktopIcon.add((Component)this.fIconPane, "Center");
    }

    protected void uninstallComponents() {
        this.fDesktopIcon.setLayout(null);
        this.fDesktopIcon.remove(this.fIconPane);
    }

    protected void installListeners() {
        this.fDesktopIcon.addMouseListener(this);
        this.fDesktopIcon.addMouseMotionListener(this);
        this.fFrame.addComponentListener(this);
    }

    protected void uninstallListeners() {
        this.fFrame.removeComponentListener(this);
        this.fDesktopIcon.removeMouseMotionListener(this);
        this.fDesktopIcon.removeMouseListener(this);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(32, 32);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(128, 128);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(64, 64);
    }

    public Insets getInsets(JComponent jComponent) {
        return new Insets(0, 0, 0, 0);
    }

    void updateIcon() {
        this.fIconPane.updateIcon();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.fTrackingIcon = this.fIconPane.mouseInIcon(mouseEvent);
        if (this.fTrackingIcon) {
            this.fIconPane.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.fFrame.isIconifiable() && this.fFrame.isIcon() && this.fTrackingIcon) {
            this.fTrackingIcon = false;
            if (this.fIconPane.mouseInIcon(mouseEvent)) {
                if (this.fDockLabel != null) {
                    this.fDockLabel.hide();
                }
                try {
                    this.fFrame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                this.fIconPane.repaint();
            }
        }
        if (this.fDockLabel != null && !this.fIconPane.getBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.fDockLabel.hide();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            return;
        }
        String string = this.fFrame.getTitle();
        if (string == null || string.equals("")) {
            string = "Untitled";
        }
        this.fDockLabel = new DockLabel(string);
        this.fDockLabel.show(this.fDesktopIcon);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.fDockLabel != null && (mouseEvent.getModifiers() & 0x10) == 0) {
            this.fDockLabel.hide();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.fFrame.putClientProperty(CACHED_FRAME_ICON_KEY, null);
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.fFrame.putClientProperty(CACHED_FRAME_ICON_KEY, null);
    }

    class DockLabel
    extends JLabel {
        static final int NUB_HEIGHT = 7;
        static final int ROUND_ADDITIONAL_HEIGHT = 8;
        static final int ROUND_ADDITIONAL_WIDTH = 12;

        DockLabel(String string) {
            super(string);
            this.setBorder(null);
            this.setOpaque(false);
            this.setFont(AquaFonts.getDockIconFont());
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.setSize(SwingUtilities.computeStringWidth(fontMetrics, this.getText()) + 24, fontMetrics.getAscent() + 7 + 8);
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics2D graphics2D;
            int n = this.getWidth();
            int n2 = this.getHeight();
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            graphics.setFont(font);
            String string = this.getText().trim();
            int n3 = fontMetrics.getAscent();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            int n4 = n / 2;
            int n5 = n4 - (int)rectangle2D.getWidth() / 2;
            Graphics2D graphics2D2 = graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
            if (graphics2D != null) {
                graphics.setColor(UIManager.getColor("DesktopIcon.labelBackground"));
                Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int n6 = n2 - 8 + 1;
                graphics.fillRoundRect(0, 0, n, n6, n6, n6);
                int[] nArray = new int[]{n4, n4 + 7, n4 - 7};
                int[] nArray2 = new int[]{n2, n2 - 7, n2 - 7};
                graphics.fillPolygon(nArray, nArray2, 3);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
            graphics.setColor(Color.black);
            JavaSupport.drawString(this, (Graphics2D)graphics, string, n5, 2 + n3);
            graphics.setColor(Color.white);
            JavaSupport.drawString(this, (Graphics2D)graphics, string, n5, 1 + n3);
        }

        public void show(Component component) {
            Serializable serializable;
            int n = (component.getWidth() - this.getWidth()) / 2;
            int n2 = -(this.getHeight() + 6);
            Container container = component.getParent();
            for (serializable = container; serializable != null; serializable = ((Component)serializable).getParent()) {
                if (!(serializable instanceof JRootPane) || ((Component)serializable).getParent() instanceof JInternalFrame) continue;
                container = ((JRootPane)serializable).getLayeredPane();
                for (serializable = container.getParent(); serializable != null && !(serializable instanceof Window); serializable = ((Component)serializable).getParent()) {
                }
                break;
            }
            serializable = SwingUtilities.convertPoint(component, n, n2, container);
            this.setLocation(((Point)serializable).x, ((Point)serializable).y);
            if (container instanceof JLayeredPane) {
                ((JLayeredPane)container).add(this, JLayeredPane.POPUP_LAYER, 0);
            }
        }

        @Override
        public void hide() {
            Container container = this.getParent();
            Rectangle rectangle = this.getBounds();
            if (container == null) {
                return;
            }
            container.remove(this);
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    class ScaledImageLabel
    extends JLabel {
        ScaledImageLabel() {
            super(null, null, 0);
        }

        void updateIcon() {
            Object object = AquaInternalFrameDockIconUI.this.fFrame.getClientProperty(AquaInternalFrameDockIconUI.CACHED_FRAME_ICON_KEY);
            if (object instanceof ImageIcon) {
                this.setIcon((ImageIcon)object);
                return;
            }
            int n = AquaInternalFrameDockIconUI.this.fFrame.getWidth();
            int n2 = AquaInternalFrameDockIconUI.this.fFrame.getHeight();
            if (n <= 0 || n2 <= 0) {
                n = 128;
                n2 = 128;
            }
            BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
            Graphics graphics = ((Image)bufferedImage).getGraphics();
            AquaInternalFrameDockIconUI.this.fFrame.paint(graphics);
            graphics.dispose();
            float f = (float)AquaInternalFrameDockIconUI.this.fDesktopIcon.getWidth() / (float)Math.max(n, n2) * 0.89f;
            ImageIcon imageIcon = new ImageIcon(bufferedImage.getScaledInstance((int)((float)n * f), -1, 4));
            AquaInternalFrameDockIconUI.this.fFrame.putClientProperty(AquaInternalFrameDockIconUI.CACHED_FRAME_ICON_KEY, imageIcon);
            this.setIcon(imageIcon);
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.getIcon() == null) {
                this.updateIcon();
            }
            graphics.translate(0, 2);
            if (!AquaInternalFrameDockIconUI.this.fTrackingIcon) {
                super.paint(graphics);
                return;
            }
            ImageIcon imageIcon = (ImageIcon)this.getIcon();
            ImageIcon imageIcon2 = new ImageIcon(AquaImageFactory.generateSelectedDarkImage(imageIcon.getImage()));
            this.setIcon(imageIcon2);
            super.paint(graphics);
            this.setIcon(imageIcon);
        }

        boolean mouseInIcon(MouseEvent mouseEvent) {
            return this.getBounds().contains(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(64, 64);
        }
    }
}

