/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.utils;

import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RNAMLParser
extends DefaultHandler {
    private Hashtable<String, RNATmp> _molecules = new Hashtable();
    private boolean _inSequenceIDs = false;
    private boolean _inLength;
    private boolean _inSequence = false;
    private boolean _inHelix = false;
    private boolean _inStrAnnotation = false;
    private boolean _inBP = false;
    private boolean _inBP5 = false;
    private boolean _inBP3 = false;
    private boolean _inEdge5 = false;
    private boolean _inEdge3 = false;
    private boolean _inPosition = false;
    private boolean _inBondOrientation = false;
    private boolean _inMolecule = false;
    private StringBuffer _buffer;
    private String _currentModel = "";
    private int _id5;
    private int _id3;
    private int _length;
    String _edge5;
    String _edge3;
    String _orientation;
    String _helixID;

    public InputSource createSourceFromURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            InputStream inputStream = uRLConnection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            return new InputSource(inputStreamReader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new InputSource(new StringReader(""));
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        String string3;
        URL uRL;
        if (string2.endsWith("rnaml.dtd") && (uRL = ClassLoader.getSystemResource(string3 = "/rnaml.dtd")) != null) {
            try {
                InputStream inputStream = uRL.openStream();
                if (inputStream != null) {
                    return new InputSource(inputStream);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return new InputSource(new StringReader(""));
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("numbering-table")) {
            this._inSequenceIDs = true;
            this._buffer = new StringBuffer();
        } else if (string3.equals("helix")) {
            this._inHelix = true;
            this._buffer = new StringBuffer();
            this._helixID = attributes.getValue("id");
        } else if (string3.equals("seq-data")) {
            this._inSequence = true;
            this._buffer = new StringBuffer();
        } else if (string3.equals("length")) {
            this._inLength = true;
            this._buffer = new StringBuffer();
        } else if (string3.equals("str-annotation")) {
            this._inStrAnnotation = true;
        } else if (string3.equals("base-pair")) {
            this._inBP = true;
        } else if (string3.equals("base-id-5p")) {
            if (this._inBP || this._inHelix) {
                this._inBP5 = true;
            }
        } else if (string3.equals("base-id-3p")) {
            if (this._inBP || this._inHelix) {
                this._inBP3 = true;
            }
        } else if (string3.equals("edge-5p")) {
            this._inEdge5 = true;
            this._buffer = new StringBuffer();
        } else if (string3.equals("edge-3p")) {
            this._inEdge3 = true;
            this._buffer = new StringBuffer();
        } else if (string3.equals("position")) {
            this._inPosition = true;
            this._buffer = new StringBuffer();
        } else if (string3.equals("bond-orientation")) {
            this._inBondOrientation = true;
            this._buffer = new StringBuffer();
        } else if (string3.equals("molecule")) {
            this._inMolecule = true;
            String string4 = attributes.getValue("id");
            this._molecules.put(string4, new RNATmp());
            this._currentModel = string4;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("numbering-table")) {
            this._inSequenceIDs = false;
            String string4 = this._buffer.toString();
            string4 = string4.trim();
            String[] stringArray = string4.split("\\s+");
            Vector<Integer> vector = new Vector<Integer>();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    vector.add(new Integer(Integer.parseInt(stringArray[i])));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            this._molecules.get((Object)this._currentModel)._sequenceIDs = vector;
            this._buffer = null;
        } else if (string3.equals("seq-data")) {
            this._inSequence = false;
            String string5 = this._buffer.toString();
            string5 = string5.trim();
            String[] stringArray = string5.split("\\s+");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < stringArray[i].length(); ++j) {
                    arrayList.add("" + stringArray[i].charAt(j));
                }
            }
            this._molecules.get((Object)this._currentModel)._sequence = arrayList;
            this._buffer = null;
        } else if (string3.equals("bond-orientation")) {
            this._inBondOrientation = false;
            String string6 = this._buffer.toString();
            this._orientation = string6 = string6.trim();
            this._buffer = null;
        } else if (string3.equals("str-annotation")) {
            this._inStrAnnotation = false;
        } else if (string3.equals("base-pair")) {
            if (this._inMolecule) {
                this._inBP = false;
                BPTemp bPTemp = new BPTemp(this._id5, this._id3, this._edge5, this._edge3, this._orientation);
                this._molecules.get((Object)this._currentModel)._structure.add(bPTemp);
            }
        } else if (string3.equals("helix")) {
            this._inHelix = false;
            if (this._inMolecule) {
                HelixTemp helixTemp = new HelixTemp(this._id5, this._id3, this._length, this._helixID);
                this._molecules.get((Object)this._currentModel)._helices.add(helixTemp);
            }
        } else if (string3.equals("base-id-5p")) {
            this._inBP5 = false;
        } else if (string3.equals("base-id-3p")) {
            this._inBP3 = false;
        } else if (string3.equals("length")) {
            this._inLength = false;
            String string7 = this._buffer.toString();
            string7 = string7.trim();
            this._length = Integer.parseInt(string7);
            this._buffer = null;
        } else if (string3.equals("position")) {
            String string8 = this._buffer.toString();
            string8 = string8.trim();
            int n = Integer.parseInt(string8);
            if (this._inBP5) {
                this._id5 = n;
            }
            if (this._inBP3) {
                this._id3 = n;
            }
            this._buffer = null;
        } else if (string3.equals("edge-5p")) {
            this._inEdge5 = false;
            String string9 = this._buffer.toString();
            this._edge5 = string9 = string9.trim();
            this._buffer = null;
        } else if (string3.equals("edge-3p")) {
            this._inEdge3 = false;
            String string10 = this._buffer.toString();
            this._edge3 = string10 = string10.trim();
            this._buffer = null;
        } else if (string3.equals("molecule")) {
            this._inMolecule = false;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this._buffer != null) {
            this._buffer.append(string);
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        this.postProcess();
    }

    private void discardStacking() {
        Vector<BPTemp> vector = new Vector<BPTemp>();
        for (int i = 0; i < this._molecules.get((Object)this._currentModel)._structure.size(); ++i) {
            BPTemp bPTemp = this._molecules.get((Object)this._currentModel)._structure.get(i);
            if (!bPTemp.orientation.equals("c") && !bPTemp.orientation.equals("t")) continue;
            vector.add(bPTemp);
        }
        this._molecules.get((Object)this._currentModel)._structure = vector;
    }

    public static boolean isSelfCrossing(int[] nArray) {
        Stack<Point> stack = new Stack<Point>();
        stack.add(new Point(0, nArray.length - 1));
        while (!stack.empty()) {
            Point point = (Point)stack.pop();
            if (point.x > point.y) continue;
            if (nArray[point.x] == -1) {
                stack.push(new Point(point.x + 1, point.y));
                continue;
            }
            int n = point.x;
            int n2 = point.y;
            int n3 = nArray[n];
            if (n3 <= n || n3 > n2) {
                return true;
            }
            stack.push(new Point(n + 1, n3 - 1));
            stack.push(new Point(n3 + 1, n2));
        }
        return false;
    }

    private void debugPrintArray(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(objectArray[i]);
        }
        stringBuffer.append("]");
        System.out.println(stringBuffer.toString());
    }

    public static int[] planarize(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (!RNAMLParser.isSelfCrossing(nArray)) {
            return nArray;
        }
        int n6 = nArray.length;
        int[] nArray2 = new int[n6];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = -1;
        }
        short[][] sArray = new short[n6][n6];
        short[][] sArray2 = new short[n6][n6];
        int n7 = 3;
        for (n5 = 0; n5 < nArray2.length; ++n5) {
            for (n4 = n5; n4 < Math.min(n5 + n7, nArray2.length); ++n4) {
                sArray[n5][n4] = 0;
                sArray2[n5][n4] = -1;
            }
        }
        for (n5 = n7; n5 < n6; ++n5) {
            for (n4 = 0; n4 < n6 - n5; ++n4) {
                n3 = n4 + n5;
                sArray[n4][n3] = sArray[n4 + 1][n3];
                sArray2[n4][n3] = -1;
                n2 = nArray[n4];
                if (n2 == -1 || n2 > n3 || n4 >= n2) continue;
                n = 1;
                if (n4 + 1 <= n2 - 1) {
                    n += sArray[n4 + 1][n2 - 1];
                }
                if (n2 + 1 <= n3) {
                    n += sArray[n2 + 1][n3];
                }
                if (n <= sArray[n4][n3]) continue;
                sArray[n4][n3] = (short)n;
                sArray2[n4][n3] = (short)n2;
            }
        }
        Stack<Point> stack = new Stack<Point>();
        stack.add(new Point(0, n6 - 1));
        while (!stack.empty()) {
            Point point = (Point)stack.pop();
            if (point.x > point.y) continue;
            if (sArray2[point.x][point.y] == -1) {
                nArray2[point.x] = -1;
                stack.push(new Point(point.x + 1, point.y));
                continue;
            }
            n3 = point.x;
            n2 = point.y;
            nArray2[n3] = n = sArray2[point.x][point.y];
            nArray2[n] = n3;
            stack.push(new Point(n3 + 1, n - 1));
            stack.push(new Point(n + 1, n2));
        }
        return nArray2;
    }

    public static void planarize(ArrayList<ModeleBP> arrayList, ArrayList<ModeleBP> arrayList2, ArrayList<ModeleBP> arrayList3, int n) {
        int n2;
        ModeleBP modeleBP2;
        int n3;
        int n4;
        int n5;
        int stack;
        int n6;
        Hashtable hashtable = new Hashtable();
        for (ModeleBP object22 : arrayList) {
            n6 = object22.getPartner5().getIndex();
            if (!hashtable.containsKey(n6)) {
                hashtable.put(n6, new ArrayList());
            }
            ((ArrayList)hashtable.get(n6)).add(object22);
        }
        Object object3 = new short[n][n];
        short[][] sArray = new short[n][n];
        n6 = 3;
        for (stack = 0; stack < n; ++stack) {
            for (n5 = stack; n5 < Math.min(stack + n6, n); ++n5) {
                object3[stack][n5] = false;
                sArray[stack][n5] = -1;
            }
        }
        for (stack = n6; stack < n; ++stack) {
            for (n5 = 0; n5 < n - stack; ++n5) {
                n4 = n5 + stack;
                object3[n5][n4] = object3[n5 + 1][n4];
                sArray[n5][n4] = -1;
                if (!hashtable.containsKey(n5)) continue;
                ArrayList n8 = (ArrayList)hashtable.get(n5);
                for (n3 = 0; n3 < n8.size(); ++n3) {
                    modeleBP2 = (ModeleBP)n8.get(n3);
                    n2 = modeleBP2.getPartner3().getIndex();
                    if (n2 == -1 || n2 > n4 || n5 >= n2) continue;
                    int n7 = 1;
                    if (n5 + 1 <= n2 - 1) {
                        n7 += object3[n5 + 1][n2 - 1];
                    }
                    if (n2 + 1 <= n4) {
                        n7 += object3[n2 + 1][n4];
                    }
                    if (n7 <= object3[n5][n4]) continue;
                    object3[n5][n4] = (short)n7;
                    sArray[n5][n4] = (short)n3;
                }
            }
        }
        Stack<Point> stack2 = new Stack<Point>();
        stack2.add(new Point(0, n - 1));
        while (!stack2.empty()) {
            Point iterator = (Point)stack2.pop();
            if (iterator.x > iterator.y) continue;
            if (sArray[iterator.x][iterator.y] == -1) {
                stack2.push(new Point(iterator.x + 1, iterator.y));
                continue;
            }
            n4 = iterator.x;
            int arrayList5 = iterator.y;
            n3 = sArray[iterator.x][iterator.y];
            modeleBP2 = (ModeleBP)((ArrayList)hashtable.get(n4)).get(n3);
            n2 = modeleBP2.getPartner3().getIndex();
            arrayList2.add(modeleBP2);
            stack2.push(new Point(n4 + 1, n2 - 1));
            stack2.push(new Point(n2 + 1, arrayList5));
        }
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            n4 = (Integer)iterator.next();
            ArrayList arrayList4 = (ArrayList)hashtable.get(n4);
            for (ModeleBP modeleBP2 : arrayList4) {
                if (arrayList2.contains(modeleBP2)) continue;
                arrayList3.add(modeleBP2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void postProcess() {
        for (RNATmp rNATmp : this._molecules.values()) {
            BPTemp bPTemp;
            int n;
            void var5_11;
            int n2;
            int n3;
            Cloneable cloneable;
            if (rNATmp._sequenceIDs.size() == 0) {
                cloneable = new Vector();
                for (n3 = 0; n3 < rNATmp._sequence.size(); ++n3) {
                    ((Vector)cloneable).add(new Integer(n3 + 1));
                }
                rNATmp._sequenceIDs = cloneable;
            }
            cloneable = new Hashtable();
            for (n3 = 0; n3 < rNATmp._sequenceIDs.size(); ++n3) {
                ((Hashtable)cloneable).put(rNATmp._sequenceIDs.get(n3), n3);
            }
            for (BPTemp bPTemp2 : rNATmp._structure) {
                --bPTemp2.pos3;
                --bPTemp2.pos5;
            }
            this.discardStacking();
            Hashtable hashtable = new Hashtable();
            for (BPTemp bPTemp3 : rNATmp._structure) {
                n2 = bPTemp3.pos5;
                if (!hashtable.containsKey(n2)) {
                    hashtable.put(n2, new Hashtable());
                }
                if (((Hashtable)hashtable.get(n2)).contains(bPTemp3.pos3)) continue;
                ((Hashtable)hashtable.get(n2)).put(bPTemp3.pos3, bPTemp3);
            }
            boolean bl = false;
            while (var5_11 < rNATmp._helices.size()) {
                HelixTemp helixTemp = rNATmp._helices.get((int)var5_11);
                for (n2 = 0; n2 < helixTemp.length; ++n2) {
                    int n4 = helixTemp.pos5 + n2 - 1;
                    n = helixTemp.pos3 - n2 - 1;
                    bPTemp = new BPTemp(n4, n, "+", "+", "c");
                    if (!hashtable.containsKey(n4)) {
                        hashtable.put(n4, new Hashtable());
                    }
                    if (((Hashtable)hashtable.get(n4)).contains(n)) continue;
                    ((Hashtable)hashtable.get(n4)).put(n, bPTemp);
                }
                ++var5_11;
            }
            Vector<BPTemp> vector2 = new Vector<BPTemp>();
            Iterator iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                n2 = (Integer)iterator.next();
                Iterator iterator2 = ((Hashtable)hashtable.get(n2)).keySet().iterator();
                while (iterator2.hasNext()) {
                    n = (Integer)iterator2.next();
                    bPTemp = (BPTemp)((Hashtable)hashtable.get(n2)).get(n);
                    vector2.add(bPTemp);
                }
            }
            rNATmp._structure = vector2;
        }
    }

    public ArrayList<RNATmp> getMolecules() {
        return new ArrayList<RNATmp>(this._molecules.values());
    }

    public class RNATmp {
        public ArrayList<String> _sequence = new ArrayList();
        public Vector<Integer> _sequenceIDs = new Vector();
        public Vector<BPTemp> _structure = new Vector();
        public Vector<HelixTemp> _helices = new Vector();

        public ArrayList<String> getSequence() {
            return this._sequence;
        }

        public Vector<BPTemp> getStructure() {
            return this._structure;
        }
    }

    public class BPTemp {
        public int pos5;
        public int pos3;
        public String edge5;
        public String edge3;
        public String orientation;

        public BPTemp(int n, int n2, String string, String string2, String string3) {
            if (string2 == null) {
                string2 = "+";
            }
            if (string == null) {
                string = "+";
            }
            if (string3 == null) {
                string3 = "c";
            }
            this.pos5 = n;
            this.pos3 = n2;
            this.edge5 = string;
            this.edge3 = string2;
            this.orientation = string3;
        }

        public ModeleBP createBPStyle(ModeleBase modeleBase, ModeleBase modeleBase2) {
            boolean bl = false;
            ModeleBP.Edge edge = this.edge5.equals("W") ? ModeleBP.Edge.WC : (this.edge5.equals("H") ? ModeleBP.Edge.HOOGSTEEN : (this.edge5.equals("S") ? ModeleBP.Edge.SUGAR : ModeleBP.Edge.WC));
            ModeleBP.Edge edge2 = this.edge3.equals("W") ? ModeleBP.Edge.WC : (this.edge3.equals("H") ? ModeleBP.Edge.HOOGSTEEN : (this.edge3.equals("S") ? ModeleBP.Edge.SUGAR : ModeleBP.Edge.WC));
            if (this.edge5.equals("+") && this.edge3.equals("+") || this.edge5.equals("-") && this.edge3.equals("-")) {
                edge2 = ModeleBP.Edge.WC;
                edge = ModeleBP.Edge.WC;
            }
            ModeleBP.Stericity stericity = this.orientation.equals("c") ? ModeleBP.Stericity.CIS : (this.orientation.equals("t") ? ModeleBP.Stericity.TRANS : ModeleBP.Stericity.CIS);
            return new ModeleBP(modeleBase, modeleBase2, edge, edge2, stericity);
        }

        public String toString() {
            return "[" + this.pos5 + "," + this.pos3 + "," + this.edge5 + "," + this.edge3 + "," + this.orientation + "]";
        }
    }

    public class HelixTemp {
        public int pos5;
        public int pos3;
        public int length;
        public String name;

        public HelixTemp(int n, int n2, int n3, String string) {
            this.pos3 = n2;
            this.pos5 = n;
            this.length = n3;
            this.name = string;
        }

        public String toString() {
            return "[" + this.name + "," + this.pos5 + "," + this.pos3 + "," + this.length + "]";
        }
    }
}

