/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.treealign;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class Tree<T>
implements Iterable<Tree<T>> {
    private List<Tree<T>> children;
    private T value;
    private Tree<T> tree = this;

    public T getValue() {
        return this.value;
    }

    public void setValue(T t) {
        this.value = t;
    }

    public List<Tree<T>> getChildren() {
        return this.children;
    }

    public void replaceChildrenListBy(List<Tree<T>> list) {
        this.children = list;
    }

    public Tree(Iterable<Tree<T>> iterable) {
        this();
        for (Tree<T> tree : iterable) {
            this.children.add(tree);
        }
    }

    public Tree() {
        this.children = new ArrayList<Tree<T>>();
    }

    public int rootDegree() {
        return this.children.size();
    }

    public int countNodes() {
        int n = 1;
        for (Tree<T> tree : this.children) {
            n += tree.countNodes();
        }
        return n;
    }

    public int computeDegree() {
        int n = this.children.size();
        for (Tree<T> tree : this.children) {
            int n2 = tree.computeDegree();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public String toGraphvizNodeId() {
        return super.toString();
    }

    @Override
    public Iterator<Tree<T>> iterator() {
        return new DFSPrefixIterator();
    }

    public class DFSPrefixIterator
    implements Iterator<Tree<T>> {
        private LinkedList<Tree<T>> remainingNodes = new LinkedList();

        @Override
        public boolean hasNext() {
            return !this.remainingNodes.isEmpty();
        }

        @Override
        public Tree<T> next() {
            if (this.remainingNodes.isEmpty()) {
                throw new NoSuchElementException();
            }
            Tree tree = this.remainingNodes.getLast();
            this.remainingNodes.removeLast();
            List list = tree.getChildren();
            int n = list.size();
            for (int i = n - 1; i >= 0; --i) {
                this.remainingNodes.add(list.get(i));
            }
            return tree;
        }

        public DFSPrefixIterator() {
            this.remainingNodes.add(Tree.this.tree);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

