/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.geom.ComputeArcCenter;
import fr.orsay.lri.varna.models.geom.ComputeEllipseAxis;
import fr.orsay.lri.varna.models.geom.CubicBezierCurve;
import fr.orsay.lri.varna.models.geom.HalfEllipse;
import fr.orsay.lri.varna.models.geom.LinesIntersect;
import fr.orsay.lri.varna.models.geom.MiscGeom;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.models.templates.DrawRNATemplateCurveMethod;
import fr.orsay.lri.varna.models.templates.DrawRNATemplateMethod;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplate;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateBasePair;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import fr.orsay.lri.varna.models.templates.RNATemplateAlign;
import fr.orsay.lri.varna.models.templates.RNATemplateDrawingAlgorithmException;
import fr.orsay.lri.varna.models.templates.RNATemplateMapping;
import fr.orsay.lri.varna.models.treealign.Tree;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DrawRNATemplate {
    private RNA rna;
    private RNATemplateMapping mapping;
    private ArrayList<ModeleBase> _listeBases;

    public DrawRNATemplate(RNA rNA) {
        this.rna = rNA;
        this._listeBases = rNA.getListeBases();
    }

    public RNATemplateMapping getMapping() {
        return this.mapping;
    }

    public void drawRNATemplate(RNATemplate rNATemplate, VARNAConfig vARNAConfig, DrawRNATemplateMethod drawRNATemplateMethod, DrawRNATemplateCurveMethod drawRNATemplateCurveMethod) throws RNATemplateDrawingAlgorithmException {
        int n;
        Object object;
        Object object2;
        Iterator<RNATemplate.RNATemplateElement> iterator;
        Point2D.Double[] doubleArray;
        this.mapping = RNATemplateAlign.mapRNAWithTemplate(this.rna, rNATemplate);
        double d = 1.0;
        Map<RNATemplate.RNATemplateHelix, Point2D.Double> map = null;
        if (drawRNATemplateMethod == DrawRNATemplateMethod.MAXSCALINGFACTOR) {
            doubleArray = new HashMap();
            double d2 = Double.NEGATIVE_INFINITY;
            iterator = rNATemplate.rnaIterator();
            while (iterator.hasNext()) {
                RNATemplate.RNATemplateElement rNATemplateElement = iterator.next();
                if (!(rNATemplateElement instanceof RNATemplate.RNATemplateHelix) || this.mapping.getAncestor(rNATemplateElement) == null || doubleArray.containsKey(rNATemplateElement)) continue;
                object2 = (RNATemplate.RNATemplateHelix)rNATemplateElement;
                object = RNATemplateAlign.intArrayFromList(this.mapping.getAncestor((RNATemplate.RNATemplateElement)object2));
                Arrays.sort((int[])object);
                double d3 = this.computeLengthIncreaseFactor((int[])object, (RNATemplate.RNATemplateHelix)object2);
                doubleArray.put(object2, d3);
                if (!(d3 > d2)) continue;
                d2 = d3;
            }
            d = Math.max(1.0, d2);
        } else if (drawRNATemplateMethod == DrawRNATemplateMethod.HELIXTRANSLATE) {
            try {
                doubleArray = rNATemplate.toTree();
                map = this.computeHelixTranslations((Tree<RNANodeValueTemplate>)doubleArray, this.mapping);
            }
            catch (ExceptionInvalidRNATemplate exceptionInvalidRNATemplate) {
                throw new RNATemplateDrawingAlgorithmException("ExceptionInvalidRNATemplate: " + exceptionInvalidRNATemplate.getMessage());
            }
        }
        doubleArray = new Point2D.Double[this._listeBases.size()];
        Point2D.Double[] doubleArray2 = new Point2D.Double[this._listeBases.size()];
        double[] dArray = new double[this._listeBases.size()];
        for (n = 0; n < this._listeBases.size(); ++n) {
            doubleArray[n] = new Point2D.Double(0.0, 0.0);
            doubleArray2[n] = new Point2D.Double(0.0, 0.0);
        }
        n = 1;
        while (n != 0) {
            int n2;
            Object object3;
            Point2D.Double double_;
            Object object4;
            Object object5;
            n = 0;
            object2 = new HashSet();
            object = null;
            RNATemplate.RNATemplateElement.EdgeEndPoint edgeEndPoint = null;
            int n3 = 0;
            iterator = rNATemplate.rnaIterator();
            RNATemplate.RNATemplateElement rNATemplateElement = null;
            while (iterator.hasNext()) {
                Point2D.Double double_2;
                int n4;
                boolean bl;
                rNATemplateElement = iterator.next();
                if (!(rNATemplateElement instanceof RNATemplate.RNATemplateHelix) || this.mapping.getAncestor(rNATemplateElement) == null) continue;
                object5 = (Line2D.Double[])rNATemplateElement;
                object4 = RNATemplateAlign.intArrayFromList(this.mapping.getAncestor((RNATemplate.RNATemplateElement)object5));
                Arrays.sort(object4);
                if (!object2.contains(object5)) {
                    bl = true;
                    this.drawHelixLikeTemplateHelix((int[])object4, (RNATemplate.RNATemplateHelix)object5, doubleArray, doubleArray2, dArray, d, map);
                    object2.add(object5);
                } else {
                    bl = false;
                }
                RNATemplate.RNATemplateElement.EdgeEndPoint edgeEndPoint2 = bl ? (((RNATemplate.RNATemplateHelix)object5).getIn1Is() == RNATemplate.In1Is.IN1_IS_5PRIME ? ((RNATemplate.RNATemplateHelix)object5).getIn1() : ((RNATemplate.RNATemplateHelix)object5).getIn2()) : (((RNATemplate.RNATemplateHelix)object5).getIn1Is() == RNATemplate.In1Is.IN1_IS_5PRIME ? ((RNATemplate.RNATemplateHelix)object5).getIn2() : ((RNATemplate.RNATemplateHelix)object5).getIn1());
                Point2D.Double double_3 = new Point2D.Double();
                double_ = new Point2D.Double();
                if (object != null) {
                    if (object == object5) {
                        object3 = new Point2D.Double();
                        this.computeHelixEndPointDirections(edgeEndPoint, (Point2D.Double)object3, new Point2D.Double());
                        double d4 = MiscGeom.angleFromVector((Point2D.Double)object3);
                        n4 = object4[((int[])object4).length / 2 - 1];
                        double_3.setLocation(doubleArray[n4]);
                        int n5 = object4[((int[])object4).length / 2];
                        double_.setLocation(doubleArray[n5]);
                        double_2 = new Point2D.Double((double_3.x + double_.x) / 2.0, (double_3.y + double_.y) / 2.0);
                        this.rna.drawLoop(n4, n5, double_2.x, double_2.y, d4, doubleArray, doubleArray2, dArray);
                        if (((RNATemplate.RNATemplateHelix)object5).isFlipped()) {
                            DrawRNATemplate.symmetric(double_2, (Point2D.Double)object3, doubleArray, n4, n5);
                            DrawRNATemplate.symmetric(double_2, (Point2D.Double)object3, doubleArray2, n4, n5);
                        }
                    } else {
                        Point2D.Double double_4;
                        Point2D.Double double_5;
                        int n6 = n3;
                        int n7 = bl ? object4[0] : object4[((int[])object4).length / 2];
                        double_3.setLocation(doubleArray[n6]);
                        double_.setLocation(doubleArray[n7]);
                        if (edgeEndPoint.getOtherElement() instanceof RNATemplate.RNATemplateUnpairedSequence && edgeEndPoint2.getOtherElement() instanceof RNATemplate.RNATemplateUnpairedSequence) {
                            double_5 = new Point2D.Double();
                            this.computeBezierTangentVectorTarget(edgeEndPoint, double_3, double_5);
                            double_4 = new Point2D.Double();
                            this.computeBezierTangentVectorTarget(edgeEndPoint2, double_, double_4);
                        } else {
                            double_5 = null;
                            double_4 = null;
                        }
                        this.drawAlongCurve(n6, n7, double_3, double_5, double_4, double_, doubleArray, doubleArray2, dArray, drawRNATemplateCurveMethod, ((RNATemplate.RNATemplateHelix)object).isFlipped());
                    }
                } else if (object4[0] > 0) {
                    Point2D.Double double_6;
                    RNATemplate.RNATemplateElement rNATemplateElement2 = this.mapping.getPartner(0);
                    object3 = rNATemplateElement2 != null && rNATemplateElement2 instanceof RNATemplate.RNATemplateUnpairedSequence ? (RNATemplate.RNATemplateUnpairedSequence)rNATemplateElement2 : ((rNATemplateElement2 = rNATemplate.getFirst()) != null && rNATemplateElement2 instanceof RNATemplate.RNATemplateUnpairedSequence ? (RNATemplate.RNATemplateUnpairedSequence)rNATemplateElement2 : null);
                    int n8 = 0;
                    n4 = bl ? object4[0] : object4[((int[])object4).length / 2];
                    double_.setLocation(doubleArray[n4]);
                    if (object3 != null) {
                        doubleArray[0].setLocation(((RNATemplate.RNATemplateUnpairedSequence)object3).getVertex5());
                        doubleArray[0].x *= d;
                        doubleArray[0].y *= d;
                    } else {
                        double d5 = this.computeStraightLineIdealLength(n8, n4);
                        Point2D.Double double_7 = new Point2D.Double();
                        if (edgeEndPoint2 != null) {
                            this.computeHelixEndPointDirections(edgeEndPoint2, new Point2D.Double(), double_7);
                        } else {
                            double_7.setLocation(1.0, 0.0);
                        }
                        doubleArray[n8].setLocation(doubleArray[n4].x + double_7.x * d5, doubleArray[n4].y + double_7.y * d5);
                    }
                    double_3.setLocation(doubleArray[0]);
                    if (edgeEndPoint2.getOtherElement() instanceof RNATemplate.RNATemplateUnpairedSequence && object3 != null) {
                        double_6 = new Point2D.Double();
                        this.computeBezierTangentVectorTarget(((RNATemplate.RNATemplateUnpairedSequence)object3).getIn(), double_3, double_6);
                        double_2 = new Point2D.Double();
                        this.computeBezierTangentVectorTarget(edgeEndPoint2, double_, double_2);
                    } else {
                        double_6 = null;
                        double_2 = null;
                    }
                    this.drawAlongCurve(n8, n4, double_3, double_6, double_2, double_, doubleArray, doubleArray2, dArray, drawRNATemplateCurveMethod, false);
                }
                object = object5;
                edgeEndPoint = edgeEndPoint2.getNextEndPoint();
                if (bl) {
                    n3 = object4[((int[])object4).length / 2 - 1];
                    continue;
                }
                n3 = object4[((int[])object4).length - 1];
            }
            if (n3 < doubleArray.length - 1 && rNATemplateElement != null && doubleArray.length > 1) {
                Point2D.Double double_8;
                Point2D.Double double_9;
                RNATemplate.RNATemplateElement rNATemplateElement3;
                object5 = null;
                if (object == null && (object5 = (rNATemplateElement3 = this.mapping.getPartner(0)) != null && rNATemplateElement3 instanceof RNATemplate.RNATemplateUnpairedSequence ? (RNATemplate.RNATemplateUnpairedSequence)rNATemplateElement3 : ((rNATemplateElement3 = rNATemplate.getFirst()) != null && rNATemplateElement3 instanceof RNATemplate.RNATemplateUnpairedSequence ? (RNATemplate.RNATemplateUnpairedSequence)rNATemplateElement3 : null)) != null) {
                    doubleArray[0].setLocation(((RNATemplate.RNATemplateUnpairedSequence)object5).getVertex5());
                    doubleArray[0].x *= d;
                    doubleArray[0].y *= d;
                }
                RNATemplate.RNATemplateUnpairedSequence rNATemplateUnpairedSequence = (object4 = (Object)this.mapping.getPartner(doubleArray.length - 1)) != null && object4 instanceof RNATemplate.RNATemplateUnpairedSequence ? (RNATemplate.RNATemplateUnpairedSequence)object4 : ((object4 = (Object)rNATemplateElement) != null && object4 instanceof RNATemplate.RNATemplateUnpairedSequence ? (RNATemplate.RNATemplateUnpairedSequence)object4 : null);
                int n9 = n3;
                int n10 = doubleArray.length - 1;
                if (rNATemplateUnpairedSequence != null) {
                    doubleArray[n10].setLocation(rNATemplateUnpairedSequence.getVertex3());
                    doubleArray[n10].x *= d;
                    doubleArray[n10].y *= d;
                } else {
                    double d6 = this.computeStraightLineIdealLength(n9, n10);
                    Point2D.Double double_10 = new Point2D.Double();
                    if (edgeEndPoint != null) {
                        this.computeHelixEndPointDirections(edgeEndPoint, new Point2D.Double(), double_10);
                    } else {
                        double_10.setLocation(1.0, 0.0);
                    }
                    doubleArray[n10].setLocation(doubleArray[n9].x + double_10.x * d6, doubleArray[n9].y + double_10.y * d6);
                }
                double_ = new Point2D.Double();
                object3 = new Point2D.Double();
                double_.setLocation(doubleArray[n9]);
                ((Point2D)object3).setLocation(doubleArray[n10]);
                if (edgeEndPoint != null && edgeEndPoint.getOtherElement() instanceof RNATemplate.RNATemplateUnpairedSequence && rNATemplateUnpairedSequence != null) {
                    double_9 = new Point2D.Double();
                    this.computeBezierTangentVectorTarget(edgeEndPoint, double_, double_9);
                    double_8 = new Point2D.Double();
                    this.computeBezierTangentVectorTarget(rNATemplateUnpairedSequence.getOut(), (Point2D.Double)object3, double_8);
                } else if (object == null && object5 != null && rNATemplateUnpairedSequence != null) {
                    double_9 = new Point2D.Double();
                    this.computeBezierTangentVectorTarget(((RNATemplate.RNATemplateUnpairedSequence)object5).getIn(), double_, double_9);
                    double_8 = new Point2D.Double();
                    this.computeBezierTangentVectorTarget(rNATemplateUnpairedSequence.getOut(), (Point2D.Double)object3, double_8);
                } else {
                    double_9 = null;
                    double_8 = null;
                }
                this.drawAlongCurve(n9, n10, double_, double_9, double_8, (Point2D.Double)object3, doubleArray, doubleArray2, dArray, drawRNATemplateCurveMethod, object != null ? ((RNATemplate.RNATemplateHelix)object).isFlipped() : false);
            }
            if (drawRNATemplateMethod != DrawRNATemplateMethod.NOINTERSECT || doubleArray.length <= 3) continue;
            object5 = new Line2D.Double[doubleArray.length - 1];
            for (n2 = 0; n2 < doubleArray.length - 1; ++n2) {
                object5[n2] = new Line2D.Double(doubleArray[n2], doubleArray[n2 + 1]);
            }
            n2 = 0;
            for (int i = 0; i < ((Object)object5).length; ++i) {
                for (int j = i + 2; j < ((Object)object5).length; ++j) {
                    if (!LinesIntersect.linesIntersect((Line2D.Double)object5[i], (Line2D.Double)object5[j])) continue;
                    ++n2;
                }
            }
            if (n2 <= 0 || !(d < 3.0)) continue;
            d += 0.1;
            n = 1;
        }
        if (drawRNATemplateMethod == DrawRNATemplateMethod.MAXSCALINGFACTOR || drawRNATemplateMethod == DrawRNATemplateMethod.NOINTERSECT) {
            // empty if block
        }
        for (int i = 0; i < this._listeBases.size(); ++i) {
            this._listeBases.get(i).setCoords(new Point2D.Double(doubleArray[i].x * vARNAConfig._spaceBetweenBases, doubleArray[i].y * vARNAConfig._spaceBetweenBases));
            this._listeBases.get(i).setCenter(new Point2D.Double(doubleArray2[i].x * vARNAConfig._spaceBetweenBases, doubleArray2[i].y * vARNAConfig._spaceBetweenBases));
        }
    }

    private void computeHelixEndPointDirections(RNATemplate.RNATemplateElement.EdgeEndPoint edgeEndPoint, Point2D.Double double_, Point2D.Double double_2) {
        RNATemplate.RNATemplateHelix rNATemplateHelix = (RNATemplate.RNATemplateHelix)edgeEndPoint.getElement();
        Point2D.Double double_3 = rNATemplateHelix.getStartPosition();
        Point2D.Double double_4 = rNATemplateHelix.getEndPosition();
        Point2D.Double double_5 = new Point2D.Double();
        switch (edgeEndPoint.getPosition()) {
            case IN1: 
            case OUT2: {
                double_5.x = double_3.x - double_4.x;
                double_5.y = double_3.y - double_4.y;
                break;
            }
            case IN2: 
            case OUT1: {
                double_5.x = double_4.x - double_3.x;
                double_5.y = double_4.y - double_3.y;
            }
        }
        double d = Math.hypot(double_5.x, double_5.y);
        double_.x = double_5.x / d;
        double_.y = double_5.y / d;
        switch (edgeEndPoint.getPosition()) {
            case IN1: 
            case IN2: {
                double_2.x = -double_.y;
                double_2.y = double_.x;
                break;
            }
            case OUT2: 
            case OUT1: {
                double_2.x = double_.y;
                double_2.y = -double_.x;
            }
        }
        if (rNATemplateHelix.isFlipped()) {
            double_2.x = -double_2.x;
            double_2.y = -double_2.y;
        }
    }

    private void computeBezierTangentVectorTarget(RNATemplate.RNATemplateElement.EdgeEndPoint edgeEndPoint, Point2D.Double double_, Point2D.Double double_2) throws RNATemplateDrawingAlgorithmException {
        boolean bl;
        RNATemplate.RNATemplateUnpairedSequence rNATemplateUnpairedSequence;
        if (edgeEndPoint.getElement() instanceof RNATemplate.RNATemplateHelix) {
            RNATemplate.RNATemplateElement.EdgeEndPoint edgeEndPoint2;
            rNATemplateUnpairedSequence = (RNATemplate.RNATemplateUnpairedSequence)edgeEndPoint.getOtherElement();
            RNATemplate.EdgeEndPointPosition edgeEndPointPosition = edgeEndPoint.getPosition();
            switch (edgeEndPointPosition) {
                case IN1: 
                case IN2: {
                    bl = false;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            RNATemplate.RNATemplateElement.EdgeEndPoint edgeEndPoint3 = edgeEndPoint2 = bl ? rNATemplateUnpairedSequence.getIn().getOtherEndPoint() : rNATemplateUnpairedSequence.getOut().getOtherEndPoint();
            if (edgeEndPoint2 == null) {
                throw new RNATemplateDrawingAlgorithmException("Sequence is not connected to an helix.");
            }
        } else {
            rNATemplateUnpairedSequence = (RNATemplate.RNATemplateUnpairedSequence)edgeEndPoint.getElement();
            bl = edgeEndPoint == rNATemplateUnpairedSequence.getIn();
        }
        double d = bl ? rNATemplateUnpairedSequence.getInTangentVectorLength() : rNATemplateUnpairedSequence.getOutTangentVectorLength();
        double d2 = bl ? rNATemplateUnpairedSequence.getInTangentVectorAngle() : rNATemplateUnpairedSequence.getOutTangentVectorAngle();
        Point2D.Double double_3 = new Point2D.Double();
        double_3.x = d * Math.cos(d2);
        double_3.y = d * Math.sin(d2);
        double_2.x = double_.x + double_3.x;
        double_2.y = double_.y + double_3.y;
    }

    private double computeLengthIncreaseFactor(int[] nArray, RNATemplate.RNATemplateHelix rNATemplateHelix) {
        double d = this.computeHelixTemplateLength(rNATemplateHelix);
        double d2 = this.computeHelixRealLength(nArray);
        return d2 / d;
    }

    private Point2D.Double computeLengthIncreaseDelta(int[] nArray, RNATemplate.RNATemplateHelix rNATemplateHelix) {
        double d = this.computeHelixTemplateLength(rNATemplateHelix);
        double d2 = this.computeHelixRealLength(nArray);
        Point2D.Double double_ = new Point2D.Double();
        this.computeTemplateHelixVectors(rNATemplateHelix, null, double_, null);
        return new Point2D.Double(double_.x * (d2 - d), double_.y * (d2 - d));
    }

    private void computeTemplateHelixVectors(RNATemplate.RNATemplateHelix rNATemplateHelix, Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
        Point2D.Double double_4;
        Point2D.Double double_5;
        if (rNATemplateHelix.getIn1Is() == RNATemplate.In1Is.IN1_IS_5PRIME) {
            double_5 = rNATemplateHelix.getStartPosition();
            double_4 = rNATemplateHelix.getEndPosition();
        } else {
            double_4 = rNATemplateHelix.getStartPosition();
            double_5 = rNATemplateHelix.getEndPosition();
        }
        if (double_ != null) {
            double_.x = double_5.x;
            double_.y = double_5.y;
        }
        if (double_2 != null || double_3 != null) {
            if (double_2 == null) {
                double_2 = new Point2D.Double();
            }
            double_2.x = double_4.x - double_5.x;
            double_2.y = double_4.y - double_5.y;
            double d = Math.hypot(double_2.x, double_2.y);
            double_2.x /= d;
            double_2.y /= d;
            if (double_3 != null) {
                double_3.x = -double_2.y;
                double_3.y = double_2.x;
                if (rNATemplateHelix.isFlipped()) {
                    double_3.x = -double_3.x;
                    double_3.y = -double_3.y;
                }
                double d2 = Math.hypot(double_3.x, double_3.y);
                double_3.x /= d2;
                double_3.y /= d2;
            }
        }
    }

    private double estimateBulgeArcLength(int n, int n2) {
        if (n + 1 == n2) {
            return 40.0;
        }
        double d = 0.0;
        int n3 = n;
        while (n3 < n2) {
            int n4 = this._listeBases.get(n3).getElementStructure();
            if (n3 < n4 && n4 < n2) {
                d += 65.0;
                n3 = n4;
                continue;
            }
            d += 40.0;
            ++n3;
        }
        return d;
    }

    private double estimateBulgeWidth(int n, int n2) {
        double d = this.estimateBulgeArcLength(n, n2);
        return 2.0 * (d / Math.PI);
    }

    private double computeHelixTemplateLength(RNATemplate.RNATemplateHelix rNATemplateHelix) {
        return Math.hypot(rNATemplateHelix.getStartPosition().x - rNATemplateHelix.getEndPosition().x, rNATemplateHelix.getStartPosition().y - rNATemplateHelix.getEndPosition().y);
    }

    private double computeHelixRealLength(int[] nArray) {
        return this.drawHelixLikeTemplateHelix(nArray, null, null, null, null, 0.0, null);
    }

    private UnpairedLineCounts countUnpairedLine(int n, int n2) {
        UnpairedLineCounts unpairedLineCounts = new UnpairedLineCounts();
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            int n6 = this._listeBases.get(n5).getElementStructure();
            if (n5 < n6 && n6 < n2) {
                ++n3;
                n5 = n6;
                continue;
            }
            ++n4;
            ++n5;
        }
        unpairedLineCounts.nBP = n3;
        unpairedLineCounts.nLD = n4;
        unpairedLineCounts.total = n3 + n4;
        return unpairedLineCounts;
    }

    private double drawHelixLikeTemplateHelix(int[] nArray, RNATemplate.RNATemplateHelix rNATemplateHelix, Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2, double[] dArray, double d, Map<RNATemplate.RNATemplateHelix, Point2D.Double> map) {
        Object object;
        int n = nArray.length / 2;
        if (n == 0) {
            return 0.0;
        }
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(1.0, 0.0);
        Point2D.Double double_3 = new Point2D.Double(0.0, 1.0);
        boolean bl = false;
        if (rNATemplateHelix != null) {
            this.computeTemplateHelixVectors(rNATemplateHelix, double_, double_2, double_3);
            bl = rNATemplateHelix.isFlipped();
        }
        Point2D.Double double_4 = new Point2D.Double(double_2.x * 40.0, double_2.y * 40.0);
        double_.x = (double_.x - double_3.x * 65.0 / 2.0) * d;
        double_.y = (double_.y - double_3.y * 65.0 / 2.0) * d;
        if (map != null && map.containsKey(rNATemplateHelix)) {
            object = map.get(rNATemplateHelix);
            double_.x += object.x;
            double_.y += object.y;
        }
        object = new Point2D.Double[nArray.length];
        for (int i = 0; i < ((Point2D.Double[])object).length; ++i) {
            object[i] = new Point2D.Double();
        }
        Point2D.Double double_5 = new Point2D.Double(0.0, 0.0);
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            int n2 = 2 * n - i - 1;
            Point2D.Double double_6 = object[i];
            Point2D.Double double_7 = object[n2];
            boolean bl3 = bl2 = i >= 1 && (nArray[i] != nArray[i - 1] + 1 || nArray[n2 + 1] != nArray[n2] + 1);
            if (i >= 1) {
                if (nArray[i] < nArray[i - 1] || nArray[n2 + 1] < nArray[n2]) {
                    throw new Error("Internal bug: basesInHelixArray must be sorted");
                }
                if (bl2) {
                    double d2 = this.estimateBulgeWidth(nArray[i - 1], nArray[i]);
                    double d3 = this.estimateBulgeWidth(nArray[n2], nArray[n2 + 1]);
                    double d4 = Math.max(d2, d3);
                    if (doubleArray != null) {
                        for (int j = 0; j < 2; ++j) {
                            double d5;
                            int n3;
                            Object object2;
                            int n4;
                            int n5;
                            double d6;
                            Point2D.Double double_8 = new Point2D.Double();
                            Point2D.Double double_9 = new Point2D.Double();
                            Point2D.Double double_10 = new Point2D.Double();
                            Point2D.Double double_11 = new Point2D.Double();
                            double d7 = d6 = bl ? -1.0 : 1.0;
                            if (j == 0) {
                                n5 = nArray[i - 1];
                                n4 = nArray[i];
                                double_8.setLocation(double_.x + double_5.x, double_.y + double_5.y);
                                double_9.setLocation(double_.x + double_5.x + double_2.x * d4, double_.y + double_5.y + double_2.y * d4);
                                double_10.setLocation(-double_3.x, -double_3.y);
                                double_11.setLocation(double_2);
                            } else {
                                n5 = nArray[n2];
                                n4 = nArray[n2 + 1];
                                double_8.setLocation(double_.x + double_5.x + double_2.x * d4 + double_3.x * 65.0, double_.y + double_5.y + double_2.y * d4 + double_3.y * 65.0);
                                double_9.setLocation(double_.x + double_5.x + double_3.x * 65.0, double_.y + double_5.y + double_3.y * 65.0);
                                double_10.setLocation(double_3);
                                double_11.setLocation(-double_2.x, -double_2.y);
                            }
                            double d8 = this.estimateBulgeArcLength(n5, n4);
                            double d9 = ComputeArcCenter.computeArcCenter(d4, d8);
                            if (d9 > -1000.0) {
                                object2 = new Point2D.Double(double_8.x + double_11.x * d4 / 2.0 + double_10.x * d9, double_8.y + double_11.y * d4 / 2.0 + double_10.y * d9);
                                n3 = n5;
                                double d10 = 0.0;
                                d5 = Math.hypot(double_8.x - ((Point2D.Double)object2).x, double_8.y - ((Point2D.Double)object2).y);
                                double d11 = MiscGeom.angleFromVector(double_8.x - ((Point2D.Double)object2).x, double_8.y - ((Point2D.Double)object2).y);
                                while (n3 < n4) {
                                    int n6 = this._listeBases.get(n3).getElementStructure();
                                    if (n3 < n6 && n6 < n4) {
                                        d10 += 65.0;
                                        n3 = n6;
                                    } else {
                                        d10 += 40.0;
                                        ++n3;
                                    }
                                    if (n3 >= n4) continue;
                                    doubleArray[n3].x = ((Point2D.Double)object2).x + d5 * Math.cos(d11 + d6 * d10 / d5);
                                    doubleArray[n3].y = ((Point2D.Double)object2).y + d5 * Math.sin(d11 + d6 * d10 / d5);
                                }
                            } else {
                                object2 = this.countUnpairedLine(n5, n4);
                                double d12 = Math.max((d4 - (double)((UnpairedLineCounts)object2).nBP * 65.0) / (double)((UnpairedLineCounts)object2).nLD, 0.0);
                                double d13 = 0.0;
                                int n7 = n5;
                                while (n7 < n4) {
                                    int n8 = this._listeBases.get(n7).getElementStructure();
                                    if (n7 < n8 && n8 < n4) {
                                        d13 += 65.0;
                                        n7 = n8;
                                    } else {
                                        d13 += d12;
                                        ++n7;
                                    }
                                    if (n7 >= n4) continue;
                                    doubleArray[n7].x = double_8.x + double_11.x * d13;
                                    doubleArray[n7].y = double_8.y + double_11.y * d13;
                                }
                            }
                            int n9 = n5;
                            while (n9 < n4) {
                                n3 = this._listeBases.get(n9).getElementStructure();
                                if (n9 < n3 && n3 < n4) {
                                    Point2D.Double double_12 = doubleArray[n9];
                                    Point2D.Double double_13 = doubleArray[n3];
                                    d5 = MiscGeom.angleFromVector(double_13.x - double_12.x, double_13.y - double_12.y) - 1.5707963267948966 + (bl ? Math.PI : 0.0);
                                    Point2D.Double double_14 = new Point2D.Double((double_12.x + double_13.x) / 2.0, (double_12.y + double_13.y) / 2.0);
                                    this.rna.drawLoop(n9, n3, double_14.x, double_14.y, d5, doubleArray, doubleArray2, dArray);
                                    if (rNATemplateHelix.isFlipped()) {
                                        Point2D.Double double_15 = new Point2D.Double(Math.cos(d5), Math.sin(d5));
                                        DrawRNATemplate.symmetric(double_14, double_15, doubleArray, n9, n3);
                                        DrawRNATemplate.symmetric(double_14, double_15, doubleArray2, n9, n3);
                                    }
                                    n9 = n3;
                                    continue;
                                }
                                ++n9;
                            }
                        }
                    }
                    double_5.x += double_2.x * d4;
                    double_5.y += double_2.y * d4;
                    double_6.x = double_.x + double_5.x;
                    double_6.y = double_.y + double_5.y;
                    double_7.x = double_6.x + double_3.x * 65.0;
                    double_7.y = double_6.y + double_3.y * 65.0;
                    continue;
                }
                double_5.x += double_4.x;
                double_5.y += double_4.y;
                double_6.x = double_.x + double_5.x;
                double_6.y = double_.y + double_5.y;
                double_7.x = double_6.x + double_3.x * 65.0;
                double_7.y = double_6.y + double_3.y * 65.0;
                continue;
            }
            double_6.x = double_.x;
            double_6.y = double_.y;
            double_7.x = double_6.x + double_3.x * 65.0;
            double_7.y = double_6.y + double_3.y * 65.0;
        }
        Point2D.Double double_16 = object[0];
        Point2D.Double double_17 = object[n - 1];
        if (doubleArray != null) {
            for (int i = 0; i < ((Point2D.Double[])object).length; ++i) {
                doubleArray[nArray[i]] = object[i];
            }
        }
        return Math.hypot(double_17.x - double_16.x, double_17.y - double_16.y);
    }

    private double computeStraightLineIdealLength(int n, int n2) {
        UnpairedLineCounts unpairedLineCounts = this.countUnpairedLine(n, n2);
        return 65.0 * (double)unpairedLineCounts.nBP + 40.0 * (double)unpairedLineCounts.nLD;
    }

    private boolean drawOnStraightLine(int n, int n2, Point2D.Double double_, Point2D.Double double_2, Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2, boolean bl) {
        Point2D.Double double_3 = new Point2D.Double(double_2.x - double_.x, double_2.y - double_.y);
        double d = Math.hypot(double_3.x, double_3.y);
        UnpairedLineCounts unpairedLineCounts = this.countUnpairedLine(n, n2);
        double d2 = Math.max((d - (double)unpairedLineCounts.nBP * 65.0) / (double)unpairedLineCounts.nLD, 0.0);
        if (bl && d2 < 30.0) {
            return false;
        }
        double d3 = 0.0;
        int n3 = n;
        while (n3 <= n2) {
            doubleArray[n3].x = double_.x + double_3.x * d3 / d;
            doubleArray[n3].y = double_.y + double_3.y * d3 / d;
            int n4 = this._listeBases.get(n3).getElementStructure();
            if (n3 < n4 && n4 < n2) {
                d3 += 65.0;
                n3 = n4;
                continue;
            }
            d3 += d2;
            ++n3;
        }
        return true;
    }

    private boolean drawOnBezierCurve(int n, int n2, Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3, Point2D.Double double_4, Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2, boolean bl) {
        UnpairedLineCounts unpairedLineCounts = this.countUnpairedLine(n, n2);
        int n3 = unpairedLineCounts.total;
        CubicBezierCurve cubicBezierCurve = new CubicBezierCurve(double_, double_2, double_3, double_4, 10 * n3);
        double d = cubicBezierCurve.getApproxCurveLength();
        double d2 = Math.max((d - (double)unpairedLineCounts.nBP * 65.0) / (double)unpairedLineCounts.nLD, 0.0);
        if (bl && d2 < 30.0) {
            return false;
        }
        double[] dArray = new double[n3 + 1];
        double d3 = 0.0;
        int n4 = 0;
        int n5 = n;
        while (n5 <= n2) {
            dArray[n4] = d3;
            ++n4;
            int n6 = this._listeBases.get(n5).getElementStructure();
            if (n5 < n6 && n6 < n2) {
                d3 += 65.0;
                n5 = n6;
                continue;
            }
            d3 += d2;
            ++n5;
        }
        Point2D.Double[] doubleArray3 = cubicBezierCurve.uniformParam(dArray);
        int n7 = 0;
        n4 = n;
        while (n4 <= n2) {
            doubleArray[n4] = doubleArray3[n7];
            n5 = this._listeBases.get(n4).getElementStructure();
            n4 = n4 < n5 && n5 < n2 ? n5 : ++n4;
            ++n7;
        }
        return true;
    }

    private void drawOnEllipse(int n, int n2, Point2D.Double double_, Point2D.Double double_2, Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2, boolean bl) {
        AffineTransform affineTransform;
        int n3;
        UnpairedLineCounts unpairedLineCounts = this.countUnpairedLine(n, n2);
        double d = 65.0 * (double)unpairedLineCounts.nBP + 40.0 * (double)unpairedLineCounts.nLD;
        double d2 = d * 2.0;
        double d3 = double_.distance(double_2) / 2.0;
        double d4 = ComputeEllipseAxis.computeEllipseAxis(d3, d2);
        if (d4 == 0.0) {
            this.drawOnStraightLine(n, n2, double_, double_2, doubleArray, doubleArray2, false);
            return;
        }
        int n4 = unpairedLineCounts.total;
        HalfEllipse halfEllipse = new HalfEllipse(d3, d4, 10 * n4);
        double d5 = halfEllipse.getApproxCurveLength();
        double d6 = Math.max((d5 - (double)unpairedLineCounts.nBP * 65.0) / (double)unpairedLineCounts.nLD, 0.0);
        double[] dArray = new double[n4 + 1];
        double d7 = 0.0;
        int n5 = 0;
        int n6 = n;
        while (n6 <= n2) {
            dArray[n5] = d7;
            ++n5;
            n3 = this._listeBases.get(n6).getElementStructure();
            if (n6 < n3 && n3 < n2) {
                d7 += 65.0;
                n6 = n3;
                continue;
            }
            d7 += d6;
            ++n6;
        }
        Point2D[] point2DArray = halfEllipse.uniformParam(dArray);
        if (bl) {
            affineTransform = new AffineTransform();
            affineTransform.scale(1.0, -1.0);
            affineTransform.transform(point2DArray, 0, point2DArray, 0, point2DArray.length);
        }
        affineTransform = HalfEllipse.matchAxisA(double_, double_2);
        affineTransform.transform(point2DArray, 0, point2DArray, 0, point2DArray.length);
        n5 = 0;
        n6 = n;
        while (n6 <= n2) {
            doubleArray[n6] = point2DArray[n5];
            n3 = this._listeBases.get(n6).getElementStructure();
            n6 = n6 < n3 && n3 < n2 ? n3 : ++n6;
            ++n5;
        }
    }

    private void drawAlongCurve(int n, int n2, Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3, Point2D.Double double_4, Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2, double[] dArray, DrawRNATemplateCurveMethod drawRNATemplateCurveMethod, boolean bl) {
        int n3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = 0;
        for (int i = n; i <= n2; ++i) {
            n3 = this._listeBases.get(i).getElementStructure();
            if (n3 < 0 || n3 > n2 || n3 < n) {
                if (n4 != 0) continue;
                arrayList.add(i);
                continue;
            }
            if (i < n3) {
                if (n4 == 0) {
                    arrayList.add(i);
                    arrayList.add(n3);
                }
                ++n4;
                continue;
            }
            --n4;
        }
        n4 = arrayList.size();
        int[] nArray = RNATemplateAlign.intArrayFromList(arrayList);
        if (n4 > 0) {
            if (drawRNATemplateCurveMethod == DrawRNATemplateCurveMethod.ALWAYS_REPLACE_BY_ELLIPSES) {
                this.drawOnEllipse(n, n2, double_, double_4, doubleArray, doubleArray2, bl);
            } else if (drawRNATemplateCurveMethod == DrawRNATemplateCurveMethod.SMART) {
                n3 = double_2 != null && double_3 != null ? (int)(this.drawOnBezierCurve(n, n2, double_, double_2, double_3, double_4, doubleArray, doubleArray2, true) ? 1 : 0) : (int)(this.drawOnStraightLine(n, n2, double_, double_4, doubleArray, doubleArray2, true) ? 1 : 0);
                if (n3 == 0) {
                    this.drawOnEllipse(n, n2, double_, double_4, doubleArray, doubleArray2, bl);
                }
            } else if (double_2 != null && double_3 != null) {
                this.drawOnBezierCurve(n, n2, double_, double_2, double_3, double_4, doubleArray, doubleArray2, false);
            } else {
                this.drawOnStraightLine(n, n2, double_, double_4, doubleArray, doubleArray2, false);
            }
        }
        for (n3 = 0; n3 < n4 - 1; ++n3) {
            int n5 = nArray[n3];
            int n6 = nArray[n3 + 1];
            if (this._listeBases.get(n5).getElementStructure() != n6) continue;
            Point2D.Double double_5 = doubleArray[n5];
            Point2D.Double double_6 = doubleArray[n6];
            double d = MiscGeom.angleFromVector(double_6.x - double_5.x, double_6.y - double_5.y);
            this.rna.drawLoop(n5, n6, (double_5.x + double_6.x) / 2.0, (double_5.y + double_6.y) / 2.0, d - 1.5707963267948966, doubleArray, doubleArray2, dArray);
            if (!bl) continue;
            Point2D.Double double_7 = new Point2D.Double(doubleArray[n6].x - doubleArray[n5].x, doubleArray[n6].y - doubleArray[n5].y);
            DrawRNATemplate.symmetric(doubleArray[n5], double_7, doubleArray, n5, n6);
            DrawRNATemplate.symmetric(doubleArray[n5], double_7, doubleArray2, n5, n6);
        }
    }

    private static void symmetric(Point2D.Double double_, Point2D.Double double_2, Point2D.Double[] doubleArray, int n, int n2) {
        double d = double_2.x * double_2.x + double_2.y * double_2.y;
        for (int i = n; i <= n2; ++i) {
            Point2D.Double double_3 = new Point2D.Double(doubleArray[i].x - double_.x, doubleArray[i].y - double_.y);
            Point2D.Double double_4 = new Point2D.Double(-(double_3.x * double_2.y * double_2.y - 2.0 * double_3.y * double_2.x * double_2.y - double_3.x * double_2.x * double_2.x) / d, (double_3.y * double_2.y * double_2.y + 2.0 * double_3.x * double_2.x * double_2.y - double_3.y * double_2.x * double_2.x) / d);
            doubleArray[i].x = double_4.x + double_.x;
            doubleArray[i].y = double_4.y + double_.y;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void computeHelixTranslations(Tree<RNANodeValueTemplate> tree, Map<RNATemplate.RNATemplateHelix, Point2D.Double> map, RNATemplateMapping rNATemplateMapping, Point2D.Double double_) {
        Object object;
        RNANodeValueTemplate rNANodeValueTemplate = tree.getValue();
        Point2D.Double double_2 = double_;
        if (rNANodeValueTemplate instanceof RNANodeValueTemplateBasePair && !map.containsKey(object = ((RNANodeValueTemplateBasePair)rNANodeValueTemplate).getHelix())) {
            void var8_10;
            map.put((RNATemplate.RNATemplateHelix)object, double_);
            if (rNATemplateMapping.getAncestor((RNATemplate.RNATemplateElement)object) != null) {
                int[] object2 = RNATemplateAlign.intArrayFromList(rNATemplateMapping.getAncestor((RNATemplate.RNATemplateElement)object));
                Arrays.sort(object2);
            } else {
                int[] nArray = new int[]{};
            }
            Point2D.Double double_3 = this.computeLengthIncreaseDelta((int[])var8_10, (RNATemplate.RNATemplateHelix)object);
            double_2 = new Point2D.Double(double_.x + double_3.x, double_.y + double_3.y);
        }
        for (Tree tree2 : tree.getChildren()) {
            this.computeHelixTranslations(tree2, map, rNATemplateMapping, double_2);
        }
    }

    private Map<RNATemplate.RNATemplateHelix, Point2D.Double> computeHelixTranslations(Tree<RNANodeValueTemplate> tree, RNATemplateMapping rNATemplateMapping) {
        HashMap<RNATemplate.RNATemplateHelix, Point2D.Double> hashMap = new HashMap<RNATemplate.RNATemplateHelix, Point2D.Double>();
        this.computeHelixTranslations(tree, hashMap, rNATemplateMapping, new Point2D.Double(0.0, 0.0));
        return hashMap;
    }

    private static class UnpairedLineCounts {
        public int nBP;
        public int nLD;
        public int total;

        private UnpairedLineCounts() {
        }
    }
}

