/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.annotations;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.VARNAConfigLoader;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HighlightRegionAnnotation
implements Serializable {
    private static final long serialVersionUID = 7087014168028684775L;
    public static final Color DEFAULT_OUTLINE_COLOR = Color.decode("#6ed86e");
    public static final Color DEFAULT_FILL_COLOR = Color.decode("#bcffdd");
    public static final double DEFAULT_RADIUS = 16.0;
    private Color _outlineColor = DEFAULT_OUTLINE_COLOR;
    private Color _fillColor = DEFAULT_FILL_COLOR;
    private double _radius = 16.0;
    private ArrayList<ModeleBase> _bases;
    public static String XML_ELEMENT_NAME = "region";
    public static String XML_VAR_OUTLINE_NAME = "outline";
    public static String XML_VAR_FILL_NAME = "fill";
    public static String XML_VAR_RADIUS_NAME = "radius";
    public static final int NUM_STEPS_ROUNDED_CORNERS = 16;

    public void toXML(TransformerHandler transformerHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", XML_VAR_OUTLINE_NAME, "CDATA", "" + XMLUtils.toHTMLNotation(this._outlineColor));
        attributesImpl.addAttribute("", "", XML_VAR_FILL_NAME, "CDATA", "" + XMLUtils.toHTMLNotation(this._fillColor));
        attributesImpl.addAttribute("", "", XML_VAR_RADIUS_NAME, "CDATA", "" + this._radius);
        transformerHandler.startElement("", "", XML_ELEMENT_NAME, attributesImpl);
        XMLUtils.toXML(transformerHandler, this._bases);
        transformerHandler.endElement("", "", XML_ELEMENT_NAME);
    }

    public HighlightRegionAnnotation(RNA rNA, int n, int n2) {
        this(rNA.getBasesBetween(n, n2));
    }

    public HighlightRegionAnnotation() {
        this(new ArrayList<ModeleBase>());
    }

    public HighlightRegionAnnotation(ArrayList<ModeleBase> arrayList) {
        this(arrayList, DEFAULT_FILL_COLOR, DEFAULT_OUTLINE_COLOR, 16.0);
    }

    public HighlightRegionAnnotation(ArrayList<ModeleBase> arrayList, Color color, Color color2, double d) {
        this._bases = arrayList;
        this._fillColor = color;
        this._outlineColor = color2;
        this._radius = d;
    }

    public HighlightRegionAnnotation clone() {
        return new HighlightRegionAnnotation(this._bases, this._fillColor, this._outlineColor, this._radius);
    }

    public int getMinIndex() {
        int n = Integer.MAX_VALUE;
        for (ModeleBase modeleBase : this._bases) {
            n = Math.min(n, modeleBase.getIndex());
        }
        return n;
    }

    public int getMaxIndex() {
        int n = Integer.MIN_VALUE;
        for (ModeleBase modeleBase : this._bases) {
            n = Math.max(n, modeleBase.getIndex());
        }
        return n;
    }

    public void setOutlineColor(Color color) {
        this._outlineColor = color;
    }

    public ArrayList<ModeleBase> getBases() {
        return this._bases;
    }

    public void setBases(ArrayList<ModeleBase> arrayList) {
        this._bases = arrayList;
    }

    public void setFillColor(Color color) {
        this._fillColor = color;
    }

    public Color getFillColor() {
        return this._fillColor;
    }

    public Color getOutlineColor() {
        return this._outlineColor;
    }

    public double getRadius() {
        return this._radius;
    }

    public void setRadius(double d) {
        this._radius = d;
    }

    private Point2D.Double symImage(Point2D.Double double_, Point2D.Double double_2) {
        return new Point2D.Double(2.0 * double_2.x - double_.x, 2.0 * double_2.y - double_.y);
    }

    private LinkedList<Point2D.Double> buildRoundedCorner(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
        LinkedList<Point2D.Double> linkedList = new LinkedList<Point2D.Double>();
        Point2D.Double double_4 = new Point2D.Double((double_.x + double_2.x) / 2.0, (double_.y + double_2.y) / 2.0);
        double d = double_.distance(double_2) / 2.0;
        double d2 = Math.atan2(double_.y - double_4.y, double_.x - double_4.x);
        double d3 = 0.18479956785822313;
        Point2D.Double double_5 = new Point2D.Double(double_4.x + d * Math.cos(d2 + 1.5707963267948966), double_4.y + d * Math.sin(d2 + 1.5707963267948966));
        if (double_5.distance(double_3) < double_.distance(double_3)) {
            d3 = -d3;
        }
        for (int i = 1; i <= 16; ++i) {
            double d4 = d2 + (double)i * d3;
            Point2D.Double double_6 = new Point2D.Double(double_4.x + d * Math.cos(d4), double_4.y + d * Math.sin(d4));
            linkedList.addLast(double_6);
        }
        return linkedList;
    }

    public GeneralPath getShape(Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2, double d) {
        Cloneable cloneable;
        int n;
        GeneralPath generalPath = new GeneralPath();
        LinkedList<Point2D.Double> linkedList = new LinkedList<Point2D.Double>();
        for (n = 0; n < this.getBases().size(); ++n) {
            double d2;
            int n2 = this.getBases().get(n).getIndex();
            int n3 = n2 - 1;
            int n4 = n2 + 1;
            cloneable = new Point2D.Double(0.0, 0.0);
            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
            Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
            if (n == 0) {
                if (n == this.getBases().size() - 1) {
                    double_ = doubleArray[n2];
                    cloneable = new Point2D.Double(double_.x + d * this.getRadius(), double_.y);
                    double_2 = new Point2D.Double(double_.x - d * this.getRadius(), double_.y);
                } else {
                    double_ = doubleArray[n2];
                    double_2 = doubleArray[n4];
                    cloneable = this.symImage(double_2, double_);
                }
            } else if (n == this.getBases().size() - 1) {
                cloneable = doubleArray[n3];
                double_ = doubleArray[n2];
                double_2 = this.symImage((Point2D.Double)cloneable, double_);
            } else {
                cloneable = doubleArray[n3];
                double_ = doubleArray[n2];
                double_2 = doubleArray[n4];
            }
            double d3 = double_2.distance(double_);
            Point2D.Double double_3 = new Point2D.Double((double_2.x - double_.x) / d3, (double_2.y - double_.y) / d3);
            Point2D.Double double_4 = new Point2D.Double(double_3.y, -double_3.x);
            double d4 = double_.distance((Point2D)cloneable);
            Point2D.Double double_5 = new Point2D.Double((double_.x - cloneable.x) / d4, (double_.y - cloneable.y) / d4);
            Point2D.Double double_6 = new Point2D.Double(double_5.y, -double_5.x);
            double d5 = new Point2D.Double(double_6.x - double_4.x, double_6.y - double_4.y).distance(new Point2D.Double(0.0, 0.0)) / 2.0;
            Point2D.Double double_7 = new Point2D.Double((double_4.x + double_6.x) / 2.0, (double_4.y + double_6.y) / 2.0);
            double d6 = double_7.distance(new Point2D.Double(0.0, 0.0));
            double_7.x /= d6;
            double_7.y /= d6;
            double d7 = d2 = d6 + d5 * d5 / d6;
            double d8 = d2;
            Point2D.Double double_8 = new Point2D.Double(double_.x + d7 * d * this.getRadius() * double_7.x, double_.y + d7 * d * this.getRadius() * double_7.y);
            Point2D.Double double_9 = new Point2D.Double(double_.x - d8 * d * this.getRadius() * double_7.x, double_.y - d8 * d * this.getRadius() * double_7.y);
            if (linkedList.size() > 0) {
                Point2D.Double double_10 = (Point2D.Double)linkedList.getLast();
                Point2D.Double double_11 = (Point2D.Double)linkedList.getFirst();
                if (double_8.distance(double_10) + double_9.distance(double_11) < double_8.distance(double_11) + double_9.distance(double_10)) {
                    linkedList.addLast(double_8);
                    linkedList.addFirst(double_9);
                    continue;
                }
                linkedList.addFirst(double_8);
                linkedList.addLast(double_9);
                continue;
            }
            linkedList.addLast(double_8);
            linkedList.addFirst(double_9);
        }
        if (this.getBases().size() == 1) {
            n = linkedList.size() / 2;
            Point2D.Double double_ = (Point2D.Double)linkedList.get(n);
            Point2D.Double double_12 = new Point2D.Double(double_.x + 1.0, double_.y);
            LinkedList<Point2D.Double> linkedList2 = this.buildRoundedCorner((Point2D.Double)linkedList.get(n - 1), (Point2D.Double)linkedList.get(n), double_12);
            linkedList.addAll(n, linkedList2);
            double_ = (Point2D.Double)linkedList.get(n);
            double_12 = new Point2D.Double(double_.x + 1.0, double_.y);
            cloneable = this.buildRoundedCorner((Point2D.Double)linkedList.get(linkedList.size() - 1), (Point2D.Double)linkedList.get(0), double_12);
            linkedList.addAll(0, (Collection<Point2D.Double>)((Object)cloneable));
        } else if (this.getBases().size() > 1) {
            n = linkedList.size() / 2;
            Point2D.Double double_ = this.symImage((Point2D.Double)linkedList.get(n), (Point2D.Double)linkedList.get(n - 1));
            LinkedList<Point2D.Double> linkedList3 = this.buildRoundedCorner((Point2D.Double)linkedList.get(n - 1), (Point2D.Double)linkedList.get(n), double_);
            linkedList.addAll(n, linkedList3);
            double_ = this.symImage(doubleArray[this.getBases().get(this.getBases().size() - 1).getIndex()], doubleArray[this.getBases().get(this.getBases().size() - 2).getIndex()]);
            LinkedList<Point2D.Double> linkedList4 = this.buildRoundedCorner((Point2D.Double)linkedList.get(linkedList.size() - 1), (Point2D.Double)linkedList.get(0), double_);
            linkedList.addAll(0, linkedList4);
        }
        if (linkedList.size() > 0) {
            Point2D.Double double_ = (Point2D.Double)linkedList.get(0);
            generalPath.moveTo((float)double_.x, (float)double_.y);
            for (int i = 1; i < linkedList.size(); ++i) {
                double_ = (Point2D.Double)linkedList.get(i);
                generalPath.lineTo((float)double_.x, (float)double_.y);
            }
            generalPath.closePath();
        }
        return generalPath;
    }

    public static HighlightRegionAnnotation parseHighlightRegionAnnotation(String string, VARNAPanel vARNAPanel) {
        try {
            String[] stringArray = string.split(":");
            String[] stringArray2 = stringArray[0].split("-");
            int n = Integer.parseInt(stringArray2[0]);
            int n2 = Integer.parseInt(stringArray2[1]);
            int n3 = vARNAPanel.getRNA().getIndexFromBaseNumber(n);
            int n4 = vARNAPanel.getRNA().getIndexFromBaseNumber(n2);
            Color color = DEFAULT_FILL_COLOR;
            Color color2 = DEFAULT_OUTLINE_COLOR;
            double d = 16.0;
            ArrayList<ModeleBase> arrayList = vARNAPanel.getRNA().getBasesBetween(n3, n4);
            if (stringArray.length > 1) {
                try {
                    String[] stringArray3 = stringArray[1].split(",");
                    for (int i = 0; i < stringArray3.length; ++i) {
                        try {
                            String[] stringArray4 = stringArray3[i].split("=");
                            String string2 = stringArray4[0].toLowerCase();
                            String string3 = stringArray4[1];
                            if (string2.equals("fill")) {
                                color = VARNAConfigLoader.getSafeColor(string3, color);
                                continue;
                            }
                            if (string2.equals("outline")) {
                                color2 = VARNAConfigLoader.getSafeColor(string3, color2);
                                continue;
                            }
                            if (!string2.equals("radius")) continue;
                            d = Double.parseDouble(string3);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return new HighlightRegionAnnotation(arrayList, color, color2, d);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String toString() {
        String string = "Highlighted region " + this.getMinIndex() + "-" + this.getMaxIndex();
        return string;
    }
}

