/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.applications.templateEditor.Connection;
import fr.orsay.lri.varna.applications.templateEditor.Couple;
import fr.orsay.lri.varna.applications.templateEditor.GraphicalTemplateElement;
import fr.orsay.lri.varna.applications.templateEditor.Helix;
import fr.orsay.lri.varna.applications.templateEditor.TemplateEditorPanelUI;
import fr.orsay.lri.varna.applications.templateEditor.TemplatePanel;
import fr.orsay.lri.varna.applications.templateEditor.UnpairedRegion;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;

public class MouseControler
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private int _granularity = 8;
    private final int HYSTERESIS_DISTANCE = 10;
    TemplatePanel _sp;
    GraphicalTemplateElement _elem;
    TemplateEditorPanelUI _ui;
    private GraphicalTemplateElement.RelativePosition _currentMode = GraphicalTemplateElement.RelativePosition.RP_OUTER;
    private boolean movingView = false;
    private Point2D.Double _clickedPos = new Point2D.Double();
    private Point _clickedPosScreen = new Point();

    public MouseControler(TemplatePanel templatePanel, TemplateEditorPanelUI templateEditorPanelUI) {
        this._sp = templatePanel;
        this._elem = null;
        this._ui = templateEditorPanelUI;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getWheelRotation() == -1) {
            this._sp.zoomIn();
        } else {
            this._sp.zoomOut();
        }
        mouseWheelEvent.consume();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Point2D.Double getLogicalMouseCoords(MouseEvent mouseEvent) {
        return new Point2D.Double((double)mouseEvent.getX() / this._sp.getScaleFactor(), (double)mouseEvent.getY() / this._sp.getScaleFactor());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.movingView = false;
        this._clickedPos = new Point2D.Double(mouseEvent.getX(), mouseEvent.getY());
        this._clickedPosScreen.x = mouseEvent.getXOnScreen();
        this._clickedPosScreen.y = mouseEvent.getYOnScreen();
        if (mouseEvent.getButton() == 2) {
            this.movingView = true;
        } else {
            Point2D.Double double_ = this.getLogicalMouseCoords(mouseEvent);
            GraphicalTemplateElement graphicalTemplateElement = this._sp.getElementAt(double_.getX(), double_.getY());
            this._sp.Unselect();
            if (graphicalTemplateElement == null) {
                if (mouseEvent.getButton() == 1 && this._ui.getSelectedTool() == TemplateEditorPanelUI.Tool.CREATE_HELIX) {
                    this._currentMode = GraphicalTemplateElement.RelativePosition.RP_EDIT_START;
                } else if (mouseEvent.getButton() == 1 && this._ui.getSelectedTool() == TemplateEditorPanelUI.Tool.CREATE_UNPAIRED) {
                    UnpairedRegion unpairedRegion = new UnpairedRegion(double_.getX(), double_.getY(), this._sp.getTemplate());
                    unpairedRegion.setDominantColor(this._sp.nextBackgroundColor());
                    this._ui.addElementUI(unpairedRegion);
                    this._sp.setSelected(unpairedRegion);
                    this._sp.repaint();
                    this._elem = unpairedRegion;
                    this._currentMode = GraphicalTemplateElement.RelativePosition.RP_EDIT_START;
                }
            } else if (mouseEvent.getButton() == 1) {
                this._currentMode = graphicalTemplateElement.getRelativePosition(double_.getX(), double_.getY());
                this._sp.setSelected(graphicalTemplateElement);
                this._elem = graphicalTemplateElement;
                switch (this._currentMode) {
                    case RP_EDIT_START: 
                    case RP_EDIT_END: 
                    case RP_EDIT_TANGENT_5: 
                    case RP_EDIT_TANGENT_3: {
                        break;
                    }
                    case RP_INNER_MOVE: {
                        break;
                    }
                    case RP_INNER_GENERAL: {
                        this._currentMode = GraphicalTemplateElement.RelativePosition.RP_INNER_MOVE;
                        break;
                    }
                    case RP_CONNECT_END3: 
                    case RP_CONNECT_END5: 
                    case RP_CONNECT_START5: 
                    case RP_CONNECT_START3: {
                        boolean bl;
                        Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> couple = this._sp.getPartner(graphicalTemplateElement, this._currentMode);
                        boolean bl2 = bl = couple != null;
                        if (bl) {
                            boolean bl3;
                            Connection connection = this._sp.getConnection(graphicalTemplateElement, this._currentMode);
                            this._ui.removeConnectionUI(connection);
                            GraphicalTemplateElement graphicalTemplateElement2 = connection._h1;
                            GraphicalTemplateElement graphicalTemplateElement3 = connection._h2;
                            boolean bl4 = graphicalTemplateElement2 instanceof Helix;
                            boolean bl5 = graphicalTemplateElement2 instanceof UnpairedRegion;
                            boolean bl6 = graphicalTemplateElement3 instanceof Helix;
                            boolean bl7 = graphicalTemplateElement3 instanceof UnpairedRegion;
                            boolean bl8 = bl3 = graphicalTemplateElement2 == graphicalTemplateElement;
                            if (bl5 && bl6) {
                                bl3 = false;
                            }
                            if (bl3) {
                                this._elem = graphicalTemplateElement3;
                                this._currentMode = connection._edge2;
                            } else if (!bl3) {
                                this._elem = graphicalTemplateElement2;
                                this._currentMode = connection._edge1;
                            }
                        }
                        if (this._elem instanceof Helix) {
                            this._sp.setPointerPos(new Point2D.Double(double_.getX(), double_.getY()));
                            this._sp.setSelectedEdge(this._currentMode);
                        }
                        this._sp.setSelected(this._elem);
                        break;
                    }
                    case RP_OUTER: {
                        this._sp.Unselect();
                        this._elem = null;
                    }
                }
                this._sp.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.movingView = false;
        Point2D.Double double_ = this.getLogicalMouseCoords(mouseEvent);
        if (this._elem != null) {
            switch (this._currentMode) {
                case RP_EDIT_START: 
                case RP_EDIT_END: {
                    Helix helix;
                    if (!(this._elem instanceof Helix) || !((helix = (Helix)this._elem).getPos().distance(helix.getExtent()) < 10.0)) break;
                    this._ui.removeElementUI(this._elem);
                    this._sp.Unselect();
                    break;
                }
                case RP_INNER_MOVE: {
                    break;
                }
                case RP_CONNECT_END3: 
                case RP_CONNECT_END5: 
                case RP_CONNECT_START5: 
                case RP_CONNECT_START3: {
                    GraphicalTemplateElement graphicalTemplateElement = this._sp.getElementAt(double_.getX(), double_.getY(), this._elem);
                    if (graphicalTemplateElement != null) {
                        GraphicalTemplateElement.RelativePosition relativePosition = graphicalTemplateElement.getClosestEdge(double_.getX(), double_.getY());
                        this._ui.addConnectionUI(this._elem, this._currentMode, graphicalTemplateElement, relativePosition);
                    }
                    this._sp.setSelectedEdge(GraphicalTemplateElement.RelativePosition.RP_OUTER);
                }
            }
            this._elem = null;
            this._sp.rescale();
        }
        this._sp.setSelectedEdge(GraphicalTemplateElement.RelativePosition.RP_OUTER);
        this._currentMode = GraphicalTemplateElement.RelativePosition.RP_OUTER;
        this._sp.repaint();
    }

    private Point2D.Double projectPoint(double d, double d2, Point2D.Double double_) {
        Point2D.Double double_2 = new Point2D.Double();
        double d3 = d - double_.x;
        double d4 = d2 - double_.y;
        double d5 = Double.MIN_VALUE;
        for (int i = 0; i < this._granularity; ++i) {
            double d6;
            double d7 = Math.PI * 2 * ((double)i / (double)this._granularity);
            double d8 = Math.cos(d7);
            double d9 = d3 * d8 + d4 * (d6 = Math.sin(d7));
            if (!(d9 > d5)) continue;
            d5 = d9;
            double_2.x = double_.x + d8 * d9;
            double_2.y = double_.y + d6 * d9;
        }
        return double_2;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.movingView) {
            Point point = new Point(mouseEvent.getXOnScreen() - this._clickedPosScreen.x, mouseEvent.getYOnScreen() - this._clickedPosScreen.y);
            this._sp.translateView(point);
            this._clickedPosScreen.x = mouseEvent.getXOnScreen();
            this._clickedPosScreen.y = mouseEvent.getYOnScreen();
        } else {
            Point2D.Double double_ = this.getLogicalMouseCoords(mouseEvent);
            if (this._elem == null) {
                switch (this._currentMode) {
                    case RP_EDIT_START: {
                        if (!(this._clickedPos.distance(mouseEvent.getX(), mouseEvent.getY()) > 10.0)) break;
                        System.out.println("Creating Helix...");
                        Helix helix = new Helix(double_.getX(), double_.getY(), this._sp.getTemplate(), this._sp.getRNAComponents());
                        helix.setDominantColor(this._sp.nextBackgroundColor());
                        this._ui.addElementUI(helix);
                        this._sp.setSelected(helix);
                        this._sp.repaint();
                        this._elem = helix;
                    }
                }
            } else if (this._elem instanceof Helix) {
                Helix helix = (Helix)this._elem;
                switch (this._currentMode) {
                    case RP_EDIT_START: {
                        Point2D.Double double_2 = this.projectPoint(double_.getX(), double_.getY(), helix.getPos());
                        this._ui.setHelixExtentUI(helix, double_2.x, double_2.y);
                        break;
                    }
                    case RP_EDIT_END: {
                        Point2D.Double double_3 = this.projectPoint(double_.getX(), double_.getY(), helix.getExtent());
                        this._ui.setHelixPosUI(helix, double_3.x, double_3.y);
                        break;
                    }
                    case RP_INNER_MOVE: {
                        this._ui.moveHelixUI(helix, double_.getX(), double_.getY());
                        break;
                    }
                    case RP_CONNECT_END3: 
                    case RP_CONNECT_END5: 
                    case RP_CONNECT_START5: 
                    case RP_CONNECT_START3: {
                        this._sp.setPointerPos(new Point2D.Double(double_.getX(), double_.getY()));
                        this._sp.repaint();
                    }
                }
            } else if (this._elem instanceof UnpairedRegion) {
                UnpairedRegion unpairedRegion = (UnpairedRegion)this._elem;
                Point2D.Double double_4 = new Point2D.Double(double_.getX(), double_.getY());
                switch (this._currentMode) {
                    case RP_EDIT_TANGENT_5: {
                        this._ui.setEdge5TangentUI(unpairedRegion, double_.getX(), double_.getY());
                        this._sp.repaint();
                        break;
                    }
                    case RP_EDIT_TANGENT_3: {
                        this._ui.setEdge3TangentUI(unpairedRegion, double_.getX(), double_.getY());
                        this._sp.repaint();
                        break;
                    }
                    case RP_INNER_MOVE: {
                        this._ui.moveUnpairedUI(unpairedRegion, double_.getX(), double_.getY());
                        this._sp.repaint();
                        break;
                    }
                    case RP_CONNECT_START5: {
                        this._ui.setEdge5UI(unpairedRegion, double_.getX(), double_.getY());
                        break;
                    }
                    case RP_CONNECT_END3: {
                        this._ui.setEdge3UI(unpairedRegion, double_.getX(), double_.getY());
                    }
                }
                this._sp.repaint();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

