/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.objects.utils.trees;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.objects.core.Treenode;
import uk.ac.vamsas.objects.core.Vref;
import uk.ac.vamsas.objects.utils.trees.BinaryNode;
import uk.ac.vamsas.objects.utils.trees.SequenceNode;

public class NewickFile {
    SequenceNode root;
    private boolean HasBootstrap = false;
    private boolean HasDistances = false;
    private boolean RootHasDistance = false;
    boolean ReplaceUnderscores = true;
    boolean printRootInfo = true;
    private Pattern[] NodeSafeName = new Pattern[]{Pattern.compile("[\\[,:'()]"), Pattern.compile("'"), Pattern.compile("\\s")};
    char QuoteChar = (char)39;
    String newickFile = null;
    boolean error;
    String errormessage;
    BufferedReader dataIn = null;

    public NewickFile(String inStr) throws IOException {
        this.newickFile = inStr;
        this.parse();
    }

    public NewickFile(File inFile) throws IOException {
        this.errormessage = "Problem's reading file " + inFile;
        this.dataIn = new BufferedReader(new InputStreamReader(new FileInputStream(inFile)));
        this.parse();
    }

    public NewickFile(SequenceNode newtree) {
        this.root = newtree;
    }

    public NewickFile(SequenceNode newtree, boolean bootstrap) {
        this.HasBootstrap = bootstrap;
        this.root = newtree;
    }

    public NewickFile(SequenceNode newtree, boolean bootstrap, boolean distances) {
        this.root = newtree;
        this.HasBootstrap = bootstrap;
        this.HasDistances = distances;
    }

    public NewickFile(SequenceNode newtree, boolean bootstrap, boolean distances, boolean rootdistance) {
        this.root = newtree;
        this.HasBootstrap = bootstrap;
        this.HasDistances = distances;
        this.RootHasDistance = rootdistance;
    }

    private String ErrorStringrange(String Error2, String Er, int r, int p, String s) {
        return (Error2 == null ? "" : Error2) + Er + " at position " + p + " ( " + s.substring(p - r < 0 ? 0 : p - r, p + r > s.length() ? s.length() : p + r) + " )\n";
    }

    public boolean HasBootstrap() {
        return this.HasBootstrap;
    }

    public boolean HasDistances() {
        return this.HasDistances;
    }

    public boolean HasRootDistance() {
        return this.RootHasDistance;
    }

    public String nextLine() throws IOException {
        if (this.dataIn == null && this.newickFile == null) {
            throw new IOException("IMPLEMENTATION ERROR: NewickFile has not been initialised for reading a newick string.");
        }
        if (this.dataIn == null) {
            this.dataIn = new BufferedReader(new StringReader(this.newickFile));
            this.error = false;
        }
        if (!this.error) {
            return this.dataIn.readLine();
        }
        throw new IOException("Invalid Source Stream:" + this.errormessage);
    }

    public void parse() throws IOException {
        String nf;
        if (this.newickFile == null) {
            StringBuffer file = new StringBuffer();
            while ((nf = this.nextLine()) != null) {
                file.append(nf);
            }
            nf = file.toString();
        } else {
            nf = this.newickFile;
        }
        this.root = new SequenceNode();
        SequenceNode realroot = null;
        SequenceNode c = this.root;
        int d = -1;
        int cp = 0;
        String Error2 = null;
        String nodename = null;
        float DefDistance = 0.001f;
        int DefBootstrap = -1;
        float distance = DefDistance;
        int bootstrap = DefBootstrap;
        boolean ascending = false;
        Pattern majorsyms = Pattern.compile("[(\\['),;]");
        Matcher mjsyms = majorsyms.matcher(nf);
        int nextcp = 0;
        int ncp = cp;
        block9: while (mjsyms.find(cp) && Error2 == null) {
            int fcp = mjsyms.start();
            char schar = nf.charAt(fcp);
            switch (schar) {
                case '(': {
                    if (ascending) {
                        Error2 = this.ErrorStringrange(Error2, "Unexpected '('", 7, fcp, nf);
                        continue block9;
                    }
                    ++d;
                    if (c.right() == null) {
                        c.setRight(new SequenceNode(null, c, null, DefDistance, DefBootstrap, false));
                        c = (SequenceNode)c.right();
                    } else {
                        if (c.left() != null) {
                            SequenceNode tmpn = new SequenceNode(null, c, null, 0.0f, 0, true);
                            tmpn.SetChildren(c.left(), c.right());
                            c.setRight(tmpn);
                        }
                        c.setLeft(new SequenceNode(null, c, null, DefDistance, DefBootstrap, false));
                        c = (SequenceNode)c.left();
                    }
                    if (realroot == null) {
                        realroot = c;
                    }
                    nodename = null;
                    distance = DefDistance;
                    bootstrap = DefBootstrap;
                    cp = fcp + 1;
                    break;
                }
                case '\'': {
                    Matcher qnodename = Pattern.compile("([^']|'')+'").matcher(nf);
                    if (qnodename.find(fcp)) {
                        nodename = new String(qnodename.group(1));
                        cp = qnodename.end(0);
                        break;
                    }
                    Error2 = this.ErrorStringrange(Error2, "Unterminated quotes for nodename", 7, fcp, nf);
                    break;
                }
                default: {
                    Matcher nbootstrap;
                    if (schar == ';' && d != -1) {
                        Error2 = this.ErrorStringrange(Error2, "Wayward semicolon (depth=" + d + ")", 7, fcp, nf);
                    }
                    if (schar == '[') {
                        nextcp = nf.indexOf(93, fcp);
                        if (nextcp > -1) {
                            ++nextcp;
                            break;
                        }
                        Error2 = this.ErrorStringrange(Error2, "Unterminated comment", 3, fcp, nf);
                        nextcp = 0;
                        break;
                    }
                    String fstring = nf.substring(ncp, fcp);
                    while (fstring.indexOf(93) > -1) {
                        int cstart = fstring.indexOf(91);
                        int cend = fstring.indexOf(93);
                        String comment = fstring.substring(cstart + 1, cend);
                        fstring = fstring.substring(0, cstart) + fstring.substring(cend + 1);
                    }
                    Matcher uqnodename = Pattern.compile("^([^' :;\\](),]+).*").matcher(fstring);
                    if (uqnodename.matches() && (uqnodename.start(1) == 0 || fstring.charAt(uqnodename.start(1) - 1) != ':')) {
                        if (nodename == null) {
                            nodename = this.ReplaceUnderscores ? uqnodename.group(1).replace('_', ' ') : uqnodename.group(1);
                        } else {
                            Error2 = this.ErrorStringrange(Error2, "File has broken algorithm - overwritten nodename", 10, fcp, nf);
                        }
                    }
                    if ((nbootstrap = Pattern.compile("\\s*([+0-9]+)\\s*:.*").matcher(fstring)).matches()) {
                        if (nodename != null && nbootstrap.group(1).equals(nodename)) {
                            nodename = null;
                        }
                        if (nodename == null || nodename.length() == 0 || nbootstrap.start(1) >= uqnodename.end(1)) {
                            try {
                                bootstrap = new Integer(nbootstrap.group(1));
                                this.HasBootstrap = true;
                            }
                            catch (Exception e) {
                                Error2 = this.ErrorStringrange(Error2, "Can't parse bootstrap value", 4, ncp + nbootstrap.start(0), nf);
                            }
                        }
                    }
                    Matcher ndist = Pattern.compile(".*:([-0-9Ee.+]+)").matcher(fstring);
                    boolean nodehasdistance = false;
                    if (ndist.matches()) {
                        try {
                            distance = new Float(ndist.group(1)).floatValue();
                            this.HasDistances = true;
                            nodehasdistance = true;
                        }
                        catch (Exception e) {
                            Error2 = this.ErrorStringrange(Error2, "Can't parse node distance value", 7, ncp + ndist.start(0), nf);
                        }
                    }
                    if (ascending) {
                        c.setName(nodename);
                        c.dist = this.HasDistances ? distance : DefDistance;
                        c.setBootstrap(this.HasBootstrap ? bootstrap : DefBootstrap);
                        if (c == realroot) {
                            this.RootHasDistance = nodehasdistance;
                        }
                    } else {
                        SequenceNode newnode = new SequenceNode(null, c, nodename, this.HasDistances ? distance : DefDistance, this.HasBootstrap ? bootstrap : DefBootstrap, false);
                        if (c.right() == null) {
                            c.setRight(newnode);
                        } else if (c.left() == null) {
                            c.setLeft(newnode);
                        } else {
                            SequenceNode newdummy = new SequenceNode(null, c, null, this.HasDistances ? 0.0f : DefDistance, 0, true);
                            newdummy.SetChildren(c.left(), newnode);
                            c.setLeft(newdummy);
                        }
                    }
                    if (ascending) {
                        c = c.AscendTree();
                        if (d > -1 && c == null) {
                            Error2 = this.ErrorStringrange(Error2, "File broke algorithm: Lost place in tree (is there an extra ')' ?)", 7, fcp, nf);
                        }
                    }
                    if (nf.charAt(fcp) == ')') {
                        --d;
                        ascending = true;
                    } else if (nf.charAt(fcp) == ',') {
                        if (ascending) {
                            ascending = false;
                        } else if (c.left() != null && !c.left().isLeaf()) {
                            c = (SequenceNode)c.left();
                        }
                    }
                    nodename = null;
                    distance = DefDistance;
                    bootstrap = DefBootstrap;
                }
            }
            if (nextcp == 0) {
                ncp = cp = fcp + 1;
                continue;
            }
            cp = nextcp;
            nextcp = 0;
        }
        if (Error2 != null) {
            throw new IOException("NewickFile: " + Error2 + "\n");
        }
        this.root = (SequenceNode)this.root.right().detach();
        if (!this.RootHasDistance) {
            this.root.dist = this.HasDistances ? 0.0f : DefDistance;
        }
    }

    public SequenceNode getTree() {
        return this.root;
    }

    public Treenode[] matchTreeNodeNames(String[] names, Vobject[] boundObjects) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String print() {
        NewickFile newickFile = this;
        synchronized (newickFile) {
            StringBuffer tf = new StringBuffer();
            this.print(tf, this.root);
            return tf.append(";").toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String print(boolean withbootstraps) {
        NewickFile newickFile = this;
        synchronized (newickFile) {
            boolean boots = this.HasBootstrap;
            this.HasBootstrap = withbootstraps;
            String rv = this.print();
            this.HasBootstrap = boots;
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String print(boolean withbootstraps, boolean withdists) {
        NewickFile newickFile = this;
        synchronized (newickFile) {
            boolean dists = this.HasDistances;
            this.HasDistances = withdists;
            String rv = this.print(withbootstraps);
            this.HasDistances = dists;
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String print(boolean withbootstraps, boolean withdists, boolean printRootInfo) {
        NewickFile newickFile = this;
        synchronized (newickFile) {
            boolean rootinfo = printRootInfo;
            this.printRootInfo = printRootInfo;
            String rv = this.print(withbootstraps, withdists);
            this.printRootInfo = rootinfo;
            return rv;
        }
    }

    char getQuoteChar() {
        return this.QuoteChar;
    }

    char setQuoteChar(char c) {
        char old = this.QuoteChar;
        this.QuoteChar = c;
        return old;
    }

    private String nodeName(String name) {
        if (this.NodeSafeName[0].matcher(name).find()) {
            return this.QuoteChar + this.NodeSafeName[1].matcher(name).replaceAll("''") + this.QuoteChar;
        }
        return this.NodeSafeName[2].matcher(name).replaceAll("_");
    }

    private String printNodeField(SequenceNode c) {
        return (c.getName() == null ? "" : this.nodeName(c.getName())) + (this.HasBootstrap ? (c.getBootstrap() > -1 ? (c.getName() == null ? " " : "") + c.getBootstrap() : "") : "") + (this.HasDistances ? ":" + c.dist : "");
    }

    private String printRootField(SequenceNode root) {
        return this.printRootInfo ? (root.getName() == null ? "" : this.nodeName(root.getName())) + (this.HasBootstrap ? (root.getBootstrap() > -1 ? (root.getName() != null ? " " : "") + root.getBootstrap() : "") : "") + (this.RootHasDistance ? ":" + root.dist : "") : "";
    }

    public void print(StringBuffer tf, SequenceNode root) {
        if (root != null) {
            if (root.isLeaf() && this.printRootInfo) {
                tf.append(this.printRootField(root));
            } else if (root.isDummy()) {
                this._print(tf, (SequenceNode)root.right());
                this._print(tf, (SequenceNode)root.left());
            } else {
                tf.append("(");
                this._print(tf, (SequenceNode)root.right());
                if (root.left() != null) {
                    tf.append(",");
                }
                this._print(tf, (SequenceNode)root.left());
                tf.append(")" + this.printRootField(root));
            }
        }
    }

    public void _print(StringBuffer tf, SequenceNode c) {
        if (c != null) {
            if (c.isLeaf()) {
                tf.append(this.printNodeField(c));
            } else if (c.isDummy()) {
                this._print(tf, (SequenceNode)c.left());
                if (c.left() != null) {
                    tf.append(",");
                }
                this._print(tf, (SequenceNode)c.right());
            } else {
                tf.append("(");
                this._print(tf, (SequenceNode)c.right());
                if (c.left() != null) {
                    tf.append(",");
                }
                this._print(tf, (SequenceNode)c.left());
                tf.append(")" + this.printNodeField(c));
            }
        }
    }

    public static void main(String[] args) {
        try {
            String l;
            if (args == null || args.length != 1) {
                System.err.println("Takes one argument - file name of a newick tree file.");
                System.exit(0);
            }
            File fn = new File(args[0]);
            StringBuffer newickfile = new StringBuffer();
            BufferedReader treefile = new BufferedReader(new FileReader(fn));
            while ((l = treefile.readLine()) != null) {
                newickfile.append(l);
            }
            treefile.close();
            System.out.println("Read file :\n");
            NewickFile trf = new NewickFile(fn);
            System.out.println("Original file :\n");
            System.out.println(Pattern.compile("\n+").matcher(newickfile.toString()).replaceAll("") + "\n");
            System.out.println("Parsed file.\n");
            System.out.println("Default output type for original input.\n");
            System.out.println(trf.print());
            System.out.println("Without bootstraps.\n");
            System.out.println(trf.print(false));
            System.out.println("Without distances.\n");
            System.out.println(trf.print(true, false));
            System.out.println("Without bootstraps but with distanecs.\n");
            System.out.println(trf.print(false, true));
            System.out.println("Without bootstraps or distanecs.\n");
            System.out.println(trf.print(false, false));
            System.out.println("With bootstraps and with distances.\n");
            System.out.println(trf.print(true, true));
            System.out.println("leaves.\n");
            Vector lvs = new Vector();
            trf.findLeaves(trf.root, lvs);
            Enumeration lv = lvs.elements();
            while (lv.hasMoreElements()) {
                BinaryNode leave = (BinaryNode)lv.nextElement();
                if (leave.getName() == null) continue;
                System.out.println("Node:'" + leave.getName() + "'");
            }
        }
        catch (IOException e) {
            System.err.println("Exception\n" + e);
            e.printStackTrace();
        }
    }

    public Vector findLeaves(SequenceNode node, Vector leaves) {
        if (node == null) {
            return leaves;
        }
        if (node.left() == null && node.right() == null) {
            leaves.addElement(node);
            return leaves;
        }
        this.findLeaves((SequenceNode)node.left(), leaves);
        this.findLeaves((SequenceNode)node.right(), leaves);
        return leaves;
    }

    public Treenode[] makeTreeNodes() {
        return this.makeTreeNodes(true);
    }

    public Treenode[] makeTreeNodes(boolean ignoreplaceholders) {
        Vector leaves = new Vector();
        this.findLeaves(this.root, leaves);
        Vector<Treenode> tnv = new Vector<Treenode>();
        Enumeration l = leaves.elements();
        Hashtable nodespecs = new Hashtable();
        while (l.hasMoreElements()) {
            Vobject assocseq;
            BinaryNode tnode = (BinaryNode)l.nextElement();
            if (!(tnode instanceof SequenceNode) || ignoreplaceholders && ((SequenceNode)tnode).isPlaceholder() || !((assocseq = ((SequenceNode)tnode).element()) instanceof Vobject)) continue;
            Vobject vobj = assocseq;
            if (vobj != null) {
                Treenode node = new Treenode();
                node.setNodespec(this.makeNodeSpec(nodespecs, tnode));
                node.setName(tnode.getName());
                Vref vr = new Vref();
                vr.addRefs(vobj);
                node.addVref(vr);
                tnv.addElement(node);
                continue;
            }
            System.err.println("WARNING: Unassociated treeNode " + tnode.element().toString() + " " + (tnode.getName() != null ? " label " + tnode.getName() : ""));
        }
        if (tnv.size() > 0) {
            Object[] tn = new Treenode[tnv.size()];
            tnv.copyInto(tn);
            return tn;
        }
        return new Treenode[0];
    }

    private String makeNodeSpec(Hashtable nodespecs, BinaryNode tnode) {
        String nname = new String(tnode.getName());
        Integer nindx = (Integer)nodespecs.get(nname);
        if (nindx == null) {
            nindx = new Integer(1);
        }
        nname = nindx.toString() + " " + nname;
        return nname;
    }

    private BinaryNode findNodeSpec(String nodespec, Vector leaves) {
        int occurence = -1;
        String nspec = nodespec.substring(nodespec.indexOf(32) + 1);
        String oval = nodespec.substring(0, nodespec.indexOf(32));
        try {
            occurence = new Integer(oval);
        }
        catch (Exception e) {
            System.err.println("Invalid nodespec '" + nodespec + "'");
            return null;
        }
        BinaryNode bn = null;
        int nocc = 0;
        Enumeration en = leaves.elements();
        while (en.hasMoreElements() && nocc < occurence) {
            bn = (BinaryNode)en.nextElement();
            if (bn instanceof SequenceNode && bn.getName().equals(nspec)) {
                --occurence;
                continue;
            }
            bn = null;
        }
        return bn;
    }

    public Vector attachTreeMap(Treenode[] tn) {
        if (this.root != null || tn == null) {
            return null;
        }
        Vector leaves = new Vector();
        Vector<Object[]> nodemap = new Vector<Object[]>();
        this.findLeaves(this.root, leaves);
        int sz = tn.length;
        int i = 0;
        while (i < sz) {
            Treenode node;
            BinaryNode mappednode;
            if ((mappednode = this.findNodeSpec((node = tn[i++]).getNodespec(), leaves)) == null || !(mappednode instanceof SequenceNode)) continue;
            SequenceNode leaf = (SequenceNode)leaves.elementAt(i++);
            Vobject noderef = null;
            int vrf = 0;
            int refv = 0;
            while (noderef == null && vrf < node.getVrefCount()) {
                if (refv < node.getVref(vrf).getRefsCount()) {
                    Object ref = node.getVref(vrf).getRefs(refv++);
                    if (!(ref instanceof Vobject)) continue;
                    noderef = (Vobject)ref;
                    continue;
                }
                refv = 0;
                ++vrf;
            }
            if (noderef != null) {
                nodemap.addElement(new Object[]{node, leaf, noderef});
                leaf.setElement(noderef);
                leaf.setPlaceholder(false);
                continue;
            }
            leaf.setPlaceholder(true);
        }
        return nodemap;
    }
}

