/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import uk.ac.vamsas.client.SessionHandle;
import uk.ac.vamsas.client.simpleclient.FileWatcher;
import uk.ac.vamsas.client.simpleclient.SessionUrn;
import uk.ac.vamsas.client.simpleclient.SessionsFile;
import uk.ac.vamsas.client.simpleclient.SimpleSessionHandle;

public class SimpleSessionManager {
    private SessionsFile sessionFile = null;

    protected SimpleSessionManager(File sessionsFile) throws IOException {
        this.initManagerObjects(sessionsFile);
    }

    private void initManagerObjects(File sessionsFile) throws IOException {
        if (this.sessionFile != null) {
            throw new IOException("initFactoryObjects called for initialised ClientFactory object.");
        }
        this.sessionFile = new SessionsFile(sessionsFile);
    }

    public FileWatcher getSessionsWatcher() {
        return new FileWatcher(this.getSessionFile().sessionFile);
    }

    public String[] getCurrentSessions() {
        SimpleSessionHandle[] sessionHandles;
        String[] sessions = null;
        if (this.sessionFile != null && (sessionHandles = this.sessionFile.retrieveSessionsList()) != null) {
            sessions = new String[sessionHandles.length];
            for (int i = sessionHandles.length - 1; i > -1; --i) {
                SimpleSessionHandle sessionHandle = sessionHandles[i];
                sessions[i] = sessionHandle.getSessionUrn();
            }
        }
        return sessions;
    }

    public SimpleSessionHandle[] getSessionFor(SessionUrn urn) {
        ArrayList<SimpleSessionHandle> sessions = new ArrayList<SimpleSessionHandle>();
        if (this.sessionFile != null) {
            SessionHandle pattern = new SessionHandle(urn.getSessionUrn());
            SimpleSessionHandle[] sessionHandles = this.sessionFile.retrieveSessionsList();
            if (sessionHandles != null) {
                for (int i = sessionHandles.length - 1; i > -1; --i) {
                    SimpleSessionHandle sessionHandle = sessionHandles[i];
                    if (!sessionHandle.equals(pattern)) continue;
                    sessions.add(sessionHandle);
                }
            }
        }
        if (sessions.size() > 0) {
            SimpleSessionHandle[] sh = new SimpleSessionHandle[sessions.size()];
            sessions.toArray(sh);
            return sh;
        }
        return null;
    }

    public int addSession(SimpleSessionHandle newSession) {
        return this.sessionFile.addSession(newSession, false, this.getSessionsWatcher().getChangedState());
    }

    private SessionsFile getSessionFile() {
        return this.sessionFile;
    }

    protected void removeSession(SessionHandle session) {
        this.getSessionFile().removeSession(session, this.getSessionsWatcher().getChangedState());
    }
}

