/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.client.VorbaIdFactory;
import uk.ac.vamsas.client.VorbaXmlBinder;
import uk.ac.vamsas.client.simpleclient.VamsasArchiveReader;
import uk.ac.vamsas.objects.core.VAMSAS;
import uk.ac.vamsas.objects.core.VamsasDocument;
import uk.ac.vamsas.objects.utils.AppDataReference;
import uk.ac.vamsas.objects.utils.DocumentStuff;
import uk.ac.vamsas.objects.utils.ProvenanceStuff;

public class SimpleDocBinding {
    protected VorbaIdFactory vorba;
    protected static Log log = LogFactory.getLog((Class)SimpleDocBinding.class);

    public VorbaIdFactory getVorba() {
        return this.vorba;
    }

    public void setVorba(VorbaIdFactory vorba) {
        this.vorba = vorba;
    }

    public VamsasDocument getVamsasDocument(VamsasArchiveReader oReader) throws IOException, MarshalException, ValidationException {
        if (oReader != null) {
            if (this.vorba == null) {
                log.error((Object)"Invalid SimpleDocument construction - no VorbaIdFactory defined!");
                return null;
            }
            if (oReader.isValid()) {
                VamsasDocument doc;
                Vobject vobjs;
                InputStreamReader vdoc = new InputStreamReader(oReader.getVamsasDocumentStream());
                Object[] unmarsh = VorbaXmlBinder.getVamsasObjects(vdoc, this.vorba, new VamsasDocument());
                if (unmarsh == null) {
                    log.fatal((Object)"Couldn't unmarshall document!");
                }
                if ((vobjs = (Vobject)unmarsh[0]) != null && (doc = (VamsasDocument)vobjs) != null) {
                    return doc;
                }
                log.debug((Object)"Found no VamsasDocument object in properly formatted Vamsas Archive.");
            } else {
                InputStream vxmlis = oReader.getVamsasXmlStream();
                if (vxmlis != null) {
                    BufferedInputStream ixml = new BufferedInputStream(oReader.getVamsasXmlStream());
                    InputStreamReader vxml = new InputStreamReader(ixml);
                    Object[] unmarsh = VorbaXmlBinder.getVamsasObjects(vxml, this.vorba, new VAMSAS());
                    if (unmarsh == null) {
                        log.fatal((Object)"Couldn't unmarshall document!");
                    }
                    VAMSAS[] root = new VAMSAS[]{null};
                    root[0] = (VAMSAS)unmarsh[0];
                    if (root[0] == null) {
                        log.debug((Object)"Found no VAMSAS object in VamsasXML stream.");
                    } else {
                        log.debug((Object)"Making new VamsasDocument from VamsasXML stream.");
                        VamsasDocument doc = DocumentStuff.newVamsasDocument(root, ProvenanceStuff.newProvenance(this.vorba.getUserHandle().getFullName(), "Vamsas Document constructed from vamsas.xml"), "alpha");
                        root[0] = null;
                        root = null;
                        return doc;
                    }
                }
            }
        }
        return null;
    }

    public Vector getReferencedEntries(VamsasDocument doc, VamsasArchiveReader oReader) {
        Vector docrefs;
        if (oReader == null) {
            return null;
        }
        if (doc == null) {
            try {
                doc = this.getVamsasDocument(oReader);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to get document from " + oReader.jfileName));
            }
        }
        if ((docrefs = AppDataReference.getAppDataReferences(doc)) == null) {
            return null;
        }
        Vector entries = oReader.getExtraEntries();
        if (entries != null && entries.size() > 0 && docrefs.size() > 0) {
            int i = 0;
            int j = entries.size();
            do {
                if (!docrefs.contains(entries.get(i))) {
                    entries.remove(i);
                    --j;
                    continue;
                }
                ++i;
            } while (i < j);
        }
        return entries;
    }
}

