/*
 * Decompiled with CFR 0.152.
 */
package mc_view;

import jalview.analysis.AlignSeq;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.Mapping;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ResidueProperties;
import jalview.structure.StructureImportSettings;
import jalview.structure.StructureMapping;
import jalview.util.Comparison;
import java.awt.Color;
import java.util.List;
import java.util.Vector;
import mc_view.Atom;
import mc_view.Bond;
import mc_view.Residue;

public class PDBChain {
    public static final String RESNUM_FEATURE = "RESNUM";
    private static final String IEASTATUS = "IEA:jalview";
    public String id;
    public Vector<Bond> bonds = new Vector();
    public Vector<Atom> atoms = new Vector();
    public Vector<Residue> residues = new Vector();
    public int offset;
    public SequenceI sequence;
    public SequenceI shadow = null;
    public boolean isNa = false;
    public boolean isVisible = true;
    public int pdbstart = 0;
    public int pdbend = 0;
    public int seqstart = 0;
    public int seqend = 0;
    public String pdbid = "";
    protected String newline = System.getProperty("line.separator");
    public Mapping shadowMap;

    public PDBChain(String thePdbid, String theId) {
        this.pdbid = thePdbid == null ? thePdbid : thePdbid.toLowerCase();
        this.id = theId;
    }

    public void setNewlineString(String nl) {
        this.newline = nl;
    }

    public String getNewlineString() {
        return this.newline;
    }

    public String print() {
        StringBuilder tmp = new StringBuilder(256);
        for (Bond b : this.bonds) {
            tmp.append(b.at1.resName).append(" ").append(b.at1.resNumber).append(" ").append(this.offset).append(this.newline);
        }
        return tmp.toString();
    }

    public void makeExactMapping(AlignSeq as, SequenceI s1) {
        int pdbpos = as.getSeq2Start() - 2;
        int alignpos = s1.getStart() + as.getSeq1Start() - 3;
        for (Atom atom : this.atoms) {
            atom.alignmentMapping = -1;
        }
        for (int i = 0; i < as.astr1.length(); ++i) {
            boolean sameResidue;
            if (as.astr1.charAt(i) != '-') {
                ++alignpos;
            }
            if (as.astr2.charAt(i) != '-') {
                ++pdbpos;
            }
            if (!(sameResidue = Comparison.isSameResidue(as.astr1.charAt(i), as.astr2.charAt(i), false)) || pdbpos >= this.residues.size()) continue;
            Residue res = this.residues.elementAt(pdbpos);
            for (Atom atom : res.atoms) {
                atom.alignmentMapping = alignpos;
            }
        }
    }

    public void makeExactMapping(StructureMapping mapping, SequenceI s1) {
        for (Atom atom : this.atoms) {
            atom.alignmentMapping = -1;
        }
        SequenceI ds = s1;
        while (ds.getDatasetSequence() != null) {
            ds = ds.getDatasetSequence();
        }
        int pdboffset = 0;
        for (Residue res : this.residues) {
            char seqchar;
            boolean sameResidue;
            int seqpos = mapping.getSeqPos(res.atoms.get((int)0).resNumber);
            char strchar = this.sequence.getCharAt(pdboffset++);
            if (seqpos == Integer.MIN_VALUE || !(sameResidue = Comparison.isSameResidue(seqchar = ds.getCharAt(seqpos - ds.getStart()), strchar, false))) continue;
            for (Atom atom : res.atoms) {
                atom.alignmentMapping = seqpos - 1;
            }
        }
    }

    public void transferRESNUMFeatures(SequenceI seq, String status) {
        SequenceI sq = seq;
        while (sq != null && sq.getDatasetSequence() != null) {
            if ((sq = sq.getDatasetSequence()) != this.sequence) continue;
            return;
        }
        if (status == null) {
            status = IEASTATUS;
        }
        List<SequenceFeature> features = this.sequence.getSequenceFeatures();
        for (SequenceFeature feature : features) {
            if (feature.getFeatureGroup() == null || !feature.getFeatureGroup().equals(this.pdbid)) continue;
            int newBegin = 1 + this.residues.elementAt((int)(feature.getBegin() - this.offset)).atoms.elementAt((int)0).alignmentMapping;
            int newEnd = 1 + this.residues.elementAt((int)(feature.getEnd() - this.offset)).atoms.elementAt((int)0).alignmentMapping;
            SequenceFeature tx = new SequenceFeature(feature, newBegin, newEnd, feature.getFeatureGroup(), feature.getScore());
            tx.setStatus(status + (tx.getStatus() == null || tx.getStatus().length() == 0 ? "" : ":" + tx.getStatus()));
            if (tx.begin == 0 || tx.end == 0) continue;
            sq.addSequenceFeature(tx);
        }
    }

    public void makeCaBondList() {
        boolean na = false;
        int numNa = 0;
        for (int i = 0; i < this.residues.size() - 1; ++i) {
            Residue tmpres = this.residues.elementAt(i);
            Residue tmpres2 = this.residues.elementAt(i + 1);
            Atom at1 = tmpres.findAtom("CA");
            Atom at2 = tmpres2.findAtom("CA");
            na = false;
            if (at1 == null && at2 == null) {
                na = true;
                at1 = tmpres.findAtom("P");
                at2 = tmpres2.findAtom("P");
            }
            if (at1 != null && at2 != null) {
                if (!at1.chain.equals(at2.chain)) continue;
                if (na) {
                    ++numNa;
                }
                this.makeBond(at1, at2);
                continue;
            }
            System.out.println("not found " + i);
        }
        if (this.residues.size() > 1 && (double)(numNa / (this.residues.size() - 1)) > 0.99) {
            this.isNa = true;
        }
    }

    public void makeBond(Atom at1, Atom at2) {
        this.bonds.addElement(new Bond(at1, at2));
    }

    public void makeResidueList(boolean visibleChainAnnotation) {
        int i;
        int count = 0;
        boolean deoxyn = false;
        boolean nucleotide = false;
        StringBuilder seq = new StringBuilder(256);
        Vector<SequenceFeature> resFeatures = new Vector<SequenceFeature>();
        Vector<Annotation> resAnnotation = new Vector<Annotation>();
        int iSize = this.atoms.size() - 1;
        int resNumber = -1;
        int insCode = 32;
        for (i = 0; i <= iSize; ++i) {
            Atom tmp = this.atoms.elementAt(i);
            resNumber = tmp.resNumber;
            insCode = tmp.insCode;
            int res = resNumber;
            int ins = insCode;
            if (i == 0) {
                this.offset = resNumber;
            }
            Vector<Atom> resAtoms = new Vector<Atom>();
            while (resNumber == res && ins == insCode && i < this.atoms.size()) {
                resAtoms.add(this.atoms.elementAt(i));
                if (++i < this.atoms.size()) {
                    resNumber = this.atoms.elementAt((int)i).resNumber;
                    insCode = this.atoms.elementAt((int)i).insCode;
                    continue;
                }
                ++resNumber;
            }
            --i;
            Atom currAtom = (Atom)resAtoms.get(0);
            if (currAtom.insCode != ' ' && !this.residues.isEmpty() && this.residues.lastElement().atoms.get((int)0).resNumber == currAtom.resNumber) {
                String desc = currAtom.resName + ":" + currAtom.resNumIns + " " + this.pdbid + this.id;
                SequenceFeature sf = new SequenceFeature("INSERTION", desc, this.offset + count - 1, this.offset + count - 1, "PDB_INS");
                resFeatures.addElement(sf);
                this.residues.lastElement().atoms.addAll(resAtoms);
                continue;
            }
            this.residues.addElement(new Residue(resAtoms, resNumber - 1, count));
            Residue tmpres = this.residues.lastElement();
            Atom tmpat = tmpres.atoms.get(0);
            String desc = tmpat.resName + ":" + tmpat.resNumIns + " " + this.pdbid + this.id;
            SequenceFeature sf = new SequenceFeature(RESNUM_FEATURE, desc, this.offset + count, this.offset + count, this.pdbid);
            resFeatures.addElement(sf);
            resAnnotation.addElement(new Annotation(tmpat.tfactor));
            Integer symbol = ResidueProperties.getAA3Hash().get(tmpat.resName);
            if (symbol == null) {
                String nucname = tmpat.resName.trim();
                boolean bl = deoxyn = nucname.length() == 2 && ResidueProperties.aaIndex[nucname.charAt(0)] == ResidueProperties.aaIndex[68];
                if (tmpat.name.equalsIgnoreCase("CA") || ResidueProperties.nucleotideIndex[nucname.charAt(deoxyn ? 1 : 0)] == -1) {
                    char r = ResidueProperties.getSingleCharacterCode(ResidueProperties.getCanonicalAminoAcid(tmpat.resName));
                    seq.append(r == '0' ? (char)'X' : (char)r);
                } else {
                    nucleotide = true;
                    seq.append(nucname.charAt(deoxyn ? 1 : 0));
                }
            } else {
                if (nucleotide) {
                    System.err.println("Warning: mixed nucleotide and amino acid chain.. its gonna do bad things to you!");
                }
                seq.append(ResidueProperties.aa[symbol]);
            }
            ++count;
        }
        if (this.id.length() < 1) {
            this.id = " ";
        }
        this.isNa = nucleotide;
        this.sequence = new Sequence(this.id, seq.toString(), this.offset, resNumber - 1);
        if (StructureImportSettings.isShowSeqFeatures()) {
            iSize = resFeatures.size();
            for (i = 0; i < iSize; ++i) {
                this.sequence.addSequenceFeature((SequenceFeature)resFeatures.elementAt(i));
                resFeatures.setElementAt(null, i);
            }
        }
        if (visibleChainAnnotation) {
            Annotation[] annots = new Annotation[resAnnotation.size()];
            float max = 0.0f;
            float min = 0.0f;
            iSize = annots.length;
            for (int i2 = 0; i2 < iSize; ++i2) {
                annots[i2] = (Annotation)resAnnotation.elementAt(i2);
                max = Math.max(max, annots[i2].value);
                min = Math.min(min, annots[i2].value);
                resAnnotation.setElementAt(null, i2);
            }
            AlignmentAnnotation tfactorann = new AlignmentAnnotation("Temperature Factor", "Temperature Factor for " + this.pdbid + this.id, annots, min, max, 2);
            tfactorann.setSequenceRef(this.sequence);
            this.sequence.addAlignmentAnnotation(tfactorann);
        }
    }

    public void setChargeColours() {
        for (Bond b : this.bonds) {
            if (b.at1 != null && b.at2 != null) {
                b.startCol = PDBChain.getChargeColour(b.at1.resName);
                b.endCol = PDBChain.getChargeColour(b.at2.resName);
                continue;
            }
            b.startCol = Color.gray;
            b.endCol = Color.gray;
        }
    }

    public static Color getChargeColour(String resName) {
        Color result = Color.lightGray;
        if ("ASP".equals(resName) || "GLU".equals(resName)) {
            result = Color.red;
        } else if ("LYS".equals(resName) || "ARG".equals(resName)) {
            result = Color.blue;
        } else if ("CYS".equals(resName)) {
            result = Color.yellow;
        }
        return result;
    }

    public void setChainColours(ColourSchemeI cs) {
        for (Bond b : this.bonds) {
            try {
                int index = ResidueProperties.aa3Hash.get(b.at1.resName);
                b.startCol = cs.findColour(ResidueProperties.aa[index].charAt(0), 0, null, null, 0.0f);
                index = ResidueProperties.aa3Hash.get(b.at2.resName);
                b.endCol = cs.findColour(ResidueProperties.aa[index].charAt(0), 0, null, null, 0.0f);
            }
            catch (Exception e) {
                b.startCol = Color.gray;
                b.endCol = Color.gray;
            }
        }
    }

    public void setChainColours(Color col) {
        for (Bond b : this.bonds) {
            b.startCol = col;
            b.endCol = col;
        }
    }

    public void transferResidueAnnotation(StructureMapping mapping, Mapping sqmpping) {
        block4: {
            SequenceI dsq;
            block5: {
                SequenceI sq;
                dsq = sq = mapping.getSequence();
                if (sqmpping == null) {
                    sqmpping = mapping.getSeqToPdbMapping();
                }
                if (sq == null) break block4;
                while (dsq.getDatasetSequence() != null) {
                    dsq = dsq.getDatasetSequence();
                }
                if (this.shadow == null || this.shadow.getAnnotation() == null) break block5;
                for (AlignmentAnnotation ana : this.shadow.getAnnotation()) {
                    List<AlignmentAnnotation> transfer = sq.getAlignmentAnnotations(ana.getCalcId(), ana.label);
                    if (transfer != null && transfer.size() != 0) continue;
                    ana = new AlignmentAnnotation(ana);
                    ana.liftOver(this.sequence, this.shadowMap);
                    ana.liftOver(dsq, sqmpping);
                    dsq.addAlignmentAnnotation(ana);
                }
                break block4;
            }
            if (this.sequence == null || this.sequence.getAnnotation() == null) break block4;
            for (AlignmentAnnotation ana : this.sequence.getAnnotation()) {
                List<AlignmentAnnotation> transfer = dsq.getAlignmentAnnotations(ana.getCalcId(), ana.label);
                if (transfer != null && transfer.size() != 0) continue;
                ana = new AlignmentAnnotation(ana);
                ana.liftOver(dsq, sqmpping);
                dsq.addAlignmentAnnotation(ana);
            }
        }
    }
}

