/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.utils;

import jalview.util.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class UrlDownloadClient {
    public static void download(String urlstring, String outfile) throws IOException {
        FileOutputStream fos = null;
        Channel rbc = null;
        Path temp = null;
        try {
            temp = Files.createTempFile(".jalview_", ".tmp", new FileAttribute[0]);
            URL url = new URL(urlstring);
            rbc = Channels.newChannel(url.openStream());
            fos = new FileOutputStream(temp.toString());
            fos.getChannel().transferFrom((ReadableByteChannel)rbc, 0L, Long.MAX_VALUE);
            Files.copy(temp, Paths.get(outfile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                System.out.println("Exception while closing download file output stream: " + e.getMessage());
            }
            try {
                if (rbc != null) {
                    rbc.close();
                }
            }
            catch (IOException e) {
                System.out.println("Exception while closing download channel: " + e.getMessage());
            }
            try {
                if (temp != null) {
                    Files.deleteIfExists(temp);
                }
            }
            catch (IOException e) {
                System.out.println("Exception while deleting download temp file: " + e.getMessage());
            }
        }
    }

    public static void download(String urlstring, File tempFile) throws IOException {
        if (!Platform.setFileBytes(tempFile, urlstring)) {
            UrlDownloadClient.download(urlstring, tempFile.toString());
        }
    }
}

