/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.rest;

import jalview.ws.params.ArgumentI;
import jalview.ws.params.InvalidArgumentException;
import jalview.ws.params.OptionI;
import jalview.ws.params.ParameterI;
import jalview.ws.params.simple.IntegerParameter;
import jalview.ws.params.simple.Option;
import jalview.ws.rest.NoValidInputDataException;
import jalview.ws.rest.RestJob;
import jalview.ws.rest.RestServiceDescription;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public abstract class InputType {
    private static final Pattern URL_PATTERN = Pattern.compile("^([^=]+)=?'?([^']*)?'?");
    boolean replaceids;
    public String token;
    public int min = 1;
    public int max = 0;
    protected ArrayList<Class> inputData = new ArrayList();

    protected InputType(Class[] types) {
        if (types != null) {
            for (Class t : types) {
                this.inputData.add(t);
            }
        }
    }

    public boolean validFor(RestJob restJob) {
        if (!this.validFor(restJob.rsd)) {
            return false;
        }
        for (Class cl : this.inputData) {
            if (restJob.hasDataOfType(cl)) continue;
            return false;
        }
        return true;
    }

    public boolean validFor(RestServiceDescription restServiceDescription) {
        return restServiceDescription.inputParams.values().contains(this);
    }

    protected ContentBody utf8StringBody(String content, String type) {
        Charset utf8 = Charset.forName("UTF-8");
        try {
            if (type == null) {
                return new StringBody(utf8.encode(content).asCharBuffer().toString());
            }
            return new StringBody(utf8.encode(content).asCharBuffer().toString(), type, utf8);
        }
        catch (Exception ex) {
            System.err.println("Couldn't transform string\n" + content + "\nException was :");
            ex.printStackTrace(System.err);
            return null;
        }
    }

    public abstract ContentBody formatForInput(RestJob var1) throws UnsupportedEncodingException, NoValidInputDataException;

    public boolean isConstant() {
        return this.inputData == null || this.inputData.size() == 0;
    }

    public abstract List<String> getURLEncodedParameter();

    public abstract boolean configureProperty(String var1, String var2, StringBuffer var3);

    public abstract String getURLtokenPrefix();

    public boolean configureFromURLtokenString(List<String> tokenstring, StringBuffer warnings) {
        boolean valid = true;
        for (String tok : tokenstring) {
            Matcher mtch = URL_PATTERN.matcher(tok);
            if (!mtch.find()) continue;
            try {
                if (mtch.group(1).equals("min")) {
                    this.min = Integer.parseInt(mtch.group(2));
                    continue;
                }
                if (mtch.group(1).equals("max")) {
                    this.max = Integer.parseInt(mtch.group(2));
                    continue;
                }
            }
            catch (NumberFormatException x) {
                valid = false;
                warnings.append("Invalid value for parameter " + mtch.group(1).toLowerCase() + " '" + mtch.group(2) + "' (expected an integer)\n");
            }
            if (this.configureProperty(mtch.group(1), mtch.group(2), warnings)) continue;
            if (warnings.length() == 0) {
                warnings.append("Failed to configure InputType :" + this.getURLtokenPrefix() + " with property string: '" + mtch.group(0) + "'\n (token is '" + mtch.group(1) + "' and value is '" + mtch.group(2) + "')\n");
            }
            valid = false;
        }
        return valid;
    }

    public void addBaseParams(ArrayList<String> prms) {
        if (this.min != 1) {
            prms.add("min='" + this.min + "'");
        }
        if (this.max != 0) {
            prms.add("max='" + this.max + "'");
        }
    }

    public abstract List<OptionI> getOptions();

    public List<OptionI> getBaseOptions() {
        ArrayList<OptionI> opts = new ArrayList<OptionI>();
        opts.add(new IntegerParameter("min", "Minimum number of data of this type", true, 1, this.min, 0, -1));
        opts.add(new IntegerParameter("max", "Maximum number of data of this type", false, 0, this.max, 0, -1));
        return opts;
    }

    public void configureFromArgumentI(List<ArgumentI> currentSettings) throws InvalidArgumentException {
        ArrayList<String> urltoks = new ArrayList<String>();
        for (ArgumentI arg : currentSettings) {
            String rg;
            if (arg instanceof ParameterI) {
                rg = arg.getName() + "='" + arg.getValue() + "'";
            } else {
                String string = arg.getValue().length() > 0 ? (arg.getValue().equals(arg.getName()) ? arg.getName() : arg.getName() + "='" + arg.getValue() + "'") : (rg = arg.getName());
            }
            if (rg.length() <= 0) continue;
            urltoks.add(rg);
        }
        StringBuffer warnings = new StringBuffer();
        if (!this.configureFromURLtokenString(urltoks, warnings)) {
            throw new InvalidArgumentException(warnings.toString());
        }
    }

    protected OptionI createMolTypeOption(String name, String descr, boolean req, molType curType, molType defType) {
        return new Option(name, descr, req, defType == null ? "" : defType.toString(), curType == null ? "" : curType.toString(), molType.toStringValues(), null);
    }

    public static enum molType {
        NUC,
        PROT,
        MIX;


        public static Collection<String> toStringValues() {
            ArrayList<String> c = new ArrayList<String>();
            for (molType type : molType.values()) {
                c.add(type.toString());
            }
            return c;
        }
    }
}

