/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import compbio.metadata.Argument;
import compbio.ws.client.Services;
import jalview.api.AlignCalcWorkerI;
import jalview.bin.Cache;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvSwingUtils;
import jalview.gui.WebserviceInfo;
import jalview.gui.WsJobParameters;
import jalview.util.MessageManager;
import jalview.ws.WSClient;
import jalview.ws.jws2.AbstractJabaCalcWorker;
import jalview.ws.jws2.JabaParamStore;
import jalview.ws.jws2.JabaPreset;
import jalview.ws.jws2.Jws2Discoverer;
import jalview.ws.jws2.SequenceAnnotationWSClient;
import jalview.ws.jws2.dm.AAConSettings;
import jalview.ws.jws2.dm.JabaWsParamSet;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.WsParamSetI;
import jalview.ws.uimodel.AlignAnalysisUIText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public abstract class Jws2Client
extends WSClient {
    protected AlignFrame alignFrame;
    protected WsParamSetI preset;
    protected List<Argument> paramset;

    public Jws2Client(AlignFrame _alignFrame, WsParamSetI preset, List<Argument> arguments) {
        this.alignFrame = _alignFrame;
        this.preset = preset;
        if (preset != null) {
            if (!(preset instanceof JabaPreset) && !(preset instanceof JabaWsParamSet)) {
                throw new Error(MessageManager.getString("error.implementation_error_can_only_instantiate_jaba_param_sets"));
            }
        } else {
            this.paramset = arguments;
        }
    }

    boolean processParams(Jws2Instance sh, boolean editParams) {
        return this.processParams(sh, editParams, false);
    }

    protected boolean processParams(Jws2Instance sh, boolean editParams, boolean adjustingExisting) {
        if (editParams) {
            WsJobParameters jobParams;
            if (sh.paramStore == null) {
                sh.paramStore = new JabaParamStore(sh, Desktop.getUserParameterStore());
            }
            WsJobParameters wsJobParameters = jobParams = this.preset == null && this.paramset != null && this.paramset.size() > 0 ? new WsJobParameters(null, sh, null, this.paramset) : new WsJobParameters(sh, this.preset);
            if (adjustingExisting) {
                jobParams.setName(MessageManager.getString("label.adjusting_parameters_for_calculation"));
            }
            if (!jobParams.showRunDialog()) {
                return false;
            }
            WsParamSetI prset = jobParams.getPreset();
            if (prset == null) {
                this.paramset = jobParams.isServiceDefaults() ? null : JabaParamStore.getJabafromJwsArgs(jobParams.getJobParams());
                this.preset = null;
            } else {
                this.preset = prset;
                this.paramset = null;
            }
        }
        return true;
    }

    public Jws2Client() {
    }

    protected WebserviceInfo setWebService(Jws2Instance serv, boolean b) {
        String serviceInstance = serv.action;
        this.WebServiceName = serv.serviceType;
        this.WebServiceJobTitle = serv.getActionText();
        this.WsURL = serv.hosturl;
        if (!b) {
            return new WebserviceInfo(this.WebServiceJobTitle, this.WebServiceJobTitle + " using service hosted at " + serv.hosturl + "\n" + (serv.description != null ? serv.description : ""), false);
        }
        return null;
    }

    abstract void attachWSMenuEntry(JMenu var1, Jws2Instance var2, AlignFrame var3);

    protected boolean registerAAConWSInstance(JMenu wsmenu, Jws2Instance service, final AlignFrame alignFrame) {
        final AlignAnalysisUIText aaui = service.getAlignAnalysisUI();
        if (aaui == null) {
            return false;
        }
        JCheckBoxMenuItem _aaConEnabled = null;
        for (int i = 0; i < wsmenu.getItemCount(); ++i) {
            JMenuItem item = wsmenu.getItem(i);
            if (!(item instanceof JCheckBoxMenuItem) || !item.getText().equals(aaui.getAAconToggle())) continue;
            _aaConEnabled = (JCheckBoxMenuItem)item;
        }
        List<AlignCalcWorkerI> aaconClient = alignFrame.getViewport().getCalcManager().getRegisteredWorkersOfClass(aaui.getClient());
        if (aaconClient != null && aaconClient.size() > 0) {
            AbstractJabaCalcWorker worker = (AbstractJabaCalcWorker)aaconClient.get(0);
            if (!worker.service.hosturl.equals(service.hosturl)) {
                Jws2Client.removeCurrentAAConWorkerFor(aaui, alignFrame);
                Jws2Client.buildCurrentAAConWorkerFor(aaui, alignFrame, service);
            }
        }
        if (_aaConEnabled == null) {
            final JCheckBoxMenuItem aaConEnabled = new JCheckBoxMenuItem(aaui.getAAconToggle());
            aaConEnabled.setToolTipText(JvSwingUtils.wrapTooltip(true, aaui.getAAconToggleTooltip()));
            aaConEnabled.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    List<AlignCalcWorkerI> aaconClient = alignFrame.getViewport().getCalcManager().getRegisteredWorkersOfClass(aaui.getClient());
                    if (aaconClient != null && aaconClient.size() > 0) {
                        Jws2Client.removeCurrentAAConWorkerFor(aaui, alignFrame);
                    } else {
                        Jws2Client.buildCurrentAAConWorkerFor(aaui, alignFrame);
                    }
                }
            });
            wsmenu.add(aaConEnabled);
            final JMenuItem modifyParams = new JMenuItem(aaui.getAAeditSettings());
            modifyParams.setToolTipText(JvSwingUtils.wrapTooltip(true, aaui.getAAeditSettingsTooltip()));
            modifyParams.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Jws2Client.showAAConAnnotationSettingsFor(aaui, alignFrame);
                }
            });
            wsmenu.add(modifyParams);
            wsmenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent arg0) {
                    if (alignFrame.getViewport().getAlignment().isNucleotide() ? aaui.isNa() : aaui.isPr()) {
                        aaConEnabled.setEnabled(true);
                        modifyParams.setEnabled(true);
                    } else {
                        aaConEnabled.setEnabled(false);
                        modifyParams.setEnabled(false);
                    }
                    List<AlignCalcWorkerI> aaconClient = alignFrame.getViewport().getCalcManager().getRegisteredWorkersOfClass(aaui.getClient());
                    if (aaconClient != null && aaconClient.size() > 0) {
                        aaConEnabled.setSelected(true);
                    } else {
                        aaConEnabled.setSelected(false);
                    }
                }

                @Override
                public void menuDeselected(MenuEvent arg0) {
                }

                @Override
                public void menuCanceled(MenuEvent arg0) {
                }
            });
        }
        return true;
    }

    private static void showAAConAnnotationSettingsFor(AlignAnalysisUIText aaui, AlignFrame alignFrame) {
        AAConSettings fave = (AAConSettings)alignFrame.getViewport().getCalcIdSettingsFor(aaui.getCalcId());
        if (fave == null) {
            fave = Jws2Client.createDefaultAAConSettings(aaui);
        }
        new SequenceAnnotationWSClient(fave, alignFrame, true);
    }

    private static void buildCurrentAAConWorkerFor(AlignAnalysisUIText aaui, AlignFrame alignFrame) {
        Jws2Client.buildCurrentAAConWorkerFor(aaui, alignFrame, null);
    }

    private static void buildCurrentAAConWorkerFor(AlignAnalysisUIText aaui, AlignFrame alignFrame, Jws2Instance service) {
        AAConSettings fave = (AAConSettings)alignFrame.getViewport().getCalcIdSettingsFor(aaui.getCalcId());
        if (fave == null) {
            fave = Jws2Client.createDefaultAAConSettings(aaui, service);
        } else if (service != null && !fave.getService().hosturl.equals(service.hosturl)) {
            Cache.log.debug((Object)("Changing AACon service to " + service.hosturl + " from " + fave.getService().hosturl));
            fave.setService(service);
        }
        new SequenceAnnotationWSClient(fave, alignFrame, false);
    }

    private static AAConSettings createDefaultAAConSettings(AlignAnalysisUIText aaui) {
        return Jws2Client.createDefaultAAConSettings(aaui, null);
    }

    private static AAConSettings createDefaultAAConSettings(AlignAnalysisUIText aaui, Jws2Instance service) {
        if (service != null) {
            if (!service.serviceType.toString().equals(Services.AAConWS.toString())) {
                Cache.log.warn((Object)("Ignoring invalid preferred service for AACon calculations (service type was " + service.serviceType + ")"));
                service = null;
            } else if (!Jws2Discoverer.getDiscoverer().getServices().contains(service)) {
                service = null;
            }
        }
        if (service == null) {
            service = Jws2Discoverer.getDiscoverer().getPreferredServiceFor(null, aaui.getServiceType());
        }
        if (service == null) {
            throw new Error(MessageManager.getString("error.no_aacon_service_found"));
        }
        return new AAConSettings(true, service, null, null);
    }

    private static void removeCurrentAAConWorkerFor(AlignAnalysisUIText aaui, AlignFrame alignFrame) {
        alignFrame.getViewport().getCalcManager().removeRegisteredWorkersOfClass(aaui.getClient());
    }
}

