/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Range;
import compbio.data.sequence.Score;
import compbio.data.sequence.ScoreManager;
import compbio.metadata.Argument;
import compbio.ws.client.Services;
import jalview.api.FeatureColourI;
import jalview.api.FeatureRenderer;
import jalview.bin.Cache;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.GraphLine;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignmentPanel;
import jalview.schemes.FeatureColour;
import jalview.util.ColorUtils;
import jalview.ws.jws2.JabawsCalcWorker;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.WsParamSetI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AADisorderClient
extends JabawsCalcWorker {
    private static final String THRESHOLD = "THRESHOLD";
    private static final String RANGE = "RANGE";
    String typeName;
    String methodName;
    String groupName;
    AlignFrame af;
    private static Map<String, Map<String, String[]>> featureMap;
    private static Map<String, Map<String, Map<String, Object>>> annotMap;
    private static String DONTCOMBINE;
    private static String INVISIBLE;

    public AADisorderClient(Jws2Instance sh, AlignFrame alignFrame, WsParamSetI thePreset, List<Argument> paramset) {
        super(sh, alignFrame, thePreset, paramset);
        this.af = alignFrame;
        this.typeName = sh.action;
        this.methodName = sh.serviceType;
        this.submitGaps = false;
        this.alignedSeqs = false;
        this.nucleotidesAllowed = false;
        this.proteinAllowed = true;
        this.bySequence = true;
    }

    @Override
    public String getServiceActionText() {
        return "Submitting amino acid sequences for disorder prediction.";
    }

    @Override
    boolean checkValidInputSeqs(boolean dynamic, List<FastaSequence> seqs) {
        return seqs.size() > 0;
    }

    @Override
    public void updateResultAnnotation(boolean immediate) {
        if (immediate || !this.calcMan.isWorking(this) && this.scoremanager != null) {
            Map<String, String[]> featureTypeMap = featureMap.get(this.service.serviceType);
            Map<String, Map<String, Object>> annotTypeMap = annotMap.get(this.service.serviceType);
            boolean dispFeatures = false;
            Hashtable<String, SequenceFeature> fc = new Hashtable<String, SequenceFeature>();
            ArrayList<AlignmentAnnotation> ourAnnot = new ArrayList<AlignmentAnnotation>();
            int graphGroup = 1;
            if (this.alignViewport.getAlignment().getAlignmentAnnotation() != null) {
                for (AlignmentAnnotation ala : this.alignViewport.getAlignment().getAlignmentAnnotation()) {
                    if (ala.graphGroup <= graphGroup) continue;
                    graphGroup = ala.graphGroup;
                }
            }
            for (String seqId : this.seqNames.keySet()) {
                SequenceI dseq;
                boolean sameGroup = false;
                SequenceI seq = (SequenceI)this.seqNames.get(seqId);
                int base = seq.findPosition(this.start) - 1;
                SequenceI aseq = seq;
                while ((dseq = seq).getDatasetSequence() != null) {
                    seq = seq.getDatasetSequence();
                }
                ScoreManager.ScoreHolder scores = null;
                try {
                    scores = this.scoremanager.getAnnotationForSequence(seqId);
                }
                catch (Exception q) {
                    Cache.log.info((Object)("Couldn't recover disorder prediction for sequence " + seq.getName() + "(Prediction name was " + seqId + ")\nSee http://issues.jalview.org/browse/JAL-1319 for one possible reason why disorder predictions might fail."));
                }
                float last = Float.NaN;
                float val = Float.NaN;
                int lastAnnot = ourAnnot.size();
                if (scores != null && scores.scores != null) {
                    for (Score scr : scores.scores) {
                        float[] range;
                        if (scr.getRanges() != null && scr.getRanges().size() > 0) {
                            Iterator vals = scr.getScores().iterator();
                            for (Range rn : scr.getRanges()) {
                                SequenceFeature sf;
                                String[] type = featureTypeMap.get(scr.getMethod());
                                if (type == null) {
                                    type = new String[]{this.typeName + " (" + scr.getMethod() + ")", this.service.getActionText()};
                                }
                                if (vals.hasNext()) {
                                    val = ((Float)vals.next()).floatValue();
                                    sf = new SequenceFeature(type[0], type[1], base + rn.from, base + rn.to, val, this.methodName);
                                } else {
                                    sf = new SequenceFeature(type[0], type[1], base + rn.from, base + rn.to, this.methodName);
                                }
                                dseq.addSequenceFeature(sf);
                                if (last != val && !Float.isNaN(last)) {
                                    fc.put(sf.getType(), sf);
                                }
                                last = val;
                                dispFeatures = true;
                            }
                            continue;
                        }
                        if (scr.getScores().size() == 0) continue;
                        String typename = this.service.serviceType + " (" + scr.getMethod() + ")";
                        String calcName = this.service.getServiceTypeURI() + "/" + scr.getMethod();
                        AlignmentAnnotation annot = this.createAnnotationRowsForScores(ourAnnot, typename, calcName, aseq, base + 1, scr);
                        annot.graph = 2;
                        Map<String, Object> styleMap = annotTypeMap == null ? null : annotTypeMap.get(scr.getMethod());
                        annot.visible = styleMap == null || styleMap.get(INVISIBLE) == null;
                        double[] thrsh = styleMap == null ? null : (double[])styleMap.get(THRESHOLD);
                        float[] fArray = range = styleMap == null ? null : (float[])styleMap.get(RANGE);
                        if (range != null) {
                            annot.graphMin = range[0];
                            annot.graphMax = range[1];
                        }
                        if (styleMap == null || styleMap.get(DONTCOMBINE) == null) {
                            if (!sameGroup) {
                                sameGroup = true;
                            }
                            annot.graphGroup = ++graphGroup;
                        }
                        annot.description = "<html>" + this.service.getActionText() + " - raw scores";
                        if (thrsh != null) {
                            String threshNote = (thrsh[0] > 0.0 ? "Above " : "Below ") + thrsh[1] + " indicates disorder";
                            annot.threshold = new GraphLine((float)thrsh[1], threshNote, Color.red);
                            annot.description = annot.description + "<br/>" + threshNote;
                        }
                        annot.description = annot.description + "</html>";
                        Color col = ColorUtils.createColourFromName(this.typeName + scr.getMethod());
                        int ps = annot.annotations.length;
                        for (int p = 0; p < ps; ++p) {
                            if (annot.annotations[p] == null) continue;
                            annot.annotations[p].colour = col;
                        }
                        annot._linecolour = col;
                        this.replaceAnnotationOnAlignmentWith(annot, typename, calcName, aseq);
                    }
                }
                if (lastAnnot + 1 != ourAnnot.size()) continue;
                ((AlignmentAnnotation)ourAnnot.get((int)lastAnnot)).graphGroup = -1;
            }
            if (dispFeatures) {
                FeatureRenderer fr = ((AlignmentPanel)this.ap).cloneFeatureRenderer();
                for (String ft : fc.keySet()) {
                    FeatureColourI gc = fr.getFeatureStyle(ft);
                    if (!gc.isSimpleColour()) continue;
                    FeatureColour ggc = new FeatureColour(gc.getColour(), Color.white, gc.getColour(), Color.white, Float.MIN_VALUE, Float.MAX_VALUE);
                    ggc.setAutoScaled(true);
                    fr.setColour(ft, ggc);
                }
                ((AlignmentPanel)this.ap).updateFeatureRendererFrom(fr);
                if (this.af.alignPanel == this.ap) {
                    this.af.setShowSeqFeatures(true);
                }
            }
            if (ourAnnot.size() > 0) {
                this.updateOurAnnots(ourAnnot);
                this.ap.adjustAnnotationHeight();
                this.ap.paintAlignment(true, true);
            }
        }
    }

    @Override
    public String getCalcId() {
        return null;
    }

    static {
        DONTCOMBINE = "DONTCOMBINE";
        INVISIBLE = "INVISIBLE";
        featureMap = new HashMap<String, Map<String, String[]>>();
        HashMap<String, String[]> fmap = new HashMap<String, String[]>();
        featureMap.put(Services.IUPredWS.toString(), fmap);
        fmap.put("Glob", new String[]{"Globular Domain", "Predicted globular domain"});
        fmap = new HashMap();
        featureMap.put(Services.JronnWS.toString(), fmap);
        fmap = new HashMap();
        featureMap.put(Services.DisemblWS.toString(), fmap);
        fmap.put("REM465", new String[]{"REM465", "Missing density"});
        fmap.put("HOTLOOPS", new String[]{"HOTLOOPS", "Flexible loops"});
        fmap.put("COILS", new String[]{"COILS", "Random coil"});
        fmap = new HashMap();
        featureMap.put(Services.GlobPlotWS.toString(), fmap);
        fmap.put("GlobDoms", new String[]{"Globular Domain", "Predicted globular domain"});
        fmap.put("Disorder", new String[]{"Protein Disorder", "Probable unstructured peptide region"});
        annotMap = new HashMap<String, Map<String, Map<String, Object>>>();
        HashMap amap = new HashMap();
        annotMap.put(Services.GlobPlotWS.toString(), amap);
        amap.put("Dydx", new HashMap());
        ((Map)amap.get("Dydx")).put(DONTCOMBINE, DONTCOMBINE);
        ((Map)amap.get("Dydx")).put(THRESHOLD, new double[]{1.0, 0.0});
        ((Map)amap.get("Dydx")).put(RANGE, new float[]{-1.0f, 1.0f});
        amap.put("SmoothedScore", new HashMap());
        ((Map)amap.get("SmoothedScore")).put(INVISIBLE, INVISIBLE);
        amap.put("RawScore", new HashMap());
        ((Map)amap.get("RawScore")).put(INVISIBLE, INVISIBLE);
        amap = new HashMap();
        annotMap.put(Services.DisemblWS.toString(), amap);
        amap.put("COILS", new HashMap());
        amap.put("HOTLOOPS", new HashMap());
        amap.put("REM465", new HashMap());
        ((Map)amap.get("COILS")).put(THRESHOLD, new double[]{1.0, 0.516});
        ((Map)amap.get("COILS")).put(RANGE, new float[]{0.0f, 1.0f});
        ((Map)amap.get("HOTLOOPS")).put(THRESHOLD, new double[]{1.0, 0.6});
        ((Map)amap.get("HOTLOOPS")).put(RANGE, new float[]{0.0f, 1.0f});
        ((Map)amap.get("REM465")).put(THRESHOLD, new double[]{1.0, 0.1204});
        ((Map)amap.get("REM465")).put(RANGE, new float[]{0.0f, 1.0f});
        amap = new HashMap();
        annotMap.put(Services.IUPredWS.toString(), amap);
        amap.put("Long", new HashMap());
        amap.put("Short", new HashMap());
        ((Map)amap.get("Long")).put(THRESHOLD, new double[]{1.0, 0.5});
        ((Map)amap.get("Long")).put(RANGE, new float[]{0.0f, 1.0f});
        ((Map)amap.get("Short")).put(THRESHOLD, new double[]{1.0, 0.5});
        ((Map)amap.get("Short")).put(RANGE, new float[]{0.0f, 1.0f});
        amap = new HashMap();
        annotMap.put(Services.JronnWS.toString(), amap);
        amap.put("JRonn", new HashMap());
        ((Map)amap.get("JRonn")).put(THRESHOLD, new double[]{1.0, 0.5});
        ((Map)amap.get("JRonn")).put(RANGE, new float[]{0.0f, 1.0f});
    }
}

