/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Score;
import compbio.metadata.Argument;
import compbio.ws.client.Services;
import jalview.datamodel.AlignmentAnnotation;
import jalview.gui.AlignFrame;
import jalview.util.MessageManager;
import jalview.ws.jws2.JabawsCalcWorker;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.WsParamSetI;
import jalview.ws.uimodel.AlignAnalysisUIText;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AAConClient
extends JabawsCalcWorker {
    private static String CALC_ID = "jabaws2.AACon";

    public AAConClient(Jws2Instance service, AlignFrame alignFrame, WsParamSetI preset, List<Argument> paramset) {
        super(service, alignFrame, preset, paramset);
        this.submitGaps = true;
        this.alignedSeqs = true;
        this.nucleotidesAllowed = false;
        this.proteinAllowed = true;
        this.filterNonStandardResidues = true;
        this.gapMap = new boolean[0];
        this.initViewportParams();
    }

    @Override
    public String getServiceActionText() {
        return "calculating Amino acid consensus using AACon service";
    }

    @Override
    public void updateResultAnnotation(boolean immediate) {
        if (immediate || !this.calcMan.isWorking(this) && this.scoremanager != null) {
            Map scoremap = this.scoremanager.asMap();
            int alWidth = this.alignViewport.getAlignment().getWidth();
            ArrayList<AlignmentAnnotation> ourAnnot = new ArrayList<AlignmentAnnotation>();
            for (String score : scoremap.keySet()) {
                Set scores = (Set)scoremap.get(score);
                for (Score scr : scores) {
                    if (scr.getRanges() != null && scr.getRanges().size() > 0) continue;
                    this.createAnnotationRowsForScores(ourAnnot, this.getCalcId(), alWidth, scr);
                }
            }
            if (ourAnnot.size() > 0) {
                this.updateOurAnnots(ourAnnot);
            }
        }
    }

    @Override
    boolean checkValidInputSeqs(boolean dynamic, List<FastaSequence> seqs) {
        return seqs.size() > 1;
    }

    @Override
    public String getCalcId() {
        return CALC_ID;
    }

    public static AlignAnalysisUIText getAlignAnalysisUITest() {
        return new AlignAnalysisUIText(Services.AAConWS.toString(), AAConClient.class, CALC_ID, false, true, true, MessageManager.getString("label.aacon_calculations"), MessageManager.getString("tooltip.aacon_calculations"), MessageManager.getString("label.aacon_settings"), MessageManager.getString("tooltip.aacon_settings"));
    }
}

