/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws1;

import ext.vamsas.SeqSearchI;
import jalview.analysis.AlignSeq;
import jalview.analysis.SeqsetUtils;
import jalview.api.FeatureColourI;
import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.WebserviceInfo;
import jalview.io.AnnotationFile;
import jalview.io.DataSourceType;
import jalview.io.FeaturesFile;
import jalview.io.NewickFile;
import jalview.util.Comparison;
import jalview.util.MessageManager;
import jalview.ws.AWsJob;
import jalview.ws.JobStateSummary;
import jalview.ws.WSClientI;
import jalview.ws.jws1.JWS1Thread;
import jalview.ws.jws1.WSJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import vamsas.objects.simple.MsaResult;
import vamsas.objects.simple.SeqSearchResult;
import vamsas.objects.simple.SequenceSet;
import vamsas.objects.simple.WsJobId;

class SeqSearchWSThread
extends JWS1Thread
implements WSClientI {
    String dbs = null;
    boolean profile = false;
    String alTitle;
    AlignmentI dataset;
    SeqSearchI server = null;
    private String dbArg;

    SeqSearchWSThread(SeqSearchI server, String wsUrl, WebserviceInfo wsinfo, AlignFrame alFrame, AlignmentView alview, String wsname, String db) {
        super(alFrame, wsinfo, alview, wsname, wsUrl);
        this.server = server;
        this.dbArg = db;
    }

    SeqSearchWSThread(SeqSearchI server, String wsUrl, WebserviceInfo wsinfo, AlignFrame alFrame, String wsname, String title, AlignmentView _msa, String db, AlignmentI seqset) {
        this(server, wsUrl, wsinfo, alFrame, _msa, wsname, db);
        this.OutputHeader = this.wsInfo.getProgressText();
        this.alTitle = title;
        this.dataset = seqset;
        SequenceI[][] conmsa = _msa.getVisibleContigs('-');
        if (conmsa != null) {
            int njobs = conmsa.length;
            this.jobs = new SeqSearchWSJob[njobs];
            for (int j = 0; j < njobs; ++j) {
                this.jobs[j] = j != 0 ? new SeqSearchWSJob(wsinfo.addJobPane(), conmsa[j]) : new SeqSearchWSJob(0, conmsa[j]);
                if (njobs > 0) {
                    wsinfo.setProgressName("region " + this.jobs[j].getJobnum(), this.jobs[j].getJobnum());
                }
                wsinfo.setProgressText(this.jobs[j].getJobnum(), this.OutputHeader);
            }
        }
    }

    @Override
    public boolean isCancellable() {
        return true;
    }

    @Override
    public void cancelJob() {
        if (!this.jobComplete && this.jobs != null) {
            boolean cancelled = true;
            for (int job = 0; job < this.jobs.length; ++job) {
                if (!this.jobs[job].isSubmitted() || this.jobs[job].isSubjobComplete()) continue;
                String cancelledMessage = "";
                try {
                    WsJobId cancelledJob = this.server.cancel(this.jobs[job].getJobId());
                    if (cancelledJob.getStatus() == 2) {
                        cancelledMessage = "Job cancelled.";
                        ((SeqSearchWSJob)this.jobs[job]).cancel();
                        this.wsInfo.setStatus(this.jobs[job].getJobnum(), 3);
                    } else if (cancelledJob.getStatus() == 3) {
                        cancelledMessage = cancelledMessage + "Server cannot cancel this job. just close the window.\n";
                        cancelled = false;
                    }
                    if (cancelledJob.getJobId() != null) {
                        cancelledMessage = cancelledMessage + "[" + cancelledJob.getJobId() + "]";
                    }
                    cancelledMessage = cancelledMessage + "\n";
                }
                catch (Exception exc) {
                    cancelledMessage = cancelledMessage + "\nProblems cancelling the job : Exception received...\n" + exc + "\n";
                    Cache.log.warn((Object)("Exception whilst cancelling " + this.jobs[job].getJobId()), (Throwable)exc);
                }
                this.wsInfo.setProgressText(this.jobs[job].getJobnum(), this.OutputHeader + cancelledMessage + "\n");
            }
            if (cancelled) {
                this.wsInfo.setStatus(3);
                this.jobComplete = true;
            }
            this.interrupt();
        } else if (!this.jobComplete) {
            this.wsInfo.setProgressText(this.OutputHeader + "Server cannot cancel this job because it has not been submitted properly. just close the window.\n");
        }
    }

    @Override
    public void pollJob(AWsJob job) throws Exception {
        ((SeqSearchWSJob)job).result = this.server.getResult(((SeqSearchWSJob)job).getJobId());
    }

    @Override
    public void StartJob(AWsJob job) {
        if (!(job instanceof SeqSearchWSJob)) {
            throw new Error(MessageManager.formatMessage("error.implementation_error_msawbjob_called", new String[]{job.getClass().toString()}));
        }
        SeqSearchWSJob j = (SeqSearchWSJob)job;
        if (j.isSubmitted()) {
            if (Cache.log.isDebugEnabled()) {
                Cache.log.debug((Object)("Tried to submit an already submitted job " + j.getJobId()));
            }
            return;
        }
        if (j.seqs.getSeqs() == null) {
            j.setSubmitted(true);
            j.result = new MsaResult();
            j.result.setFinished(true);
            j.result.setStatus(MessageManager.getString("label.empty_alignment_job"));
            ((MsaResult)j.result).setMsa(null);
        }
        try {
            WsJobId jobsubmit = this.server.search(j.seqs.getSeqs()[0], this.dbArg);
            if (jobsubmit == null || jobsubmit.getStatus() != 1) {
                if (jobsubmit == null) {
                    throw new Exception(MessageManager.formatMessage("exception.web_service_returned_null_try_later", new String[]{this.WsUrl}));
                }
                throw new Exception(jobsubmit.getJobId());
            }
            j.setJobId(jobsubmit.getJobId());
            j.setSubmitted(true);
            j.setSubjobComplete(false);
        }
        catch (Exception e) {
            System.err.println(this.WebServiceName + "Client: Failed to submit the sequences for alignment (probably a server side problem)\nWhen contacting Server:" + this.WsUrl + "\n" + e.toString() + "\n");
            j.setAllowedServerExceptions(0);
            this.wsInfo.setStatus(5);
            this.wsInfo.setStatus(j.getJobnum(), 5);
            this.wsInfo.appendProgressText(j.getJobnum(), MessageManager.getString("info.failed_to_submit_sequences_for_alignment"));
        }
    }

    private Sequence[] getVamsasAlignment(vamsas.objects.simple.Alignment valign) {
        vamsas.objects.simple.Sequence[] seqs = valign.getSeqs().getSeqs();
        Sequence[] msa = new Sequence[seqs.length];
        int j = seqs.length;
        for (int i = 0; i < j; ++i) {
            msa[i] = new Sequence(seqs[i].getId(), seqs[i].getSeq());
        }
        return msa;
    }

    @Override
    public void parseResult() {
        int results = 0;
        JobStateSummary finalState = new JobStateSummary();
        try {
            for (int j = 0; j < this.jobs.length; ++j) {
                finalState.updateJobPanelState(this.wsInfo, this.OutputHeader, this.jobs[j]);
                if (!this.jobs[j].isSubmitted() || !this.jobs[j].isSubjobComplete() || !this.jobs[j].hasResults()) continue;
                ++results;
                vamsas.objects.simple.Alignment valign = ((SeqSearchResult)((SeqSearchWSJob)this.jobs[j]).result).getAlignment();
                if (valign == null) continue;
                this.wsInfo.appendProgressText(this.jobs[j].getJobnum(), MessageManager.getString("info.alignment_object_method_notes"));
                String[] lines = valign.getMethod();
                for (int line = 0; line < lines.length; ++line) {
                    this.wsInfo.appendProgressText(this.jobs[j].getJobnum(), lines[line] + "\n");
                }
            }
        }
        catch (Exception ex) {
            Cache.log.error((Object)("Unexpected exception when processing results for " + this.alTitle), (Throwable)ex);
            this.wsInfo.setStatus(4);
        }
        if (results > 0) {
            this.wsInfo.showResultsNewFrame.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SeqSearchWSThread.this.displayResults(true);
                }
            });
            this.wsInfo.mergeResults.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SeqSearchWSThread.this.displayResults(false);
                }
            });
            this.wsInfo.setResultsReady();
        } else {
            this.wsInfo.setFinishedNoResults();
        }
    }

    void displayResults(boolean newFrame) {
        if (!newFrame) {
            System.err.println("MERGE WITH OLD FRAME NOT IMPLEMENTED");
            return;
        }
        for (int j = 0; j < this.jobs.length; ++j) {
            Object[] res;
            HashMap<String, FeatureColourI> featureColours = new HashMap<String, FeatureColourI>();
            Alignment al = null;
            NewickFile nf = null;
            if (this.jobs[j].hasResults()) {
                res = ((SeqSearchWSJob)this.jobs[j]).getAlignment(this.dataset, featureColours);
                if (res == null) continue;
            } else {
                al = null;
                nf = null;
                continue;
            }
            al = (Alignment)res[0];
            nf = (NewickFile)res[1];
            AlignFrame af = new AlignFrame(al, 700, 500);
            if (nf != null) {
                af.showNewickTree(nf, MessageManager.formatMessage("label.tree_from", new String[]{this.alTitle}));
            }
            af.getFeatureRenderer().transferSettings(this.featureSettings);
            Desktop.addInternalFrame(af, this.alTitle, 700, 500);
        }
    }

    @Override
    public boolean canMergeResults() {
        return false;
    }

    class SeqSearchWSJob
    extends WSJob {
        SequenceSet seqs = new SequenceSet();
        Hashtable SeqNames = new Hashtable();
        Vector emptySeqs = new Vector();

        public SeqSearchWSJob(int jobNum, SequenceI[] inSeqs) {
            this.jobnum = jobNum;
            if (!this.prepareInput(inSeqs, 2)) {
                this.submitted = true;
                this.subjobComplete = true;
                this.result = new MsaResult();
                this.result.setFinished(true);
                this.result.setStatus(MessageManager.getString("label.job_never_ran"));
            }
        }

        private boolean prepareInput(SequenceI[] seqs, int minlen) {
            int nseqs = 0;
            if (minlen < 0) {
                throw new Error(MessageManager.getString("error.implementation_error_minlen_must_be_greater_zero"));
            }
            for (int i = 0; i < seqs.length; ++i) {
                if (seqs[i].getEnd() - seqs[i].getStart() <= minlen - 1) continue;
                ++nseqs;
            }
            boolean valid = nseqs >= 1;
            vamsas.objects.simple.Sequence[] seqarray = valid ? new vamsas.objects.simple.Sequence[nseqs] : null;
            boolean submitGaps = nseqs != 1;
            int n = 0;
            for (int i = 0; i < seqs.length; ++i) {
                String newname = SeqsetUtils.unique_name(i);
                this.SeqNames.put(newname, SeqsetUtils.SeqCharacterHash(seqs[i]));
                if (valid && seqs[i].getEnd() - seqs[i].getStart() > minlen - 1) {
                    seqarray[n] = new vamsas.objects.simple.Sequence();
                    seqarray[n].setId(newname);
                    seqarray[n++].setSeq(submitGaps ? seqs[i].getSequenceAsString() : AlignSeq.extractGaps(Comparison.GapChars, seqs[i].getSequenceAsString()));
                    continue;
                }
                String empty = null;
                if (seqs[i].getEnd() >= seqs[i].getStart()) {
                    empty = submitGaps ? seqs[i].getSequenceAsString() : AlignSeq.extractGaps(Comparison.GapChars, seqs[i].getSequenceAsString());
                }
                this.emptySeqs.add(new String[]{newname, empty});
            }
            if (submitGaps) {
                // empty if block
            }
            this.seqs = new SequenceSet();
            this.seqs.setSeqs(seqarray);
            return valid;
        }

        @Override
        public boolean hasResults() {
            return this.subjobComplete && this.result != null && this.result.isFinished() && ((SeqSearchResult)this.result).getAlignment() != null && ((SeqSearchResult)this.result).getAlignment().getSeqs() != null;
        }

        public Object[] getAlignment(AlignmentI dataset, Map<String, FeatureColourI> featureColours) {
            if (this.result != null && this.result.isFinished()) {
                Sequence[] alseqs = null;
                if (((SeqSearchResult)this.result).getAlignment() != null) {
                    alseqs = SeqSearchWSThread.this.getVamsasAlignment(((SeqSearchResult)this.result).getAlignment());
                }
                Alignment al = new Alignment(alseqs);
                String inFile = null;
                try {
                    inFile = ((SeqSearchResult)this.result).getAnnotation();
                    if (inFile != null && inFile.length() > 0) {
                        new AnnotationFile().readAnnotationFile(al, inFile, DataSourceType.PASTE);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to parse the annotation file associated with the alignment.");
                    System.err.println(">>>EOF" + inFile + "\n<<<EOF\n");
                    e.printStackTrace(System.err);
                }
                try {
                    inFile = ((SeqSearchResult)this.result).getFeatures();
                    if (inFile != null && inFile.length() > 0) {
                        FeaturesFile ff = new FeaturesFile(inFile, DataSourceType.PASTE);
                        ff.parse(al, featureColours, false);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to parse the Features file associated with the alignment.");
                    System.err.println(">>>EOF" + inFile + "\n<<<EOF\n");
                    e.printStackTrace(System.err);
                }
                NewickFile nf = null;
                try {
                    inFile = ((SeqSearchResult)this.result).getNewickTree();
                    if (inFile != null && inFile.length() > 0 && !(nf = new NewickFile(inFile, DataSourceType.PASTE)).isValid()) {
                        nf.close();
                        nf = null;
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to parse the treeFile associated with the alignment.");
                    System.err.println(">>>EOF" + inFile + "\n<<<EOF\n");
                    e.printStackTrace(System.err);
                }
                return new Object[]{al, nf};
            }
            return null;
        }

        void cancel() {
            this.cancelled = true;
            this.subjobComplete = true;
            this.result = null;
        }

        @Override
        public boolean hasValidInput() {
            return this.seqs.getSeqs() != null;
        }
    }
}

