/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws1;

import ext.vamsas.MuscleWS;
import jalview.analysis.AlignSeq;
import jalview.analysis.AlignmentSorter;
import jalview.analysis.SeqsetUtils;
import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.WebserviceInfo;
import jalview.util.Comparison;
import jalview.util.MessageManager;
import jalview.ws.AWsJob;
import jalview.ws.JobStateSummary;
import jalview.ws.WSClientI;
import jalview.ws.jws1.JWS1Thread;
import jalview.ws.jws1.WSJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import vamsas.objects.simple.MsaResult;
import vamsas.objects.simple.SequenceSet;
import vamsas.objects.simple.WsJobId;

class MsaWSThread
extends JWS1Thread
implements WSClientI {
    boolean submitGaps = false;
    boolean preserveOrder = true;
    String alTitle;
    AlignmentI dataset;
    MuscleWS server = null;

    MsaWSThread(MuscleWS server, String wsUrl, WebserviceInfo wsinfo, AlignFrame alFrame, AlignmentView alview, String wsname, boolean subgaps, boolean presorder) {
        super(alFrame, wsinfo, alview, wsname, wsUrl);
        this.server = server;
        this.submitGaps = subgaps;
        this.preserveOrder = presorder;
    }

    MsaWSThread(MuscleWS server, String wsUrl, WebserviceInfo wsinfo, AlignFrame alFrame, String wsname, String title, AlignmentView _msa, boolean subgaps, boolean presorder, AlignmentI seqset) {
        this(server, wsUrl, wsinfo, alFrame, _msa, wsname, subgaps, presorder);
        this.OutputHeader = this.wsInfo.getProgressText();
        this.alTitle = title;
        this.dataset = seqset;
        SequenceI[][] conmsa = _msa.getVisibleContigs('-');
        if (conmsa != null) {
            int njobs = conmsa.length;
            this.jobs = new MsaWSJob[njobs];
            for (int j = 0; j < njobs; ++j) {
                this.jobs[j] = j != 0 ? new MsaWSJob(wsinfo.addJobPane(), conmsa[j]) : new MsaWSJob(0, conmsa[j]);
                if (njobs > 0) {
                    wsinfo.setProgressName("region " + this.jobs[j].getJobnum(), this.jobs[j].getJobnum());
                }
                wsinfo.setProgressText(this.jobs[j].getJobnum(), this.OutputHeader);
            }
        }
    }

    @Override
    public boolean isCancellable() {
        return true;
    }

    @Override
    public void cancelJob() {
        if (!this.jobComplete && this.jobs != null) {
            boolean cancelled = true;
            for (int job = 0; job < this.jobs.length; ++job) {
                if (!this.jobs[job].isSubmitted() || this.jobs[job].isSubjobComplete()) continue;
                String cancelledMessage = "";
                try {
                    WsJobId cancelledJob = this.server.cancel(this.jobs[job].getJobId());
                    if (cancelledJob.getStatus() == 2) {
                        cancelledMessage = "Job cancelled.";
                        ((MsaWSJob)this.jobs[job]).cancel();
                        this.wsInfo.setStatus(this.jobs[job].getJobnum(), 3);
                    } else if (cancelledJob.getStatus() == 3) {
                        cancelledMessage = cancelledMessage + "Server cannot cancel this job. just close the window.\n";
                        cancelled = false;
                    }
                    if (cancelledJob.getJobId() != null) {
                        cancelledMessage = cancelledMessage + "[" + cancelledJob.getJobId() + "]";
                    }
                    cancelledMessage = cancelledMessage + "\n";
                }
                catch (Exception exc) {
                    cancelledMessage = cancelledMessage + "\nProblems cancelling the job : Exception received...\n" + exc + "\n";
                    Cache.log.warn((Object)("Exception whilst cancelling " + this.jobs[job].getJobId()), (Throwable)exc);
                }
                this.wsInfo.setProgressText(this.jobs[job].getJobnum(), this.OutputHeader + cancelledMessage + "\n");
            }
            if (cancelled) {
                this.wsInfo.setStatus(3);
                this.jobComplete = true;
            }
            this.interrupt();
        } else if (!this.jobComplete) {
            this.wsInfo.setProgressText(this.OutputHeader + "Server cannot cancel this job because it has not been submitted properly. just close the window.\n");
        }
    }

    @Override
    public void pollJob(AWsJob job) throws Exception {
        ((MsaWSJob)job).result = this.server.getResult(((MsaWSJob)job).getJobId());
    }

    @Override
    public void StartJob(AWsJob job) {
        if (!(job instanceof MsaWSJob)) {
            throw new Error(MessageManager.formatMessage("error.implementation_error_msawbjob_called", new String[]{job.getClass().toString()}));
        }
        MsaWSJob j = (MsaWSJob)job;
        if (j.isSubmitted()) {
            if (Cache.log.isDebugEnabled()) {
                Cache.log.debug((Object)("Tried to submit an already submitted job " + j.getJobId()));
            }
            return;
        }
        if (j.seqs.getSeqs() == null) {
            j.setSubmitted(true);
            j.result = new MsaResult();
            j.result.setFinished(true);
            j.result.setStatus(MessageManager.getString("label.empty_alignment_job"));
            ((MsaResult)j.result).setMsa(null);
        }
        try {
            WsJobId jobsubmit = this.server.align(j.seqs);
            if (jobsubmit == null || jobsubmit.getStatus() != 1) {
                if (jobsubmit == null) {
                    throw new Exception(MessageManager.formatMessage("exception.web_service_returned_null_try_later", new String[]{this.WsUrl}));
                }
                throw new Exception(jobsubmit.getJobId());
            }
            j.setJobId(jobsubmit.getJobId());
            j.setSubmitted(true);
            j.setSubjobComplete(false);
        }
        catch (Exception e) {
            System.err.println(this.WebServiceName + "Client: Failed to submit the sequences for alignment (probably a server side problem)\nWhen contacting Server:" + this.WsUrl + "\n" + e.toString() + "\n");
            j.setAllowedServerExceptions(0);
            this.wsInfo.setStatus(5);
            this.wsInfo.setStatus(j.getJobnum(), 5);
            this.wsInfo.appendProgressText(j.getJobnum(), MessageManager.getString("info.failed_to_submit_sequences_for_alignment"));
        }
    }

    private Sequence[] getVamsasAlignment(vamsas.objects.simple.Alignment valign) {
        vamsas.objects.simple.Sequence[] seqs = valign.getSeqs().getSeqs();
        Sequence[] msa = new Sequence[seqs.length];
        int j = seqs.length;
        for (int i = 0; i < j; ++i) {
            msa[i] = new Sequence(seqs[i].getId(), seqs[i].getSeq());
        }
        return msa;
    }

    @Override
    public void parseResult() {
        int results = 0;
        JobStateSummary finalState = new JobStateSummary();
        try {
            for (int j = 0; j < this.jobs.length; ++j) {
                finalState.updateJobPanelState(this.wsInfo, this.OutputHeader, this.jobs[j]);
                if (!this.jobs[j].isSubmitted() || !this.jobs[j].isSubjobComplete() || !this.jobs[j].hasResults()) continue;
                ++results;
                vamsas.objects.simple.Alignment valign = ((MsaResult)((MsaWSJob)this.jobs[j]).result).getMsa();
                if (valign == null) continue;
                this.wsInfo.appendProgressText(this.jobs[j].getJobnum(), MessageManager.getString("info.alignment_object_method_notes"));
                String[] lines = valign.getMethod();
                for (int line = 0; line < lines.length; ++line) {
                    this.wsInfo.appendProgressText(this.jobs[j].getJobnum(), lines[line] + "\n");
                }
            }
        }
        catch (Exception ex) {
            Cache.log.error((Object)("Unexpected exception when processing results for " + this.alTitle), (Throwable)ex);
            this.wsInfo.setStatus(4);
        }
        if (results > 0) {
            this.wsInfo.showResultsNewFrame.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MsaWSThread.this.displayResults(true);
                }
            });
            this.wsInfo.mergeResults.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MsaWSThread.this.displayResults(false);
                }
            });
            this.wsInfo.setResultsReady();
        } else {
            this.wsInfo.setFinishedNoResults();
        }
    }

    void displayResults(boolean newFrame) {
        Vector<Object> alorders = new Vector<Object>();
        SequenceI[][] results = new SequenceI[this.jobs.length][];
        AlignmentOrder[] orders = new AlignmentOrder[this.jobs.length];
        for (int j = 0; j < this.jobs.length; ++j) {
            if (this.jobs[j].hasResults()) {
                Object[] res = ((MsaWSJob)this.jobs[j]).getAlignment();
                alorders.add(res[1]);
                results[j] = (SequenceI[])res[0];
                orders[j] = (AlignmentOrder)res[1];
                continue;
            }
            results[j] = null;
        }
        Object[] newview = this.input.getUpdatedView(results, orders, this.getGapChar());
        for (int j = 0; j < this.jobs.length; ++j) {
            results[j] = null;
            orders[j] = null;
        }
        SequenceI[] alignment = (SequenceI[])newview[0];
        HiddenColumns hidden = (HiddenColumns)newview[1];
        Alignment al = new Alignment(alignment);
        if (this.dataset != null) {
            al.setDataset(this.dataset);
        }
        this.propagateDatasetMappings(al);
        if (newFrame) {
            AlignFrame af = new AlignFrame((AlignmentI)al, hidden, 700, 500);
            af.getFeatureRenderer().transferSettings(this.featureSettings);
            if (alorders.size() > 0) {
                if (alorders.size() == 1) {
                    af.addSortByOrderMenuItem(this.WebServiceName + " Ordering", (AlignmentOrder)alorders.get(0));
                } else {
                    int i;
                    Vector<String> names = new Vector<String>();
                    int l = alorders.size();
                    for (i = 0; i < l; ++i) {
                        String orderName = new String(" Region " + i);
                        int j = i + 1;
                        while (j < l) {
                            if (((AlignmentOrder)alorders.get(i)).equals(alorders.get(j))) {
                                alorders.remove(j);
                                --l;
                                orderName = orderName + "," + j;
                                continue;
                            }
                            ++j;
                        }
                        if (i == 0 && j == 1) {
                            names.add(new String(""));
                            continue;
                        }
                        names.add(orderName);
                    }
                    l = alorders.size();
                    for (i = 0; i < l; ++i) {
                        af.addSortByOrderMenuItem(this.WebServiceName + (String)names.get(i) + " Ordering", (AlignmentOrder)alorders.get(i));
                    }
                }
            }
            Desktop.addInternalFrame(af, this.alTitle, 700, 500);
        } else {
            System.out.println("MERGE WITH OLD FRAME");
        }
    }

    @Override
    public boolean canMergeResults() {
        return false;
    }

    class MsaWSJob
    extends WSJob {
        SequenceSet seqs = new SequenceSet();
        Hashtable SeqNames = new Hashtable();
        Vector emptySeqs = new Vector();

        public MsaWSJob(int jobNum, SequenceI[] inSeqs) {
            this.jobnum = jobNum;
            if (!this.prepareInput(inSeqs, 2)) {
                this.submitted = true;
                this.subjobComplete = true;
                this.result = new MsaResult();
                this.result.setFinished(true);
                this.result.setStatus(MessageManager.getString("label.job_never_ran"));
            }
        }

        private boolean prepareInput(SequenceI[] seqs, int minlen) {
            int nseqs = 0;
            if (minlen < 0) {
                throw new Error(MessageManager.getString("error.implementation_error_minlen_must_be_greater_zero"));
            }
            for (int i = 0; i < seqs.length; ++i) {
                if (seqs[i].getEnd() - seqs[i].getStart() <= minlen - 1) continue;
                ++nseqs;
            }
            boolean valid = nseqs > 1;
            vamsas.objects.simple.Sequence[] seqarray = valid ? new vamsas.objects.simple.Sequence[nseqs] : null;
            int n = 0;
            for (int i = 0; i < seqs.length; ++i) {
                String newname = SeqsetUtils.unique_name(i);
                this.SeqNames.put(newname, SeqsetUtils.SeqCharacterHash(seqs[i]));
                if (valid && seqs[i].getEnd() - seqs[i].getStart() > minlen - 1) {
                    seqarray[n] = new vamsas.objects.simple.Sequence();
                    seqarray[n].setId(newname);
                    seqarray[n++].setSeq(MsaWSThread.this.submitGaps ? seqs[i].getSequenceAsString() : AlignSeq.extractGaps(Comparison.GapChars, seqs[i].getSequenceAsString()));
                    continue;
                }
                String empty = null;
                if (seqs[i].getEnd() >= seqs[i].getStart()) {
                    empty = MsaWSThread.this.submitGaps ? seqs[i].getSequenceAsString() : AlignSeq.extractGaps(Comparison.GapChars, seqs[i].getSequenceAsString());
                }
                this.emptySeqs.add(new String[]{newname, empty});
            }
            this.seqs = new SequenceSet();
            this.seqs.setSeqs(seqarray);
            return valid;
        }

        @Override
        public boolean hasResults() {
            return this.subjobComplete && this.result != null && this.result.isFinished() && ((MsaResult)this.result).getMsa() != null && ((MsaResult)this.result).getMsa().getSeqs() != null;
        }

        public Object[] getAlignment() {
            if (this.result != null && this.result.isFinished()) {
                SequenceI[] alseqs = null;
                char alseq_gapchar = '-';
                int alseq_l = 0;
                if (((MsaResult)this.result).getMsa() != null) {
                    alseqs = MsaWSThread.this.getVamsasAlignment(((MsaResult)this.result).getMsa());
                    alseq_gapchar = ((MsaResult)this.result).getMsa().getGapchar().charAt(0);
                    alseq_l = alseqs.length;
                }
                if (this.emptySeqs.size() > 0) {
                    int sw;
                    int i;
                    SequenceI[] t_alseqs = new SequenceI[alseq_l + this.emptySeqs.size()];
                    int w = 0;
                    if (alseq_l > 0) {
                        w = alseqs[0].getLength();
                        for (i = 0; i < alseq_l; ++i) {
                            if (w < alseqs[i].getLength()) {
                                w = alseqs[i].getLength();
                            }
                            t_alseqs[i] = alseqs[i];
                            alseqs[i] = null;
                        }
                    }
                    int ow = w;
                    int nw = w;
                    w = this.emptySeqs.size();
                    for (i = 0; i < w; ++i) {
                        String[] es = (String[])this.emptySeqs.get(i);
                        if (es == null || es[1] == null || nw >= (sw = es[1].length())) continue;
                        nw = sw;
                    }
                    StringBuffer insbuff = new StringBuffer(w);
                    for (i = 0; i < nw; ++i) {
                        insbuff.append(alseq_gapchar);
                    }
                    if (ow < nw) {
                        for (i = 0; i < alseq_l; ++i) {
                            sw = t_alseqs[i].getLength();
                            if (nw <= sw) continue;
                            alseqs[i].setSequence(t_alseqs[i].getSequenceAsString() + insbuff.substring(0, sw - nw));
                        }
                    }
                    w = this.emptySeqs.size();
                    for (i = 0; i < w; ++i) {
                        String[] es = (String[])this.emptySeqs.get(i);
                        t_alseqs[i + alseq_l] = es[1] == null ? new Sequence(es[0], insbuff.toString(), 1, 0) : (es[1].length() < nw ? new Sequence(es[0], es[1] + insbuff.substring(0, nw - es[1].length()), 1, 1 + es[1].length()) : new Sequence(es[0], es[1]));
                    }
                    alseqs = t_alseqs;
                }
                AlignmentOrder msaorder = new AlignmentOrder(alseqs);
                AlignmentSorter.recoverOrder(alseqs);
                SeqsetUtils.deuniquify(this.SeqNames, alseqs);
                return new Object[]{alseqs, msaorder};
            }
            return null;
        }

        void cancel() {
            this.cancelled = true;
            this.subjobComplete = true;
            this.result = null;
        }

        @Override
        public boolean hasValidInput() {
            return this.seqs.getSeqs() != null;
        }
    }
}

