/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.dbsources;

import jalview.bin.Cache;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FormatAdapter;
import jalview.ws.seqfetcher.DbSourceProxyImpl;

public abstract class Xfam
extends DbSourceProxyImpl {
    protected abstract String getURLPrefix();

    @Override
    public abstract String getDbVersion();

    abstract String getXfamSource();

    @Override
    public AlignmentI getSequenceRecords(String queries) throws Exception {
        this.startQuery();
        String xfamUrl = this.getURL(queries);
        if (Cache.log != null) {
            Cache.log.debug((Object)("XFAM URL for retrieval is: " + xfamUrl));
        }
        AlignmentI rcds = new FormatAdapter().readFile(xfamUrl, DataSourceType.URL, (FileFormatI)FileFormat.Stockholm);
        int sNum = rcds.getHeight();
        for (int s = 0; s < sNum; ++s) {
            rcds.getSequenceAt(s).addDBRef(new DBRefEntry(this.getXfamSource(), this.getDbVersion(), queries.trim().toUpperCase()));
            if (this.getDbSource().equals(this.getXfamSource())) continue;
            rcds.getSequenceAt(s).addDBRef(new DBRefEntry(this.getDbSource(), this.getDbVersion(), queries.trim().toUpperCase()));
        }
        this.stopQuery();
        return rcds;
    }

    String getURL(String queries) {
        return this.getURLPrefix() + "/family/" + queries.trim().toUpperCase() + this.getURLSuffix();
    }

    @Override
    public boolean isAlignmentSource() {
        return true;
    }

    public String getURLSuffix() {
        return "";
    }
}

