/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import jalview.analysis.AlignSeq;
import jalview.api.FeatureSettingsModelI;
import jalview.bin.Cache;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.Mapping;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.FeatureSettings;
import jalview.gui.IProgressIndicator;
import jalview.gui.OOMWarning;
import jalview.util.DBRefUtils;
import jalview.util.MessageManager;
import jalview.ws.SequenceFetcher;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import uk.ac.ebi.picr.model.UPEntry;
import uk.ac.ebi.www.picr.AccessionMappingService.AccessionMapperInterface;
import uk.ac.ebi.www.picr.AccessionMappingService.AccessionMapperServiceLocator;

public class DBRefFetcher
implements Runnable {
    private static final String NEWLINE = System.lineSeparator();
    public static final String TRIM_RETRIEVED_SEQUENCES = "TRIM_FETCHED_DATASET_SEQS";
    SequenceI[] dataset;
    IProgressIndicator progressWindow;
    CutAndPasteTransfer output = new CutAndPasteTransfer();
    AccessionMapperInterface picrClient = null;
    Hashtable<String, Vector<SequenceI>> seqRefs;
    DbSourceProxy[] dbSources;
    SequenceFetcher sfetcher;
    private List<FetchFinishedListenerI> listeners = new ArrayList<FetchFinishedListenerI>();
    private SequenceI[] alseqs;
    private boolean trimDsSeqs = true;
    Map<String, FeatureSettingsModelI> featureDisplaySettings = null;

    public DBRefFetcher(SequenceI[] seqs, IProgressIndicator progressIndicatorFrame, DbSourceProxy[] sources, FeatureSettings featureSettings, boolean isNucleotide) {
        this.progressWindow = progressIndicatorFrame;
        this.alseqs = new SequenceI[seqs.length];
        SequenceI[] ds = new SequenceI[seqs.length];
        for (int i = 0; i < seqs.length; ++i) {
            this.alseqs[i] = seqs[i];
            ds[i] = seqs[i].getDatasetSequence() != null ? seqs[i].getDatasetSequence() : seqs[i];
        }
        this.dataset = ds;
        this.sfetcher = jalview.gui.SequenceFetcher.getSequenceFetcherSingleton();
        this.trimDsSeqs = Cache.getDefault(TRIM_RETRIEVED_SEQUENCES, true);
        if (sources == null) {
            this.setDatabaseSources(featureSettings, isNucleotide);
        } else {
            this.dbSources = sources;
        }
    }

    void setDatabaseSources(FeatureSettings featureSettings, boolean forNucleotide) {
        String[] defdb = null;
        ArrayList selsources = new ArrayList();
        defdb = forNucleotide ? DBRefSource.DNACODINGDBS : DBRefSource.PROTEINDBS;
        ArrayList<DbSourceProxy> srces = new ArrayList<DbSourceProxy>();
        for (String ddb : defdb) {
            List<DbSourceProxy> srcesfordb = this.sfetcher.getSourceProxy(ddb);
            if (srcesfordb == null) continue;
            for (DbSourceProxy src : srcesfordb) {
                if (srces.contains(src)) continue;
                srces.addAll(srcesfordb);
            }
        }
        srces.addAll(selsources);
        this.dbSources = srces.toArray(new DbSourceProxy[srces.size()]);
    }

    public DBRefFetcher(SequenceI[] sequences) {
        this(sequences, null, null, null, false);
    }

    public void addListener(FetchFinishedListenerI l) {
        this.listeners.add(l);
    }

    public void fetchDBRefs(boolean waitTillFinished) {
        if (waitTillFinished) {
            this.run();
        } else {
            new Thread(this).start();
        }
    }

    void addSeqId(SequenceI seq, String key) {
        Vector<Object> seqs;
        if (this.seqRefs.containsKey(key = key.toUpperCase())) {
            seqs = this.seqRefs.get(key);
            if (seqs != null && !seqs.contains(seq)) {
                seqs.addElement(seq);
            } else if (seqs == null) {
                seqs = new Vector();
                seqs.addElement(seq);
            }
        } else {
            seqs = new Vector<SequenceI>();
            seqs.addElement(seq);
        }
        this.seqRefs.put(key, seqs);
    }

    @Override
    public void run() {
        if (this.dbSources == null) {
            throw new Error(MessageManager.getString("error.implementation_error_must_init_dbsources"));
        }
        long startTime = System.currentTimeMillis();
        if (this.progressWindow != null) {
            this.progressWindow.setProgressBar(MessageManager.getString("status.fetching_db_refs"), startTime);
        }
        try {
            if (Cache.getDefault("DBREFFETCH_USEPICR", false)) {
                this.picrClient = new AccessionMapperServiceLocator().getAccessionMapperPort();
            }
        }
        catch (Exception e) {
            System.err.println("Couldn't locate PICR service instance.\n");
            e.printStackTrace();
        }
        Vector<SequenceI> sdataset = new Vector<SequenceI>(Arrays.asList(this.dataset));
        ArrayList<String> warningMessages = new ArrayList<String>();
        this.featureDisplaySettings = null;
        for (int db = 0; sdataset.size() > 0 && db < this.dbSources.length; ++db) {
            int maxqlen = 1;
            System.out.println("Verifying against " + this.dbSources[db].getDbName());
            Object[] currSeqs = new SequenceI[sdataset.size()];
            sdataset.copyInto(currSeqs);
            Vector<String> queries = new Vector<String>();
            this.seqRefs = new Hashtable();
            int seqIndex = 0;
            DbSourceProxy dbsource = this.dbSources[db];
            maxqlen = dbsource.getMaximumQueryCount();
            while (queries.size() > 0 || seqIndex < currSeqs.length) {
                if (queries.size() > 0) {
                    int nqSize;
                    StringBuffer queryString = new StringBuffer("");
                    int numq = 0;
                    int n = nqSize = maxqlen > queries.size() ? queries.size() : maxqlen;
                    while (queries.size() > 0 && numq < nqSize) {
                        String query = (String)queries.elementAt(0);
                        if (dbsource.isValidReference(query)) {
                            queryString.append(numq == 0 ? "" : dbsource.getAccessionSeparator());
                            queryString.append(query);
                            ++numq;
                        }
                        queries.removeElementAt(0);
                    }
                    AlignmentI retrieved = null;
                    try {
                        if (Cache.log.isDebugEnabled()) {
                            Cache.log.debug((Object)("Querying " + dbsource.getDbName() + " with : '" + queryString.toString() + "'"));
                        }
                        retrieved = dbsource.getSequenceRecords(queryString.toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    catch (OutOfMemoryError err) {
                        new OOMWarning("retrieving database references (" + queryString.toString() + ")", err);
                    }
                    if (retrieved == null) continue;
                    this.transferReferences(sdataset, dbsource, retrieved, this.trimDsSeqs, warningMessages);
                    continue;
                }
                for (int i = 0; seqIndex < this.dataset.length && i < 50; ++seqIndex, ++i) {
                    SequenceI sequence = this.dataset[seqIndex];
                    List<DBRefEntry> uprefs = DBRefUtils.selectRefs(sequence.getDBRefs(), new String[]{dbsource.getDbSource()});
                    if (uprefs != null && uprefs.size() > 0) {
                        int n = uprefs.size();
                        for (int j = 0; j < n; ++j) {
                            DBRefEntry upref = uprefs.get(j);
                            this.addSeqId(sequence, upref.getAccessionId());
                            queries.addElement(upref.getAccessionId().toUpperCase());
                        }
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer(sequence.getName(), "|");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        UPEntry[] presp = null;
                        if (this.picrClient != null) {
                            try {
                                presp = this.picrClient.getUPIForAccession(token, null, this.picrClient.getMappedDatabaseNames(), null, true);
                            }
                            catch (Exception e) {
                                System.err.println("Exception with Picr for '" + token + "'\n");
                                e.printStackTrace();
                            }
                        }
                        if (presp != null && presp.length > 0) {
                            for (int id = 0; id < presp.length; ++id) {
                            }
                            System.out.println("Validated ID against PICR... (for what its worth):" + token);
                            this.addSeqId(sequence, token);
                            queries.addElement(token.toUpperCase());
                            continue;
                        }
                        this.addSeqId(sequence, token);
                        queries.addElement(token.toUpperCase());
                    }
                }
            }
        }
        if (!warningMessages.isEmpty()) {
            StringBuilder sb = new StringBuilder(warningMessages.size() * 30);
            sb.append(MessageManager.getString("label.your_sequences_have_been_verified"));
            for (String msg : warningMessages) {
                sb.append(msg).append(NEWLINE);
            }
            this.output.setText(sb.toString());
            Desktop.addInternalFrame(this.output, MessageManager.getString("label.sequences_updated"), 600, 300);
        }
        if (this.progressWindow != null) {
            this.progressWindow.setProgressBar(MessageManager.getString("label.dbref_search_completed"), startTime);
        }
        for (FetchFinishedListenerI listener : this.listeners) {
            listener.finished();
        }
    }

    boolean transferReferences(Vector<SequenceI> sdataset, DbSourceProxy dbSourceProxy, AlignmentI retrievedAl, boolean trimDatasetSeqs, List<String> warningMessages) {
        if (retrievedAl == null || retrievedAl.getHeight() == 0) {
            return false;
        }
        String dbSource = dbSourceProxy.getDbName();
        boolean modified = false;
        SequenceI[] retrieved = this.recoverDbSequences(retrievedAl.getSequencesArray());
        SequenceI sequence = null;
        for (SequenceI retrievedSeq : retrieved) {
            Vector<SequenceI> sequenceMatches = new Vector<SequenceI>();
            List<DBRefEntry> entryRefs = DBRefUtils.selectRefs(retrievedSeq.getDBRefs(), new String[]{dbSource});
            if (entryRefs == null) {
                System.err.println("Dud dbSource string ? no entryrefs selected for " + dbSource + " on " + retrievedSeq.getName());
                continue;
            }
            int n = entryRefs.size();
            for (int j = 0; j < n; ++j) {
                DBRefEntry ref = entryRefs.get(j);
                String accessionId = ref.getAccessionId();
                if (!this.seqRefs.containsKey(accessionId.toUpperCase())) continue;
                Vector<SequenceI> seqs = this.seqRefs.get(accessionId);
                for (int jj = 0; jj < seqs.size(); ++jj) {
                    sequence = seqs.elementAt(jj);
                    if (sequenceMatches.contains(sequence)) continue;
                    sequenceMatches.addElement(sequence);
                }
            }
            if (sequenceMatches.isEmpty()) {
                Enumeration<String> e = this.seqRefs.keys();
                while (e.hasMoreElements()) {
                    Vector<SequenceI> sqs = this.seqRefs.get(e.nextElement());
                    if (sqs == null || sqs.size() <= 0) continue;
                    Enumeration<SequenceI> sqe = sqs.elements();
                    while (sqe.hasMoreElements()) {
                        sequenceMatches.addElement(sqe.nextElement());
                    }
                }
            }
            if (sequenceMatches.size() > 0) {
                this.addFeatureSettings(dbSourceProxy);
            }
            String retrievedSeqString = retrievedSeq.getSequenceAsString();
            String entrySeq = retrievedSeqString.toUpperCase();
            for (int m = 0; m < sequenceMatches.size(); ++m) {
                Mapping mp;
                sequence = (SequenceI)sequenceMatches.elementAt(m);
                boolean updateRefFrame = sequence.getDBRefs() == null || sequence.getDBRefs().size() == 0;
                int sequenceStart = sequence.getStart();
                boolean remoteEnclosesLocal = false;
                String nonGapped = AlignSeq.extractGaps("-. ", sequence.getSequenceAsString()).toUpperCase();
                int absStart = entrySeq.indexOf(nonGapped);
                if (absStart == -1) {
                    absStart = nonGapped.indexOf(entrySeq);
                    if (absStart == -1) continue;
                    String msg = sequence.getName() + " has " + absStart + " prefixed residues compared to " + retrievedSeq.getName();
                    this.addWarningMessage(warningMessages, msg);
                    mp = new Mapping(null, new int[]{sequenceStart + absStart, sequenceStart + absStart + entrySeq.length() - 1}, new int[]{retrievedSeq.getStart(), retrievedSeq.getStart() + entrySeq.length() - 1}, 1, 1);
                    updateRefFrame = false;
                } else {
                    int startShift;
                    remoteEnclosesLocal = true;
                    mp = null;
                    if (updateRefFrame && (startShift = absStart - sequenceStart + 1) != 0) {
                        modified |= sequence.getFeatures().shiftFeatures(1, startShift);
                    }
                }
                System.out.println("Adding dbrefs to " + sequence.getName() + " from " + dbSource + " sequence : " + retrievedSeq.getName());
                sequence.transferAnnotation(retrievedSeq, mp);
                int absEnd = (absStart += retrievedSeq.getStart()) + nonGapped.length() - 1;
                if (!trimDatasetSeqs) {
                    if (!retrievedSeqString.equals(sequence.getSequenceAsString()) && remoteEnclosesLocal) {
                        sequence.setSequence(retrievedSeqString);
                        modified = true;
                        this.addWarningMessage(warningMessages, "Sequence for " + sequence.getName() + " expanded from " + retrievedSeq.getName());
                    }
                    if (sequence.getStart() != retrievedSeq.getStart()) {
                        sequence.setStart(retrievedSeq.getStart());
                        modified = true;
                        if (absStart != sequenceStart) {
                            this.addWarningMessage(warningMessages, "Start/end position for " + sequence.getName() + " updated from " + retrievedSeq.getName());
                        }
                    }
                }
                if (updateRefFrame) {
                    if (trimDatasetSeqs && (sequence.getStart() != absStart || sequence.getEnd() != absEnd)) {
                        sequence.setStart(absStart);
                        sequence.setEnd(absEnd);
                        modified = true;
                        this.addWarningMessage(warningMessages, "Start/end for " + sequence.getName() + " updated from " + retrievedSeq.getName());
                    }
                    for (int alsq = 0; alsq < this.alseqs.length; ++alsq) {
                        if (this.alseqs[alsq].getDatasetSequence() != sequence) continue;
                        String ngAlsq = AlignSeq.extractGaps("-. ", this.alseqs[alsq].getSequenceAsString()).toUpperCase();
                        int oldstrt = this.alseqs[alsq].getStart();
                        this.alseqs[alsq].setStart(sequence.getSequenceAsString().toUpperCase().indexOf(ngAlsq) + sequence.getStart());
                        if (oldstrt == this.alseqs[alsq].getStart()) continue;
                        this.alseqs[alsq].setEnd(ngAlsq.length() + this.alseqs[alsq].getStart() - 1);
                        modified = true;
                    }
                }
                sdataset.remove(sequence);
            }
        }
        return modified;
    }

    private void addFeatureSettings(DbSourceProxy dbSourceProxy) {
        FeatureSettingsModelI fsettings = dbSourceProxy.getFeatureColourScheme();
        if (fsettings != null) {
            if (this.featureDisplaySettings == null) {
                this.featureDisplaySettings = new HashMap<String, FeatureSettingsModelI>();
            }
            this.featureDisplaySettings.put(dbSourceProxy.getDbName(), fsettings);
        }
    }

    public List<FeatureSettingsModelI> getFeatureSettingsModels() {
        return this.featureDisplaySettings == null ? Arrays.asList(new FeatureSettingsModelI[0]) : Arrays.asList(this.featureDisplaySettings.values().toArray(new FeatureSettingsModelI[1]));
    }

    void addWarningMessage(List<String> messageList, String msg) {
        if (!messageList.contains(msg)) {
            messageList.add(msg);
        }
    }

    private SequenceI[] recoverDbSequences(SequenceI[] sequencesArray) {
        int n;
        if (sequencesArray == null || (n = sequencesArray.length) == 0) {
            return sequencesArray;
        }
        ArrayList<SequenceI> nseq = new ArrayList<SequenceI>();
        for (int i = 0; i < n; ++i) {
            nseq.add(sequencesArray[i]);
            Sequence.DBModList<DBRefEntry> dbr = sequencesArray[i].getDBRefs();
            Mapping map = null;
            if (dbr == null) continue;
            int rn = dbr.size();
            for (int r = 0; r < rn; ++r) {
                map = ((DBRefEntry)dbr.get(r)).getMap();
                if (map == null || map.getTo() == null || nseq.contains(map.getTo())) continue;
                nseq.add(map.getTo());
            }
        }
        if (nseq.size() > 0) {
            return nseq.toArray(new SequenceI[nseq.size()]);
        }
        return sequencesArray;
    }

    public static interface FetchFinishedListenerI {
        public void finished();
    }
}

