/*
 * Decompiled with CFR 0.152.
 */
package jalview.viewmodel.seqfeatures;

import jalview.api.FeaturesDisplayedI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FeaturesDisplayed
implements FeaturesDisplayedI {
    private Set<String> featuresDisplayed = new HashSet<String>();
    private Set<String> featuresRegistered = new HashSet<String>();

    public FeaturesDisplayed(FeaturesDisplayedI featuresDisplayed2) {
        Set<String> fdisp = featuresDisplayed2.getVisibleFeatures();
        for (String ftype : fdisp) {
            this.featuresDisplayed.add(ftype);
            this.featuresRegistered.add(ftype);
        }
    }

    public FeaturesDisplayed() {
    }

    @Override
    public Set<String> getVisibleFeatures() {
        return Collections.unmodifiableSet(this.featuresDisplayed);
    }

    @Override
    public boolean isVisible(String featureType) {
        return this.featuresDisplayed.contains(featureType);
    }

    @Override
    public boolean areVisible(Collection<String> featureTypes) {
        return this.featuresDisplayed.containsAll(featureTypes);
    }

    @Override
    public void clear() {
        this.featuresDisplayed.clear();
        this.featuresRegistered.clear();
    }

    @Override
    public void setAllVisible(Collection<String> makeVisible) {
        this.featuresDisplayed.addAll(makeVisible);
        this.featuresRegistered.addAll(makeVisible);
    }

    @Override
    public void setAllRegisteredVisible() {
        this.featuresDisplayed.addAll(this.featuresRegistered);
    }

    @Override
    public void setVisible(String featureType) {
        this.featuresDisplayed.add(featureType);
        this.featuresRegistered.add(featureType);
    }

    @Override
    public boolean isRegistered(String type) {
        return this.featuresRegistered.contains(type);
    }

    @Override
    public int getVisibleFeatureCount() {
        return this.featuresDisplayed.size();
    }

    @Override
    public int getRegisteredFeaturesCount() {
        return this.featuresRegistered.size();
    }
}

