/*
 * Decompiled with CFR 0.152.
 */
package jalview.viewmodel;

import jalview.api.AlignmentColsCollectionI;
import jalview.api.AlignmentRowsCollectionI;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.HiddenSequences;
import jalview.viewmodel.ViewportRanges;
import java.awt.Graphics;

public abstract class OverviewDimensions {
    protected static final int MAX_WIDTH = 400;
    protected static final int MIN_WIDTH = 120;
    protected static final int MIN_SEQ_HEIGHT = 40;
    protected static final int MAX_SEQ_HEIGHT = 300;
    private static final int DEFAULT_GRAPH_HEIGHT = 20;
    protected int width;
    protected int sequencesHeight;
    protected int graphHeight = 20;
    protected int boxX = -1;
    protected int boxY = -1;
    protected int boxWidth = -1;
    protected int boxHeight = -1;
    protected int alwidth;
    protected int alheight;
    protected float widthRatio;
    protected float heightRatio;

    public OverviewDimensions(ViewportRanges ranges, boolean showAnnotationPanel) {
        float initialScale = (float)ranges.getAbsoluteAlignmentWidth() / (float)ranges.getAbsoluteAlignmentHeight();
        if (!showAnnotationPanel) {
            this.graphHeight = 0;
        }
        if (ranges.getAbsoluteAlignmentWidth() > ranges.getAbsoluteAlignmentHeight()) {
            this.width = 400;
            this.sequencesHeight = Math.round(400.0f / initialScale);
            if (this.sequencesHeight < 40) {
                this.sequencesHeight = 40;
            }
        } else {
            this.width = Math.round(400.0f * initialScale);
            this.sequencesHeight = 300;
            if (this.width < 120) {
                this.width = 120;
            }
        }
    }

    public void drawBox(Graphics g) {
        g.drawRect(this.boxX, this.boxY, this.boxWidth, this.boxHeight);
        g.drawRect(this.boxX + 1, this.boxY + 1, this.boxWidth - 2, this.boxHeight - 2);
    }

    public int getBoxX() {
        return this.boxX;
    }

    public int getBoxY() {
        return this.boxY;
    }

    public int getBoxWidth() {
        return this.boxWidth;
    }

    public int getBoxHeight() {
        return this.boxHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.sequencesHeight + this.graphHeight;
    }

    public int getSequencesHeight() {
        return this.sequencesHeight;
    }

    public int getGraphHeight() {
        return this.graphHeight;
    }

    public float getPixelsPerCol() {
        this.resetAlignmentDims();
        return 1.0f / this.widthRatio;
    }

    public float getPixelsPerSeq() {
        this.resetAlignmentDims();
        return 1.0f / this.heightRatio;
    }

    public void setWidth(int w) {
        this.width = w;
        this.widthRatio = (float)this.alwidth / (float)this.width;
    }

    public void setHeight(int h) {
        this.sequencesHeight = h - this.graphHeight;
        this.heightRatio = (float)this.alheight / (float)this.sequencesHeight;
    }

    public abstract void updateViewportFromMouse(int var1, int var2, HiddenSequences var3, HiddenColumns var4);

    public abstract void adjustViewportFromMouse(int var1, int var2, HiddenSequences var3, HiddenColumns var4);

    public abstract void setDragPoint(int var1, int var2, HiddenSequences var3, HiddenColumns var4);

    protected abstract void updateViewportFromTopLeft(int var1, int var2, HiddenSequences var3, HiddenColumns var4);

    public abstract void setBoxPosition(HiddenSequences var1, HiddenColumns var2);

    public abstract AlignmentColsCollectionI getColumns(AlignmentI var1);

    public abstract AlignmentRowsCollectionI getRows(AlignmentI var1);

    protected abstract void resetAlignmentDims();

    protected void setBoxPosition(int startRes, int startSeq, int vpwidth, int vpheight) {
        this.resetAlignmentDims();
        int xPos = Math.min(startRes, this.alwidth - vpwidth + 1);
        this.boxX = Math.round((float)xPos / this.widthRatio);
        this.boxY = Math.round((float)startSeq / this.heightRatio);
        this.boxWidth = Math.round((float)vpwidth / this.widthRatio);
        this.boxHeight = Math.round((float)vpheight / this.heightRatio);
    }

    public boolean isPositionInBox(int x, int y) {
        return x > this.boxX && y > this.boxY && x < this.boxX + this.boxWidth && y < this.boxY + this.boxHeight;
    }

    protected abstract int getLeftXFromCentreX(int var1, HiddenColumns var2);

    protected abstract int getTopYFromCentreY(int var1, HiddenSequences var2);
}

