/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;

public class MessageManager {
    private static ResourceBundle rb;
    private static Logger log;
    private static Locale loc;
    private static Set<String> reportedMissing;

    public static String getString(String key) {
        String value = "[missing key] " + key;
        try {
            value = rb.getString(key);
        }
        catch (Exception e) {
            String msg = "I18N missing: " + loc + "\t" + key;
            MessageManager.logWarning(key, msg);
        }
        return value;
    }

    public static Locale getLocale() {
        return loc;
    }

    public static String formatMessage(String key, Object ... params) {
        try {
            return MessageFormat.format(rb.getString(key), params);
        }
        catch (Exception e) {
            log.warn((Object)("I18N missing: " + loc + "\t" + key));
            String value = "[missing key] " + key + "";
            for (Object p : params) {
                value = value + " '" + p.toString() + "'";
            }
            return value;
        }
    }

    public static String formatMessage(String key, String[] params) {
        return MessageManager.formatMessage(key, (Object[])params);
    }

    public static String getStringOrReturn(String keyroot, String name) {
        String smkey = keyroot + name.toLowerCase().replaceAll(" ", "");
        try {
            name = rb.getString(smkey);
        }
        catch (Exception x) {
            String msg = "I18N missing key with root " + keyroot + ": " + loc + "\t" + smkey;
            MessageManager.logWarning(smkey, msg);
        }
        return name;
    }

    private static void logWarning(String key, String msg) {
        if (!reportedMissing.contains(key)) {
            reportedMissing.add(key);
            log.info((Object)msg);
        }
    }

    static {
        log = Logger.getLogger((String)MessageManager.class.getCanonicalName());
        reportedMissing = new HashSet<String>();
        try {
            loc = Locale.getDefault();
            log.info((Object)("Getting messages for lang: " + loc));
            ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
            rb = ResourceBundle.getBundle("lang.Messages", loc, control);
        }
        catch (Exception q) {
            log.warn((Object)("Exception when initting Locale for i18n messages\n" + q.getMessage()));
            q.printStackTrace();
        }
        catch (Error v) {
            log.warn((Object)("Error when initting Locale for i18n messages\n" + v.getMessage()));
            v.printStackTrace();
        }
    }
}

