/*
 * Decompiled with CFR 0.152.
 */
package jalview.rest;

import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.rest.API;
import jalview.rest.AbstractEndpoint;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SelectSequencesEndpoint
extends AbstractEndpoint {
    protected static final String path = "selectsequences";
    private static final String name = "Select sequence(s) positions";
    private static final String parameters = "<sequence names>/<range>";
    private static final String description = "Select the specified sequence(s) with the specified range";

    public SelectSequencesEndpoint(API api) {
        super(api, path, name, parameters, description);
    }

    @Override
    public void processEndpoint(HttpServletRequest request, HttpServletResponse response) {
        if (!this.checkParameters(request, response, 2)) {
            return;
        }
        String[] parameters = this.getEndpointPathParameters(request);
        String rangesString = parameters[1];
        int[][] ranges = this.parseIntRanges(rangesString);
        if (ranges == null || ranges.length < 2 || ranges[0].length < 1) {
            this.returnError(request, response, "couldn't parse range '" + rangesString + "'");
            return;
        }
        if (ranges[0].length > 1) {
            this.returnError(request, response, "only provide 1 range '" + rangesString + "'");
            return;
        }
        int start = ranges[0][0];
        int end = ranges[1][0];
        String sequenceNamesString = parameters[0];
        List<String> sequenceNames = Arrays.asList(sequenceNamesString.split(","));
        AlignFrame[] alignFrames = this.getAlignFrames(request, true);
        if (alignFrames == null) {
            this.returnError(request, response, "could not find results");
            return;
        }
        for (int i = 0; i < alignFrames.length; ++i) {
            AlignFrame af = alignFrames[i];
            List<? extends AlignmentViewPanel> aps = af.getAlignPanels();
            for (AlignmentViewPanel alignmentViewPanel : aps) {
                AlignViewportI avp = alignmentViewPanel.getAlignViewport();
                AlignmentI al = alignmentViewPanel.getAlignment();
                List<SequenceI> seqs = al.getSequences();
                SequenceGroup stretchGroup = new SequenceGroup();
                for (SequenceI seq : seqs) {
                    if (!sequenceNames.contains(seq.getName()) && (!sequenceNamesString.equals("*") || alignFrames.length != 1)) continue;
                    stretchGroup.addSequence(seq, false);
                }
                if (start == -1 && end == -1) {
                    stretchGroup.setStartRes(al.getStartRes());
                    stretchGroup.setEndRes(al.getEndRes());
                } else {
                    stretchGroup.setStartRes(start);
                    stretchGroup.setEndRes(end);
                }
                avp.setSelectionGroup(stretchGroup);
                alignmentViewPanel.paintAlignment(false, false);
                avp.sendSelection();
            }
        }
    }
}

