/*
 * Decompiled with CFR 0.152.
 */
package jalview.rest;

import jalview.bin.Cache;
import jalview.httpserver.AbstractRequestHandler;
import jalview.httpserver.HttpServer;
import jalview.rest.AbstractEndpoint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.handler.ContextHandler;

public class RestHandler
extends AbstractRequestHandler {
    private static final String MY_PATH = "rest";
    private static final String MY_NAME = "Rest";
    private String missingEndpointMessage = null;
    private boolean init = false;
    private Map<String, EndpointI> endpoints = null;
    private static RestHandler instance = null;

    protected Map<String, EndpointI> getEndpoints() {
        return this.endpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RestHandler getInstance() throws BindException {
        Class<RestHandler> clazz = RestHandler.class;
        synchronized (RestHandler.class) {
            if (instance == null) {
                instance = new RestHandler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected RestHandler() throws BindException {
        this.init();
    }

    @Override
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        System.out.println(request.toString());
        if (this.endpoints == null) {
            String queryString = request.getQueryString();
            String reply = "REST not yet implemented; received " + request.getMethod() + ": " + request.getRequestURL() + (queryString == null ? "" : "?" + queryString);
            System.out.println(reply);
            response.setHeader("Cache-Control", "no-cache/no-store");
            response.setHeader("Content-type", "text/plain");
            PrintWriter writer = response.getWriter();
            writer.write(reply);
            return;
        }
        String endpointName = this.getRequestedEndpointName(request);
        if (!this.endpoints.containsKey(endpointName) || this.endpoints.get(endpointName) == null) {
            response.setHeader("Cache-Control", "no-cache/no-store");
            response.setHeader("Content-type", "text/plain");
            PrintWriter writer = response.getWriter();
            writer.write(this.missingEndpointMessage == null ? "REST endpoint '" + endpointName + "' not defined" : this.missingEndpointMessage);
            writer.write("\n");
            writer.write("Available endpoints are:\n");
            ContextHandler ch = HttpServer.getInstance().getContextHandler(this);
            String base = HttpServer.getInstance().getUri().toString();
            String contextPath = ch == null ? "" : ch.getContextPath();
            for (String key : this.endpoints.keySet()) {
                writer.write(base + contextPath + "/" + key + "\n");
            }
            response.setStatus(400);
            return;
        }
        response.setHeader("Cache-Control", "no-cache/no-store");
        response.setHeader("Content-type", "text/plain");
        EndpointI ep = this.endpoints.get(endpointName);
        ep.processEndpoint(request, response);
    }

    @Override
    public String getName() {
        return MY_NAME;
    }

    protected void init() throws BindException {
        this.init(MY_PATH);
    }

    protected void init(String path) throws BindException {
        this.setPath(path);
    }

    protected boolean addEndpoint(EndpointI ep) {
        if (this.endpoints == null) {
            this.endpoints = new HashMap<String, EndpointI>();
        }
        AbstractEndpoint e = (AbstractEndpoint)ep;
        this.endpoints.put(ep.getPath(), ep);
        return true;
    }

    protected String getRequestedEndpointName(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        int slashpos = pathInfo.indexOf(47, 1);
        return slashpos > 1 ? pathInfo.substring(1, slashpos) : pathInfo.substring(1);
    }

    protected String[] getEndpointPathParameters(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        int slashpos = pathInfo.indexOf(47, 1);
        return slashpos < 1 ? null : pathInfo.substring(slashpos + 1).split("/");
    }

    protected void returnError(HttpServletRequest request, HttpServletResponse response, String message) {
        response.setStatus(500);
        String endpointName = this.getRequestedEndpointName(request);
        Cache.error(this.getName() + " error: endpoint " + endpointName + " failed: '" + message + "'");
        try {
            PrintWriter writer = response.getWriter();
            writer.write("Endpoint " + endpointName + ": " + message);
        }
        catch (IOException e) {
            Cache.debug(e);
        }
    }

    protected void returnStatus(HttpServletResponse response, String id, Status status) {
        try {
            PrintWriter writer = response.getWriter();
            if (id != null) {
                writer.write("id=" + id + "\n");
            }
            if (status != null) {
                writer.write("status=" + status.toString() + "\n");
            }
        }
        catch (IOException e) {
            Cache.debug(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRequestBody(HttpServletRequest request) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        return sb.toString();
    }

    public static interface EndpointI {
        public String getPath();

        public String getName();

        public String getParameters();

        public String getDescription();

        public void processEndpoint(HttpServletRequest var1, HttpServletResponse var2);
    }

    public static enum Status {
        STARTED,
        IN_PROGRESS,
        FINISHED,
        ERROR,
        NOT_RUN;

    }
}

