/*
 * Decompiled with CFR 0.152.
 */
package jalview.rest;

import jalview.bin.Cache;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.rest.API;
import jalview.rest.AbstractEndpointAsync;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DatatypeConverter;

public class InputAlignmentEndpoint
extends AbstractEndpointAsync {
    protected static final String path = "inputalignment";
    private static final String name = "Input Alignment";
    private static final String parameters = "POST <body> | GET ?[data=<data>|file=<fileURI>|url=<URL>]";
    private static final String description = "Input an alignment from POST request body, GET request 'data' parameter, local file in 'file' parameter, url in 'url' parameter";
    private String fileString;
    private String urlString;
    private String method;
    private String data;
    private String body;
    private boolean isPost;
    private boolean hasData;
    private String access = null;
    private String ref = null;

    public InputAlignmentEndpoint(API api) {
        super(api, path, name, parameters, description);
    }

    @Override
    protected void initialise(HttpServletRequest request, HttpServletResponse response) {
        String content;
        this.fileString = request.getParameter("file");
        this.urlString = request.getParameter("url");
        this.method = request.getMethod().toLowerCase();
        this.data = request.getParameter("data");
        this.body = null;
        this.isPost = this.method.equalsIgnoreCase("post");
        boolean bl = this.hasData = this.data != null;
        if (this.isPost) {
            this.access = "post";
            try {
                this.body = this.getRequestBody(request);
            }
            catch (IOException e) {
                this.returnError(request, response, "could not read POST body");
                Cache.debug(e);
                return;
            }
        } else if (this.hasData) {
            this.access = "data";
        } else if (this.fileString != null) {
            this.access = "file";
            this.ref = this.fileString;
        } else if (this.urlString != null) {
            this.access = "url";
            this.ref = this.urlString;
        }
        if (this.access == null) {
            this.returnError(request, response, "requires POST body or one of parameters 'data', 'file' or 'url'");
            return;
        }
        if (this.isPost || this.hasData) {
            content = this.isPost ? this.body : this.data;
            this.objectsPassedToProcessAsync.put("content", content);
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(content.getBytes());
                byte[] digest = md5.digest();
                this.ref = DatatypeConverter.printBase64Binary((byte[])digest).toLowerCase();
            }
            catch (NoSuchAlgorithmException e) {
                Cache.debug(e);
            }
        } else {
            content = null;
        }
        this.objectsPassedToProcessAsync.put("content", content);
        this.setId(request, this.access + "::" + this.ref);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) {
        this.processAsync(request, response, null);
    }

    @Override
    protected void processAsync(HttpServletRequest request, HttpServletResponse response, Map<String, Object> finalMap) {
        boolean success;
        String content = (String)finalMap.get("content");
        if (this.isPost || this.hasData) {
            CutAndPasteTransfer cap = new CutAndPasteTransfer();
            cap.setText(content);
            cap.ok_actionPerformed(null);
            cap.cancel_actionPerformed(null);
        } else if (this.fileString != null) {
            URL url = null;
            File file = null;
            try {
                url = new URL(this.fileString);
                file = new File(url.toURI());
            }
            catch (MalformedURLException | URISyntaxException e) {
                this.returnError(request, response, "could not resolve file='" + this.fileString + "'");
                Cache.debug(e);
                return;
            }
            if (!file.exists()) {
                this.returnError(request, response, "file='" + this.fileString + "' does not exist");
                return;
            }
            Desktop.instance.openFile(file, null, null);
        } else if (this.urlString != null && !(success = Desktop.instance.loadUrl(this.urlString, null))) {
            this.returnError(request, response, "url='" + this.urlString + "' could not be opened");
            return;
        }
    }
}

