/*
 * Decompiled with CFR 0.152.
 */
package jalview.rest;

import jalview.api.AlignmentViewPanel;
import jalview.bin.Cache;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.rest.API;
import jalview.rest.AbstractEndpointAsync;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetCrossReferencesEndpoint
extends AbstractEndpointAsync {
    private static final String path = "getcrossreferences";
    private static final String name = "Get Cross References";
    private static final String parameters = "<resource name>/<sequence ids>?fromId=<id>";
    private static final String description = "Get Cross References for alignment <id>";
    private String resourceName;
    private AlignFrame af;
    private SequenceI[] seqs;

    public GetCrossReferencesEndpoint(API api) {
        super(api, path, name, parameters, description);
    }

    @Override
    protected void initialise(HttpServletRequest request, HttpServletResponse response) {
        if (!this.checkParameters(request, response, 1)) {
            return;
        }
        String[] parameters = this.getEndpointPathParameters(request);
        this.resourceName = parameters[0];
        String fromId = request.getParameter("fromId");
        this.setId(request, this.resourceName + "::" + fromId);
        if (this.checkStatus(request, response)) {
            return;
        }
        this.af = this.getAlignFrameFromId(request);
        if (this.af == null) {
            this.returnError(request, response, "Could not find results");
            return;
        }
        if (this.af.canShowProducts()) {
            List<String> products = this.af.getProducts();
            if (products == null) {
                this.returnError(request, response, "no cross reference products available");
                return;
            }
            if (!products.contains(this.resourceName)) {
                StringBuilder sb = new StringBuilder();
                sb.append("cross reference product '").append(this.resourceName).append("' not available: available products are\n");
                sb.append("products=");
                boolean first = true;
                for (String p : products) {
                    if (!first) {
                        sb.append(",");
                        first = false;
                    }
                    sb.append(p);
                }
                sb.append("\n");
                this.returnError(request, response, sb.toString());
                return;
            }
        }
        this.seqs = this.af.getViewport().getAlignment().getSequencesArray();
        if (this.seqs == null || this.seqs.length == 0) {
            this.returnError(request, response, "no sequences selected");
            return;
        }
        boolean dna = this.af.getViewport().getAlignment().isNucleotide();
        this.setCompletableFuture(this.af.showProductsFor(this.seqs, dna, this.resourceName, true, this.getId()));
    }

    @Override
    protected void processAsync(HttpServletRequest request, HttpServletResponse response, Map<String, Object> map) {
        Cache.warn("THIS SHOULD NOT BE RUN");
    }

    @Override
    protected String finishedResponseString(HttpServletRequest request, HttpServletResponse response) {
        AlignFrame af = AlignFrame.getAlignFrameFromRestId(this.getId());
        if (af == null) {
            return null;
        }
        List<? extends AlignmentViewPanel> aps = af.getAlignPanels();
        StringBuilder sb = new StringBuilder();
        for (AlignmentViewPanel alignmentViewPanel : aps) {
            AlignmentI al = alignmentViewPanel.getAlignment();
            List<SequenceI> seqs = al.getSequences();
            for (SequenceI seq : seqs) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(seq.getName());
            }
        }
        sb.insert(0, "sequences=");
        sb.append("\n");
        return sb.toString();
    }
}

