/*
 * Decompiled with CFR 0.152.
 */
package jalview.rest;

import jalview.api.AlignmentViewPanel;
import jalview.bin.Cache;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.SequenceFetcher;
import jalview.rest.API;
import jalview.rest.AbstractEndpointAsync;
import jalview.util.DBRefUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FetchSequencesEndpoint
extends AbstractEndpointAsync {
    private static final String path = "fetchsequences";
    private static final String name = "Fetch Sequences";
    private static final String parameters = "<resource name>/<sequence ids>";
    private static final String description = "Fetch sequences from online resource";
    private SequenceFetcher sf;

    public FetchSequencesEndpoint(API api) {
        super(api, path, name, parameters, description);
    }

    @Override
    protected void initialise(HttpServletRequest request, HttpServletResponse response) {
        if (!this.checkParameters(request, response, 2)) {
            return;
        }
        String[] parameters = this.getEndpointPathParameters(request);
        String dbName = parameters[0];
        String dbId = parameters[1];
        this.setId(request, dbName + "::" + dbId);
        if (this.checkStatus(request, response)) {
            return;
        }
        String db = DBRefUtils.getCanonicalName(dbName);
        Desktop desktop = Desktop.instance;
        this.sf = new SequenceFetcher(desktop, db, dbId, false);
        this.setCompletableFuture(this.sf.ok_actionPerformed(true, this.getId()));
    }

    @Override
    protected void processAsync(HttpServletRequest request, HttpServletResponse response, Map<String, Object> map) {
        Cache.warn("THIS SHOULD NOT BE RUN");
    }

    @Override
    protected void atEnd() {
        this.sf.close_actionPerformed(null);
    }

    @Override
    protected String finishedResponseString(HttpServletRequest request, HttpServletResponse response) {
        AlignFrame af = this.getAlignFrameFromId(request, "id");
        if (af == null) {
            return null;
        }
        List<? extends AlignmentViewPanel> aps = af.getAlignPanels();
        StringBuilder sb = new StringBuilder();
        for (AlignmentViewPanel alignmentViewPanel : aps) {
            AlignmentI al = alignmentViewPanel.getAlignment();
            if (al == null) continue;
            List<SequenceI> seqs = al.getSequences();
            for (SequenceI seq : seqs) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(seq.getName());
            }
        }
        sb.insert(0, "sequences=");
        sb.append("\n");
        return sb.toString();
    }
}

